/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.io;

import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.NewKStar;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ScoredSequenceCsvPrinter
implements NewKStar.SequenceComputedListener {
    private final PrintWriter writer;
    private boolean headerWritten;
    private int row = 1;
    private final List<Column> Columns = Arrays.asList(new Column("Seq #", scoredSequence -> String.format("%d", this.row++)), new Column("Assignments", scoredSequence -> scoredSequence.sequence().toString(Sequence.Renderer.AssignmentMutations)), new Column("K* score (log10)", scoredSequence -> scoredSequence.score().scoreLog10String()), new Column("K* score lower (log10)", scoredSequence -> scoredSequence.score().lowerBoundLog10String()), new Column("K* score upper (log10)", scoredSequence -> scoredSequence.score().upperBoundLog10String()), new Column("Complex pfunc lower (log10)", scoredSequence -> scoredSequence.score().complexLowerBoundLog10String()), new Column("Complex pfunc upper (log10)", scoredSequence -> scoredSequence.score().complexUpperBoundLog10String()), new Column("Complex # Confs", scoredSequence -> String.format("%d", scoredSequence.score().complex.numConfs)), new Column("Complex Delta", scoredSequence -> String.format("%f", scoredSequence.score().complex.values.getEffectiveEpsilon())), new Column("Ligand pfunc lower (log10)", scoredSequence -> scoredSequence.score().ligandLowerBoundLog10String()), new Column("Ligand pfunc upper (log10)", scoredSequence -> scoredSequence.score().ligandUpperBoundLog10String()), new Column("Ligand # Confs", scoredSequence -> String.format("%d", scoredSequence.score().ligand.numConfs)), new Column("Ligand Delta", scoredSequence -> String.format("%f", scoredSequence.score().ligand.values.getEffectiveEpsilon())), new Column("Protein pfunc lower (log10)", scoredSequence -> scoredSequence.score().proteinLowerBoundLog10String()), new Column("Protein pfunc upper (log10)", scoredSequence -> scoredSequence.score().proteinUpperBoundLog10String()), new Column("Protein # Confs", scoredSequence -> String.format("%d", scoredSequence.score().protein.numConfs)), new Column("Protein Delta", scoredSequence -> String.format("%f", scoredSequence.score().protein.values.getEffectiveEpsilon())));

    public ScoredSequenceCsvPrinter(PrintWriter writer) {
        this.writer = writer;
    }

    public void writeSequence(ScoredSequence sequence) {
        if (!this.headerWritten) {
            this.headerWritten = true;
            String header = this.Columns.stream().map(col -> col.header).collect(Collectors.joining(","));
            this.writer.write(header + "\n");
        }
        String rowStr = this.Columns.stream().map(col -> col.extract(sequence)).collect(Collectors.joining(","));
        this.writer.write(rowStr + "\n");
        this.writer.flush();
    }

    @Override
    public void onSequence(NewKStar kstar, ScoredSequence seq) {
        this.writeSequence(seq);
    }

    record Column(String header, Function<ScoredSequence, String> extractor) {
        String extract(ScoredSequence scoredSequence) {
            return this.extractor.apply(scoredSequence);
        }
    }
}

