/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.design.commands.FileExistsValidation;
import edu.duke.cs.osprey.design.models.MoleculeDto;
import edu.duke.cs.osprey.design.models.Residue;
import edu.duke.cs.osprey.design.models.ResidueModifier;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import jcuda.runtime.JCuda;
import jcuda.runtime.cudaDeviceProp;

public class DesignFileDelegate {
    @Parameter(description="Path to design file.", names={"--design", "-d"}, converter=FileConverter.class, validateWith={FileExistsValidation.class})
    public File design;
    @Parameter(description="Prints this help information", names={"--help", "-h"}, help=true)
    boolean help;
    @Parameter(description="The approximation accuracy. Z* = (1 - epsilon)Z. Values closer to 0 improve approximation accuracy.", names={"--epsilon", "-e"})
    double epsilon = 0.683;
    @Parameter(names={"--verify-design"}, description="Verifies input parameters, but does not run the design")
    boolean verifyInput;
    @Parameter(names={"--cuda", "-c"}, description="Enable CUDA GPU acceleration. By default uses all available GPUs at max number of streams.")
    boolean useCuda;
    @Parameter(names={"--max-confs"}, description="Number of lowest energy conformations to save. Off by default.")
    public int maxConfs = -1;
    @Parameter(names={"--ensemble-dir"}, description="Directory to save each sequence's structural ensemble in. Defaults to current working directory.")
    public String ensembleDir = ".";
    @Parameter(names={"--write-n-confs"}, description="The number (n) of best conformations to write in each sequence's ensemble. Defaults to 10.")
    public int writeNConfs = 10;
    @Parameter(names={"--max-simultaneous-mutations"}, description="When multiple positions are mutable, the number of simultaneously mutable positions.")
    public int maxSimultaneousMutations = 1;
    @Parameter(names={"--frcmod"}, description="Amber frcmod file for additional forcefield parameters.")
    public String frcmodPath;

    int getNumGpu() {
        int[] deviceCount = new int[]{0};
        JCuda.cudaGetDeviceCount((int[])deviceCount);
        return deviceCount[0];
    }

    int getNumberGpuMultiprocessors(int deviceIdx) {
        cudaDeviceProp deviceProps = new cudaDeviceProp();
        JCuda.cudaGetDeviceProperties((cudaDeviceProp)deviceProps, (int)deviceIdx);
        return deviceProps.multiProcessorCount;
    }

    Parallelism getParallelism() {
        if (this.useCuda) {
            JCuda.setExceptionsEnabled((boolean)true);
            int numGpus = this.getNumGpu();
            int numMultiprocessors = this.getNumberGpuMultiprocessors(0);
            return new Parallelism(Runtime.getRuntime().availableProcessors(), numGpus, numMultiprocessors);
        }
        return new Parallelism(Runtime.getRuntime().availableProcessors(), 0, 0);
    }

    SimpleConfSpace createConfSpace(MoleculeDto spec, ForcefieldParams ffParams) {
        Molecule molecule = PDBIO.read(spec.coordinates);
        String extraTemplates = spec.extraTemplates == null ? "" : spec.extraTemplates;
        String extraTemplateCoords = spec.extraTemplatesCoordinates == null ? "" : spec.extraTemplatesCoordinates;
        String additionalRotamers = spec.additionalRotamers == null ? "" : spec.additionalRotamers;
        ResidueTemplateLibrary templateLibrary = new ResidueTemplateLibrary.Builder(ffParams.forcefld).addTemplates(extraTemplates).addTemplateCoords(extraTemplateCoords).addRotamers(additionalRotamers).build();
        Strand.Builder strandBuilder = new Strand.Builder(molecule).setTemplateLibrary(templateLibrary).setTemplateMatchingMethod(Residue.TemplateMatchingMethod.AtomNames);
        for (ResidueModifier mod : spec.residueModifiers) {
            String identifier = mod.identity.positionIdentifier();
            strandBuilder.setResidueMutability(identifier, List.copyOf(mod.mutability), mod.flexibility.includeStructureRotamer, mod.flexibility.useContinuous);
        }
        Strand protein = strandBuilder.build();
        List identities = spec.residueModifiers.stream().map(m -> m.identity).collect(Collectors.toUnmodifiableList());
        for (Residue identity : identities) {
            Strand.ResidueFlex flex = protein.flexibility.get(identity.positionIdentifier());
            if (flex.wildType.substring(0, 2).equalsIgnoreCase(identity.aminoAcidType.substring(0, 2))) continue;
            throw new RuntimeException(String.format("Design parameter thought residue %s was %s, but in structure is %s", identity.positionIdentifier(), identity.aminoAcidType, flex.wildType));
        }
        return new SimpleConfSpace.Builder().addStrand(protein, new StrandFlex[0]).build();
    }
}

