/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ParametricMolecule;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.design.commands.DelegatingCommand;
import edu.duke.cs.osprey.design.models.MoleculeDesign;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.forcefield.AtomPairElectrostaticContribution;
import edu.duke.cs.osprey.energy.forcefield.AtomPairEnergyContribution;
import edu.duke.cs.osprey.energy.forcefield.AtomPairSolvationContribution;
import edu.duke.cs.osprey.energy.forcefield.AtomPairVanDerWaalsContribution;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.ResPairEnergyContribution;
import edu.duke.cs.osprey.energy.forcefield.ResidueForcefieldEnergy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Parameters(commandDescription="Calculate the energies of the top (n) confs")
public class CommandTopNConfs
extends DelegatingCommand {
    public static final String CommandName = "topn";
    static final String CommandDescription = "Calculate the energies of the top (n) confs";
    @Parameter(names={"--energy"}, description="Analyze the energy of conformation(s).")
    private List<Integer> captureEnergies = new ArrayList<Integer>();
    @Parameter(names={"--n"}, description="Number of conformations to retrieve energy for.")
    private int numConfs = 10;
    @Parameter(names={"--m"}, description="Number of residues for each conformation to get atom-specific breakdowns for.")
    private int topNRes = 5;

    @Override
    public int run(JCommander commander, String[] args) {
        Optional<Integer> retVal = this.processHelpAndNoArgs(commander, args);
        if (retVal.isPresent()) {
            return retVal.get();
        }
        Optional<MoleculeDesign> designOpt = this.parseDesignSpec(MoleculeDesign.class);
        if (designOpt.isEmpty()) {
            return 1;
        }
        MoleculeDesign design = designOpt.get();
        return this.runTopNConfs(design);
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }

    private int runTopNConfs(MoleculeDesign design) {
        ForcefieldParams ffParams = new ForcefieldParams();
        SimpleConfSpace confSpace = this.delegate.createConfSpace(design.molecule, ffParams);
        if (this.delegate.verifyInput) {
            return 0;
        }
        try (EnergyCalculator ecalc = new EnergyCalculator.Builder(confSpace, ffParams).setParallelism(this.delegate.getParallelism()).build();){
            EnergyMatrix emat = new SimplerEnergyMatrixCalculator.Builder(confSpace, ecalc).build().calcEnergyMatrix();
            ConfEnergyCalculator confECalc = new ConfEnergyCalculator.Builder(confSpace, ecalc).build();
            ConfAStarTree astarTree = new ConfAStarTree.Builder(emat, confSpace).setTraditional().build();
            for (int i = 0; i < this.numConfs; ++i) {
                ConfSearch.ScoredConf sConf = astarTree.nextConf();
                ConfSearch.EnergiedConf eConf = confECalc.calcEnergy(sConf);
                ResidueInteractions interactions = confECalc.makeFragInters(new RCTuple(sConf.getAssignments()));
                ParametricMolecule parametricMolecule = confSpace.makeMolecule(sConf.getAssignments());
                this.printConf(i, sConf, eConf);
                ResidueForcefieldEnergy efunc = new ResidueForcefieldEnergy(ecalc.resPairCache, interactions, parametricMolecule.mol);
                List<ResPairEnergyContribution> energyContributions = efunc.getEnergyContributions(efunc.resPairs);
                List<ResPairEnergyContribution> residueEnergies = energyContributions.stream().sorted(Comparator.comparingDouble(ResPairEnergyContribution::getEnergy).reversed()).collect(Collectors.toList());
                this.printTopAtomContributions(residueEnergies);
            }
            int n = 0;
            return n;
        }
    }

    private void printTopAtomContributions(List<ResPairEnergyContribution> residueEnergies) {
        int n = 3;
        for (int i = 0; i < n; ++i) {
            for (AtomPairEnergyContribution contribution : residueEnergies.get(i).getTopEnergyContributions(n)) {
                StringBuilder builder = new StringBuilder();
                if (contribution instanceof AtomPairElectrostaticContribution) {
                    builder.append("Electrostatic:\t");
                } else if (contribution instanceof AtomPairVanDerWaalsContribution) {
                    builder.append("van der Waals:\t");
                } else if (contribution instanceof AtomPairSolvationContribution) {
                    builder.append("Solvation:\t");
                }
                builder.append(contribution.getEnergy());
                builder.append("\t");
                builder.append(contribution.getAtom1().toString()).append("\t");
                builder.append(contribution.getAtom2().toString()).append("\t");
                System.out.println(builder.toString());
            }
        }
    }

    private void printConf(int confIdx, ConfSearch.ScoredConf sConf, ConfSearch.EnergiedConf eConf) {
        double score = sConf.getScore();
        double energy = eConf.getEnergy();
        System.out.println(String.format("Conf %d: Score:\t%f\t\tEnergy:\t%f", confIdx, score, energy));
    }
}

