/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import edu.duke.cs.osprey.design.commands.CliCommand;
import edu.duke.cs.osprey.gui.io.PDBKt;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import java.io.File;

@Parameters(commandDescription="Flip the sign of the z-coordinate of all atoms in a PDB")
public class CommandInvert
implements CliCommand {
    public static final String CommandName = "invert";
    public static final String CommandDescription = "Flip the sign of the z-coordinate of all atoms in a PDB";
    @Parameter(description="pdb-file")
    private String pdbFile;

    @Override
    public int run(JCommander commander, String[] args) {
        File f = new File(this.pdbFile);
        if (!f.exists()) {
            System.err.printf("The file you specified, %s, doesn't exist%n", this.pdbFile);
            return 1;
        }
        Molecule molecule = PDBKt.toMolecule(PDBIO.readFile(f), "pdb");
        Molecule invertedCopy2 = molecule.invertedCopy();
        String invertedStr = PDBKt.toPDB(invertedCopy2, false, false, null, null, false, false, false);
        System.out.print(invertedStr);
        return 0;
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }
}

