/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.gmec.EnergyRange;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

@Deprecated
public class ConfPrinter {
    private static final int LabelSize = 30;
    private static final String LabelFormat = "\t%-30s";
    SearchProblem searchSpace;
    Writer confFileHandle;
    String confFileName;
    int numConfs;
    double minEnergy;
    boolean printEPICEnergy;

    public ConfPrinter(SearchProblem searchProb, String confFileName, boolean printEPICEnergy) {
        this.searchSpace = searchProb;
        this.confFileName = confFileName;
        this.numConfs = 0;
        this.minEnergy = Double.POSITIVE_INFINITY;
        this.printEPICEnergy = printEPICEnergy;
        try {
            this.confFileHandle = new FileWriter(confFileName);
        }
        catch (IOException ex) {
            throw new RuntimeException("ERROR OPENING CONF FILE.  NAME: " + confFileName, ex);
        }
    }

    public String getConfReport(int[] conf) {
        int pos;
        StringBuilder buf = new StringBuilder();
        buf.append(String.format(LabelFormat, "RCs (residue-based numbers)"));
        for (int rc : conf) {
            buf.append(String.format(" %3d", rc));
        }
        buf.append("\n");
        buf.append(String.format(LabelFormat, "Residue types"));
        for (pos = 0; pos < this.searchSpace.confSpace.numPos; ++pos) {
            String resType = this.searchSpace.confSpace.posFlex.get((int)pos).RCs.get((int)conf[pos]).AAType;
            buf.append(String.format(" %3s", resType));
        }
        buf.append("\n");
        buf.append(String.format(LabelFormat, "Rotamer numbers"));
        for (pos = 0; pos < this.searchSpace.confSpace.numPos; ++pos) {
            int rotNum = this.searchSpace.confSpace.posFlex.get((int)pos).RCs.get((int)conf[pos]).rotNum;
            buf.append(String.format(" %3d", rotNum));
        }
        buf.append("\n");
        return buf.toString();
    }

    public String getConfReport(ConfSearch.EnergiedConf conf) {
        return this.getConfReport(conf, null);
    }

    public String getConfReport(ConfSearch.EnergiedConf conf, EnergyRange window) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getConfReport(conf.getAssignments()));
        buf.append(String.format("\t%-30s %.6f", "Energy", conf.getEnergy()));
        if (window != null) {
            buf.append(String.format(" (best so far: %.6f)", window.getMin()));
        }
        buf.append("\n");
        buf.append(String.format("\t%-30s %.6f (gap: %.6f", "Score", conf.getScore(), Math.abs(conf.getScore() - conf.getEnergy())));
        if (window != null) {
            buf.append(String.format(", remaining: %.6f", window.getMax() - conf.getScore()));
        }
        buf.append(")\n");
        if (this.printEPICEnergy) {
            buf.append(String.format("\t%-30s%.6f\n", "EPIC", this.searchSpace.EPICMinimizedEnergy(conf.getAssignments())));
        }
        return buf.toString();
    }

    public String getConfReport(ConfSearch.ScoredConf conf) {
        return this.getConfReport(conf, null);
    }

    public String getConfReport(ConfSearch.ScoredConf conf, EnergyRange window) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getConfReport(conf.getAssignments()));
        if (window == null) {
            buf.append(String.format("\t%-30s %.6f\n", "Score", conf.getScore()));
        } else {
            buf.append(String.format("\t%-30s %.6f (remaining: %.6f)\n", "Score", conf.getScore(), window.getMax() - conf.getScore()));
        }
        return buf.toString();
    }

    public void printConf(ConfSearch.EnergiedConf conf) {
        try {
            int pos;
            this.confFileHandle.write(this.numConfs++ + " CONF: ");
            for (int rc : conf.getAssignments()) {
                this.confFileHandle.write(rc + " ");
            }
            this.confFileHandle.write("RESTYPES: ");
            for (pos = 0; pos < this.searchSpace.confSpace.numPos; ++pos) {
                String resType = this.searchSpace.confSpace.posFlex.get((int)pos).RCs.get((int)conf.getAssignments()[pos]).AAType;
                this.confFileHandle.write(resType + " ");
            }
            this.confFileHandle.write("ROTS: ");
            for (pos = 0; pos < this.searchSpace.confSpace.numPos; ++pos) {
                int rotNum = this.searchSpace.confSpace.posFlex.get((int)pos).RCs.get((int)conf.getAssignments()[pos]).rotNum;
                this.confFileHandle.write(rotNum + " ");
            }
            this.minEnergy = Math.min(this.minEnergy, conf.getEnergy());
            Double epicEnergy = null;
            if (this.printEPICEnergy) {
                epicEnergy = this.searchSpace.EPICMinimizedEnergy(conf.getAssignments());
            }
            this.confFileHandle.write("Score: " + conf.getScore() + " Energy: " + conf.getEnergy() + " Best so far: " + this.minEnergy);
            if (epicEnergy != null) {
                this.confFileHandle.write(" EPIC energy: " + this.searchSpace.EPICMinimizedEnergy(conf.getAssignments()));
            }
            this.confFileHandle.write("\n");
            this.confFileHandle.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    void closeConfFile() {
        try {
            this.confFileHandle.close();
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR CLOSING CONF FILE.  NAME: " + this.confFileName + e.getMessage());
        }
    }
}

