/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace.compiled.motions;

import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ContinuousMotion;
import edu.duke.cs.osprey.confspace.compiled.DegreeOfFreedom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class TranslationRotation
implements ContinuousMotion {
    public final Description desc;
    public final AssignedCoords coords;
    public final List<Integer> atomIndices = new ArrayList<Integer>();
    public final Set<Integer> modifiedPosIndices = new HashSet<Integer>();
    public final Dof dofPsi;
    public final Dof dofTheta;
    public final Dof dofPhi;
    public final Dof dofX;
    public final Dof dofY;
    public final Dof dofZ;
    private final Quaterniond rotationInverse;
    private final Vector3d translation;

    public TranslationRotation(Description desc, AssignedCoords coords, int molInfoIndex) {
        this.desc = desc;
        this.coords = coords;
        for (int atomi = 0; atomi < coords.confSpace.numStaticAtoms; ++atomi) {
            if (coords.confSpace.staticMolInfoIndices[atomi] != molInfoIndex) continue;
            this.atomIndices.add(coords.getStaticIndex(atomi));
            this.modifiedPosIndices.add(-1);
        }
        for (int posi = 0; posi < coords.confSpace.numPos(); ++posi) {
            int confi = coords.assignments[posi];
            if (confi == -1) continue;
            ConfSpace.Conf conf = coords.confSpace.positions[posi].confs[confi];
            for (int atomi = 0; atomi < conf.numAtoms; ++atomi) {
                if (conf.atomMolInfoIndices[atomi] != molInfoIndex) continue;
                this.atomIndices.add(coords.getConfIndex(posi, atomi));
                this.modifiedPosIndices.add(posi);
            }
        }
        this.rotationInverse = new Quaterniond();
        this.rotationInverse.identity();
        this.translation = new Vector3d(0.0, 0.0, 0.0);
        double rotationStep = 0.004363323;
        double translationStep = 0.01;
        String molName = coords.confSpace.molInfos[molInfoIndex].name;
        this.dofPsi = new Dof("Rotation @ " + molName + ", Psi (X)", desc.maxRotationRadians, rotationStep);
        this.dofTheta = new Dof("Rotation @ " + molName + ", Theta (Y)", desc.maxRotationRadians, rotationStep);
        this.dofPhi = new Dof("Rotation @ " + molName + ", Phi (Z)", desc.maxRotationRadians, rotationStep);
        this.dofX = new Dof("Translation @ " + molName + ", X", desc.maxDistance, translationStep);
        this.dofY = new Dof("Translation @ " + molName + ", Y", desc.maxDistance, translationStep);
        this.dofZ = new Dof("Translation @ " + molName + ", Z", desc.maxDistance, translationStep);
    }

    private void apply() {
        Vector3d pos = new Vector3d();
        Quaterniond q = new Quaterniond().rotationXYZ(this.dofPsi.value, this.dofTheta.value, this.dofPhi.value);
        Vector3d t = new Vector3d(this.dofX.value, this.dofY.value, this.dofZ.value);
        for (int atomi : this.atomIndices) {
            this.coords.coords.get(atomi, pos);
            pos.sub((Vector3dc)this.desc.centroid);
            pos.sub((Vector3dc)this.translation);
            pos.rotate((Quaterniondc)this.rotationInverse);
            pos.rotate((Quaterniondc)q);
            pos.add((Vector3dc)t);
            pos.add((Vector3dc)this.desc.centroid);
            this.coords.coords.set(atomi, (Vector3dc)pos);
        }
        this.translation.set((Vector3dc)t);
        this.rotationInverse.set((Quaterniondc)q).invert();
    }

    @Override
    public void appendDofs(List<DegreeOfFreedom> dofs) {
        dofs.add(this.dofPsi);
        dofs.add(this.dofTheta);
        dofs.add(this.dofPhi);
        dofs.add(this.dofX);
        dofs.add(this.dofY);
        dofs.add(this.dofZ);
    }

    public static class Description
    implements ContinuousMotion.MolDescription {
        public final double maxDistance;
        public final double maxRotationRadians;
        public final Vector3d centroid;

        public Description(double maxDistance, double maxRotationRadians, Vector3d centroid) {
            this.maxDistance = maxDistance;
            this.maxRotationRadians = maxRotationRadians;
            this.centroid = centroid;
        }

        @Override
        public ContinuousMotion build(AssignedCoords coords, int molInfoIndex) {
            return new TranslationRotation(this, coords, molInfoIndex);
        }

        @Override
        public int maxNumDofs() {
            return 6;
        }
    }

    public class Dof
    implements DegreeOfFreedom {
        public final TranslationRotation translationRotation;
        public final String name;
        public final double min;
        public final double max;
        public final double step;
        private double value;

        public Dof(String name, double dist, double step) {
            this.translationRotation = TranslationRotation.this;
            this.value = 0.0;
            this.name = name;
            this.min = -dist;
            this.max = dist;
            this.step = step;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public double min() {
            return this.min;
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double get() {
            return this.value;
        }

        @Override
        public void set(double val) {
            this.value = val;
            TranslationRotation.this.apply();
        }

        @Override
        public Set<Integer> modifiedPosIndices() {
            return TranslationRotation.this.modifiedPosIndices;
        }

        @Override
        public double initialStepSize() {
            return this.step;
        }
    }
}

