/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace.compiled;

import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.tools.MathTools;
import java.util.ArrayList;
import java.util.List;

public enum PosInterDist {
    DesmetEtAl1992{

        @Override
        public List<PosInter> single(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi1, int confi1) {
            ArrayList<PosInter> inters = new ArrayList<PosInter>();
            inters.add(new PosInter(posi1, posi1, 1.0, PosInterDist.getErefOffset(confSpace, eref, posi1, confi1)));
            inters.add(new PosInter(posi1, -1, 1.0, 0.0));
            return inters;
        }

        @Override
        public List<PosInter> pair(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi1, int confi1, int posi2, int confi2) {
            ArrayList<PosInter> inters = new ArrayList<PosInter>();
            inters.add(new PosInter(posi1, posi2, 1.0, 0.0));
            return inters;
        }

        @Override
        public List<PosInter> tripleCorrection(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi1, int confi1, int posi2, int confi2, int posi3, int confi3) {
            double weight = 1.0 / (double)MathTools.numTriplesPerPair(confSpace.positions.length);
            ArrayList<PosInter> inters = new ArrayList<PosInter>();
            inters.add(new PosInter(posi1, posi2, weight, 0.0));
            inters.add(new PosInter(posi1, posi3, weight, 0.0));
            inters.add(new PosInter(posi2, posi3, weight, 0.0));
            return inters;
        }
    }
    ,
    TighterBounds{

        @Override
        public List<PosInter> single(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi1, int confi1) {
            return new ArrayList<PosInter>();
        }

        @Override
        public List<PosInter> pair(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi1, int confi1, int posi2, int confi2) {
            double weight = 1.0 / (double)MathTools.numPairsPerSingle(confSpace.positions.length);
            ArrayList<PosInter> inters = new ArrayList<PosInter>();
            inters.add(new PosInter(posi1, posi1, weight, PosInterDist.getErefOffset(confSpace, eref, posi1, confi1)));
            inters.add(new PosInter(posi2, posi2, weight, PosInterDist.getErefOffset(confSpace, eref, posi2, confi2)));
            inters.add(new PosInter(posi1, -1, weight, 0.0));
            inters.add(new PosInter(posi2, -1, weight, 0.0));
            inters.add(new PosInter(posi1, posi2, 1.0, 0.0));
            return inters;
        }

        @Override
        public List<PosInter> tripleCorrection(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi1, int confi1, int posi2, int confi2, int posi3, int confi3) {
            double singleWeight = 1.0 / (double)MathTools.numTriplesPerSingle(confSpace.positions.length);
            double pairWeight = 1.0 / (double)MathTools.numTriplesPerPair(confSpace.positions.length);
            ArrayList<PosInter> inters = new ArrayList<PosInter>();
            inters.add(new PosInter(posi1, posi1, singleWeight, PosInterDist.getErefOffset(confSpace, eref, posi1, confi1)));
            inters.add(new PosInter(posi2, posi2, singleWeight, PosInterDist.getErefOffset(confSpace, eref, posi2, confi2)));
            inters.add(new PosInter(posi3, posi3, singleWeight, PosInterDist.getErefOffset(confSpace, eref, posi2, confi2)));
            inters.add(new PosInter(posi1, -1, singleWeight, 0.0));
            inters.add(new PosInter(posi2, -1, singleWeight, 0.0));
            inters.add(new PosInter(posi3, -1, singleWeight, 0.0));
            inters.add(new PosInter(posi1, posi2, pairWeight, 0.0));
            inters.add(new PosInter(posi1, posi3, pairWeight, 0.0));
            inters.add(new PosInter(posi2, posi3, pairWeight, 0.0));
            return inters;
        }
    };


    public static List<PosInter> staticStatic() {
        ArrayList<PosInter> inters = new ArrayList<PosInter>();
        inters.add(new PosInter(-1, -1, 1.0, 0.0));
        return inters;
    }

    public static List<PosInter> all(ConfSpace confSpace, SimpleReferenceEnergies eref, int[] conf) {
        ArrayList<PosInter> inters = new ArrayList<PosInter>();
        inters.add(new PosInter(-1, -1, 1.0, 0.0));
        for (int posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            if (conf[posi1] == -1) continue;
            inters.add(new PosInter(posi1, posi1, 1.0, PosInterDist.getErefOffset(confSpace, eref, posi1, conf)));
            inters.add(new PosInter(posi1, -1, 1.0, 0.0));
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                if (conf[posi2] == -1) continue;
                inters.add(new PosInter(posi1, posi2, 1.0, 0.0));
            }
        }
        return inters;
    }

    public static List<PosInter> all(ConfSpace confSpace, int[] conf) {
        return PosInterDist.all(confSpace, null, conf);
    }

    public static List<PosInter> dynamic(ConfSpace confSpace, SimpleReferenceEnergies eref, int[] conf) {
        ArrayList<PosInter> inters = new ArrayList<PosInter>();
        for (int posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            if (conf[posi1] == -1) continue;
            inters.add(new PosInter(posi1, posi1, 1.0, PosInterDist.getErefOffset(confSpace, eref, posi1, conf)));
            inters.add(new PosInter(posi1, -1, 1.0, 0.0));
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                if (conf[posi2] == -1) continue;
                inters.add(new PosInter(posi1, posi2, 1.0, 0.0));
            }
        }
        return inters;
    }

    public static List<PosInter> dynamic(ConfSpace confSpace, int[] conf) {
        return PosInterDist.dynamic(confSpace, null, conf);
    }

    private static double getErefOffset(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi, int confi) {
        if (eref != null) {
            return eref.getOffset(posi, confSpace.confType(posi, confi));
        }
        return 0.0;
    }

    private static double getErefOffset(ConfSpace confSpace, SimpleReferenceEnergies eref, int posi, int[] conf) {
        if (conf != null) {
            return PosInterDist.getErefOffset(confSpace, eref, posi, conf[posi]);
        }
        return 0.0;
    }

    public abstract List<PosInter> single(ConfSpace var1, SimpleReferenceEnergies var2, int var3, int var4);

    public abstract List<PosInter> pair(ConfSpace var1, SimpleReferenceEnergies var2, int var3, int var4, int var5, int var6);

    public abstract List<PosInter> tripleCorrection(ConfSpace var1, SimpleReferenceEnergies var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

