/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace.compiled;

import org.joml.Vector3d;
import org.joml.Vector3dc;

public class CoordsList {
    public final int size;
    private final double[] coords;

    public CoordsList(int size) {
        this.size = size;
        this.coords = new double[size * 3];
    }

    public CoordsList(CoordsList other) {
        this(other.size);
        this.copyFrom(other, 0);
    }

    public double x(int i) {
        return this.coords[i * 3];
    }

    public void setX(int i, double val) {
        this.coords[i * 3] = val;
    }

    public double y(int i) {
        return this.coords[i * 3 + 1];
    }

    public void setY(int i, double val) {
        this.coords[i * 3 + 1] = val;
    }

    public double z(int i) {
        return this.coords[i * 3 + 2];
    }

    public void setZ(int i, double val) {
        this.coords[i * 3 + 2] = val;
    }

    public void get(int i, Vector3d out) {
        int o = i * 3;
        out.x = this.coords[o];
        out.y = this.coords[++o];
        out.z = this.coords[++o];
    }

    public void set(int i, double x, double y, double z) {
        int o = i * 3;
        this.coords[o] = x;
        this.coords[++o] = y;
        this.coords[++o] = z;
    }

    public void set(int i, Vector3dc in) {
        int o = i * 3;
        this.coords[o] = in.x();
        this.coords[++o] = in.y();
        this.coords[++o] = in.z();
    }

    public void copyFrom(CoordsList src, int destIndex) {
        System.arraycopy(src.coords, 0, this.coords, destIndex * 3, src.size * 3);
    }

    public boolean equals(Object other) {
        return other instanceof CoordsList && this.equals((CoordsList)other);
    }

    public boolean equals(CoordsList other) {
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.coords[i] == other.coords[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("CoordsList[n=%d]", this.size);
    }

    public void print() {
        for (int i = 0; i < this.size; ++i) {
            System.out.printf("%f %f %f%n", this.x(i), this.y(i), this.z(i));
        }
    }
}

