/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace.compiled;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ContinuousMotion;
import edu.duke.cs.osprey.confspace.compiled.CoordsList;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.confspace.compiled.motions.DihedralAngle;
import edu.duke.cs.osprey.confspace.compiled.motions.TranslationRotation;
import edu.duke.cs.osprey.energy.compiled.AmberEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EEF1EnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EnergyCalculator;
import edu.duke.cs.osprey.tools.LZMA2;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.joml.Vector3d;

public class ConfSpace
implements ConfSpaceIteration {
    public static int NotAssigned = -1;
    public static int NoResidue = -1;
    private final int hash;
    public final String name;
    public final String[] forcefieldIds;
    public final EnergyCalculator[] ecalcs;
    public final MolInfo[] molInfos;
    public final ResInfo[] resInfos;
    public final int numStaticAtoms;
    public final CoordsList staticCoords;
    public final String[] staticNames;
    public final int[] staticMolInfoIndices;
    public final int[] staticResInfoIndices;
    public final double[] staticEnergies;
    public final Pos[] positions;
    public final int maxNumConfAtoms;
    public final int[] confAtomOffsetsByPos;
    public final int maxNumDofs;
    public final SeqSpace seqSpace;
    private final IndicesStatic[] indicesStatic;
    private final IndicesSingle[][][] indicesSingles;
    private final IndicesPair[][][][] indicesPairs;
    private final double[][][] ffparams;

    public static ConfSpace fromBytes(byte[] bytes) {
        ConfSpace confSpace;
        int hash = Arrays.hashCode(bytes);
        byte[] xzMagic = new byte[]{-3, 55, 122, 88, 90, 0};
        if (bytes.length > 6 && bytes[0] == xzMagic[0] && bytes[1] == xzMagic[1] && bytes[2] == xzMagic[2] && bytes[3] == xzMagic[3] && bytes[4] == xzMagic[4] && bytes[5] == xzMagic[5]) {
            bytes = LZMA2.decompressBytes(bytes);
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            boolean endValid;
            boolean startValid;
            boolean bl = startValid = in.read() == 95 && in.read() == 111 && in.read() == 115 && in.read() == 112 && in.read() == 99 && in.read() == 99 && in.read() == 115 && in.read() == 95;
            if (!startValid) {
                throw new IllegalArgumentException("unrecognized compiled conformation space format");
            }
            int version = in.readInt();
            ConfSpace confSpace2 = switch (version) {
                case 1 -> new ConfSpace(hash, in);
                default -> throw new IllegalArgumentException("unrecognized compiled conformation space version: " + version);
            };
            boolean bl2 = endValid = in.read() == 95 && in.read() == 111 && in.read() == 115 && in.read() == 112 && in.read() == 99 && in.read() == 99 && in.read() == 115 && in.read() == 95;
            if (!endValid) {
                throw new IllegalArgumentException("compiled conformation space has been corrupted");
            }
            confSpace = confSpace2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("can't read compiled conformation space", ex);
            }
        }
        in.close();
        return confSpace;
    }

    private ConfSpace(int hash, DataInput in) throws IOException {
        int i;
        int ffi;
        this.hash = hash;
        this.name = in.readUTF();
        int numForcefields = in.readInt();
        this.forcefieldIds = new String[numForcefields];
        this.ecalcs = new EnergyCalculator[numForcefields];
        for (ffi = 0; ffi < numForcefields; ++ffi) {
            String id;
            this.forcefieldIds[ffi] = id = in.readUTF();
            this.ecalcs[ffi] = switch (EnergyCalculator.Type.get(in.readUTF())) {
                default -> throw new IncompatibleClassChangeError();
                case EnergyCalculator.Type.Amber -> new AmberEnergyCalculator(id, ffi);
                case EnergyCalculator.Type.EEF1 -> new EEF1EnergyCalculator(id, ffi);
            };
        }
        for (ffi = 0; ffi < this.forcefieldIds.length; ++ffi) {
            this.ecalcs[ffi].readSettings(in);
        }
        this.molInfos = new MolInfo[in.readInt()];
        for (i = 0; i < this.molInfos.length; ++i) {
            this.molInfos[i] = new MolInfo(in.readUTF(), in.readByte() == 1 ? in.readUTF() : null, in.readInt());
            block21: for (int motioni = 0; motioni < this.molInfos[i].motions.length; ++motioni) {
                String motionType;
                switch (motionType = in.readUTF()) {
                    case "dihedralAngle": {
                        this.molInfos[i].motions[motioni] = ConfSpace.readDihedralAngle(in);
                        continue block21;
                    }
                    case "translationRotation": {
                        this.molInfos[i].motions[motioni] = ConfSpace.readTranslationRotation(in);
                        continue block21;
                    }
                    default: {
                        throw new UnsupportedOperationException("continuous motion type '" + motionType + "' is not supported for molecules");
                    }
                }
            }
        }
        this.resInfos = new ResInfo[in.readInt()];
        for (i = 0; i < this.resInfos.length; ++i) {
            this.resInfos[i] = new ResInfo(in.readUTF(), in.readUTF(), in.readUTF(), in.readInt());
        }
        this.numStaticAtoms = in.readInt();
        this.staticCoords = new CoordsList(this.numStaticAtoms);
        this.staticNames = new String[this.numStaticAtoms];
        this.staticResInfoIndices = new int[this.numStaticAtoms];
        this.staticMolInfoIndices = new int[this.numStaticAtoms];
        for (i = 0; i < this.numStaticAtoms; ++i) {
            this.staticCoords.set(i, in.readDouble(), in.readDouble(), in.readDouble());
            this.staticMolInfoIndices[i] = in.readInt();
            this.staticResInfoIndices[i] = in.readInt();
            this.staticNames[i] = in.readUTF();
        }
        this.staticEnergies = new double[this.forcefieldIds.length];
        for (ffi = 0; ffi < this.forcefieldIds.length; ++ffi) {
            this.staticEnergies[ffi] = in.readDouble();
        }
        int numPositions = in.readInt();
        this.positions = new Pos[numPositions];
        this.indicesSingles = new IndicesSingle[this.forcefieldIds.length][numPositions][];
        for (int posi = 0; posi < numPositions; ++posi) {
            Pos[] posName = in.readUTF();
            String wildType2 = in.readUTF();
            int numFrags = in.readInt();
            int numConfs = in.readInt();
            for (int ffi2 = 0; ffi2 < this.forcefieldIds.length; ++ffi2) {
                this.indicesSingles[ffi2][posi] = new IndicesSingle[numConfs];
            }
            Conf[] confs = new Conf[numConfs];
            for (int confi = 0; confi < numConfs; ++confi) {
                String id = in.readUTF();
                String type = in.readUTF();
                int fragIndex = in.readInt();
                int numAtoms = in.readInt();
                CoordsList atomCoords = new CoordsList(numAtoms);
                String[] atomNames2 = new String[numAtoms];
                int[] atomMolInfoIndices = new int[numAtoms];
                int[] atomResInfoIndices = new int[numAtoms];
                for (int atomi = 0; atomi < numAtoms; ++atomi) {
                    atomCoords.set(atomi, in.readDouble(), in.readDouble(), in.readDouble());
                    atomMolInfoIndices[atomi] = in.readInt();
                    atomResInfoIndices[atomi] = in.readInt();
                    atomNames2[atomi] = in.readUTF();
                }
                int numMotions = in.readInt();
                ContinuousMotion.ConfDescription[] motions = new ContinuousMotion.ConfDescription[numMotions];
                block29: for (int motioni = 0; motioni < numMotions; ++motioni) {
                    String motionType;
                    switch (motionType = in.readUTF()) {
                        case "dihedralAngle": {
                            motions[motioni] = ConfSpace.readDihedralAngle(in);
                            continue block29;
                        }
                        default: {
                            throw new UnsupportedOperationException("continuous motion type '" + motionType + "' is not supported for conformations");
                        }
                    }
                }
                double[] energies = new double[this.forcefieldIds.length];
                for (int ffi3 = 0; ffi3 < this.forcefieldIds.length; ++ffi3) {
                    energies[ffi3] = in.readDouble();
                }
                confs[confi] = new Conf(this, confi, id, type, fragIndex, numAtoms, atomCoords, atomNames2, atomMolInfoIndices, atomResInfoIndices, motions, energies);
            }
            this.positions[posi] = new Pos(this, posi, (String)posName, wildType2, numFrags, confs);
        }
        this.confAtomOffsetsByPos = new int[this.positions.length];
        int maxNumConfAtoms = this.staticCoords.size;
        for (Pos pos2 : this.positions) {
            this.confAtomOffsetsByPos[pos2.index] = maxNumConfAtoms;
            maxNumConfAtoms += pos2.maxNumAtoms;
        }
        this.maxNumConfAtoms = maxNumConfAtoms;
        this.indicesStatic = new IndicesStatic[this.forcefieldIds.length];
        for (int ffi4 = 0; ffi4 < this.forcefieldIds.length; ++ffi4) {
            int num = in.readInt();
            int[][] indices = new int[num][3];
            for (int i2 = 0; i2 < num; ++i2) {
                indices[i2][0] = in.readInt();
                indices[i2][1] = in.readInt();
                indices[i2][2] = in.readInt();
            }
            this.indicesStatic[ffi4] = new IndicesStatic(this, indices);
        }
        for (int posi = 0; posi < numPositions; ++posi) {
            Pos pos3 = this.positions[posi];
            for (int fragi = 0; fragi < pos3.numFrags; ++fragi) {
                for (int ffi5 = 0; ffi5 < this.forcefieldIds.length; ++ffi5) {
                    int numSingles = in.readInt();
                    int[][] singles = new int[numSingles][3];
                    for (int i3 = 0; i3 < numSingles; ++i3) {
                        singles[i3][0] = in.readInt();
                        singles[i3][1] = in.readInt();
                        singles[i3][2] = in.readInt();
                    }
                    int numStatics = in.readInt();
                    int[][] statics = new int[numStatics][3];
                    for (int i4 = 0; i4 < numStatics; ++i4) {
                        statics[i4][0] = in.readInt();
                        statics[i4][1] = in.readInt();
                        statics[i4][2] = in.readInt();
                    }
                    this.indicesSingles[ffi5][posi][fragi] = new IndicesSingle(this, singles, statics);
                }
            }
        }
        int numPosPairs = Math.max(0, numPositions * (numPositions + 1) / 2 - 1);
        this.indicesPairs = new IndicesPair[this.forcefieldIds.length][numPosPairs][][];
        for (int posi1 = 0; posi1 < numPositions; ++posi1) {
            Pos pos1 = this.positions[posi1];
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                Pos pos2 = this.positions[posi2];
                int posPairIndex = this.posPairIndex(pos1.index, pos2.index);
                for (int ffi6 = 0; ffi6 < this.forcefieldIds.length; ++ffi6) {
                    this.indicesPairs[ffi6][posPairIndex] = new IndicesPair[pos1.confs.length][pos2.confs.length];
                }
                for (int fragi1 = 0; fragi1 < pos1.numFrags; ++fragi1) {
                    for (int fragi2 = 0; fragi2 < pos2.numFrags; ++fragi2) {
                        for (int ffi7 = 0; ffi7 < this.forcefieldIds.length; ++ffi7) {
                            int numPairs = in.readInt();
                            int[][] indicesPair = new int[numPairs][3];
                            for (int i5 = 0; i5 < numPairs; ++i5) {
                                indicesPair[i5][0] = in.readInt();
                                indicesPair[i5][1] = in.readInt();
                                indicesPair[i5][2] = in.readInt();
                            }
                            this.indicesPairs[ffi7][posPairIndex][fragi1][fragi2] = new IndicesPair(this, indicesPair);
                        }
                    }
                }
            }
        }
        this.ffparams = new double[this.forcefieldIds.length][][];
        for (int ffi8 = 0; ffi8 < this.forcefieldIds.length; ++ffi8) {
            int numParams = in.readInt();
            this.ffparams[ffi8] = new double[numParams][];
            for (int i6 = 0; i6 < numParams; ++i6) {
                int numNumbers = in.readInt();
                double[] params = new double[numNumbers];
                for (int p = 0; p < numNumbers; ++p) {
                    params[p] = in.readDouble();
                }
                this.ffparams[ffi8][i6] = params;
            }
        }
        this.maxNumDofs = Arrays.stream(this.molInfos).flatMap(info2 -> Arrays.stream(info2.motions)).mapToInt(motion -> motion.maxNumDofs()).sum() + Arrays.stream(this.positions).mapToInt(pos -> Arrays.stream(pos.confs).mapToInt(conf -> Arrays.stream(conf.motions).mapToInt(motion -> motion.maxNumDofs()).sum()).max().orElse(0)).sum();
        this.seqSpace = new SeqSpace(this);
    }

    private static DihedralAngle.Description readDihedralAngle(DataInput in) throws IOException {
        double minDegrees = in.readDouble();
        double maxDegrees = in.readDouble();
        int a = in.readInt();
        int b = in.readInt();
        int c = in.readInt();
        int d = in.readInt();
        int numRotated = in.readInt();
        int[] rotated = new int[numRotated];
        for (int roti = 0; roti < numRotated; ++roti) {
            rotated[roti] = in.readInt();
        }
        return new DihedralAngle.Description(minDegrees, maxDegrees, a, b, c, d, rotated);
    }

    private static TranslationRotation.Description readTranslationRotation(DataInput in) throws IOException {
        return new TranslationRotation.Description(in.readDouble(), in.readDouble(), new Vector3d(in.readDouble(), in.readDouble(), in.readDouble()));
    }

    private int posPairIndex(int posi1, int posi2) {
        if (posi2 > posi1) {
            throw new IllegalArgumentException("posi2 should be strictly less than posi1");
        }
        return posi1 * (posi1 - 1) / 2 + posi2;
    }

    public IndicesStatic indicesStatic(int ffi) {
        return this.indicesStatic[ffi];
    }

    public IndicesSingle indicesSingles(int ffi, int posi, int confi) {
        int fragi = this.positions[posi].confs[confi].fragIndex;
        return this.indicesSinglesByFrag(ffi, posi, fragi);
    }

    public IndicesSingle indicesSinglesByFrag(int ffi, int posi, int fragi) {
        return this.indicesSingles[ffi][posi][fragi];
    }

    public IndicesPair indicesPairs(int ffi, int posi1, int confi1, int posi2, int confi2) {
        int fragi1 = this.positions[posi1].confs[confi1].fragIndex;
        int fragi2 = this.positions[posi2].confs[confi2].fragIndex;
        return this.indicesPairsByFrags(ffi, posi1, fragi1, posi2, fragi2);
    }

    public IndicesPair indicesPairsByFrags(int ffi, int posi1, int fragi1, int posi2, int fragi2) {
        return this.indicesPairs[ffi][this.posPairIndex(posi1, posi2)][fragi1][fragi2];
    }

    public int getStaticAtomIndex(int atomi) {
        return atomi;
    }

    public int getConfAtomIndex(int posi, int atomi) {
        assert (atomi < this.positions[posi].maxNumAtoms) : String.format("atom %d can't belong to position %d, which only has %d atoms", atomi, posi, this.positions[posi].maxNumAtoms);
        return this.confAtomOffsetsByPos[posi] + atomi;
    }

    public Integer findPosIndex(int atomi) {
        if (atomi < this.confAtomOffsetsByPos[0]) {
            return -1;
        }
        for (int posi = 0; posi < this.positions.length - 1; ++posi) {
            if (atomi >= this.confAtomOffsetsByPos[posi + 1]) continue;
            return posi;
        }
        if (atomi < this.maxNumConfAtoms) {
            return this.positions.length - 1;
        }
        return null;
    }

    public long avgAtomPairs(List<PosInter> inters) {
        long count = 0L;
        for (PosInter inter : inters) {
            for (int ffi = 0; ffi < this.forcefieldIds.length; ++ffi) {
                count += this.avgAtomPairs(ffi, inter);
            }
        }
        return count;
    }

    public long avgAtomPairs(int ffi, PosInter inter) {
        long count = 0L;
        int n = 0;
        if (inter.posi1 == inter.posi2) {
            if (inter.posi1 == -1) {
                count += (long)this.indicesStatic(ffi).size();
                ++n;
            } else {
                for (int confi = 0; confi < this.numConf(inter.posi1); ++confi) {
                    count += (long)this.indicesSingles(ffi, inter.posi1, confi).sizeInternals();
                    ++n;
                }
            }
        } else if (inter.posi1 == -1) {
            for (int confi = 0; confi < this.numConf(inter.posi2); ++confi) {
                count += (long)this.indicesSingles(ffi, inter.posi2, confi).sizeStatics();
                ++n;
            }
        } else if (inter.posi2 == -1) {
            for (int confi = 0; confi < this.numConf(inter.posi1); ++confi) {
                count += (long)this.indicesSingles(ffi, inter.posi1, confi).sizeStatics();
                ++n;
            }
        } else {
            for (int confi1 = 0; confi1 < this.numConf(inter.posi1); ++confi1) {
                for (int confi2 = 0; confi2 < this.numConf(inter.posi2); ++confi2) {
                    count += (long)this.indicesPairs(ffi, inter.posi1, confi1, inter.posi2, confi2).size();
                    ++n;
                }
            }
        }
        return count / (long)n;
    }

    public double[] ffparams(int ffi, int paramsi) {
        return this.ffparams[ffi][paramsi];
    }

    @Override
    public int countSingles() {
        int count = 0;
        for (int posi1 = 0; posi1 < this.positions.length; ++posi1) {
            count += this.positions[posi1].confs.length;
        }
        return count;
    }

    @Override
    public int countPairs() {
        int count = 0;
        for (int posi1 = 1; posi1 < this.positions.length; ++posi1) {
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                count += this.positions[posi1].confs.length * this.positions[posi2].confs.length;
            }
        }
        return count;
    }

    @Override
    public int numPos() {
        return this.positions.length;
    }

    @Override
    public int numConf(int posi) {
        return this.positions[posi].confs.length;
    }

    public int numFrag(int posi) {
        return this.positions[posi].numFrags;
    }

    @Override
    public String name(int posi) {
        return this.positions[posi].name;
    }

    @Override
    public String confId(int posi, int confi) {
        return this.positions[posi].confs[confi].id;
    }

    @Override
    public String confType(int posi, int confi) {
        return this.positions[posi].confs[confi].type;
    }

    @Override
    public SeqSpace seqSpace() {
        return this.seqSpace;
    }

    @Override
    public String wildType(int posi) {
        return this.positions[posi].wildType;
    }

    @Override
    public boolean hasMutations(int posi) {
        return this.positions[posi].hasMutations;
    }

    public Pos findPos(String name) {
        for (Pos pos : this.positions) {
            if (!pos.name.equals(name)) continue;
            return pos;
        }
        return null;
    }

    public Integer findStaticAtomIndex(String name) {
        for (int i = 0; i < this.staticNames.length; ++i) {
            if (!this.staticNames[i].equals(name)) continue;
            return i;
        }
        return null;
    }

    public int[] assign() {
        int[] assignments = new int[this.positions.length];
        Arrays.fill(assignments, NotAssigned);
        return assignments;
    }

    public int[] assign(int posi1, int confi1) {
        int[] assignments = this.assign();
        assignments[posi1] = confi1;
        return assignments;
    }

    public int[] assign(int posi1, int confi1, int posi2, int confi2) {
        int[] assignments = this.assign(posi1, confi1);
        assignments[posi2] = confi2;
        return assignments;
    }

    public int[] assign(int posi1, int confi1, int posi2, int confi2, int posi3, int confi3) {
        int[] assignments = this.assign(posi1, confi1, posi2, confi2);
        assignments[posi3] = confi3;
        return assignments;
    }

    public int[] assign(RCTuple tuple) {
        int[] assignments = this.assign();
        for (int i = 0; i < tuple.size(); ++i) {
            assignments[tuple.pos.get((int)i).intValue()] = tuple.RCs.get(i);
        }
        return assignments;
    }

    public AssignedCoords makeCoords(int[] assignments) {
        AssignedCoords coords = new AssignedCoords(this, assignments);
        coords.copyCoords();
        coords.makeDofs();
        return coords;
    }

    public int hashCode() {
        return this.hash;
    }

    public static class MolInfo {
        public final String name;
        public final String type;
        public final ContinuousMotion.MolDescription[] motions;

        public MolInfo(String name, String type, int numMotions) {
            this.name = name;
            this.type = type;
            this.motions = new ContinuousMotion.MolDescription[numMotions];
        }
    }

    public static class ResInfo {
        public final String chainId;
        public final String resId;
        public final String resType;
        public final int indexInChain;

        public ResInfo(String chainId, String resId, String resType, int indexInChain) {
            this.chainId = chainId;
            this.resId = resId;
            this.resType = resType;
            this.indexInChain = indexInChain;
        }
    }

    public class Pos {
        public final int index;
        public final String name;
        public final String wildType;
        public final int numFrags;
        public final Conf[] confs;
        public final int maxNumAtoms;
        public final boolean hasMutations;

        public Pos(ConfSpace this$0, int index, String name, String wildType2, int numFrags, Conf[] confs) {
            this.index = index;
            this.name = name;
            this.wildType = wildType2;
            this.numFrags = numFrags;
            this.confs = confs;
            this.maxNumAtoms = Arrays.stream(confs).mapToInt(conf -> conf.numAtoms).max().orElse(0);
            this.hasMutations = Arrays.stream(confs).anyMatch(conf -> !conf.type.equals(wildType2));
        }

        public Conf findConf(String id) {
            for (Conf conf : this.confs) {
                if (!conf.id.equals(id)) continue;
                return conf;
            }
            return null;
        }

        public Conf findConfOrThrow(String id) {
            Conf conf = this.findConf(id);
            if (conf != null) {
                return conf;
            }
            throw new NoSuchElementException("no conf with id " + id);
        }
    }

    public class IndicesSingle {
        private final int[][] internals;
        private final int[][] statics;

        IndicesSingle(ConfSpace this$0, int[][] internals, int[][] statics) {
            this.internals = internals;
            this.statics = statics;
        }

        public int sizeInternals() {
            return this.internals.length;
        }

        public int getInternalConfAtom1Index(int i) {
            return this.internals[i][0];
        }

        public int getInternalConfAtom2Index(int i) {
            return this.internals[i][1];
        }

        public int getInternalParamsIndex(int i) {
            return this.internals[i][2];
        }

        public int sizeStatics() {
            return this.statics.length;
        }

        public int getStaticConfAtomIndex(int i) {
            return this.statics[i][0];
        }

        public int getStaticStaticAtomIndex(int i) {
            return this.statics[i][1];
        }

        public int getStaticParamsIndex(int i) {
            return this.statics[i][2];
        }
    }

    public class Conf {
        public final int index;
        public final String id;
        public final String type;
        public final int fragIndex;
        public final int numAtoms;
        public final CoordsList coords;
        public final String[] atomNames;
        public final int[] atomMolInfoIndices;
        public final int[] atomResInfoIndices;
        public final ContinuousMotion.ConfDescription[] motions;
        public final double[] energies;

        public Conf(ConfSpace this$0, int index, String id, String type, int fragIndex, int numAtoms, CoordsList coords, String[] atomNames2, int[] atomMolInfoIndices, int[] atomResInfoIndices, ContinuousMotion.ConfDescription[] motions, double[] energies) {
            this.index = index;
            this.id = id;
            this.type = type;
            this.fragIndex = fragIndex;
            this.numAtoms = numAtoms;
            this.coords = coords;
            this.atomNames = atomNames2;
            this.atomResInfoIndices = atomResInfoIndices;
            this.atomMolInfoIndices = atomMolInfoIndices;
            this.motions = motions;
            this.energies = energies;
        }

        public Integer findAtomIndex(String name) {
            for (int atomi = 0; atomi < this.numAtoms; ++atomi) {
                if (!this.atomNames[atomi].equals(name)) continue;
                return atomi;
            }
            return null;
        }

        public int findAtomIndexOrThrow(String name) {
            Integer atomi = this.findAtomIndex(name);
            if (atomi != null) {
                return atomi;
            }
            throw new NoSuchElementException("no atom with name " + name);
        }
    }

    public class IndicesStatic {
        private final int[][] indices;

        public IndicesStatic(ConfSpace this$0, int[][] indices) {
            this.indices = indices;
        }

        public int size() {
            return this.indices.length;
        }

        public int getStaticAtom1Index(int i) {
            return this.indices[i][0];
        }

        public int getStaticAtom2Index(int i) {
            return this.indices[i][1];
        }

        public int getParamsIndex(int i) {
            return this.indices[i][2];
        }
    }

    public class IndicesPair {
        private final int[][] indices;

        public IndicesPair(ConfSpace this$0, int[][] indices) {
            this.indices = indices;
        }

        public int size() {
            return this.indices.length;
        }

        public int getConfAtom1Index(int i) {
            return this.indices[i][0];
        }

        public int getConfAtom2Index(int i) {
            return this.indices[i][1];
        }

        public int getParamsIndex(int i) {
            return this.indices[i][2];
        }
    }
}

