/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.FreeDihedral;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class VoxelShape
implements Serializable {
    public static final double DefaultHalfWidthDegrees = 9.0;

    public abstract int countDihedralDOFs(ResidueTemplate var1);

    public abstract List<DegreeOfFreedom> makeDihedralDOFs(Residue var1);

    public abstract ObjectiveFunction.DofBounds makeDihedralBounds(ResidueTemplate var1, int var2);

    public abstract SimpleConfSpace.DofTypes getDofTypes();

    public static class Rect
    extends VoxelShape {
        public final double halfWidth;

        public Rect() {
            this(9.0);
        }

        public Rect(double halfWidth) {
            this.halfWidth = halfWidth;
        }

        @Override
        public int countDihedralDOFs(ResidueTemplate template) {
            return template.numDihedrals;
        }

        @Override
        public List<DegreeOfFreedom> makeDihedralDOFs(Residue res) {
            ArrayList<DegreeOfFreedom> dihedrals = new ArrayList<DegreeOfFreedom>();
            for (int i = 0; i < res.template.numDihedrals; ++i) {
                dihedrals.add(new FreeDihedral(res, i));
            }
            return dihedrals;
        }

        @Override
        public ObjectiveFunction.DofBounds makeDihedralBounds(ResidueTemplate template, int rotamerIndex) {
            ObjectiveFunction.DofBounds bounds = new ObjectiveFunction.DofBounds(template.numDihedrals);
            for (int d = 0; d < template.numDihedrals; ++d) {
                double chi = template.getRotamericDihedrals(rotamerIndex, d);
                bounds.set(d, chi - this.halfWidth, chi + this.halfWidth);
            }
            return bounds;
        }

        @Override
        public SimpleConfSpace.DofTypes getDofTypes() {
            return SimpleConfSpace.DofTypes.OnlyDihedrals;
        }
    }

    public static class Point
    extends VoxelShape {
        @Override
        public int countDihedralDOFs(ResidueTemplate template) {
            return 0;
        }

        @Override
        public List<DegreeOfFreedom> makeDihedralDOFs(Residue res) {
            return new ArrayList<DegreeOfFreedom>();
        }

        @Override
        public ObjectiveFunction.DofBounds makeDihedralBounds(ResidueTemplate template, int rotamerIndex) {
            return new ObjectiveFunction.DofBounds(0);
        }

        @Override
        public SimpleConfSpace.DofTypes getDofTypes() {
            return SimpleConfSpace.DofTypes.None;
        }
    }
}

