/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.tools.UnpossibleError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class TupleTree<T>
implements Serializable {
    private static final long serialVersionUID = -8048566743262701431L;
    public final RCTuple baseTuple;
    public final Node root = new Node(-1, -1);

    public TupleTree() {
        this(null);
    }

    public TupleTree(RCTuple baseTuple) {
        if (baseTuple != null) {
            baseTuple.checkSortedPositions();
        }
        this.baseTuple = baseTuple;
    }

    private void checkTuple(RCTuple tuple) {
        tuple.checkSortedPositions();
        if (this.baseTuple != null) {
            for (int i = 0; i < this.baseTuple.size(); ++i) {
                int bpos = this.baseTuple.pos.get(i);
                int brc = this.baseTuple.RCs.get(i);
                int tpos = tuple.pos.get(i);
                int trc = tuple.RCs.get(i);
                if (bpos == tpos && brc == trc) continue;
                throw new IllegalArgumentException("Tuple " + String.valueOf(tuple) + " doesn't match base tuple " + String.valueOf(this.baseTuple) + " for this tree");
            }
        }
    }

    private int getFirstIndex() {
        if (this.baseTuple == null) {
            return 0;
        }
        return this.baseTuple.size();
    }

    public T get(RCTuple tuple) {
        this.checkTuple(tuple);
        Node parent = this.root;
        int firstIndex = this.getFirstIndex();
        for (int i = tuple.size() - 1; i >= firstIndex; --i) {
            int rc;
            int pos = tuple.pos.get(i);
            Node node = parent.get(pos, rc = tuple.RCs.get(i).intValue());
            if (node == null) {
                return null;
            }
            if (i == firstIndex) {
                return node.data;
            }
            parent = node;
        }
        throw new UnpossibleError();
    }

    public void put(RCTuple tuple, T data) {
        this.checkTuple(tuple);
        Node parent = this.root;
        int firstIndex = this.getFirstIndex();
        for (int i = tuple.size() - 1; i >= firstIndex; --i) {
            int rc;
            int pos = tuple.pos.get(i);
            Node node = parent.get(pos, rc = tuple.RCs.get(i).intValue());
            if (node == null) {
                node = parent.makeChild(pos, rc);
            }
            if (i == firstIndex) {
                node.data = data;
                node.tuple = tuple;
                continue;
            }
            parent = node;
        }
    }

    public void clear() {
        this.root.children = null;
        this.root.data = null;
    }

    private boolean matchesBaseTuple(int[] conf) {
        if (this.baseTuple == null) {
            return true;
        }
        for (int i = 0; i < this.baseTuple.size(); ++i) {
            int pos = this.baseTuple.pos.get(i);
            int rc = this.baseTuple.RCs.get(i);
            if (rc == conf[pos]) continue;
            return false;
        }
        return true;
    }

    public void forEachIn(int[] conf, BiConsumer<RCTuple, T> callback) {
        if (this.matchesBaseTuple(conf)) {
            this.forEachIn(conf, this.root, conf.length, callback);
        }
    }

    private void forEachIn(int[] conf, Node parent, int untilPos, BiConsumer<RCTuple, T> callback) {
        for (int pos = 0; pos < untilPos; ++pos) {
            Node node;
            int rc = conf[pos];
            if (rc == -1 || (node = parent.get(pos, rc)) == null) continue;
            if (node.tuple != null) {
                callback.accept(node.tuple, (RCTuple)node.data);
            }
            if (node.children == null) continue;
            this.forEachIn(conf, node, pos, callback);
        }
    }

    public void forEachIn(int[] conf, int pos1, BiConsumer<RCTuple, T> callback) {
        if (this.matchesBaseTuple(conf)) {
            this.forEachIn(conf, pos1, this.root, pos1 + 1, callback);
        }
    }

    private void forEachIn(int[] conf, int pos1, Node parent, int untilPos, BiConsumer<RCTuple, T> callback) {
        for (int pos = pos1; pos < untilPos; ++pos) {
            Node node;
            int rc = conf[pos];
            if (rc == -1 || (node = parent.get(pos, rc)) == null) continue;
            if (node.tuple != null && node.tuple.pos.contains(pos1)) {
                callback.accept(node.tuple, (RCTuple)node.data);
            }
            if (node.children == null) continue;
            this.forEachIn(conf, node, pos, callback);
        }
    }

    public void forEachIn(int[] conf, int pos1, int pos2, BiConsumer<RCTuple, T> callback) {
        if (this.matchesBaseTuple(conf)) {
            this.forEachIn(conf, pos1, pos2, this.root, pos1 + 1, callback);
        }
    }

    private void forEachIn(int[] conf, int pos1, int pos2, Node parent, int untilPos, BiConsumer<RCTuple, T> callback) {
        for (int pos = Math.max(pos1, pos2); pos < untilPos; ++pos) {
            Node node;
            int rc = conf[pos];
            if (rc == -1 || (node = parent.get(pos, rc)) == null) continue;
            if (node.tuple != null && node.tuple.pos.contains(pos1) && node.tuple.pos.contains(pos2)) {
                callback.accept(node.tuple, (RCTuple)node.data);
            }
            if (node.children == null) continue;
            this.forEachIn(conf, node, pos, callback);
        }
    }

    public List<RCTuple> makeTuplesList() {
        ArrayList<RCTuple> tuples = new ArrayList<RCTuple>();
        this.addTuplesToList(tuples, this.root);
        return tuples;
    }

    private void addTuplesToList(List<RCTuple> tuples, Node node) {
        if (node.tuple != null) {
            tuples.add(node.tuple);
        }
        if (node.children == null) {
            return;
        }
        for (List<Node> nodes : node.children) {
            if (nodes == null) continue;
            for (Node child : nodes) {
                if (child == null) continue;
                this.addTuplesToList(tuples, child);
            }
        }
    }

    private class Node
    implements Serializable {
        private static final long serialVersionUID = -47314393953695943L;
        final int pos;
        final int rc;
        List<List<Node>> children = null;
        RCTuple tuple = null;
        T data = null;

        Node(int pos, int rc) {
            this.pos = pos;
            this.rc = rc;
        }

        public Node makeChild(int pos, int rc) {
            if (this.children == null) {
                this.children = new ArrayList<List<Node>>();
            }
            while (this.children.size() <= pos) {
                this.children.add(null);
            }
            List<Node> nodes = this.children.get(pos);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.children.set(pos, nodes);
            }
            while (nodes.size() <= rc) {
                nodes.add(null);
            }
            Node child = new Node(pos, rc);
            nodes.set(rc, child);
            return child;
        }

        public Node get(int pos, int rc) {
            if (this.children == null) {
                return null;
            }
            if (pos >= this.children.size()) {
                return null;
            }
            List<Node> nodes = this.children.get(pos);
            if (nodes == null) {
                return null;
            }
            if (rc >= nodes.size()) {
                return null;
            }
            return nodes.get(rc);
        }
    }
}

