/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.AbstractTupleMatrix;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import java.util.ArrayList;

public class TupleMatrixGeneric<T>
extends AbstractTupleMatrix<T> {
    private static final long serialVersionUID = 845854459137269739L;
    private ArrayList<T> oneBody;
    private ArrayList<T> pairwise;

    protected TupleMatrixGeneric() {
    }

    public TupleMatrixGeneric(SimpleConfSpace confSpace) {
        this(confSpace.getNumPos(), confSpace.getNumResConfsByPos(), 0.0, null);
    }

    public TupleMatrixGeneric(ConfSpaceIteration confSpace) {
        this(confSpace.numPos(), confSpace.numConfsByPos(), 0.0, null);
    }

    public TupleMatrixGeneric(ConfSpace cSpace, double pruningInterval, T defaultHigherInteraction) {
        super(cSpace, pruningInterval, defaultHigherInteraction);
    }

    public TupleMatrixGeneric(int numPos, int[] numConfAtPos, double pruningInterval, T defaultHigherInteraction) {
        super(numPos, numConfAtPos, pruningInterval, defaultHigherInteraction);
    }

    @Override
    protected void allocate(int numOneBody, int numPairwise) {
        int i;
        this.oneBody = new ArrayList(numOneBody);
        for (i = 0; i < numOneBody; ++i) {
            this.oneBody.add(null);
        }
        this.pairwise = new ArrayList(numPairwise);
        for (i = 0; i < numPairwise; ++i) {
            this.pairwise.add(null);
        }
    }

    @Override
    public T getOneBody(int res, int conf) {
        return this.oneBody.get(this.getOneBodyIndex(res, conf));
    }

    @Override
    public void setOneBody(int res, int conf, T val) {
        this.oneBody.set(this.getOneBodyIndex(res, conf), val);
    }

    @Override
    public void setOneBody(int res, ArrayList<T> val) {
        int n = this.getNumConfAtPos(res);
        for (int i = 0; i < n; ++i) {
            this.oneBody.set(this.getOneBodyIndex(res, i), val.get(i));
        }
    }

    @Override
    public T getPairwise(int res1, int conf1, int res2, int conf2) {
        return this.pairwise.get(this.getPairwiseIndex(res1, conf1, res2, conf2));
    }

    @Override
    public void setPairwise(int res1, int conf1, int res2, int conf2, T val) {
        this.pairwise.set(this.getPairwiseIndex(res1, conf1, res2, conf2), val);
    }

    @Override
    public void setPairwise(int res1, int res2, ArrayList<ArrayList<T>> val) {
        int n1 = this.getNumConfAtPos(res1);
        int n2 = this.getNumConfAtPos(res2);
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pairwise.set(this.getPairwiseIndex(res1, i1, res2, i2), val.get(i1).get(i2));
            }
        }
    }
}

