/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.MoveableStrand;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class StrandFlex
implements Serializable {
    public abstract List<? extends DegreeOfFreedom> makeDofs(Strand var1, Molecule var2);

    public abstract ObjectiveFunction.DofBounds makeBounds(Strand var1);

    public int countDofs(Strand strand) {
        return this.makeDofs(strand, strand.mol).size();
    }

    public abstract ArrayList<HashMap<String, double[]>> listBackboneVoxels(SimpleConfSpace.Position var1);

    public SimpleConfSpace.DofTypes getDofTypes() {
        return SimpleConfSpace.DofTypes.Any;
    }

    protected HashMap<String, double[]> defaultBackboneVoxel(Strand strand) {
        List<? extends DegreeOfFreedom> dofs = this.makeDofs(strand, strand.mol);
        ObjectiveFunction.DofBounds bounds = this.makeBounds(strand);
        HashMap<String, double[]> vox = new HashMap<String, double[]>();
        for (int d = 0; d < dofs.size(); ++d) {
            vox.put(dofs.get(d).getName(), new double[]{bounds.getMin(d), bounds.getMax(d)});
        }
        return vox;
    }

    public static class TranslateRotate
    extends StrandFlex {
        public static final double DefaultMaxRotDegrees = 5.0;
        public static final double DefaultMaxTranslation = 1.2;
        private double maxRotDegrees;
        private double maxTranslation;

        public TranslateRotate() {
            this(5.0, 1.2);
        }

        public TranslateRotate(double maxRotDegrees, double maxTranslation) {
            this.maxRotDegrees = maxRotDegrees;
            this.maxTranslation = maxTranslation;
        }

        public List<DegreeOfFreedom> makeDofs(Strand strand, Molecule mol) {
            ArrayList<Residue> movingResidues = new ArrayList<Residue>();
            for (Residue origRes : strand.mol.residues) {
                movingResidues.add(origRes.equivalentInMolec(mol));
            }
            return new MoveableStrand(movingResidues).getDOFs();
        }

        @Override
        public ObjectiveFunction.DofBounds makeBounds(Strand strand) {
            ObjectiveFunction.DofBounds bounds = new ObjectiveFunction.DofBounds(6);
            bounds.set(0, -this.maxRotDegrees, this.maxRotDegrees);
            bounds.set(1, -this.maxRotDegrees, this.maxRotDegrees);
            bounds.set(2, -this.maxRotDegrees, this.maxRotDegrees);
            bounds.set(3, -this.maxTranslation, this.maxTranslation);
            bounds.set(4, -this.maxTranslation, this.maxTranslation);
            bounds.set(5, -this.maxTranslation, this.maxTranslation);
            return bounds;
        }

        @Override
        public ArrayList<HashMap<String, double[]>> listBackboneVoxels(SimpleConfSpace.Position pos) {
            return new ArrayList<HashMap<String, double[]>>(Arrays.asList(this.defaultBackboneVoxel(pos.strand)));
        }
    }

    public static class None
    extends StrandFlex {
        public List<DegreeOfFreedom> makeDofs(Strand strand, Molecule mol) {
            return new ArrayList<DegreeOfFreedom>();
        }

        @Override
        public ObjectiveFunction.DofBounds makeBounds(Strand strand) {
            return new ObjectiveFunction.DofBounds(0);
        }

        @Override
        public ArrayList<HashMap<String, double[]>> listBackboneVoxels(SimpleConfSpace.Position pos) {
            return new ArrayList<HashMap<String, double[]>>();
        }
    }
}

