/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.structure.Molecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class DEEPerStrandFlex
extends StrandFlex {
    DEEPerSettings dset;
    ArrayList<Perturbation> perts;

    public DEEPerStrandFlex(Strand strand, DEEPerSettings dset) {
        dset.loadPertFile(null);
        this.perts = dset.makePerturbations(strand.mol);
        this.dset = dset;
    }

    @Override
    public List<? extends DegreeOfFreedom> makeDofs(Strand strand, Molecule mol) {
        LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom> original2CopiedDOF = new LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom>();
        HashMap<DOFBlock, DOFBlock> newBlocks = new HashMap<DOFBlock, DOFBlock>();
        for (DegreeOfFreedom degreeOfFreedom : this.perts) {
            DOFBlock block = degreeOfFreedom.getBlock();
            if (newBlocks.containsKey(block)) continue;
            DOFBlock copiedBlock = block.copyForNewMolecule(mol, original2CopiedDOF);
            newBlocks.put(block, copiedBlock);
        }
        return new ArrayList(original2CopiedDOF.values());
    }

    @Override
    public ObjectiveFunction.DofBounds makeBounds(Strand strand) {
        throw new RuntimeException("ERROR: makeBounds is not well-defined for DEEPerStrandFlex, because there may be multiple backbone voxels and DOFs may only affect a few positions");
    }

    @Override
    public ArrayList<HashMap<String, double[]>> listBackboneVoxels(SimpleConfSpace.Position pos) {
        ArrayList<ArrayList<double[]>> pertIntervals = this.dset.getPertIntervals();
        ArrayList<ArrayList<Object>> pertStates = this.dset.getPertStates(pos.index);
        if (pertStates == null) {
            pertStates = new ArrayList();
            pertStates.add(null);
        }
        ArrayList<HashMap<String, double[]>> ans = new ArrayList<HashMap<String, double[]>>();
        for (ArrayList<Object> pertState : pertStates) {
            HashMap<String, double[]> vox = new HashMap<String, double[]>();
            if (pertState != null) {
                for (int[] nArray : pertState) {
                    int pertNum = nArray[0];
                    int pertStateNum = nArray[1];
                    double[] pertInterval = pertIntervals.get(pertNum).get(pertStateNum);
                    vox.put(this.perts.get(pertNum).getName(), (double[])pertInterval.clone());
                }
            }
            ans.add(vox);
        }
        return ans;
    }
}

