/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.Queue;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.gmec.ConsoleConfPrinter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public interface ConfSearch {
    public ScoredConf nextConf();

    default public BigInteger getNumConformations() {
        throw new UnsupportedOperationException();
    }

    default public List<ScoredConf> nextConfs(double maxEnergy) {
        ScoredConf conf;
        ArrayList<ScoredConf> nodes = new ArrayList<ScoredConf>();
        while ((conf = this.nextConf()) != null) {
            nodes.add(conf);
            if (!(conf.getScore() >= maxEnergy)) continue;
            break;
        }
        return nodes;
    }

    default public List<ScoredConf> nextConfs(int num) {
        ScoredConf conf;
        ArrayList<ScoredConf> confs = new ArrayList<ScoredConf>();
        for (int i = 0; i < num && (conf = this.nextConf()) != null; ++i) {
            confs.add(conf);
        }
        return confs;
    }

    public static class ScoredConf
    implements Serializable {
        private int[] assignments;
        private double score;

        public ScoredConf(int[] assignments, double score) {
            this.assignments = assignments;
            this.score = score;
        }

        public ScoredConf(ScoredConf other) {
            this.assignments = (int[])other.assignments.clone();
            this.score = other.score;
        }

        public int[] getAssignments() {
            return this.assignments;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double val) {
            this.score = val;
        }

        public void offsetScore(double val) {
            this.score += val;
        }

        public boolean equals(Object other) {
            return other instanceof ScoredConf && this.equals((ScoredConf)other);
        }

        public boolean equals(ScoredConf other) {
            return Arrays.equals(this.assignments, other.assignments) && Double.compare(this.score, other.score) == 0;
        }

        public String toString() {
            return String.format("%s %.4f", Conf.toString(this.assignments), this.score);
        }
    }

    public static class Splitter {
        public final ConfSearch confs;
        public final ConfSearch first;
        public final ConfSearch second;
        private Queue.FIFO<ScoredConf> buf;

        public Splitter(ConfSearch confs) {
            this(confs, false, null);
        }

        public Splitter(final ConfSearch confs, boolean useExternalMemory, RCs rcs) {
            this.confs = confs;
            this.buf = Queue.FIFOFactory.of(new ScoredConf[0]);
            final AtomicBoolean exhausted = new AtomicBoolean(false);
            this.first = new ConfSearch(){

                @Override
                public ScoredConf nextConf() {
                    ScoredConf conf = confs.nextConf();
                    if (conf == null) {
                        exhausted.set(true);
                        return null;
                    }
                    buf.push(conf);
                    return conf;
                }

                @Override
                public BigInteger getNumConformations() {
                    return confs.getNumConformations();
                }
            };
            this.second = new ConfSearch(){

                @Override
                public ScoredConf nextConf() {
                    ScoredConf conf = (ScoredConf)buf.poll();
                    if (conf == null && !exhausted.get()) {
                        throw new OutOfOrderException();
                    }
                    return conf;
                }

                @Override
                public BigInteger getNumConformations() {
                    return confs.getNumConformations();
                }
            };
        }

        public static class OutOfOrderException
        extends RuntimeException {
            public OutOfOrderException() {
                super("second reader tried to read confs before first reader");
            }
        }
    }

    public static class MultiSplitter {
        private ConfSearch confs;
        private CircularFifoQueue<ScoredConf> buf;
        private long firstIndex;
        private List<Stream> streams;

        public MultiSplitter(ConfSearch confs) {
            this.confs = confs;
            this.buf = new CircularFifoQueue();
            this.firstIndex = 0L;
            this.streams = new ArrayList<Stream>();
        }

        public Stream makeStream() {
            if (this.firstIndex > 0L) {
                throw new IllegalStateException("can't start new stream after first read");
            }
            Stream stream = new Stream();
            this.streams.add(stream);
            return stream;
        }

        public int getBufferSize() {
            return this.buf.size();
        }

        public class Stream
        implements ConfSearch {
            private long index = 0L;

            private Stream() {
            }

            public ConfSearch getSource() {
                return MultiSplitter.this.confs;
            }

            @Override
            public ScoredConf nextConf() {
                long pos = this.index - MultiSplitter.this.firstIndex;
                assert (pos >= 0L);
                assert (pos <= (long)MultiSplitter.this.buf.size());
                ScoredConf conf = null;
                if (pos == (long)MultiSplitter.this.buf.size()) {
                    conf = MultiSplitter.this.confs.nextConf();
                    if (conf != null) {
                        if (MultiSplitter.this.buf.isAtFullCapacity()) {
                            CircularFifoQueue newBuf = new CircularFifoQueue(MultiSplitter.this.buf.maxSize() * 2);
                            newBuf.addAll(MultiSplitter.this.buf);
                            MultiSplitter.this.buf = newBuf;
                        }
                        MultiSplitter.this.buf.add((Object)conf);
                    }
                } else {
                    if (pos > Integer.MAX_VALUE) {
                        throw new Error("Integer overflow! Conf buffer grew too large: " + pos);
                    }
                    conf = (ScoredConf)MultiSplitter.this.buf.get((int)pos);
                }
                if (conf != null) {
                    ++this.index;
                    assert (this.index - MultiSplitter.this.firstIndex <= (long)(MultiSplitter.this.buf.size() + 1));
                }
                if (pos == 0L && this.everyoneHasReadFirst()) {
                    MultiSplitter.this.buf.remove();
                    ++MultiSplitter.this.firstIndex;
                }
                return conf;
            }

            private boolean everyoneHasReadFirst() {
                for (Stream other : MultiSplitter.this.streams) {
                    if (other.index != MultiSplitter.this.firstIndex) continue;
                    return false;
                }
                return true;
            }

            @Override
            public BigInteger getNumConformations() {
                return MultiSplitter.this.confs.getNumConformations();
            }

            public void close() {
                MultiSplitter.this.streams.remove(this);
                long minIndex = Long.MAX_VALUE;
                for (Stream stream : MultiSplitter.this.streams) {
                    minIndex = Math.min(minIndex, stream.index);
                }
                while (this.index < minIndex) {
                    MultiSplitter.this.buf.remove();
                    ++this.index;
                    ++MultiSplitter.this.firstIndex;
                }
            }
        }
    }

    public static class EnergiedConf
    extends ScoredConf
    implements Serializable {
        private double energy;

        public EnergiedConf(ScoredConf conf, double energy) {
            super(conf);
            this.energy = energy;
        }

        public EnergiedConf(int[] conf, double score, double energy) {
            super(conf, score);
            this.energy = energy;
        }

        public double getEnergy() {
            return this.energy;
        }

        public void setEnergy(double val) {
            this.energy = val;
        }

        public void offsetEnergy(double val) {
            this.energy += val;
        }

        @Override
        public String toString() {
            return this.toString(null);
        }

        public String toString(SimpleConfSpace confSpace) {
            return ConsoleConfPrinter.makeReport(this, confSpace, null);
        }

        public HashMap<String, List<String>> getProperties(SimpleConfSpace confSpace) {
            return ConsoleConfPrinter.makeReportMap(this, confSpace, null);
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof EnergiedConf && this.equals((EnergiedConf)other);
        }

        public boolean equals(EnergiedConf other) {
            return super.equals(other) && Double.compare(this.energy, other.energy) == 0;
        }
    }
}

