/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.tools.AutoCleanable;
import edu.duke.cs.osprey.tools.IntEncoding;
import edu.duke.cs.osprey.tools.MapDBTools;
import edu.duke.cs.osprey.tools.Streams;
import edu.duke.cs.osprey.tools.UnpossibleError;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;

public class ConfDB
implements AutoCleanable {
    public final ConfSpaceIteration confSpace;
    public final File file;
    private final DB db;
    private final Map<String, ConfTable> tables;
    private final HTreeMap<Sequence, SequenceInfo> sequences;
    private final Map<Sequence, SequenceDB> sequenceDBs;
    private final IntEncoding assignmentEncoding;

    public static ConfDB makeIfNeeded(ConfSpaceIteration confSpace, File file) {
        if (file == null) {
            return null;
        }
        return new ConfDB(confSpace, file);
    }

    public ConfDB(ConfSpaceIteration confSpace) {
        this(confSpace, null);
    }

    public ConfDB(ConfSpaceIteration confSpace, File file) {
        this.confSpace = confSpace;
        this.file = file;
        int maxAssignment = IntStream.range(0, confSpace.numPos()).map(pos -> confSpace.numConf(pos)).max().orElse(0);
        this.assignmentEncoding = IntEncoding.get(maxAssignment + 1);
        MapDBTools.SequenceSerializer sequenceSerializer = new MapDBTools.SequenceSerializer(confSpace.seqSpace());
        int infoSize = 8;
        MapDBTools.SimpleSerializer<SequenceInfo> infoSerializer = new MapDBTools.SimpleSerializer<SequenceInfo>(this, 8){

            public void serialize(@NotNull DataOutput2 out, @NotNull SequenceInfo info2) throws IOException {
                out.writeDouble(info2.lowerEnergyOfUnsampledConfs);
            }

            public SequenceInfo deserialize(@NotNull DataInput2 in, int available) throws IOException {
                return new SequenceInfo(in.readDouble());
            }
        };
        this.db = file != null ? DBMaker.fileDB((File)file).transactionEnable().fileMmapEnableIfSupported().closeOnJvmShutdown().make() : DBMaker.memoryDB().make();
        this.tables = new HashMap<String, ConfTable>();
        this.sequences = this.db.hashMap("sequences").keySerializer((Serializer)sequenceSerializer).valueSerializer((Serializer)infoSerializer).createOrOpen();
        this.sequenceDBs = new HashMap<Sequence, SequenceDB>();
    }

    public ConfTable get(Key key) {
        if (key == null) {
            return null;
        }
        if (key.rtIndices != null) {
            return this.getSequence(new Sequence(this.confSpace.seqSpace(), key.rtIndices));
        }
        if (key.table != null) {
            return this.table(key.table);
        }
        throw new UnpossibleError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfTable table(String name) {
        Map<String, ConfTable> map = this.tables;
        synchronized (map) {
            ConfTable table = this.tables.get(name);
            if (table == null) {
                table = new ConfTable(name);
                this.tables.put(name, table);
            }
            return table;
        }
    }

    public long getNumSequences() {
        return this.sequences.sizeLong();
    }

    public Iterable<Sequence> getSequences() {
        return this.sequences.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceDB getSequence(Sequence sequence) {
        if (sequence.seqSpace != this.confSpace.seqSpace()) {
            throw new IllegalArgumentException("this sequence is from a different sequence space than the sequence space used by this db");
        }
        Map<Sequence, SequenceDB> map = this.sequenceDBs;
        synchronized (map) {
            SequenceDB sdb = this.sequenceDBs.get(sequence);
            if (sdb == null) {
                sdb = new SequenceDB(sequence);
                this.sequenceDBs.put(sequence, sdb);
                if (!this.sequences.containsKey((Object)sequence)) {
                    this.sequences.put((Object)sequence, (Object)new SequenceInfo());
                }
            }
            return sdb;
        }
    }

    public void flush() {
        this.db.commit();
    }

    @Override
    public void close() {
        this.flush();
        for (ConfTable table : this.tables.values()) {
            table.close();
        }
        this.tables.clear();
        for (SequenceDB sdb : this.sequenceDBs.values()) {
            sdb.close();
        }
        this.sequenceDBs.clear();
        this.db.close();
    }

    @Override
    public void clean() {
        this.close();
    }

    public static class Key
    implements Serializable {
        public final int[] rtIndices;
        public final String table;

        public Key(Sequence seq) {
            this(seq.rtIndices);
        }

        public Key(int[] rtIndices) {
            this.rtIndices = rtIndices;
            this.table = null;
        }

        public Key(String table) {
            this.rtIndices = null;
            this.table = table;
        }
    }

    public class SequenceDB
    extends ConfTable {
        public final Sequence sequence;

        public SequenceDB(Sequence sequence) {
            super(Streams.joinToString(ConfDB.this.confSpace.seqSpace().positions, ":", pos -> sequence.get((SeqSpace.Position)pos).name));
            this.sequence = sequence;
        }

        private SequenceInfo getInfo() {
            return (SequenceInfo)ConfDB.this.sequences.get((Object)this.sequence);
        }

        private void setInfo(SequenceInfo info2) {
            ConfDB.this.sequences.put((Object)this.sequence, (Object)info2);
        }

        public double getLowerEnergyOfUnsampledConfs() {
            return this.getInfo().lowerEnergyOfUnsampledConfs;
        }

        public void setLowerEnergyOfUnsampledConfs(double val) {
            SequenceInfo info2 = this.getInfo();
            info2.lowerEnergyOfUnsampledConfs = val;
            this.setInfo(info2);
        }

        public void updateLowerEnergyOfUnsampledConfs(double val) {
            SequenceInfo info2 = this.getInfo();
            if (Double.isNaN(info2.lowerEnergyOfUnsampledConfs) || val > info2.lowerEnergyOfUnsampledConfs) {
                info2.lowerEnergyOfUnsampledConfs = val;
            }
            this.setInfo(info2);
        }
    }

    public class ConfTable
    implements Iterable<Conf>,
    AutoCloseable {
        public final String id;
        private final BTreeMap<int[], ConfInfo> btree;
        private final EnergyIndex lowerIndex;
        private final EnergyIndex upperIndex;

        public ConfTable(String id) {
            this.id = id;
            int ConfInfoBytes = 32;
            MapDBTools.SimpleSerializer<ConfInfo> confInfoSerializer = new MapDBTools.SimpleSerializer<ConfInfo>(this, 32){

                public void serialize(@NotNull DataOutput2 out, @NotNull ConfInfo info2) throws IOException {
                    out.writeDouble(info2.lowerEnergy);
                    out.writeLong(info2.lowerTimestampNs);
                    out.writeDouble(info2.upperEnergy);
                    out.writeLong(info2.upperTimestampNs);
                }

                public ConfInfo deserialize(@NotNull DataInput2 in, int available) throws IOException {
                    return new ConfInfo(in.readDouble(), in.readLong(), in.readDouble(), in.readLong());
                }
            };
            this.btree = ConfDB.this.db.treeMap(id).keySerializer((GroupSerializer)new AssignmentsSerializer()).valueSerializer((GroupSerializer)confInfoSerializer).createOrOpen();
            this.lowerIndex = new EnergyIndex(ConfDB.this, id + "-lowerEnergy");
            this.upperIndex = new EnergyIndex(ConfDB.this, id + "-upperEnergy");
        }

        @Override
        public void close() {
            this.btree.close();
        }

        public void setBounds(ConfSearch.EnergiedConf econf, long timestampNs) {
            this.setBounds(econf.getAssignments(), econf.getScore(), econf.getEnergy(), timestampNs);
        }

        public void setBounds(int[] assignments, double lowerEnergy, double upperEnergy, long timestampNs) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 == null) {
                info2 = new ConfInfo();
            } else {
                if (info2.lowerTimestampNs != 0L) {
                    this.lowerIndex.remove(info2.lowerEnergy, assignments);
                }
                if (info2.upperTimestampNs != 0L) {
                    this.upperIndex.remove(info2.upperEnergy, assignments);
                }
            }
            info2.lowerEnergy = lowerEnergy;
            info2.lowerTimestampNs = timestampNs;
            info2.upperEnergy = upperEnergy;
            info2.upperTimestampNs = timestampNs;
            this.btree.put((Object)assignments, (Object)info2);
            this.lowerIndex.add(lowerEnergy, assignments);
            this.upperIndex.add(upperEnergy, assignments);
        }

        public void setLowerBound(int[] assignments, double energy, long timestampNs) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 == null) {
                info2 = new ConfInfo();
            } else if (info2.lowerTimestampNs != 0L) {
                this.lowerIndex.remove(info2.lowerEnergy, assignments);
            }
            info2.lowerEnergy = energy;
            info2.lowerTimestampNs = timestampNs;
            this.btree.put((Object)assignments, (Object)info2);
            this.lowerIndex.add(energy, assignments);
        }

        public void setUpperBound(int[] assignments, double energy, long timestampNs) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 == null) {
                info2 = new ConfInfo();
            } else if (info2.upperTimestampNs != 0L) {
                this.upperIndex.remove(info2.upperEnergy, assignments);
            }
            info2.upperEnergy = energy;
            info2.upperTimestampNs = timestampNs;
            this.btree.put((Object)assignments, (Object)info2);
            this.upperIndex.add(energy, assignments);
        }

        public Conf get(int[] assignments) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 == null) {
                return null;
            }
            return new Conf(assignments, info2);
        }

        public ConfSearch.ScoredConf getScored(int[] assignments) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 == null) {
                return null;
            }
            return new ConfSearch.ScoredConf(assignments, info2.lowerTimestampNs == 0L ? Double.NaN : info2.lowerEnergy);
        }

        public ConfSearch.EnergiedConf getEnergied(ConfSearch.ScoredConf conf) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)conf.getAssignments());
            if (info2 == null || info2.upperTimestampNs == 0L) {
                return null;
            }
            return new ConfSearch.EnergiedConf(conf, info2.upperEnergy);
        }

        public ConfSearch.EnergiedConf getEnergied(int[] assignments) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 == null) {
                return null;
            }
            return new ConfSearch.EnergiedConf(assignments, info2.lowerTimestampNs == 0L ? Double.NaN : info2.lowerEnergy, info2.upperTimestampNs == 0L ? Double.NaN : info2.upperEnergy);
        }

        public void remove(int[] assignments) {
            ConfInfo info2 = (ConfInfo)this.btree.get((Object)assignments);
            if (info2 != null) {
                if (info2.lowerTimestampNs != 0L) {
                    this.lowerIndex.remove(info2.lowerEnergy, assignments);
                }
                if (info2.upperTimestampNs != 0L) {
                    this.upperIndex.remove(info2.upperEnergy, assignments);
                }
                this.btree.remove((Object)assignments);
            }
        }

        @Override
        public Iterator<Conf> iterator() {
            return Streams.of(this.btree.entryIterator()).map(entry -> new Conf((int[])entry.getKey(), (ConfInfo)entry.getValue())).iterator();
        }

        public Iterable<ConfSearch.ScoredConf> scoredConfs(SortOrder sort) {
            switch (sort) {
                case Assignment: {
                    return () -> Streams.of(this.iterator()).map(conf -> conf.toScoredConf()).iterator();
                }
                case Score: {
                    return () -> Streams.of(this.lowerIndex.iterator()).map(entry -> new ConfSearch.ScoredConf((int[])entry.getValue(), (Double)entry.getKey())).iterator();
                }
                case Energy: {
                    return () -> Streams.of(this.upperIndex.iterator()).map(entry -> this.getScored((int[])entry.getValue())).filter(conf -> conf != null).iterator();
                }
            }
            throw new UnpossibleError();
        }

        public Iterable<ConfSearch.EnergiedConf> energiedConfs(SortOrder sort) {
            switch (sort) {
                case Assignment: {
                    return () -> Streams.of(this.iterator()).map(conf -> conf.toEnergiedConf()).iterator();
                }
                case Score: {
                    return () -> Streams.of(this.lowerIndex.iterator()).map(entry -> this.getEnergied((int[])entry.getValue())).filter(conf -> conf != null).iterator();
                }
                case Energy: {
                    return () -> Streams.of(this.upperIndex.iterator()).map(entry -> this.getEnergied((int[])entry.getValue())).filter(conf -> conf != null).iterator();
                }
            }
            throw new UnpossibleError();
        }

        public Iterable<Double> lowerBounds() {
            return () -> this.lowerIndex.btree.keyIterator();
        }

        public Iterable<Double> upperBounds() {
            return () -> this.upperIndex.btree.keyIterator();
        }

        public List<Conf> getConfsByLowerBound(double energy) {
            List<int[]> multiAssignments = this.lowerIndex.get(energy);
            if (multiAssignments == null) {
                return null;
            }
            return Streams.of(multiAssignments).map(assignments -> this.get((int[])assignments)).collect(Collectors.toList());
        }

        public List<Conf> getConfsByUpperBound(double energy) {
            List<int[]> multiAssignments = this.upperIndex.get(energy);
            if (multiAssignments == null) {
                return null;
            }
            return Streams.of(multiAssignments).map(assignments -> this.get((int[])assignments)).collect(Collectors.toList());
        }

        public long size() {
            return this.btree.sizeLong();
        }

        public void flush() {
            ConfDB.this.flush();
        }
    }

    private static class SequenceInfo {
        public double lowerEnergyOfUnsampledConfs;

        public SequenceInfo() {
            this.lowerEnergyOfUnsampledConfs = Double.NaN;
        }

        public SequenceInfo(double lowerEnergyOfUnsampledConfs) {
            this.lowerEnergyOfUnsampledConfs = lowerEnergyOfUnsampledConfs;
        }
    }

    private class EnergyIndex
    implements Iterable<Map.Entry<Double, int[]>> {
        public final BTreeMap<Double, List<int[]>> btree;

        public EnergyIndex(ConfDB confDB, String id) {
            this.btree = confDB.db.treeMap(id).keySerializer(Serializer.DOUBLE).valueSerializer((GroupSerializer)confDB.new MultiAssignmentsSerializer()).createOrOpen();
        }

        public List<int[]> get(double energy) {
            return (List)this.btree.get((Object)energy);
        }

        public void add(double energy, int[] assignments) {
            List<Object> multiAssignments = this.get(energy);
            if (multiAssignments == null) {
                multiAssignments = Arrays.asList(new int[][]{assignments});
            } else {
                if (this.hasAssignments(multiAssignments, assignments)) {
                    return;
                }
                multiAssignments.add(assignments);
            }
            this.btree.put((Object)energy, multiAssignments);
        }

        public void remove(double energy, int[] assignments) {
            List<int[]> multiAssignments = this.get(energy);
            if (multiAssignments != null && this.removeAssignments(multiAssignments, assignments)) {
                if (multiAssignments.size() == 0) {
                    this.btree.remove((Object)energy);
                } else {
                    this.btree.put((Object)energy, multiAssignments);
                }
            }
        }

        @Override
        public Iterator<Map.Entry<Double, int[]>> iterator() {
            return Streams.of(this.btree.entryIterator()).flatMap(entry -> ((List)entry.getValue()).stream().map(assignments -> new EnergiedAssignments(this, (Double)entry.getKey(), (int[])assignments))).iterator();
        }

        private boolean hasAssignments(List<int[]> multiAssignments, int[] assignments) {
            for (int[] a : multiAssignments) {
                if (!Arrays.equals(a, assignments)) continue;
                return true;
            }
            return false;
        }

        private boolean removeAssignments(List<int[]> multiAssignments, int[] assignments) {
            Iterator<int[]> iter = multiAssignments.iterator();
            while (iter.hasNext()) {
                int[] a = iter.next();
                if (!Arrays.equals(a, assignments)) continue;
                iter.remove();
                return true;
            }
            return false;
        }

        private class EnergiedAssignments
        implements Map.Entry<Double, int[]> {
            public final double energy;
            public final int[] assignments;

            public EnergiedAssignments(EnergyIndex energyIndex, double energy, int[] assignments) {
                this.energy = energy;
                this.assignments = assignments;
            }

            @Override
            public Double getKey() {
                return this.energy;
            }

            @Override
            public int[] getValue() {
                return this.assignments;
            }

            @Override
            public int[] setValue(int[] value2) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class MultiAssignmentsSerializer
    extends MapDBTools.SimpleSerializer<List<int[]>> {
        private final AssignmentsSerializer serializer;

        public MultiAssignmentsSerializer() {
            super(-1);
            this.serializer = new AssignmentsSerializer();
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull List<int[]> multiAssignments) throws IOException {
            out.writeInt(multiAssignments.size());
            for (int[] assignments : multiAssignments) {
                this.serializer.serialize(out, assignments);
            }
        }

        public List<int[]> deserialize(@NotNull DataInput2 in, int available) throws IOException {
            ArrayList<int[]> multiAssignments = new ArrayList<int[]>();
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                multiAssignments.add(this.serializer.deserialize(in, available));
            }
            return multiAssignments;
        }
    }

    private class AssignmentsSerializer
    extends MapDBTools.SimpleSerializer<int[]> {
        private final int numPos;

        public AssignmentsSerializer() {
            super(ConfDB.this.assignmentEncoding.numBytes * ConfDB.this.confSpace.numPos());
            this.numPos = ConfDB.this.confSpace.numPos();
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull int[] assignments) throws IOException {
            for (int i = 0; i < this.numPos; ++i) {
                ConfDB.this.assignmentEncoding.write((DataOutput)out, assignments[i] + 1);
            }
        }

        public int[] deserialize(@NotNull DataInput2 in, int available) throws IOException {
            int[] assignments = new int[this.numPos];
            for (int i = 0; i < this.numPos; ++i) {
                assignments[i] = ConfDB.this.assignmentEncoding.read((DataInput)in) - 1;
            }
            return assignments;
        }

        public int compare(int[] a, int[] b) {
            if (a == b) {
                return 0;
            }
            int len = Math.min(a.length, b.length);
            for (int i = 0; i < len; ++i) {
                int val = Integer.compare(a[i], b[i]);
                if (val == 0) continue;
                return val;
            }
            return Integer.compare(a.length, b.length);
        }

        public boolean equals(int[] a, int[] b) {
            return Arrays.equals(a, b);
        }

        public int hashCode(@NotNull int[] assignments, int seed) {
            return DataIO.intHash((int)(Arrays.hashCode(assignments) + seed));
        }
    }

    private static class ConfInfo {
        public double lowerEnergy;
        public long lowerTimestampNs;
        public double upperEnergy;
        public long upperTimestampNs;

        public ConfInfo() {
            this.lowerEnergy = 0.0;
            this.lowerTimestampNs = 0L;
            this.upperEnergy = 0.0;
            this.upperTimestampNs = 0L;
        }

        public ConfInfo(double lowerEnergy, long lowerTimestampNs, double upperEnergy, long upperTimestampNs) {
            this.lowerEnergy = lowerEnergy;
            this.lowerTimestampNs = lowerTimestampNs;
            this.upperEnergy = upperEnergy;
            this.upperTimestampNs = upperTimestampNs;
        }

        public Conf.Bound makeLowerBound() {
            return this.makeBound(this.lowerEnergy, this.lowerTimestampNs);
        }

        public Conf.Bound makeUpperBound() {
            return this.makeBound(this.upperEnergy, this.upperTimestampNs);
        }

        private Conf.Bound makeBound(double energy, long timestampNs) {
            if (timestampNs == 0L) {
                return null;
            }
            return new Conf.Bound(energy, timestampNs);
        }
    }

    public static class Conf {
        public final int[] assignments;
        public final Bound lower;
        public final Bound upper;

        public Conf(int[] assignments, Bound lower, Bound upper) {
            this.assignments = assignments;
            this.lower = lower;
            this.upper = upper;
        }

        private Conf(int[] assignments, ConfInfo info2) {
            this.assignments = assignments;
            this.lower = info2.makeLowerBound();
            this.upper = info2.makeUpperBound();
        }

        public ConfSearch.ScoredConf toScoredConf() {
            return new ConfSearch.ScoredConf(this.assignments, this.lower == null ? Double.NaN : this.lower.energy);
        }

        public ConfSearch.EnergiedConf toEnergiedConf() {
            return new ConfSearch.EnergiedConf(this.assignments, this.lower == null ? Double.NaN : this.lower.energy, this.upper == null ? Double.NaN : this.upper.energy);
        }

        public static class Bound {
            public final double energy;
            public final long timestampNs;

            public Bound(double energy, long timestampNs) {
                this.energy = energy;
                this.timestampNs = timestampNs;
            }
        }
    }

    public static enum SortOrder {
        Assignment,
        Score,
        Energy;

    }

    public static class DBs
    implements AutoCleanable {
        private final Map<ConfSpaceIteration, ConfDB> dbs = new IdentityHashMap<ConfSpaceIteration, ConfDB>();
        private final Adder adder = new Adder();

        public DBs add(ConfSpaceIteration confSpace, File file) {
            this.adder.add(confSpace, file);
            return this;
        }

        public <T> DBs addAll(Iterable<T> things, BiConsumer<T, Adder> block) {
            for (T thing : things) {
                block.accept(thing, this.adder);
            }
            return this;
        }

        public ConfDB get(ConfSpaceIteration confSpace) {
            return this.dbs.get(confSpace);
        }

        @Override
        public void clean() {
            for (ConfDB db : this.dbs.values()) {
                db.clean();
            }
        }

        public class Adder {
            public void add(ConfSpaceIteration confSpace, File file) {
                if (file != null) {
                    DBs.this.dbs.put(confSpace, new ConfDB(confSpace, file));
                }
            }
        }
    }
}

