/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.scoring.mplp;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MPLPUpdater;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MessageVars;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;

public class NodeUpdater
implements MPLPUpdater {
    @Override
    public void update(MessageVars lambdas, EnergyMatrix emat) {
        RCs rcs = lambdas.getRCs();
        ConfIndex confIndex = lambdas.getConfIndex();
        for (int posi1 = 0; posi1 < confIndex.numUndefined; ++posi1) {
            double theta;
            double minVal;
            int rci1;
            int pos2;
            int posi2;
            int pos1 = confIndex.undefinedPos[posi1];
            MessageVars gammas = new MessageVars(rcs, confIndex);
            for (posi2 = 0; posi2 < confIndex.numUndefined; ++posi2) {
                pos2 = confIndex.undefinedPos[posi2];
                if (pos2 == pos1) continue;
                for (rci1 = 0; rci1 < rcs.getNum(pos1); ++rci1) {
                    int rc1 = rcs.get(pos1, rci1);
                    minVal = Double.POSITIVE_INFINITY;
                    for (int rci2 = 0; rci2 < rcs.getNum(pos2); ++rci2) {
                        int rc2 = rcs.get(pos2, rci2);
                        theta = emat.getPairwise(pos1, rc1, pos2, rc2);
                        double delta = lambdas.getEnergyWithout(posi2, rci2, posi1);
                        minVal = Math.min(minVal, theta + delta);
                    }
                    gammas.set(posi2, posi1, rci1, minVal);
                }
            }
            for (posi2 = 0; posi2 < confIndex.numUndefined; ++posi2) {
                pos2 = confIndex.undefinedPos[posi2];
                if (pos2 == pos1) continue;
                for (rci1 = 0; rci1 < rcs.getNum(pos1); ++rci1) {
                    double gamma = gammas.get(posi2, posi1, rci1);
                    double gammaEnergy = gammas.getEnergy(posi1, rci1) / (double)confIndex.numUndefined;
                    double lambda = Double.isFinite(gammaEnergy) ? gamma - gammaEnergy : Double.POSITIVE_INFINITY;
                    lambdas.set(posi2, posi1, rci1, lambda);
                }
                for (int rci2 = 0; rci2 < rcs.getNum(pos2); ++rci2) {
                    int rc2 = rcs.get(pos2, rci2);
                    minVal = Double.POSITIVE_INFINITY;
                    for (int rci12 = 0; rci12 < rcs.getNum(pos1); ++rci12) {
                        int rc1 = rcs.get(pos1, rci12);
                        theta = emat.getPairwise(pos1, rc1, pos2, rc2);
                        double gamma1 = gammas.getEnergy(posi1, rci12);
                        double gamma2 = gammas.get(posi2, posi1, rci12);
                        if (!Double.isFinite(theta) || !Double.isFinite(gamma1) || !Double.isFinite(gamma2)) continue;
                        minVal = Math.min(minVal, theta + 2.0 * gamma1 / (double)confIndex.numUndefined - gamma2);
                    }
                    double energyWithout = lambdas.getEnergyWithout(posi2, rci2, posi1);
                    minVal = Double.isFinite(energyWithout) ? (minVal - energyWithout) / 2.0 : Double.POSITIVE_INFINITY;
                    lambdas.set(posi1, posi2, rci2, minVal);
                }
            }
        }
    }
}

