/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.scoring;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MPLPUpdater;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MessageVars;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;

public class MPLPPairwiseHScorer
implements AStarScorer {
    private MPLPUpdater updater;
    private EnergyMatrix emat;
    private int maxNumIterations;
    private double epsilon;

    public MPLPPairwiseHScorer(MPLPUpdater updater, EnergyMatrix emat, int maxNumIterations, double epsilon) {
        this.updater = updater;
        this.emat = emat;
        this.maxNumIterations = maxNumIterations;
        this.epsilon = epsilon;
    }

    @Override
    public MPLPPairwiseHScorer make() {
        return new MPLPPairwiseHScorer(this.updater, this.emat, this.maxNumIterations, this.epsilon);
    }

    @Override
    public double calc(ConfIndex confIndex, RCs rcs) {
        MessageVars lambdas = new MessageVars(rcs, confIndex);
        lambdas.initTraditionalAStar(this.emat);
        double energy = lambdas.getTotalEnergy();
        for (int i = 0; i < this.maxNumIterations; ++i) {
            this.updater.update(lambdas, this.emat);
            double newEnergy = lambdas.getTotalEnergy();
            if (Math.abs(newEnergy - energy) < this.epsilon) break;
            energy = newEnergy;
        }
        return energy;
    }
}

