/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.order;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StaticEnergyHMeanAStarOrder
implements AStarOrder {
    private EnergyMatrix emat;
    private List<Integer> posOrder;

    public StaticEnergyHMeanAStarOrder(EnergyMatrix emat) {
        this.emat = emat;
        this.posOrder = null;
    }

    @Override
    public void setScorers(AStarScorer gscorer, AStarScorer hscorer) {
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public int getNextPos(ConfIndex confIndex, RCs rcs) {
        if (this.posOrder == null) {
            this.posOrder = this.calcPosOrder(confIndex, rcs);
        }
        return this.posOrder.get(confIndex.node.getLevel());
    }

    private List<Integer> calcPosOrder(ConfIndex confIndex, RCs rcs) {
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int pos = 0; pos < rcs.getNumPos(); ++pos) {
            order.add(pos);
        }
        final ArrayList<Double> scores = new ArrayList<Double>();
        for (int pos = 0; pos < rcs.getNumPos(); ++pos) {
            scores.add(this.scorePos(rcs, pos));
        }
        Collections.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer pos1, Integer pos2) {
                double score1 = (Double)scores.get(pos1);
                double score2 = (Double)scores.get(pos2);
                return Double.compare(score2, score1);
            }
        });
        return order;
    }

    private double scorePos(RCs rcs, int pos1) {
        double score = 0.0;
        for (int pos2 = 0; pos2 < rcs.getNumPos(); ++pos2) {
            int rc12;
            if (pos2 == pos1) continue;
            double minPairwise = Double.POSITIVE_INFINITY;
            for (int rc12 : rcs.get(pos1)) {
                for (int rc2 : rcs.get(pos2)) {
                    minPairwise = Math.min(minPairwise, this.emat.getPairwise(pos1, rc12, pos2, rc2));
                }
            }
            double pos2Score = 0.0;
            int[] nArray = rcs.get(pos1);
            rc12 = nArray.length;
            for (int i = 0; i < rc12; ++i) {
                int rc13 = nArray[i];
                for (int rc2 : rcs.get(pos2)) {
                    double normalizedPairwise = this.emat.getPairwise(pos1, rc13, pos2, rc2) - minPairwise;
                    if (normalizedPairwise == 0.0) continue;
                    pos2Score += 1.0 / normalizedPairwise;
                }
            }
            int numRcs1 = rcs.get(pos1).length;
            int numRcs2 = rcs.get(pos2).length;
            pos2Score = (double)(numRcs1 * numRcs2 - 1) / pos2Score;
            score += pos2Score;
        }
        return score;
    }
}

