/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.order;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.tools.MathTools;

public class DynamicHMeanAStarOrder
implements AStarOrder {
    public final MathTools.Optimizer optimizer;
    private AStarScorer gscorer;
    private AStarScorer hscorer;

    public DynamicHMeanAStarOrder() {
        this(MathTools.Optimizer.Minimize);
    }

    public DynamicHMeanAStarOrder(MathTools.Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public void setScorers(AStarScorer gscorer, AStarScorer hscorer) {
        this.gscorer = gscorer;
        this.hscorer = hscorer;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public int getNextPos(ConfIndex confIndex, RCs rcs) {
        int bestPos = -1;
        double bestScore = this.optimizer.initDouble();
        for (int i = 0; i < confIndex.numUndefined; ++i) {
            int pos = confIndex.undefinedPos[i];
            double score = this.scorePos(confIndex, rcs, pos);
            if (!this.optimizer.isBetter(score, bestScore)) continue;
            bestScore = score;
            bestPos = pos;
        }
        if (bestPos >= 0) {
            return bestPos;
        }
        return confIndex.undefinedPos[0];
    }

    double scorePos(ConfIndex confIndex, RCs rcs, int pos) {
        double parentScore = confIndex.node.getScore();
        double reciprocalSum = 0.0;
        for (int rc : rcs.get(pos)) {
            double childScore = this.gscorer.calcDifferential(confIndex, rcs, pos, rc) + this.hscorer.calcDifferential(confIndex, rcs, pos, rc);
            reciprocalSum += 1.0 / (childScore - parentScore);
        }
        return -1.0 / reciprocalSum;
    }
}

