/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.comets;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;

public class UpdatedPruningMatrix
extends PruningMatrix {
    public PruningMatrix parent;
    ArrayList<TreeSet<Integer>> prunedRCUpdates = new ArrayList();
    ArrayList<ArrayList<TreeMap<Integer, TreeSet<Integer>>>> prunedPairUpdates = new ArrayList();

    public UpdatedPruningMatrix(PruningMatrix parent) {
        this.parent = parent;
        int numPos = parent.getNumPos();
        for (int pos = 0; pos < numPos; ++pos) {
            this.prunedRCUpdates.add(new TreeSet());
            this.prunedPairUpdates.add(new ArrayList());
            for (int pos2 = 0; pos2 < pos; ++pos2) {
                this.prunedPairUpdates.get(pos).add(new TreeMap());
            }
        }
    }

    @Override
    public void markAsPruned(RCTuple tup) {
        int tupNumPos = tup.pos.size();
        if (tupNumPos == 1) {
            int pos = tup.pos.get(0);
            int rc = tup.RCs.get(0);
            this.prunedRCUpdates.get(pos).add(rc);
        } else if (tupNumPos == 2) {
            TreeMap<Integer, TreeSet<Integer>> pairs;
            int pos1 = tup.pos.get(0);
            int pos2 = tup.pos.get(1);
            int rc1 = tup.RCs.get(0);
            int rc2 = tup.RCs.get(1);
            if (pos1 < pos2) {
                pos2 = tup.pos.get(0);
                pos1 = tup.pos.get(1);
                rc2 = tup.RCs.get(0);
                rc1 = tup.RCs.get(1);
            }
            if (!(pairs = this.prunedPairUpdates.get(pos1).get(pos2)).containsKey(rc1)) {
                pairs.put(rc1, new TreeSet());
            }
            pairs.get(rc1).add(rc2);
        } else {
            throw new RuntimeException("ERROR: UpdatedPruningMatrix just stores updated singles and pairs pruning, can't store pruned tuple: " + tup.stringListing());
        }
    }

    @Override
    public Boolean getPairwise(int res1, int index1, int res2, int index2) {
        if (this.parent.getPairwise(res1, index1, res2, index2).booleanValue()) {
            return true;
        }
        if (res1 > res2) {
            return UpdatedPruningMatrix.checkIntPair(this.prunedPairUpdates.get(res1).get(res2), index1, index2);
        }
        return UpdatedPruningMatrix.checkIntPair(this.prunedPairUpdates.get(res2).get(res1), index2, index1);
    }

    private static boolean checkIntPair(TreeMap<Integer, TreeSet<Integer>> pairs, int rc1, int rc2) {
        return pairs.containsKey(rc1) && pairs.get(rc1).contains(rc2);
    }

    @Override
    public Boolean getOneBody(int res, int index) {
        if (this.parent.getOneBody(res, index).booleanValue()) {
            return true;
        }
        return this.prunedRCUpdates.get(res).contains(index);
    }

    @Override
    public HigherTupleFinder<Boolean> getHigherOrderTerms(int res1, int index1, int res2, int index2) {
        return this.parent.getHigherOrderTerms(res1, index1, res2, index2);
    }

    public int countUpdates() {
        int count = 0;
        for (TreeSet<Integer> treeSet : this.prunedRCUpdates) {
            count += treeSet.size();
        }
        for (ArrayList arrayList : this.prunedPairUpdates) {
            for (TreeMap ppUpdates : arrayList) {
                for (TreeSet pUpdates : ppUpdates.values()) {
                    count += pUpdates.size();
                }
            }
        }
        return count;
    }

    @Override
    public int getNumConfAtPos(int pos) {
        return this.parent.getNumConfAtPos(pos);
    }

    @Override
    public int getNumPos() {
        return this.parent.getNumPos();
    }
}

