/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.comets;

import edu.duke.cs.osprey.astar.comets.LME;
import edu.duke.cs.osprey.astar.comets.NewCOMETSTree;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.PrecomputedMatrices;
import java.util.ArrayList;

public class NewCOMETSDoer {
    NewCOMETSTree tree;
    int numSeqsWanted;
    LME objFcn;
    LME[] constraints;
    int numStates;
    int numTreeLevels;
    ArrayList<ArrayList<String>> AATypeOptions = null;
    ArrayList<ArrayList<Integer>> mutable2StatePosNums = new ArrayList();

    public NewCOMETSDoer(SimpleConfSpace[] confSpaces, PrecomputedMatrices[] precompMats, LME objFcn, LME[] constraints, ArrayList<ArrayList<Integer>> mutable2StatePosNums, ArrayList<ArrayList<String>> AATypeOptions, int numMaxMut, String[] wtSeq, int numSeqsWanted, boolean outputGMECStructs, ConfEnergyCalculator[] confECalc) {
        this.objFcn = objFcn;
        this.constraints = constraints;
        this.mutable2StatePosNums = mutable2StatePosNums;
        this.AATypeOptions = AATypeOptions;
        this.numStates = confSpaces.length;
        this.numTreeLevels = AATypeOptions.size();
        this.numSeqsWanted = numSeqsWanted;
        this.tree = new NewCOMETSTree(this.numTreeLevels, objFcn, constraints, AATypeOptions, numMaxMut, wtSeq, this.numStates, confSpaces, precompMats, mutable2StatePosNums, outputGMECStructs, confECalc);
    }

    public ArrayList<String> calcBestSequences() {
        ConfSearch.ScoredConf conf;
        System.out.println("Performing multistate A*");
        long startAStarTime = System.currentTimeMillis();
        ArrayList<String> bestSequences = new ArrayList<String>();
        for (int seqNum = 0; seqNum < this.numSeqsWanted && (conf = this.tree.nextConf()) != null; ++seqNum) {
            bestSequences.add(this.tree.seqAsString(conf.getAssignments()));
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Sequence enumeration time: " + (double)(stopTime - startAStarTime) / 60000.0);
        return bestSequences;
    }
}

