/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar;

import edu.duke.cs.osprey.astar.AStarNode;
import java.io.Serializable;
import java.util.Arrays;

public class SlimAStarNode
implements AStarNode,
Serializable {
    private static final long serialVersionUID = -8612409900432350474L;
    private short numPos;
    private short level;
    private Link link;
    private double gscore;
    private double hscore;

    private SlimAStarNode(int numPos, int level, Link link) {
        assert (numPos <= Short.MAX_VALUE);
        assert (level <= Short.MAX_VALUE);
        this.numPos = (short)numPos;
        this.level = (short)level;
        this.link = link;
        this.gscore = Double.NaN;
        this.hscore = Double.NaN;
    }

    private SlimAStarNode(int numPos) {
        this(numPos, 0, new Link());
    }

    private SlimAStarNode(int numPos, SlimAStarNode parent, int assignedPos, int assignedRc) {
        this(numPos, parent.level + 1, new Link(parent.link, assignedPos, assignedRc));
    }

    public Link getLink() {
        return this.link;
    }

    @Override
    public int compareTo(AStarNode other) {
        return Double.compare(this.getScore(), other.getScore());
    }

    @Override
    public int[] getNodeAssignments() {
        int[] conf = new int[this.numPos];
        Arrays.fill(conf, -1);
        Link link = this.link;
        while (!link.isRoot()) {
            conf[link.getPos()] = link.getRC();
            link = link.getParent();
        }
        return conf;
    }

    @Override
    public double getScore() {
        return this.gscore + this.hscore;
    }

    @Override
    public void setScore(double val) {
        throw new UnsupportedOperationException("use setGScore() and setHScore() instead");
    }

    public double getGScore() {
        return this.gscore;
    }

    public void setGScore(double val) {
        this.gscore = val;
    }

    public double getHScore() {
        return this.hscore;
    }

    public void setHScore(double val) {
        this.hscore = val;
    }

    @Override
    public boolean scoreNeedsRefinement() {
        return false;
    }

    @Override
    public void setScoreNeedsRefinement(boolean val) {
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean isFullyDefined() {
        return this.getLevel() == this.numPos;
    }

    public static class Link
    implements Comparable<Link>,
    Serializable {
        private static final long serialVersionUID = -6371596109692467264L;
        private Link parent;
        private short pos;
        private short rc;

        public Link() {
            this(null, -1, -1);
        }

        public Link(Link parent, int pos, int rc) {
            assert (pos <= Short.MAX_VALUE);
            assert (rc <= Short.MAX_VALUE);
            this.parent = parent;
            this.pos = (short)pos;
            this.rc = (short)rc;
        }

        public Link getParent() {
            return this.parent;
        }

        public int getPos() {
            return this.pos;
        }

        public int getRC() {
            return this.rc;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public int compareTo(Link other) {
            return this.pos - other.pos;
        }
    }

    public static class Factory
    implements AStarNode.Factory<SlimAStarNode>,
    Serializable {
        private static final long serialVersionUID = 4759571366344935185L;
        private int numPos;

        public Factory(int numPos) {
            this.numPos = numPos;
        }

        @Override
        public SlimAStarNode makeRoot() {
            return new SlimAStarNode(this.numPos);
        }

        @Override
        public SlimAStarNode make(SlimAStarNode parent, int pos, int rc) {
            return new SlimAStarNode(this.numPos, parent, pos, rc);
        }
    }
}

