/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class GMECMutSpace {
    HashMap<String, HashSet<String>> acceptableNextResType = new HashMap();
    ArrayList<ArrayList<String>> rcAATypes = new ArrayList();

    public GMECMutSpace(String mutFileName, ConfSpace confSpace) {
        this.readFile(mutFileName);
        for (int pos = 0; pos < confSpace.numPos; ++pos) {
            ArrayList<String> aaTypesAtPos = new ArrayList<String>();
            ArrayList<RC> RCs2 = confSpace.posFlex.get((int)pos).RCs;
            for (int rc = 0; rc < RCs2.size(); ++rc) {
                aaTypesAtPos.add(RCs2.get((int)rc).AAType);
            }
            this.rcAATypes.add(aaTypesAtPos);
        }
    }

    public GMECMutSpace(String mutFileName, SimpleConfSpace confSpace) {
        this.readFile(mutFileName);
        for (int pos = 0; pos < confSpace.getNumPos(); ++pos) {
            ArrayList<String> aaTypesAtPos = new ArrayList<String>();
            List<SimpleConfSpace.ResidueConf> RCs2 = confSpace.positions.get((int)pos).resConfs;
            for (int rc = 0; rc < RCs2.size(); ++rc) {
                aaTypesAtPos.add(RCs2.get((int)rc).template.name);
            }
            this.rcAATypes.add(aaTypesAtPos);
        }
    }

    private void readFile(String mutFileName) {
        try {
            FileInputStream is = new FileInputStream(mutFileName);
            BufferedReader bufread = new BufferedReader(new InputStreamReader(is));
            String curLine = bufread.readLine();
            while (curLine != null) {
                int pos;
                StringTokenizer st = new StringTokenizer(curLine);
                int numPos = st.countTokens();
                Object seq = "";
                for (pos = 0; pos < numPos; ++pos) {
                    seq = (String)seq + st.nextToken().substring(0, 3).toUpperCase();
                }
                for (pos = 0; pos < numPos; ++pos) {
                    String partialSeq = ((String)seq).substring(0, 3 * pos);
                    if (!this.acceptableNextResType.containsKey(partialSeq)) {
                        this.acceptableNextResType.put(partialSeq, new HashSet());
                    }
                    this.acceptableNextResType.get(partialSeq).add(((String)seq).substring(3 * pos, 3 * (pos + 1)));
                }
                curLine = bufread.readLine();
            }
            bufread.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("ERROR: Couldn't find mut file " + mutFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isNewRCAllowed(int[] confSoFar, int numDefined, int newRC) {
        String partialSeq = this.writePartialSeq(confSoFar, numDefined);
        if (!this.acceptableNextResType.containsKey(partialSeq)) {
            throw new RuntimeException("ERROR: partial conf has forbidden sequence");
        }
        String newResType = this.rcAATypes.get(numDefined).get(newRC);
        return this.acceptableNextResType.get(partialSeq).contains(newResType);
    }

    String writePartialSeq(int[] confSoFar, int numDefined) {
        Object ans = "";
        for (int pos = 0; pos < numDefined; ++pos) {
            ans = (String)ans + this.rcAATypes.get(pos).get(confSoFar[pos]);
        }
        return ans;
    }
}

