/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar;

import edu.duke.cs.osprey.astar.AStarNode;
import java.io.Serializable;
import java.util.Arrays;

public class FullAStarNode
implements AStarNode,
Serializable {
    private static final long serialVersionUID = -537132381411057989L;
    private int[] nodeAssignments;
    private double score;
    private double gscore;
    private double hscore;
    boolean scoreNeedsRefinement;
    public double UB = Double.POSITIVE_INFINITY;
    public int[] UBConf = null;

    public FullAStarNode(int[] nodeAssignments) {
        this.nodeAssignments = nodeAssignments;
        this.score = Double.NaN;
        this.gscore = Double.NaN;
        this.hscore = Double.NaN;
        this.scoreNeedsRefinement = false;
    }

    public FullAStarNode(FullAStarNode fan) {
        this.UB = fan.UB;
        this.UBConf = fan.UBConf;
        this.gscore = fan.gscore;
        this.hscore = fan.hscore;
        this.nodeAssignments = fan.nodeAssignments;
        this.score = fan.score;
        this.scoreNeedsRefinement = fan.scoreNeedsRefinement;
    }

    @Override
    public int compareTo(AStarNode other) {
        return Double.valueOf(this.score).compareTo(other.getScore());
    }

    @Override
    public int[] getNodeAssignments() {
        return this.nodeAssignments;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    public double getGScore() {
        return this.gscore;
    }

    public void setGScore(double val) {
        this.gscore = val;
    }

    public double getHScore() {
        return this.hscore;
    }

    public void setHScore(double val) {
        this.hscore = val;
    }

    @Override
    public int getLevel() {
        int level = 0;
        for (int a : this.nodeAssignments) {
            if (a < 0) continue;
            ++level;
        }
        return level;
    }

    @Override
    public boolean isFullyDefined() {
        for (int a : this.nodeAssignments) {
            if (a >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean scoreNeedsRefinement() {
        return this.scoreNeedsRefinement;
    }

    @Override
    public void setScoreNeedsRefinement(boolean val) {
        this.scoreNeedsRefinement = val;
    }

    public static class Factory
    implements AStarNode.Factory<FullAStarNode>,
    Serializable {
        private static final long serialVersionUID = -6909420740336320965L;
        private int numPos;

        public Factory(int numPos) {
            this.numPos = numPos;
        }

        @Override
        public FullAStarNode makeRoot() {
            int[] conf = new int[this.numPos];
            Arrays.fill(conf, -1);
            return new FullAStarNode(conf);
        }

        @Override
        public FullAStarNode make(FullAStarNode parent, int pos, int rc) {
            int[] conf = (int[])parent.getNodeAssignments().clone();
            conf[pos] = rc;
            return new FullAStarNode(conf);
        }
    }
}

