/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar;

import edu.duke.cs.osprey.astar.AStarNode;
import edu.duke.cs.osprey.confspace.ConfSearch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public abstract class AStarTree<T extends AStarNode>
implements ConfSearch,
Serializable {
    private static final long serialVersionUID = 2311735341816014431L;
    private PriorityQueue<T> pq = null;
    public int numExpanded = 0;
    public int numPruned = 0;

    @Override
    public ConfSearch.ScoredConf nextConf() {
        T leafNode = this.nextLeafNode();
        if (leafNode == null) {
            return null;
        }
        return this.outputNode(leafNode);
    }

    /*
     * Unable to fully structure code
     */
    private T nextLeafNode() {
        if (this.pq == null) {
            this.initQueue(this.rootNode());
        }
        block0: while (true) {
            if ((curNode = (AStarNode)this.pq.poll()) == null) {
                System.out.println("A* tree empty...returning empty signal");
                return null;
            }
            if (this.canPruneNode(curNode)) {
                ++this.numPruned;
                continue;
            }
            while (curNode.scoreNeedsRefinement()) {
                this.refineScore(curNode);
                if (curNode.getScore() != Infinity) {
                    this.pq.add(curNode);
                }
                if ((curNode = (AStarNode)this.pq.poll()) != null) continue;
                System.out.println("A* tree empty...returning empty signal");
                return null;
            }
            if (this.isFullyAssigned(curNode)) {
                return (T)curNode;
            }
            children = this.getChildren(curNode);
            ++this.numExpanded;
            var3_3 = children.iterator();
            while (true) {
                if (var3_3.hasNext()) ** break;
                continue block0;
                child = var3_3.next();
                this.pq.add(child);
            }
            break;
        }
    }

    @Override
    public List<ConfSearch.ScoredConf> nextConfs(double maxEnergy) {
        ArrayList<ConfSearch.ScoredConf> confs = new ArrayList<ConfSearch.ScoredConf>();
        for (AStarNode node : this.nextLeafNodes(maxEnergy)) {
            confs.add(new ConfSearch.ScoredConf(node.getNodeAssignments(), node.getScore()));
        }
        return confs;
    }

    public List<AStarNode> nextLeafNodes(double maxEnergy) {
        T node;
        ArrayList<AStarNode> nodes = new ArrayList<AStarNode>();
        while ((node = this.nextLeafNode()) != null) {
            nodes.add((AStarNode)node);
            if (!(node.getScore() >= maxEnergy)) continue;
            break;
        }
        return nodes;
    }

    public void initQueue(T node) {
        this.pq = new PriorityQueue();
        this.pq.add(node);
    }

    public boolean canPruneNode(T node) {
        return false;
    }

    public ConfSearch.ScoredConf outputNode(T node) {
        return new ConfSearch.ScoredConf(node.getNodeAssignments(), node.getScore());
    }

    public void refineScore(T node) {
        throw new UnsupportedOperationException("ERROR: Score refinement not supported in this type of A* tree");
    }

    public abstract ArrayList<T> getChildren(T var1);

    public abstract T rootNode();

    public abstract boolean isFullyAssigned(T var1);

    public PriorityQueue<T> getQueue() {
        return this.pq;
    }

    public double curBestScore() {
        return ((AStarNode)this.pq.peek()).getScore();
    }
}

