/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.Predicate;

public interface Queue<T> {
    public void push(T var1);

    public T peek();

    public void pop();

    public long size();

    public boolean isEmpty();

    default public void pushAll(Collection<T> vals) {
        for (T val : vals) {
            this.push(val);
        }
    }

    default public void pushAll(T[] vals) {
        for (T val : vals) {
            this.push(val);
        }
    }

    default public T poll() {
        T val = this.peek();
        if (val != null) {
            this.pop();
        }
        return val;
    }

    default public <Q extends Queue<T>> Q filterTo(Q other, Predicate<T> pred) {
        while (!this.isEmpty()) {
            T val = this.poll();
            if (!pred.test(val)) continue;
            other.push(val);
        }
        return other;
    }

    default public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return Queue.this.peek() != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Queue.this.poll();
            }
        };
    }

    public static class PriorityFactory<T>
    implements Factory<T> {
        private Comparator<T> comparator;

        @SafeVarargs
        public static <T> Queue<T> of(final Comparator<T> comparator, final T ... vals) {
            return new Queue<T>(){
                private PriorityQueue<T> q;
                {
                    this.q = new PriorityQueue(comparator);
                    for (Object val : vals) {
                        this.q.add(val);
                    }
                }

                @Override
                public void push(T val) {
                    this.q.add(val);
                }

                @Override
                public T peek() {
                    return this.q.peek();
                }

                @Override
                public void pop() {
                    this.q.remove();
                }

                @Override
                public long size() {
                    return this.q.size();
                }

                @Override
                public boolean isEmpty() {
                    return this.q.isEmpty();
                }
            };
        }

        public PriorityFactory(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public Queue<T> make() {
            return PriorityFactory.of(this.comparator, new Object[0]);
        }
    }

    public static class FIFOFactory<T>
    implements Factory.FIFO<T> {
        @SafeVarargs
        public static <T> FIFO<T> of(final T ... vals) {
            return new FIFO<T>(){
                private ArrayDeque<T> q = new ArrayDeque();
                {
                    for (Object val : vals) {
                        this.q.add(val);
                    }
                }

                @Override
                public void push(T val) {
                    this.q.add(val);
                }

                @Override
                public T peek() {
                    return this.q.peek();
                }

                @Override
                public void pop() {
                    this.q.pop();
                }

                @Override
                public long size() {
                    return this.q.size();
                }

                @Override
                public boolean isEmpty() {
                    return this.q.isEmpty();
                }
            };
        }

        public static <T> FIFO<T> of(Iterable<T> iterable, long size) {
            return FIFOFactory.of(iterable.iterator(), size);
        }

        public static <T> FIFO<T> of(final Iterator<T> iter, final long size) {
            return new FIFO<T>(){
                private T next = null;
                {
                    this.advance();
                }

                private void advance() {
                    this.next = iter.hasNext() ? iter.next() : null;
                }

                @Override
                public void push(T val) {
                    throw new UnsupportedOperationException("this FIFO queue is read only");
                }

                @Override
                public T peek() {
                    return this.next;
                }

                @Override
                public void pop() {
                    this.advance();
                }

                @Override
                public long size() {
                    return size;
                }

                @Override
                public boolean isEmpty() {
                    return this.next != null;
                }
            };
        }

        @Override
        public FIFO<T> make() {
            return FIFOFactory.of(new Object[0]);
        }
    }

    public static interface FIFO<T>
    extends Queue<T> {
        default public void filter(Predicate<T> pred) {
            long n = this.size();
            for (long i = 0L; i < n; ++i) {
                Object val = this.poll();
                if (!pred.test(val)) continue;
                this.push(val);
            }
        }
    }

    public static interface Factory<T> {
        public Queue<T> make();

        public static interface FIFO<T> {
            public edu.duke.cs.osprey.Queue$FIFO<T> make();
        }
    }
}

