/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import com.joptimizer.util.ColtUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class Utils {
    private static Double RELATIVE_MACHINE_PRECISION = Double.NaN;
    public static Log log = LogFactory.getLog(Utils.class);

    public static File getClasspathResourceAsFile(String resourceName) throws Exception {
        return new File(new URI(Thread.currentThread().getContextClassLoader().getResource(resourceName).toString()));
    }

    public static DoubleMatrix1D randomValuesVector(int dim, double min, double max) {
        return Utils.randomValuesVector(dim, min, max, null);
    }

    public static DoubleMatrix1D randomValuesVector(int dim, double min, double max, Long seed) {
        Random random = seed != null ? new Random(seed) : new Random();
        double[] v = new double[dim];
        for (int i = 0; i < dim; ++i) {
            v[i] = min + random.nextDouble() * (max - min);
        }
        return DoubleFactory1D.dense.make(v);
    }

    public static DoubleMatrix2D randomValuesMatrix(int rows, int cols, double min, double max) {
        return Utils.randomValuesMatrix(rows, cols, min, max, null);
    }

    public static DoubleMatrix2D randomValuesMatrix(int rows, int cols, double min, double max, Long seed) {
        Random random = seed != null ? new Random(seed) : new Random();
        double[][] matrix = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matrix[i][j] = min + random.nextDouble() * (max - min);
            }
        }
        return DoubleFactory2D.dense.make(matrix);
    }

    public static DoubleMatrix2D randomValuesSparseMatrix(int rows, int cols, double min, double max, double sparsityIndex, Long seed) {
        Random random = seed != null ? new Random(seed) : new Random();
        double minThreshold = min + sparsityIndex * (max - min);
        double[][] matrix = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                double d = min + random.nextDouble() * (max - min);
                if (!(d > minThreshold)) continue;
                matrix[i][j] = d;
            }
        }
        return DoubleFactory2D.sparse.make(matrix);
    }

    public static DoubleMatrix2D randomValuesPositiveMatrix(int rows, int cols, double min, double max, Long seed) {
        DoubleMatrix2D Q = Utils.randomValuesMatrix(rows, cols, min, max, seed);
        DoubleMatrix2D P = Algebra.DEFAULT.mult(Q, Algebra.DEFAULT.transpose(Q.copy()));
        return Algebra.DEFAULT.mult(P, P);
    }

    public static double calculateScaledResidual(DoubleMatrix2D A, DoubleMatrix2D X, DoubleMatrix2D B) {
        double residual = -1.7976931348623157E308;
        double niX = Algebra.DEFAULT.normInfinity(X);
        double niB = Algebra.DEFAULT.normInfinity(B);
        if (Double.compare(niX, 0.0) == 0 && Double.compare(niB, 0.0) == 0) {
            return 0.0;
        }
        double num = Algebra.DEFAULT.normInfinity(Algebra.DEFAULT.mult(A, X).assign(B, Functions.minus));
        double den = Algebra.DEFAULT.normInfinity(A) * niX + niB;
        residual = num / den;
        return residual;
    }

    public static double calculateScaledResidual(double[][] A, double[][] X, double[][] B) {
        DoubleMatrix2D AMatrix = DoubleFactory2D.dense.make(A);
        DoubleMatrix2D XMatrix = DoubleFactory2D.dense.make(X);
        DoubleMatrix2D BMatrix = DoubleFactory2D.dense.make(B);
        return Utils.calculateScaledResidual(AMatrix, XMatrix, BMatrix);
    }

    public static double calculateScaledResidual(DoubleMatrix2D A, DoubleMatrix1D x, DoubleMatrix1D b) {
        double residual = -1.7976931348623157E308;
        double nix = Algebra.DEFAULT.normInfinity(x);
        double nib = Algebra.DEFAULT.normInfinity(b);
        if (Double.compare(nix, 0.0) == 0 && Double.compare(nib, 0.0) == 0) {
            return 0.0;
        }
        double num = Algebra.DEFAULT.normInfinity(ColtUtils.zMult(A, x, b, -1.0));
        double den = Algebra.DEFAULT.normInfinity(A) * nix + nib;
        residual = num / den;
        return residual;
    }

    public static double calculateScaledResidual(double[][] A, double[] x, double[] b) {
        DoubleMatrix2D AMatrix = DoubleFactory2D.dense.make(A);
        DoubleMatrix1D xVector = DoubleFactory1D.dense.make(x);
        DoubleMatrix1D bVector = DoubleFactory1D.dense.make(b);
        return Utils.calculateScaledResidual(AMatrix, xVector, bVector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final double getDoubleMachineEpsilon() {
        if (!Double.isNaN(RELATIVE_MACHINE_PRECISION)) {
            return RELATIVE_MACHINE_PRECISION;
        }
        Double d = RELATIVE_MACHINE_PRECISION;
        synchronized (d) {
            if (!Double.isNaN(RELATIVE_MACHINE_PRECISION)) {
                return RELATIVE_MACHINE_PRECISION;
            }
            double eps = 1.0;
            while (1.0 + (eps /= 2.0) / 2.0 != 1.0) {
            }
            log.debug((Object)("Calculated double machine epsilon: " + eps));
            RELATIVE_MACHINE_PRECISION = eps;
        }
        return RELATIVE_MACHINE_PRECISION;
    }

    public static int getMaxIndex(DoubleMatrix1D v) {
        int maxIndex = -1;
        double maxValue = -1.7976931348623157E308;
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.getQuick(i) > maxValue)) continue;
            maxIndex = i;
            maxValue = v.getQuick(i);
        }
        return maxIndex;
    }

    public static int getMinIndex(DoubleMatrix1D v) {
        int minIndex = -1;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.getQuick(i) < minValue)) continue;
            minIndex = i;
            minValue = v.getQuick(i);
        }
        return minIndex;
    }

    public static final double[][] createConstantDiagonalMatrix(int dim, double c) {
        double[][] matrix = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            matrix[i][i] = c;
        }
        return matrix;
    }

    @Deprecated
    public static final double[][] upperTriangularMatrixInverse(double[][] L) throws Exception {
        int dim = L.length;
        double[][] x = Utils.createConstantDiagonalMatrix(dim, 1.0);
        for (int j = 0; j < dim; ++j) {
            double[] LJ = L[j];
            double LJJ = LJ[j];
            double[] xJ = x[j];
            int k = 0;
            while (k < dim) {
                int n = k++;
                xJ[n] = xJ[n] / LJJ;
            }
            for (int i = j + 1; i < dim; ++i) {
                double[] xI = x[i];
                double LJI = LJ[i];
                for (int k2 = 0; k2 < dim; ++k2) {
                    int n = k2;
                    xI[n] = xI[n] - xJ[k2] * LJI;
                }
            }
        }
        return new Array2DRowRealMatrix(x).transpose().getData();
    }

    @Deprecated
    public static final double[][] lowerTriangularMatrixInverse(double[][] L) throws Exception {
        double[][] LT = new Array2DRowRealMatrix(L).transpose().getData();
        double[][] x = Utils.upperTriangularMatrixInverse(LT);
        return new Array2DRowRealMatrix(x).transpose().getData();
    }

    public static final double calculateDeterminant(double[][] ai, int dim) {
        double det = 0.0;
        if (dim == 1) {
            det = ai[0][0];
        } else if (dim == 2) {
            det = ai[0][0] * ai[1][1] - ai[0][1] * ai[1][0];
        } else {
            double[][] ai1 = new double[dim - 1][dim - 1];
            for (int k = 0; k < dim; ++k) {
                double ai0k = ai[0][k];
                if (!(ai0k < 0.0) && !(ai0k > 0.0)) continue;
                for (int i1 = 1; i1 < dim; ++i1) {
                    int j = 0;
                    for (int j1 = 0; j1 < dim; ++j1) {
                        if (j1 == k) continue;
                        ai1[i1 - 1][j] = ai[i1][j1];
                        ++j;
                    }
                }
                if (k % 2 == 0) {
                    det += ai0k * Utils.calculateDeterminant(ai1, dim - 1);
                    continue;
                }
                det -= ai0k * Utils.calculateDeterminant(ai1, dim - 1);
            }
        }
        return det;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeDoubleArrayToFile(double[] v, String fileName) throws Exception {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        df.applyPattern("#");
        df.setMaximumFractionDigits(16);
        String[][] ret = new String[v.length][1];
        for (int j = 0; j < v.length; ++j) {
            ret[j][0] = Double.isNaN(v[j]) ? String.valueOf(v[j]) : df.format(v[j]);
        }
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(fileName), CSVFormat.DEFAULT.withDelimiter(','));
        try {
            csvPrinter.printRecords((Object[])ret);
        }
        finally {
            csvPrinter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeDoubleMatrixToFile(double[][] m, String fileName) throws Exception {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        df.applyPattern("#");
        df.setMaximumFractionDigits(16);
        String[][] ret = new String[m.length][];
        for (int i = 0; i < m.length; ++i) {
            double[] MI = m[i];
            String[] retI = new String[MI.length];
            for (int j = 0; j < MI.length; ++j) {
                retI[j] = Double.isNaN(MI[j]) ? String.valueOf(MI[j]) : df.format(MI[j]);
            }
            ret[i] = retI;
        }
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(fileName), CSVFormat.DEFAULT.withDelimiter(','));
        try {
            csvPrinter.printRecords((Object[])ret);
        }
        finally {
            csvPrinter.close();
        }
    }

    public static final double[] loadDoubleArrayFromFile(String classpathFileName) throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
        CSVParser parser = new CSVParser((Reader)new InputStreamReader(is), CSVFormat.DEFAULT.withDelimiter(',').withCommentMarker('#'));
        List records = parser.getRecords();
        double[] v = new double[records.size()];
        for (int i = 0; i < records.size(); ++i) {
            v[i] = Double.parseDouble(((CSVRecord)records.get(i)).get(0));
        }
        return v;
    }

    public static final double[][] loadDoubleMatrixFromFile(String classpathFileName, char fieldSeparator) throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
        CSVParser parser = new CSVParser((Reader)new InputStreamReader(is), CSVFormat.DEFAULT.withDelimiter(fieldSeparator).withCommentMarker('#'));
        List records = parser.getRecords();
        double[][] m = new double[records.size()][((CSVRecord)records.get(0)).size()];
        for (int i = 0; i < records.size(); ++i) {
            for (int j = 0; j < ((CSVRecord)records.get(0)).size(); ++j) {
                m[i][j] = Double.parseDouble(((CSVRecord)records.get(i)).get(j));
            }
        }
        return m;
    }

    public static final double[][] loadDoubleMatrixFromFile(String classpathFileName) throws Exception {
        return Utils.loadDoubleMatrixFromFile(classpathFileName, ",".charAt(0));
    }

    public static final int[] getFullRankSubmatrixRowIndices(RealMatrix M) {
        int row = M.getRowDimension();
        int col = M.getColumnDimension();
        SingularValueDecomposition dFact1 = new SingularValueDecomposition(M);
        int r = dFact1.getRank();
        int[] ret = new int[r];
        if (r < row) {
            RealMatrix fullM = MatrixUtils.createRealMatrix((int)1, (int)col);
            fullM.setRowVector(0, M.getRowVector(0));
            ret[0] = 0;
            int iRank = 1;
            for (int i = 1; i < row; ++i) {
                RealMatrix tmp = MatrixUtils.createRealMatrix((int)(fullM.getRowDimension() + 1), (int)col);
                tmp.setSubMatrix(fullM.getData(), 0, 0);
                tmp.setRowVector(fullM.getRowDimension(), M.getRowVector(i));
                SingularValueDecomposition dFact_i = new SingularValueDecomposition(tmp);
                int ri = dFact_i.getRank();
                if (ri <= iRank) continue;
                fullM = tmp;
                ret[iRank] = i;
                iRank = ri;
                if (iRank != r) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < r; ++i) {
                ret[i] = i;
            }
        }
        return ret;
    }

    public static final long[] getExpAndMantissa(double myDouble) {
        long lbits = Double.doubleToLongBits(myDouble);
        long lsign = lbits >>> 63;
        long lexp = (lbits >>> 52 & 0x7FFL) - 1023L;
        long lmantissa = lbits & 0xFFFFFFFFFFFFFL;
        long[] ret = new long[]{lsign, lexp, lmantissa};
        log.debug((Object)("double  : " + myDouble));
        log.debug((Object)("sign    : " + lsign));
        log.debug((Object)("exp     : " + lexp));
        log.debug((Object)("mantissa: " + lmantissa));
        log.debug((Object)("reverse : " + Double.longBitsToDouble(lsign << 63 | lexp + 1023L << 52 | lmantissa)));
        log.debug((Object)("log(d)  : " + Math.log1p(myDouble)));
        return ret;
    }

    public static final double[] replaceValues(double[] v, double oldValue, double newValue) {
        double[] ret = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            double vi = v[i];
            ret[i] = Double.compare(oldValue, vi) != 0 ? vi : newValue;
        }
        return ret;
    }

    public static final double round(double d, double precision) {
        return (double)Math.round(d * precision) / precision;
    }

    public static final void serializeObject(Object obj, String filename) throws Exception {
        FileOutputStream fout = new FileOutputStream(filename, true);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(obj);
    }

    public static final Object deserializeObject(String classpathFileName) throws Exception {
        InputStream streamIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
        ObjectInputStream objectinputstream = new ObjectInputStream(streamIn);
        return objectinputstream.readObject();
    }
}

