/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Mult;
import com.joptimizer.solvers.AugmentedKKTSolver;
import com.joptimizer.solvers.FullKKTSolver;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KKTSolver {
    protected DoubleMatrix2D H;
    protected DoubleMatrix2D A;
    protected DoubleMatrix2D AT;
    protected DoubleMatrix1D g;
    protected DoubleMatrix1D h;
    protected double toleranceKKT = Utils.getDoubleMachineEpsilon();
    protected boolean checkKKTSolutionAccuracy;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    protected double defaultScalar = 1.0E-6;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public abstract DoubleMatrix1D[] solve() throws Exception;

    public void setHMatrix(DoubleMatrix2D HMatrix) {
        this.H = HMatrix;
    }

    public void setAMatrix(DoubleMatrix2D AMatrix) {
        this.A = AMatrix;
        this.AT = this.ALG.transpose(this.A);
    }

    public void setGVector(DoubleMatrix1D gVector) {
        this.g = gVector;
    }

    public void setHVector(DoubleMatrix1D hVector) {
        this.h = hVector;
    }

    public void setToleranceKKT(double tolerance) {
        this.toleranceKKT = tolerance;
    }

    public void setCheckKKTSolutionAccuracy(boolean b) {
        this.checkKKTSolutionAccuracy = b;
    }

    protected DoubleMatrix1D[] solveAugmentedKKT() throws Exception {
        this.log.info((Object)"solveAugmentedKKT");
        if (this.A == null) {
            throw new Exception("KKT solution failed");
        }
        AugmentedKKTSolver kktSolver = new AugmentedKKTSolver();
        kktSolver.setCheckKKTSolutionAccuracy(false);
        kktSolver.setHMatrix(this.H);
        kktSolver.setAMatrix(this.A);
        kktSolver.setGVector(this.g);
        kktSolver.setHVector(this.h);
        return ((KKTSolver)kktSolver).solve();
    }

    protected DoubleMatrix1D[] solveFullKKT() throws Exception {
        this.log.info((Object)"solveFullKKT");
        FullKKTSolver kktSolver = new FullKKTSolver();
        kktSolver.setCheckKKTSolutionAccuracy(false);
        kktSolver.setHMatrix(this.H);
        kktSolver.setAMatrix(this.A);
        kktSolver.setGVector(this.g);
        kktSolver.setHVector(this.h);
        return ((KKTSolver)kktSolver).solve();
    }

    protected boolean checkKKTSolutionAccuracy(DoubleMatrix1D v, DoubleMatrix1D w) {
        DoubleMatrix2D KKT = null;
        DoubleMatrix1D x = null;
        DoubleMatrix1D b = null;
        if (this.A != null) {
            DoubleMatrix2D[][] parts;
            if (this.AT == null) {
                this.AT = this.ALG.transpose(this.A);
            }
            if (this.h != null) {
                parts = new DoubleMatrix2D[][]{{this.H, this.AT}, {this.A, null}};
                KKT = this.H instanceof SparseDoubleMatrix2D && this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                x = this.F1.append(v, w);
                b = this.F1.append(this.g, this.h).assign(Mult.mult(-1.0));
            } else {
                parts = new DoubleMatrix2D[][]{{this.H, this.AT}};
                KKT = this.H instanceof SparseDoubleMatrix2D && this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                x = this.F1.append(v, w);
                b = ColtUtils.scalarMult(this.g, -1.0);
            }
        } else {
            KKT = this.H;
            x = v;
            b = ColtUtils.scalarMult(this.g, -1.0);
        }
        double scaledResidual = Utils.calculateScaledResidual(KKT, x, b);
        this.log.debug((Object)("KKT inversion scaled residual: " + scaledResidual));
        return scaledResidual < this.toleranceKKT;
    }

    protected DoubleMatrix2D createFullDataMatrix(DoubleMatrix2D SubDiagonalSymmMatrix) {
        int c = SubDiagonalSymmMatrix.columns();
        DoubleMatrix2D ret = this.F2.make(c, c);
        for (int i = 0; i < c; ++i) {
            for (int j = 0; j <= i; ++j) {
                ret.setQuick(i, j, SubDiagonalSymmMatrix.getQuick(i, j));
                ret.setQuick(j, i, SubDiagonalSymmMatrix.getQuick(i, j));
            }
        }
        return ret;
    }
}

