/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.algebra.CholeskyFactorization;
import com.joptimizer.algebra.Matrix1NormRescaler;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AugmentedKKTSolver
extends KKTSolver {
    private double s = 1.0E-6;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public DoubleMatrix1D[] solve() throws Exception {
        if (this.A == null) {
            throw new IllegalStateException("Matrix A cannot be null");
        }
        DoubleMatrix1D v = null;
        DoubleMatrix1D w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)this.H.toArray())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
            this.log.debug((Object)("A: " + ArrayUtils.toString((Object)this.A.toArray())));
            if (this.h != null) {
                this.log.debug((Object)("h: " + ArrayUtils.toString((Object)this.h.toArray())));
            }
        }
        final DoubleMatrix2D HAugm = ColtUtils.subdiagonalMultiply(this.AT, this.A);
        HAugm.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double HAugmij) {
                return AugmentedKKTSolver.this.s * HAugmij;
            }
        });
        this.H.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double Hij) {
                if (i + 1 > j) {
                    HAugm.setQuick(i, j, Hij + HAugm.getQuick(i, j));
                }
                return Hij;
            }
        });
        DoubleMatrix1D gAugm = null;
        if (this.h != null) {
            DoubleMatrix1D gATQh;
            DoubleMatrix1D ATQh = this.ALG.mult(this.AT, ColtUtils.diagonalMatrixMult(this.F1.make(this.A.rows(), 1.0), this.h));
            gAugm = gATQh = ColtUtils.add(this.g, ATQh, this.defaultScalar);
        } else {
            gAugm = this.g.copy();
        }
        CholeskyFactorization HFact = new CholeskyFactorization(HAugm, new Matrix1NormRescaler());
        try {
            HFact.factorize();
        }
        catch (Exception e) {
            this.log.error((Object)"singular KKT system");
            throw new Exception("singular KKT system");
        }
        DoubleMatrix1D HInvg = HFact.solve(gAugm);
        DoubleMatrix2D HInvAT = HFact.solve(this.AT);
        DoubleMatrix2D MenoSLower = ColtUtils.subdiagonalMultiply(this.A, HInvAT);
        DoubleMatrix1D AHInvg = this.ALG.mult(this.A, HInvg);
        CholeskyFactorization MSFact = new CholeskyFactorization(MenoSLower, new Matrix1NormRescaler());
        MSFact.factorize();
        w = this.h == null ? MSFact.solve(ColtUtils.scalarMult(AHInvg, -1.0)) : MSFact.solve(ColtUtils.add(this.h, AHInvg, -1.0));
        v = HInvg.assign(this.ALG.mult(HInvAT, w), Functions.plus).assign(Mult.mult(-1.0));
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy(v, w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        DoubleMatrix1D[] ret = new DoubleMatrix1D[]{v, w};
        return ret;
    }

    public void setS(double s) {
        this.s = s;
    }
}

