/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkXlibSurfaceCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DPY;
    public static final int WINDOW;

    public VkXlibSurfaceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkXlibSurfaceCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkXlibSurfaceCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkXlibSurfaceCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkXlibSurfaceCreateFlagsKHR")
    public int flags() {
        return VkXlibSurfaceCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="Display *")
    public long dpy() {
        return VkXlibSurfaceCreateInfoKHR.ndpy(this.address());
    }

    @NativeType(value="Window")
    public long window() {
        return VkXlibSurfaceCreateInfoKHR.nwindow(this.address());
    }

    public VkXlibSurfaceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkXlibSurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkXlibSurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR flags(@NativeType(value="VkXlibSurfaceCreateFlagsKHR") int value) {
        VkXlibSurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR dpy(@NativeType(value="Display *") long value) {
        VkXlibSurfaceCreateInfoKHR.ndpy(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR window(@NativeType(value="Window") long value) {
        VkXlibSurfaceCreateInfoKHR.nwindow(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR set(int sType, long pNext, int flags, long dpy, long window) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dpy(dpy);
        this.window(window);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR set(VkXlibSurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkXlibSurfaceCreateInfoKHR malloc() {
        return (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR calloc() {
        return (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkXlibSurfaceCreateInfoKHR create(long address) {
        return (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkXlibSurfaceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkXlibSurfaceCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkXlibSurfaceCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkXlibSurfaceCreateInfoKHR mallocStack() {
        return VkXlibSurfaceCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkXlibSurfaceCreateInfoKHR callocStack() {
        return VkXlibSurfaceCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkXlibSurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return (VkXlibSurfaceCreateInfoKHR)VkXlibSurfaceCreateInfoKHR.wrap(VkXlibSurfaceCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkXlibSurfaceCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ndpy(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DPY));
    }

    public static long nwindow(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WINDOW));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndpy(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DPY), (long)Checks.check((long)value));
    }

    public static void nwindow(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WINDOW), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DPY)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkXlibSurfaceCreateInfoKHR.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkXlibSurfaceCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkXlibSurfaceCreateInfoKHR.__member((int)4), VkXlibSurfaceCreateInfoKHR.__member((int)POINTER_SIZE), VkXlibSurfaceCreateInfoKHR.__member((int)4), VkXlibSurfaceCreateInfoKHR.__member((int)POINTER_SIZE), VkXlibSurfaceCreateInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DPY = layout.offsetof(3);
        WINDOW = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkXlibSurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkXlibSurfaceCreateInfoKHR ELEMENT_FACTORY = VkXlibSurfaceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkXlibSurfaceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkXlibSurfaceCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkXlibSurfaceCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkXlibSurfaceCreateFlagsKHR")
        public int flags() {
            return VkXlibSurfaceCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="Display *")
        public long dpy() {
            return VkXlibSurfaceCreateInfoKHR.ndpy(this.address());
        }

        @NativeType(value="Window")
        public long window() {
            return VkXlibSurfaceCreateInfoKHR.nwindow(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkXlibSurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkXlibSurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkXlibSurfaceCreateFlagsKHR") int value) {
            VkXlibSurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer dpy(@NativeType(value="Display *") long value) {
            VkXlibSurfaceCreateInfoKHR.ndpy(this.address(), value);
            return this;
        }

        public Buffer window(@NativeType(value="Window") long value) {
            VkXlibSurfaceCreateInfoKHR.nwindow(this.address(), value);
            return this;
        }
    }
}

