/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkConformanceVersionKHR;

public class VkPhysicalDeviceDriverPropertiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DRIVERID;
    public static final int DRIVERNAME;
    public static final int DRIVERINFO;
    public static final int CONFORMANCEVERSION;

    public VkPhysicalDeviceDriverPropertiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceDriverPropertiesKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceDriverPropertiesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceDriverPropertiesKHR.npNext(this.address());
    }

    @NativeType(value="VkDriverIdKHR")
    public int driverID() {
        return VkPhysicalDeviceDriverPropertiesKHR.ndriverID(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE_KHR]")
    public ByteBuffer driverName() {
        return VkPhysicalDeviceDriverPropertiesKHR.ndriverName(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE_KHR]")
    public String driverNameString() {
        return VkPhysicalDeviceDriverPropertiesKHR.ndriverNameString(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE_KHR]")
    public ByteBuffer driverInfo() {
        return VkPhysicalDeviceDriverPropertiesKHR.ndriverInfo(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE_KHR]")
    public String driverInfoString() {
        return VkPhysicalDeviceDriverPropertiesKHR.ndriverInfoString(this.address());
    }

    public VkConformanceVersionKHR conformanceVersion() {
        return VkPhysicalDeviceDriverPropertiesKHR.nconformanceVersion(this.address());
    }

    public VkPhysicalDeviceDriverPropertiesKHR conformanceVersion(Consumer<VkConformanceVersionKHR> consumer) {
        consumer.accept(this.conformanceVersion());
        return this;
    }

    public VkPhysicalDeviceDriverPropertiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceDriverPropertiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceDriverPropertiesKHR pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceDriverPropertiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceDriverPropertiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceDriverPropertiesKHR set(VkPhysicalDeviceDriverPropertiesKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceDriverPropertiesKHR malloc() {
        return (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceDriverPropertiesKHR calloc() {
        return (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceDriverPropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceDriverPropertiesKHR create(long address) {
        return (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceDriverPropertiesKHR createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceDriverPropertiesKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceDriverPropertiesKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceDriverPropertiesKHR mallocStack() {
        return VkPhysicalDeviceDriverPropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceDriverPropertiesKHR callocStack() {
        return VkPhysicalDeviceDriverPropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceDriverPropertiesKHR mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceDriverPropertiesKHR callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceDriverPropertiesKHR)VkPhysicalDeviceDriverPropertiesKHR.wrap(VkPhysicalDeviceDriverPropertiesKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceDriverPropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceDriverPropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceDriverPropertiesKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndriverID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DRIVERID);
    }

    public static ByteBuffer ndriverName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERNAME), (int)256);
    }

    public static String ndriverNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DRIVERNAME));
    }

    public static ByteBuffer ndriverInfo(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERINFO), (int)256);
    }

    public static String ndriverInfoString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DRIVERINFO));
    }

    public static VkConformanceVersionKHR nconformanceVersion(long struct) {
        return VkConformanceVersionKHR.create(struct + (long)CONFORMANCEVERSION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceDriverPropertiesKHR.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceDriverPropertiesKHR.__member((int)4), VkPhysicalDeviceDriverPropertiesKHR.__member((int)POINTER_SIZE), VkPhysicalDeviceDriverPropertiesKHR.__member((int)4), VkPhysicalDeviceDriverPropertiesKHR.__array((int)1, (int)256), VkPhysicalDeviceDriverPropertiesKHR.__array((int)1, (int)256), VkPhysicalDeviceDriverPropertiesKHR.__member((int)VkConformanceVersionKHR.SIZEOF, (int)VkConformanceVersionKHR.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DRIVERID = layout.offsetof(2);
        DRIVERNAME = layout.offsetof(3);
        DRIVERINFO = layout.offsetof(4);
        CONFORMANCEVERSION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceDriverPropertiesKHR, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceDriverPropertiesKHR ELEMENT_FACTORY = VkPhysicalDeviceDriverPropertiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceDriverPropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceDriverPropertiesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceDriverPropertiesKHR.npNext(this.address());
        }

        @NativeType(value="VkDriverIdKHR")
        public int driverID() {
            return VkPhysicalDeviceDriverPropertiesKHR.ndriverID(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE_KHR]")
        public ByteBuffer driverName() {
            return VkPhysicalDeviceDriverPropertiesKHR.ndriverName(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE_KHR]")
        public String driverNameString() {
            return VkPhysicalDeviceDriverPropertiesKHR.ndriverNameString(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE_KHR]")
        public ByteBuffer driverInfo() {
            return VkPhysicalDeviceDriverPropertiesKHR.ndriverInfo(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE_KHR]")
        public String driverInfoString() {
            return VkPhysicalDeviceDriverPropertiesKHR.ndriverInfoString(this.address());
        }

        public VkConformanceVersionKHR conformanceVersion() {
            return VkPhysicalDeviceDriverPropertiesKHR.nconformanceVersion(this.address());
        }

        public Buffer conformanceVersion(Consumer<VkConformanceVersionKHR> consumer) {
            consumer.accept(this.conformanceVersion());
            return this;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceDriverPropertiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceDriverPropertiesKHR.npNext(this.address(), value);
            return this;
        }
    }
}

