/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkImageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int IMAGETYPE;
    public static final int FORMAT;
    public static final int EXTENT;
    public static final int MIPLEVELS;
    public static final int ARRAYLAYERS;
    public static final int SAMPLES;
    public static final int TILING;
    public static final int USAGE;
    public static final int SHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;
    public static final int INITIALLAYOUT;

    public VkImageCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkImageCreateFlags")
    public int flags() {
        return VkImageCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkImageType")
    public int imageType() {
        return VkImageCreateInfo.nimageType(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkImageCreateInfo.nformat(this.address());
    }

    public VkExtent3D extent() {
        return VkImageCreateInfo.nextent(this.address());
    }

    public VkImageCreateInfo extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    @NativeType(value="uint32_t")
    public int mipLevels() {
        return VkImageCreateInfo.nmipLevels(this.address());
    }

    @NativeType(value="uint32_t")
    public int arrayLayers() {
        return VkImageCreateInfo.narrayLayers(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int samples() {
        return VkImageCreateInfo.nsamples(this.address());
    }

    @NativeType(value="VkImageTiling")
    public int tiling() {
        return VkImageCreateInfo.ntiling(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int usage() {
        return VkImageCreateInfo.nusage(this.address());
    }

    @NativeType(value="VkSharingMode")
    public int sharingMode() {
        return VkImageCreateInfo.nsharingMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndexCount() {
        return VkImageCreateInfo.nqueueFamilyIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pQueueFamilyIndices() {
        return VkImageCreateInfo.npQueueFamilyIndices(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int initialLayout() {
        return VkImageCreateInfo.ninitialLayout(this.address());
    }

    public VkImageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkImageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkImageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageCreateInfo flags(@NativeType(value="VkImageCreateFlags") int value) {
        VkImageCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkImageCreateInfo imageType(@NativeType(value="VkImageType") int value) {
        VkImageCreateInfo.nimageType(this.address(), value);
        return this;
    }

    public VkImageCreateInfo format(@NativeType(value="VkFormat") int value) {
        VkImageCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkImageCreateInfo extent(VkExtent3D value) {
        VkImageCreateInfo.nextent(this.address(), value);
        return this;
    }

    public VkImageCreateInfo mipLevels(@NativeType(value="uint32_t") int value) {
        VkImageCreateInfo.nmipLevels(this.address(), value);
        return this;
    }

    public VkImageCreateInfo arrayLayers(@NativeType(value="uint32_t") int value) {
        VkImageCreateInfo.narrayLayers(this.address(), value);
        return this;
    }

    public VkImageCreateInfo samples(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkImageCreateInfo.nsamples(this.address(), value);
        return this;
    }

    public VkImageCreateInfo tiling(@NativeType(value="VkImageTiling") int value) {
        VkImageCreateInfo.ntiling(this.address(), value);
        return this;
    }

    public VkImageCreateInfo usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkImageCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkImageCreateInfo sharingMode(@NativeType(value="VkSharingMode") int value) {
        VkImageCreateInfo.nsharingMode(this.address(), value);
        return this;
    }

    public VkImageCreateInfo pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkImageCreateInfo.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkImageCreateInfo initialLayout(@NativeType(value="VkImageLayout") int value) {
        VkImageCreateInfo.ninitialLayout(this.address(), value);
        return this;
    }

    public VkImageCreateInfo set(int sType, long pNext, int flags, int imageType, int format, VkExtent3D extent, int mipLevels, int arrayLayers, int samples, int tiling, int usage, int sharingMode, @Nullable IntBuffer pQueueFamilyIndices, int initialLayout) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.imageType(imageType);
        this.format(format);
        this.extent(extent);
        this.mipLevels(mipLevels);
        this.arrayLayers(arrayLayers);
        this.samples(samples);
        this.tiling(tiling);
        this.usage(usage);
        this.sharingMode(sharingMode);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        this.initialLayout(initialLayout);
        return this;
    }

    public VkImageCreateInfo set(VkImageCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageCreateInfo malloc() {
        return (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageCreateInfo calloc() {
        return (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageCreateInfo create(long address) {
        return (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkImageCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageCreateInfo mallocStack() {
        return VkImageCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageCreateInfo callocStack() {
        return VkImageCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkImageCreateInfo mallocStack(MemoryStack stack) {
        return (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageCreateInfo callocStack(MemoryStack stack) {
        return (VkImageCreateInfo)VkImageCreateInfo.wrap(VkImageCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nimageType(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGETYPE);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static int nmipLevels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPLEVELS);
    }

    public static int narrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)ARRAYLAYERS);
    }

    public static int nsamples(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLES);
    }

    public static int ntiling(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILING);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nsharingMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)), (int)VkImageCreateInfo.nqueueFamilyIndexCount(struct));
    }

    public static int ninitialLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)INITIALLAYOUT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nimageType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGETYPE, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)VkExtent3D.SIZEOF);
    }

    public static void nmipLevels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPLEVELS, value);
    }

    public static void narrayLayers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ARRAYLAYERS, value);
    }

    public static void nsamples(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLES, value);
    }

    public static void ntiling(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILING, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nsharingMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PQUEUEFAMILYINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkImageCreateInfo.nqueueFamilyIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ninitialLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INITIALLAYOUT, value);
    }

    public static void validate(long struct) {
        if (VkImageCreateInfo.nqueueFamilyIndexCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkImageCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkImageCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)POINTER_SIZE), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)4), VkImageCreateInfo.__member((int)POINTER_SIZE), VkImageCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        IMAGETYPE = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        EXTENT = layout.offsetof(5);
        MIPLEVELS = layout.offsetof(6);
        ARRAYLAYERS = layout.offsetof(7);
        SAMPLES = layout.offsetof(8);
        TILING = layout.offsetof(9);
        USAGE = layout.offsetof(10);
        SHARINGMODE = layout.offsetof(11);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(12);
        PQUEUEFAMILYINDICES = layout.offsetof(13);
        INITIALLAYOUT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<VkImageCreateInfo, Buffer>
    implements NativeResource {
        private static final VkImageCreateInfo ELEMENT_FACTORY = VkImageCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkImageCreateFlags")
        public int flags() {
            return VkImageCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkImageType")
        public int imageType() {
            return VkImageCreateInfo.nimageType(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkImageCreateInfo.nformat(this.address());
        }

        public VkExtent3D extent() {
            return VkImageCreateInfo.nextent(this.address());
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        @NativeType(value="uint32_t")
        public int mipLevels() {
            return VkImageCreateInfo.nmipLevels(this.address());
        }

        @NativeType(value="uint32_t")
        public int arrayLayers() {
            return VkImageCreateInfo.narrayLayers(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int samples() {
            return VkImageCreateInfo.nsamples(this.address());
        }

        @NativeType(value="VkImageTiling")
        public int tiling() {
            return VkImageCreateInfo.ntiling(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int usage() {
            return VkImageCreateInfo.nusage(this.address());
        }

        @NativeType(value="VkSharingMode")
        public int sharingMode() {
            return VkImageCreateInfo.nsharingMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndexCount() {
            return VkImageCreateInfo.nqueueFamilyIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pQueueFamilyIndices() {
            return VkImageCreateInfo.npQueueFamilyIndices(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int initialLayout() {
            return VkImageCreateInfo.ninitialLayout(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkImageCreateFlags") int value) {
            VkImageCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer imageType(@NativeType(value="VkImageType") int value) {
            VkImageCreateInfo.nimageType(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkImageCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCreateInfo.nextent(this.address(), value);
            return this;
        }

        public Buffer mipLevels(@NativeType(value="uint32_t") int value) {
            VkImageCreateInfo.nmipLevels(this.address(), value);
            return this;
        }

        public Buffer arrayLayers(@NativeType(value="uint32_t") int value) {
            VkImageCreateInfo.narrayLayers(this.address(), value);
            return this;
        }

        public Buffer samples(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkImageCreateInfo.nsamples(this.address(), value);
            return this;
        }

        public Buffer tiling(@NativeType(value="VkImageTiling") int value) {
            VkImageCreateInfo.ntiling(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkImageCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer sharingMode(@NativeType(value="VkSharingMode") int value) {
            VkImageCreateInfo.nsharingMode(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkImageCreateInfo.npQueueFamilyIndices(this.address(), value);
            return this;
        }

        public Buffer initialLayout(@NativeType(value="VkImageLayout") int value) {
            VkImageCreateInfo.ninitialLayout(this.address(), value);
            return this;
        }
    }
}

