/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorBufferInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int RANGE;

    public VkDescriptorBufferInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorBufferInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkDescriptorBufferInfo.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkDescriptorBufferInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long range() {
        return VkDescriptorBufferInfo.nrange(this.address());
    }

    public VkDescriptorBufferInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkDescriptorBufferInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo offset(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorBufferInfo.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo range(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorBufferInfo.nrange(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo set(long buffer, long offset, long range) {
        this.buffer(buffer);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public VkDescriptorBufferInfo set(VkDescriptorBufferInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorBufferInfo malloc() {
        return (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDescriptorBufferInfo calloc() {
        return (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDescriptorBufferInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDescriptorBufferInfo create(long address) {
        return (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)address);
    }

    @Nullable
    public static VkDescriptorBufferInfo createSafe(long address) {
        return address == 0L ? null : (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDescriptorBufferInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorBufferInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDescriptorBufferInfo mallocStack() {
        return VkDescriptorBufferInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorBufferInfo callocStack() {
        return VkDescriptorBufferInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorBufferInfo mallocStack(MemoryStack stack) {
        return (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorBufferInfo callocStack(MemoryStack stack) {
        return (VkDescriptorBufferInfo)VkDescriptorBufferInfo.wrap(VkDescriptorBufferInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorBufferInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorBufferInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorBufferInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return UNSAFE.getLong(null, struct + (long)RANGE);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorBufferInfo.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorBufferInfo.__member((int)8), VkDescriptorBufferInfo.__member((int)8), VkDescriptorBufferInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        RANGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorBufferInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorBufferInfo ELEMENT_FACTORY = VkDescriptorBufferInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorBufferInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkDescriptorBufferInfo.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkDescriptorBufferInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long range() {
            return VkDescriptorBufferInfo.nrange(this.address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkDescriptorBufferInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorBufferInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorBufferInfo.nrange(this.address(), value);
            return this;
        }
    }
}

