/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.NumberParameter;

public class DoubleParameter
extends NumberParameter<DoubleParameter, Double> {
    public DoubleParameter(OptionID optionID, double d) {
        super(optionID, d);
    }

    public DoubleParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Double)this.getValue()).toString();
    }

    @Override
    protected Double parseValue(Object object) throws WrongParameterValueException {
        if (object instanceof Double) {
            return (Double)object;
        }
        try {
            return FormatUtil.parseDouble(object.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a double value, read: " + object + "!\n");
        }
        catch (NumberFormatException numberFormatException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a double value, read: " + object + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<double>";
    }

    public double doubleValue() {
        return (Double)this.getValue();
    }
}

