/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.Parameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public final class ClassGenericsUtil {
    private static final Logging LOG = Logging.getLogger(ClassGenericsUtil.class);
    private static final ClassLoader loader = ClassLoader.getSystemClassLoader();
    public static final String FACTORY_METHOD_NAME = "parameterize";

    private ClassGenericsUtil() {
    }

    public static <T> T instantiate(Class<T> clazz, String string) throws UnableToComplyException {
        T t;
        try {
            try {
                t = clazz.cast(loader.loadClass(string).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                t = clazz.cast(loader.loadClass(clazz.getPackage().getName() + "." + string).newInstance());
            }
        }
        catch (InstantiationException instantiationException) {
            throw new UnableToComplyException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnableToComplyException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnableToComplyException(classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new UnableToComplyException(classCastException);
        }
        return t;
    }

    public static <T> T instantiateGenerics(Class<?> clazz, String string) throws UnableToComplyException {
        Object obj;
        try {
            try {
                obj = clazz.cast(loader.loadClass(string).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                obj = clazz.cast(loader.loadClass(clazz.getPackage().getName() + "." + string).newInstance());
            }
        }
        catch (InstantiationException instantiationException) {
            throw new UnableToComplyException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnableToComplyException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnableToComplyException(classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new UnableToComplyException(classCastException);
        }
        return (T)obj;
    }

    public static <C> Method getParameterizationFactoryMethod(Class<C> clazz, Class<?> clazz2) throws NoSuchMethodException {
        Method method = clazz.getMethod(FACTORY_METHOD_NAME, Parameterization.class);
        if (method == null) {
            throw new NoSuchMethodException("No parameterization method found.");
        }
        if (!clazz2.isAssignableFrom(method.getReturnType())) {
            throw new NoSuchMethodException("Return type doesn't match: " + method.getReturnType().getName() + ", expected: " + clazz2.getName());
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Factory method is not static.");
        }
        return method;
    }

    public static Parameterizer getParameterizer(Class<?> clazz) {
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!Parameterizer.class.isAssignableFrom(clazz2)) continue;
            try {
                return clazz2.asSubclass(Parameterizer.class).newInstance();
            }
            catch (Exception exception) {
                LOG.warning("Non-usable Parameterizer in class: " + clazz.getName());
            }
        }
        return null;
    }

    public static <C> C tryInstantiate(Class<C> clazz, Class<?> clazz2, Parameterization parameterization) throws InvocationTargetException, NoSuchMethodException, Exception {
        if (clazz2 == null) {
            throw new UnsupportedOperationException("Trying to instantiate 'null' class!");
        }
        Parameterizer parameterizer = ClassGenericsUtil.getParameterizer(clazz2);
        if (parameterizer instanceof AbstractParameterizer) {
            Object object = ((AbstractParameterizer)parameterizer).make(parameterization);
            return clazz.cast(object);
        }
        try {
            Method method = ClassGenericsUtil.getParameterizationFactoryMethod(clazz2, clazz);
            Object object = method.invoke(null, parameterization);
            return clazz.cast(object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor<?> constructor = clazz2.getConstructor(Parameterization.class);
                Object obj = constructor.newInstance(parameterization);
                return clazz.cast(obj);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                Object obj = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
                return clazz.cast(obj);
            }
        }
    }

    public static <C> C parameterizeOrAbort(Class<?> clazz, Parameterization parameterization) {
        try {
            Object obj = ClassGenericsUtil.tryInstantiate(clazz, clazz, parameterization);
            if (obj == null) {
                throw new AbortException("Could not instantiate class. Check parameters.");
            }
            return (C)obj;
        }
        catch (Exception exception) {
            if (parameterization.hasErrors()) {
                for (ParameterException parameterException : parameterization.getErrors()) {
                    LOG.warning(parameterException.toString());
                }
            }
            throw new AbortException("Instantiation failed", exception);
        }
    }

    public static <T> T[] newArrayOfNull(int n, Class<T> clazz) {
        return (Object[])Array.newInstance(clazz, n);
    }

    public static <B, T extends B> T[] toArray(Collection<T> collection, Class<B> clazz) {
        return collection.toArray(ClassGenericsUtil.newArray(clazz, 0));
    }

    public static <T> ArrayList<T>[] newArrayOfEmptyArrayList(int n) {
        ArrayList[] arrayListArray = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        return arrayListArray;
    }

    public static <T> HashSet<T>[] newArrayOfEmptyHashSet(int n) {
        HashSet[] hashSetArray = new HashSet[n];
        for (int i = 0; i < n; ++i) {
            hashSetArray[i] = new HashSet();
        }
        return hashSetArray;
    }

    public static <D, T extends D> Class<T> uglyCastIntoSubclass(Class<D> clazz) {
        return clazz;
    }

    public static <BASE, FROM extends BASE, TO extends BASE> Class<TO> uglyCrossCast(Class<FROM> clazz, Class<BASE> clazz2) {
        if (!clazz2.isAssignableFrom(clazz)) {
            if (clazz == null) {
                throw new ClassCastException("Attempted to use 'null' as class.");
            }
            throw new ClassCastException(clazz.getName() + " is not a superclass of " + clazz2);
        }
        return clazz;
    }

    public static <B, T extends B> T castWithGenericsOrNull(Class<B> clazz, Object object) {
        try {
            return (T)clazz.cast(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static <T> T newInstance(T t) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Object obj = t.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            return (T)obj;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Null pointer exception in newInstance()", nullPointerException);
        }
    }

    public static <T> Class<? extends T> getComponentType(T[] TArray) {
        Class<?> clazz = TArray.getClass().getComponentType();
        return clazz;
    }

    public static <T> T[] newArray(Class<? extends T> clazz, int n) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Argument cannot be primitive: " + clazz);
        }
        Object object = Array.newInstance(clazz, n);
        return (Object[])object;
    }

    public static <T> T[] newArray(T[] TArray, int n) {
        return ClassGenericsUtil.newArray(ClassGenericsUtil.getComponentType(TArray), n);
    }

    public static <T, C extends Collection<T>> C cloneCollection(C c) {
        try {
            C c2 = ClassGenericsUtil.newInstance(c);
            c2.addAll(c);
            return c2;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public static <T> T[] collectionToArray(Collection<T> collection, T[] TArray) {
        if (TArray.length < collection.size()) {
            TArray = ClassGenericsUtil.newArray(TArray, collection.size());
        }
        int n = 0;
        for (T t : collection) {
            TArray[n] = t;
            ++n;
        }
        if (n < TArray.length) {
            TArray[n] = null;
        }
        return TArray;
    }
}

