/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.textwriter.MultipleFilesOutput;
import de.lmu.ifi.dbs.elki.result.textwriter.SingleStreamOutput;
import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class ResultWriter
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(ResultWriter.class);
    private File out;
    private boolean gzip = false;
    private boolean warnoverwrite = true;
    private Pattern filter = null;

    public ResultWriter(File file, boolean bl, boolean bl2, Pattern pattern) {
        this.out = file;
        this.gzip = bl;
        this.warnoverwrite = bl2;
        this.filter = pattern;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        StreamFactory streamFactory;
        TextWriter textWriter = new TextWriter();
        try {
            if (this.out == null) {
                streamFactory = new SingleStreamOutput(this.gzip);
            } else if (this.out.exists()) {
                if (this.out.isDirectory()) {
                    if (this.warnoverwrite && this.out.listFiles().length > 0) {
                        LOG.warning("Output directory specified is not empty. Files will be overwritten and old files may be left over.");
                    }
                    streamFactory = new MultipleFilesOutput(this.out, this.gzip);
                } else {
                    if (this.warnoverwrite) {
                        LOG.warning("Output file exists and will be overwritten!");
                    }
                    streamFactory = new SingleStreamOutput(this.out, this.gzip);
                }
            } else {
                streamFactory = new MultipleFilesOutput(this.out, this.gzip);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error opening output.", iOException);
        }
        try {
            Database database = ResultUtil.findDatabase(resultHierarchy);
            textWriter.output(database, result, streamFactory, this.filter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Input/Output error while writing result.", iOException);
        }
        catch (UnableToComplyException unableToComplyException) {
            throw new IllegalStateException("Unable to comply while writing result.", unableToComplyException);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID GZIP_OUTPUT_ID = new OptionID("out.gzip", "Enable gzip compression of output files.");
        public static final OptionID OVERWRITE_OPTION_ID = new OptionID("out.silentoverwrite", "Silently overwrite output files.");
        public static final OptionID FILTER_PATTERN_ID = new OptionID("out.filter", "Filter pattern for output selection. Only output streams that match the given pattern will be written.");
        private File out = null;
        private boolean gzip = false;
        private boolean warnoverwrite = true;
        private Pattern filter = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            Flag flag2;
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(OutputStep.Parameterizer.OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE, true);
            if (parameterization.grab(fileParameter)) {
                this.out = (File)fileParameter.getValue();
            }
            if (parameterization.grab(flag2 = new Flag(GZIP_OUTPUT_ID))) {
                this.gzip = (Boolean)flag2.getValue();
            }
            if (parameterization.grab(flag = new Flag(OVERWRITE_OPTION_ID))) {
                this.warnoverwrite = (Boolean)flag.getValue() == false;
            }
            PatternParameter patternParameter = new PatternParameter(FILTER_PATTERN_ID);
            patternParameter.setOptional(true);
            if (parameterization.grab(patternParameter)) {
                this.filter = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected ResultWriter makeInstance() {
            return new ResultWriter(this.out, this.gzip, this.warnoverwrite, this.filter);
        }
    }
}

