/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogGammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LogGammaLogMADEstimator
extends AbstractLogMADEstimator<LogGammaDistribution> {
    public static final LogGammaLogMADEstimator STATIC = new LogGammaLogMADEstimator();

    private LogGammaLogMADEstimator() {
    }

    @Override
    public LogGammaDistribution estimateFromLogMedianMAD(double d, double d2, double d3) {
        if (d < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero median.");
        }
        if (d2 < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero MAD.");
        }
        double d4 = d / (d2 * d2);
        double d5 = d * d4;
        if (!(d5 > 0.0) || !(d4 > 0.0)) {
            throw new ArithmeticException("LogGamma estimation produced non-positive parameter values: k=" + d5 + " theta=" + d4);
        }
        return new LogGammaDistribution(d5, d4, d3 - 1.0);
    }

    @Override
    public Class<? super LogGammaDistribution> getDistributionClass() {
        return LogGammaDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogGammaLogMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

