/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.AbstractLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MTreeLeafEntry
extends AbstractLeafEntry
implements MTreeEntry {
    private static final long serialVersionUID = 2L;
    private double parentDistance;

    public MTreeLeafEntry() {
    }

    public MTreeLeafEntry(DBID dBID, double d) {
        super(dBID);
        this.parentDistance = d;
    }

    @Override
    public final DBID getRoutingObjectID() {
        return this.getDBID();
    }

    @Override
    public final boolean setRoutingObjectID(DBID dBID) {
        throw new UnsupportedOperationException("Leaf entries should not be assigned a routing object.");
    }

    @Override
    public final double getParentDistance() {
        return this.parentDistance;
    }

    @Override
    public final boolean setParentDistance(double d) {
        if (this.parentDistance == d) {
            return false;
        }
        this.parentDistance = d;
        return true;
    }

    @Override
    public double getCoveringRadius() {
        return 0.0;
    }

    @Override
    public boolean setCoveringRadius(double d) {
        throw new UnsupportedOperationException("This entry is not a directory entry!");
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeDouble(this.parentDistance);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.parentDistance = objectInput.readDouble();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MTreeLeafEntry mTreeLeafEntry = (MTreeLeafEntry)object;
        return Math.abs(this.parentDistance - mTreeLeafEntry.parentDistance) < Double.MIN_NORMAL;
    }
}

