/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public class MapIntegerDBIDRecordStore
implements WritableRecordStore {
    private final int rlen;
    private final TIntObjectMap<Object[]> data;

    public MapIntegerDBIDRecordStore(int n, TIntObjectMap<Object[]> tIntObjectMap) {
        this.rlen = n;
        this.data = tIntObjectMap;
    }

    public MapIntegerDBIDRecordStore(int n) {
        this(n, (TIntObjectMap<Object[]>)new TIntObjectHashMap());
    }

    public MapIntegerDBIDRecordStore(int n, int n2) {
        this(n2, (TIntObjectMap<Object[]>)new TIntObjectHashMap(n));
    }

    @Override
    public <T> WritableDataStore<T> getStorage(int n, Class<? super T> clazz) {
        return new StorageAccessor(n);
    }

    protected <T> T get(DBIDRef dBIDRef, int n) {
        Object[] objectArray = (Object[])this.data.get(DBIDUtil.asInteger(dBIDRef));
        if (objectArray == null) {
            return null;
        }
        return (T)objectArray[n];
    }

    protected <T> T set(DBIDRef dBIDRef, int n, T t) {
        Object[] objectArray = (Object[])this.data.get(DBIDUtil.asInteger(dBIDRef));
        if (objectArray == null) {
            objectArray = new Object[this.rlen];
            this.data.put(DBIDUtil.asInteger(dBIDRef), (Object)objectArray);
        }
        Object object = objectArray[n];
        objectArray[n] = t;
        return (T)object;
    }

    @Override
    public boolean remove(DBIDRef dBIDRef) {
        return this.data.remove(DBIDUtil.asInteger(dBIDRef)) != null;
    }

    protected class StorageAccessor<T>
    implements WritableDataStore<T> {
        private final int index;

        protected StorageAccessor(int n) {
            this.index = n;
        }

        @Override
        public T get(DBIDRef dBIDRef) {
            return MapIntegerDBIDRecordStore.this.get(dBIDRef, this.index);
        }

        @Override
        public T put(DBIDRef dBIDRef, T t) {
            return MapIntegerDBIDRecordStore.this.set(dBIDRef, this.index, t);
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("Record storage accessors cannot be destroyed.");
        }

        @Override
        public void delete(DBIDRef dBIDRef) {
            throw new UnsupportedOperationException("Record storage accessors cannot be deleted.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Record storage accessors cannot be cleared.");
        }

        @Override
        public String getLongName() {
            return "raw";
        }

        @Override
        public String getShortName() {
            return "raw";
        }
    }
}

