/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

@Description(value="Load clustering results from an external file. Each line is expected to consists of one clustering, one integer per point and an (optional) non-numeric label.")
public class ExternalClustering
extends AbstractAlgorithm<Clustering<? extends Model>>
implements ClusteringAlgorithm<Clustering<? extends Model>> {
    private static final Logging LOG = Logging.getLogger(ExternalClustering.class);
    public static final String COMMENT = "#";
    private File file;

    public ExternalClustering(File file) {
        this.file = file;
    }

    @Override
    public Clustering<? extends Model> run(Database database) {
        Clustering<? extends Model> clustering = null;
        try (InputStream inputStream = FileUtil.tryGzipInput(new FileInputStream(this.file));
             TokenizedReader tokenizedReader = CSVReaderFormat.DEFAULT_FORMAT.makeReader();){
            Tokenizer tokenizer = tokenizedReader.getTokenizer();
            tokenizedReader.reset(inputStream);
            TIntArrayList tIntArrayList = new TIntArrayList(database.getRelation(TypeUtil.DBID, new Object[0]).size());
            ArrayList<String> arrayList = new ArrayList<String>();
            block22: while (tokenizedReader.nextLineExceptComments()) {
                while (tokenizer.valid()) {
                    try {
                        tIntArrayList.add((int)tokenizer.getLongBase10());
                    }
                    catch (NumberFormatException numberFormatException) {
                        arrayList.add(tokenizer.getSubstring());
                    }
                    tokenizer.advance();
                }
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("Read " + tIntArrayList.size() + " assignments and " + arrayList.size() + " labels.");
                }
                for (Relation<?> relation : database.getRelations()) {
                    if (relation.size() != tIntArrayList.size()) continue;
                    this.attachToRelation(database, relation, tIntArrayList, arrayList);
                    tIntArrayList.clear();
                    arrayList.clear();
                    continue block22;
                }
                throw new AbortException("No relation found to match with clustering of size " + tIntArrayList.size());
            }
        }
        catch (IOException iOException) {
            throw new AbortException("Could not load outlier scores: " + iOException.getMessage() + " when loading " + this.file, iOException);
        }
        return clustering;
    }

    private void attachToRelation(Database database, Relation<?> relation, TIntArrayList tIntArrayList, ArrayList<String> arrayList) {
        DBIDs dBIDs = relation.getDBIDs();
        if (!(dBIDs instanceof ArrayDBIDs)) {
            throw new AbortException("External clusterings can only be used with static DBIDs.");
        }
        TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
        TIntIterator tIntIterator = tIntArrayList.iterator();
        while (tIntIterator.hasNext()) {
            tIntIntHashMap.adjustOrPutValue(tIntIterator.next(), 1, 1);
        }
        tIntIterator = new TIntObjectHashMap(tIntIntHashMap.size());
        Object object = tIntIntHashMap.iterator();
        while (object.hasNext()) {
            object.advance();
            tIntIterator.put(object.key(), (Object)DBIDUtil.newArray(object.value()));
        }
        object = ((ArrayDBIDs)dBIDs).iter();
        for (int i = 0; i < tIntArrayList.size(); ++i) {
            ((ArrayModifiableDBIDs)tIntIterator.get(tIntArrayList.get(i))).add(object.seek(i));
        }
        object = FormatUtil.format(arrayList, " ");
        String string = ((String)object).toLowerCase().replace(' ', '-');
        Clustering<ClusterModel> clustering = new Clustering<ClusterModel>((String)object, string);
        TIntObjectIterator tIntObjectIterator = tIntIterator.iterator();
        while (tIntObjectIterator.hasNext()) {
            tIntObjectIterator.advance();
            boolean bl = tIntObjectIterator.key() < 0;
            clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)tIntObjectIterator.value(), bl, ClusterModel.CLUSTER));
        }
        database.getHierarchy().add(relation, clustering);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILE_ID = new OptionID("externalcluster.file", "The file name containing the (external) cluster vector.");
        private File file;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.file = (File)fileParameter.getValue();
            }
        }

        @Override
        protected ExternalClustering makeInstance() {
            return new ExternalClustering(this.file);
        }
    }
}

