/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.classification;

import de.lmu.ifi.dbs.elki.algorithm.classification.AbstractClassifier;
import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;

@Title(value="Prior Probability Classifier")
@Description(value="Classifier to predict simply prior probabilities for all classes as defined by their relative abundance in a given database.")
public class PriorProbabilityClassifier
extends AbstractClassifier<Object, Result> {
    private static final Logging LOG = Logging.getLogger(PriorProbabilityClassifier.class);
    protected double[] distribution;
    protected ClassLabel prediction;
    protected ArrayList<ClassLabel> labels;

    @Override
    public void buildClassifier(Database database, Relation<? extends ClassLabel> relation) {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            tObjectIntHashMap.adjustOrPutValue((Object)relation.get(dBIDIter), 1, 1);
            dBIDIter.advance();
        }
        int n = Integer.MIN_VALUE;
        double d = relation.size();
        this.distribution = new double[tObjectIntHashMap.size()];
        this.labels = new ArrayList(tObjectIntHashMap.size());
        TObjectIntIterator tObjectIntIterator = tObjectIntHashMap.iterator();
        int n2 = 0;
        while (tObjectIntIterator.hasNext()) {
            tObjectIntIterator.advance();
            this.distribution[n2] = (double)tObjectIntIterator.value() / d;
            this.labels.add((ClassLabel)tObjectIntIterator.key());
            if (tObjectIntIterator.value() > n) {
                n = tObjectIntIterator.value();
                this.prediction = (ClassLabel)tObjectIntIterator.key();
            }
            ++n2;
        }
    }

    public double[] classProbabilities(Object object, ArrayList<ClassLabel> arrayList) {
        return this.alignLabels(this.labels, this.distribution, arrayList);
    }

    @Override
    public ClassLabel classify(Object object) {
        return this.prediction;
    }

    @Override
    public String model() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.distribution.length; ++i) {
            stringBuilder.append(this.labels.get(i));
            stringBuilder.append(" : ");
            stringBuilder.append(this.distribution[i]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

