/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.StoreBinary;
import org.mapdb.StoreBinaryGetLong;
import org.mapdb.StoreDirect;
import org.mapdb.StoreDirectAbstract;
import org.mapdb.StoreDirectJava;
import org.mapdb.Utils;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0001aBo\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\u0006\u0010\u0011\u001a\u00020\b\u0012\u0006\u0010\u0012\u001a\u00020\b\u0012\u0006\u0010\u0013\u001a\u00020\b\u0012\u0006\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015J\b\u0010!\u001a\u00020\nH\u0014J\b\u0010\"\u001a\u00020\nH\u0014J\b\u0010#\u001a\u00020\nH\u0004J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020%H\u0016J=\u0010(\u001a\u00020\b\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u0001H)2\b\u0010,\u001a\u0004\u0018\u0001H)2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.H\u0016\u00a2\u0006\u0002\u0010/J$\u00100\u001a\u00020%\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.H\u0016J\b\u00101\u001a\u00020\bH\u0016J\u0010\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\nH\u0014J+\u00104\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.H\u0016\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000407H\u0016J\b\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010;\u001a\u00020<H\u0016J\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010=\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0014J\u0006\u0010>\u001a\u00020\nJ\u0010\u0010?\u001a\u00020%2\u0006\u0010@\u001a\u00020\nH\u0004J\u0010\u0010A\u001a\u00020B2\u0006\u0010@\u001a\u00020\nH\u0004J\u0018\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020B2\u0006\u0010E\u001a\u00020\rH\u0004J\u0018\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\n2\u0006\u0010H\u001a\u00020\nH\u0004J$\u0010I\u001a\u00020%2\u0006\u0010J\u001a\u00020\n2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020%0LH\u0004J0\u0010M\u001a\u00020%2\u0006\u0010J\u001a\u00020\n2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\bH\u0004J \u0010R\u001a\u00020%2\u0006\u0010J\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\bH\u0014J\u0018\u0010S\u001a\u00020\n2\u0006\u0010J\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\bH\u0014J\b\u0010T\u001a\u00020\nH\u0016J+\u0010U\u001a\u00020\n\"\u0004\b\u0000\u0010)2\b\u0010V\u001a\u0004\u0018\u0001H)2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.H\u0016\u00a2\u0006\u0002\u0010WJ\u001a\u0010X\u001a\u00020%2\u0006\u0010*\u001a\u00020\n2\b\u0010Y\u001a\u0004\u0018\u00010BH\u0002J\u0018\u0010Z\u001a\u00020%2\u0006\u0010*\u001a\u00020\n2\u0006\u0010O\u001a\u00020\nH\u0014J3\u0010[\u001a\u00020%\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\n2\b\u0010V\u001a\u0004\u0018\u0001H)2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.H\u0016\u00a2\u0006\u0002\u0010\\J\u001a\u0010]\u001a\u00020%2\u0006\u0010*\u001a\u00020\n2\b\u0010^\u001a\u0004\u0018\u00010_H\u0002J\b\u0010`\u001a\u00020%H\u0016R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001d\u00a8\u0006b"}, d2={"Lorg/mapdb/StoreDirect;", "Lorg/mapdb/StoreDirectAbstract;", "Lorg/mapdb/StoreBinary;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "isReadOnly", "", "fileLockWait", "", "isThreadSafe", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDeleteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "(Ljava/lang/String;Lorg/mapdb/volume/VolumeFactory;ZJZIJJZZZZZ)V", "freeSize", "Ljava/util/concurrent/atomic/AtomicLong;", "getFreeSize", "()Ljava/util/concurrent/atomic/AtomicLong;", "headVol", "Lorg/mapdb/volume/Volume;", "getHeadVol", "()Lorg/mapdb/volume/Volume;", "()Z", "volume", "getVolume", "allocateNewIndexPage", "allocateNewPage", "calculateFreeSize", "close", "", "commit", "compact", "compareAndSwap", "R", "recid", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "fileLoad", "freeSizeIncrement", "increment", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "getAllRecids", "Lkotlin/collections/LongIterator;", "getBinaryLong", "f", "Lorg/mapdb/StoreBinaryGetLong;", "getIndexVal", "getTotalSize", "linkedRecordDelete", "indexValue", "linkedRecordGet", "", "linkedRecordPut", "output", "size", "longStackFindEnd", "pageOffset", "pos", "longStackForEach", "masterLinkOffset", "body", "Lkotlin/Function1;", "longStackNewChunk", "prevPageOffset", "value", "valueSize", "recursive", "longStackPut", "longStackTake", "preallocate", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "putCompact", "data", "setIndexVal", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "updateProtected", "di", "Lorg/mapdb/DataOutput2;", "verify", "Companion", "mapdb"})
public final class StoreDirect
extends StoreDirectAbstract
implements StoreBinary {
    @NotNull
    private final AtomicLong freeSize;
    @NotNull
    private final Volume volume;
    @NotNull
    private final Volume headVol;
    private final boolean isReadOnly;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final AtomicLong getFreeSize() {
        return this.freeSize;
    }

    @Override
    @NotNull
    protected Volume getVolume() {
        return this.volume;
    }

    @Override
    @NotNull
    protected Volume getHeadVol() {
        return this.headVol;
    }

    @Override
    protected long getIndexVal(long recid2) {
        if (false) {
            Utils.INSTANCE.assertReadLock(this.getLocks()[this.recidToSegment(recid2)]);
        }
        try {
            long offset = this.recidToOffset(recid2);
            long indexVal = this.getVolume().getLong(offset);
            if (indexVal == 0L) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            return DataIO.parity1Get(indexVal);
        }
        catch (IndexOutOfBoundsException e) {
            throw (Throwable)new DBException.GetVoid(recid2);
        }
    }

    @Override
    protected void setIndexVal(long recid2, long value) {
        if (true) {
            Utils.INSTANCE.assertWriteLock(this.getLocks()[this.recidToSegment(recid2)]);
        }
        long offset = this.recidToOffset(recid2);
        this.getVolume().putLong(offset, DataIO.parity1Set(value));
    }

    @Override
    protected long allocateNewPage() {
        if (true) {
            Utils.INSTANCE.assertLocked(this.getStructuralLock());
        }
        long eof = this.getFileTail$mapdb();
        long newEof = eof + 0x100000L;
        this.getVolume().ensureAvailable(newEof);
        if (false) {
            this.getVolume().clear(eof, newEof);
        }
        this.setFileTail$mapdb(newEof);
        return eof;
    }

    @Override
    protected long allocateNewIndexPage() {
        long pagePointerOffset;
        if (true) {
            Utils.INSTANCE.assertLocked(this.getStructuralLock());
        }
        long indexPage = this.allocateNewPage();
        long l = pagePointerOffset = this.getIndexPages().isEmpty() ? 32864L : this.getIndexPages().get(this.getIndexPages().size() - 1) + (long)8;
        if (true && DataIO.parity16Get(this.getVolume().getLong(pagePointerOffset)) != 0L) {
            throw (Throwable)new DBException.DataCorruption("index pointer not empty");
        }
        this.getVolume().putLong(pagePointerOffset, DataIO.parity16Set(indexPage));
        this.getIndexPages().add(indexPage);
        this.getVolume().putLong(indexPage + (long)8, DataIO.parity16Set(0L));
        return indexPage;
    }

    @NotNull
    protected final byte[] linkedRecordGet(long indexValue) {
        if (true && !this.indexValFlagLinked(indexValue)) {
            throw (Throwable)((Object)new AssertionError((Object)"not linked record"));
        }
        byte[] b = new byte[131072];
        int bpos = 0;
        long pointer = indexValue;
        while (true) {
            boolean isLinked;
            int nextPointerSize = (isLinked = this.indexValFlagLinked(pointer)) ? 8 : 0;
            int size2 = (int)StoreDirectJava.indexValToSize(pointer) - nextPointerSize;
            long offset = StoreDirectJava.indexValToOffset(pointer);
            if (bpos + size2 >= b.length) {
                Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(b, b.length * 2), (String)"Arrays.copyOf(b,b.size*2)");
            }
            this.getVolume().getData(offset + (long)nextPointerSize, b, bpos, size2);
            bpos += size2;
            if (!isLinked) break;
            pointer = DataIO.parity3Get(this.getVolume().getLong(offset));
        }
        byte[] byArray = Arrays.copyOf(b, bpos);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(b,bpos)");
        return byArray;
    }

    protected final void linkedRecordDelete(long indexValue) {
        if (true && !this.indexValFlagLinked(indexValue)) {
            throw (Throwable)((Object)new AssertionError((Object)"not linked record"));
        }
        long pointer = indexValue;
        while (pointer != 0L) {
            boolean isLinked = this.indexValFlagLinked(pointer);
            long size2 = StoreDirectJava.indexValToSize(pointer);
            long offset = StoreDirectJava.indexValToOffset(pointer);
            pointer = isLinked ? DataIO.parity3Get(this.getVolume().getLong(offset)) : 0L;
            long sizeUp = DataIO.roundUp(size2, 16L);
            if (false) {
                this.getVolume().clear(offset, offset + sizeUp);
            }
            this.releaseData(sizeUp, offset, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final long linkedRecordPut(@NotNull byte[] output, int size2) {
        long l;
        void chunkSize;
        void lock$iv;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        long remSize = size2;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = Math.min(65520L, remSize);
        Utils utils = Utils.INSTANCE;
        Lock lock = this.getStructuralLock();
        void v0 = lock$iv;
        if (v0 != null) {
            v0.lock();
        }
        try {
            l = this.allocateData(DataIO.roundUp((int)chunkSize.element, 16), false);
        }
        finally {
            void v1 = lock$iv;
            if (v1 != null) {
                v1.unlock();
            }
        }
        long chunkOffset = l;
        this.getVolume().putData(chunkOffset, output, (int)(remSize - chunkSize.element), (int)chunkSize.element);
        remSize -= chunkSize.element;
        long isLinked = 0L;
        while (remSize > (long)0) {
            long l2;
            void lock$iv2;
            long prevLink = DataIO.parity3Set((chunkSize.element + isLinked << 48) + chunkOffset + isLinked);
            isLinked = 8L;
            chunkSize.element = Math.min(65512L, remSize);
            Utils $i$f$lock = Utils.INSTANCE;
            Lock lock2 = this.getStructuralLock();
            void v2 = lock$iv2;
            if (v2 != null) {
                v2.lock();
            }
            try {
                l2 = this.allocateData((int)DataIO.roundUp(chunkSize.element + (long)8, 16L), false);
            }
            finally {
                void v3 = lock$iv2;
                if (v3 != null) {
                    v3.unlock();
                }
            }
            chunkOffset = l2;
            this.getVolume().putLong(chunkOffset, prevLink);
            this.getVolume().putData(chunkOffset + (long)8, output, (int)(remSize -= chunkSize.element), (int)chunkSize.element);
        }
        if (true && remSize != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        return (chunkSize.element + (long)8 << 48) + chunkOffset + isLinked + 2L;
    }

    @Override
    protected void longStackPut(long masterLinkOffset, long value, boolean recursive) {
        if (true) {
            Utils.INSTANCE.assertLocked(this.getStructuralLock());
        }
        if (true && (masterLinkOffset <= (long)0 || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L)) {
            throw (Throwable)new DBException.DataCorruption("wrong master link");
        }
        if (true && value >> 48 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (true) {
            DataIO.parity1Get(value);
        }
        long valueSize = DataIO.packLongSize(value);
        long masterLinkVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            this.longStackNewChunk(masterLinkOffset, 0L, value, valueSize, true);
            return;
        }
        long chunkOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        long currSize = masterLinkVal >>> 48;
        long prevLinkVal = DataIO.parity4Get(this.getVolume().getLong(chunkOffset));
        long pageSize = prevLinkVal >>> 48;
        if (currSize + valueSize > pageSize) {
            this.longStackNewChunk(masterLinkOffset, chunkOffset, value, valueSize, true);
            return;
        }
        this.getVolume().putPackedLong(chunkOffset + currSize, value);
        long newMasterLinkValue = (currSize + valueSize << 48) + chunkOffset;
        this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    /*
     * WARNING - void declaration
     */
    protected final void longStackNewChunk(long masterLinkOffset, long prevPageOffset, long value, long valueSize, boolean recursive) {
        if (true) {
            Utils.INSTANCE.assertLocked(this.getStructuralLock());
        }
        if (false) {
            Collection destination$iv$iv;
            StackTraceElement it;
            Object element$iv$iv;
            Object[] $receiver$iv$iv;
            int n;
            Object[] $receiver$iv;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            Object object = stack;
            void var12_9 = $receiver$iv;
            Collection collection = new ArrayList();
            for (n = 0; n < $receiver$iv$iv.length; ++n) {
                element$iv$iv = $receiver$iv$iv[n];
                it = (StackTraceElement)element$iv$iv;
                if (!StringsKt.startsWith$default((String)it.getMethodName(), (String)"longStackPut", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (Object[])((List)destination$iv$iv);
            if ($receiver$iv.size() > 1) {
                throw (Throwable)((Object)new AssertionError((Object)"longStackNewChunk called in recursion, longStackPut() is more then once on stack frame"));
            }
            $receiver$iv = stack;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (n = 0; n < $receiver$iv$iv.length; ++n) {
                element$iv$iv = $receiver$iv$iv[n];
                it = (StackTraceElement)element$iv$iv;
                if (!StringsKt.startsWith$default((String)it.getMethodName(), (String)"longStackTake", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            if (object.size() > 1) {
                throw (Throwable)((Object)new AssertionError((Object)"longStackNewChunk called in recursion, longStackTake() is more then once on stack frame"));
            }
        }
        if (true && (masterLinkOffset <= (long)0 || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L)) {
            throw (Throwable)new DBException.DataCorruption("wrong master link");
        }
        long newChunkSize = -1L;
        if (!recursive) {
            LongProgression longProgression = RangesKt.step((LongProgression)RangesKt.downTo((long)256L, (long)16L), (long)16L);
            long $receiver$iv$iv = longProgression.getFirst();
            long l = longProgression.getLast();
            long it = longProgression.getStep();
            long l2 = $receiver$iv$iv;
            long l3 = l;
            if (it > 0L ? l2 <= l3 : l2 >= l3) {
                while (true) {
                    long indexVal;
                    void size2;
                    long masterLinkOffset2;
                    if (masterLinkOffset != (masterLinkOffset2 = this.longStackMasterLinkOffset((long)size2)) && (indexVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset2))) != 0L) {
                        newChunkSize = size2;
                        break;
                    }
                    if (size2 == l) break;
                    size2 += it;
                }
            }
        }
        long dataTail = this.getDataTail();
        long remainderSize = DataIO.roundUp(dataTail, 0x100000L) - dataTail;
        if (newChunkSize == -1L) {
            long dataTail2 = dataTail;
            if (dataTail2 == 0L) {
                newChunkSize = 160L;
            } else {
                long l = newChunkSize = remainderSize > 256L || remainderSize < 16L ? 160L : remainderSize;
            }
        }
        if (true && newChunkSize % (long)16 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        long newChunkOffset = this.allocateData((int)newChunkSize, true);
        this.getVolume().clear(newChunkOffset, newChunkOffset + newChunkSize);
        this.getVolume().putLong(newChunkOffset, DataIO.parity4Set((newChunkSize << 48) + prevPageOffset));
        this.getVolume().putPackedLong(newChunkOffset + (long)8, value);
        long newSize = (long)8 + valueSize;
        long newMasterLinkValue = (newSize << 48) + newChunkOffset;
        this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    @Override
    protected long longStackTake(long masterLinkOffset, boolean recursive) {
        long l;
        if (true) {
            Utils.INSTANCE.assertLocked(this.getStructuralLock());
        }
        if (true && (masterLinkOffset <= (long)0 || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L)) {
            throw (Throwable)new DBException.DataCorruption("wrong master link");
        }
        long masterLinkVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            return 0L;
        }
        long offset = masterLinkVal & 0xFFFFFFFFFFF0L;
        long pos = Math.max((masterLinkVal >>> 48) - (long)1, 8L);
        while (pos > (long)8 && (this.getVolume().getUnsignedByte(offset + pos - (long)1) & 0x80) == 0) {
            long l2 = pos;
            pos = l2 + -1L;
        }
        if (true && pos < 8L) {
            throw (Throwable)new DBException.DataCorruption("position too small");
        }
        if (true && this.getVolume().getLong(offset) >>> 48 <= pos) {
            throw (Throwable)new DBException.DataCorruption("position beyond chunk " + masterLinkOffset);
        }
        long ret2 = this.getVolume().getPackedLong(offset + pos) & 0xFFFFFFFFFFFFFFFL;
        this.getVolume().clear(offset + pos, offset + pos + (long)DataIO.packLongSize(ret2));
        if (pos > 8L) {
            this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set((pos << 48) + offset));
            if (true && ret2 >> 48 != 0L) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (true) {
                DataIO.parity1Get(ret2);
            }
            return ret2;
        }
        long prevChunkValue = DataIO.parity4Get(this.getVolume().getLong(offset));
        this.getVolume().putLong(offset, 0L);
        long currentSize = prevChunkValue >>> 48;
        long prevChunkOffset = prevChunkValue & 0xFFFFFFFFFFF0L;
        if (prevChunkOffset != 0L) {
            long pos2 = DataIO.parity4Get(this.getVolume().getLong(prevChunkOffset)) >>> 48;
            l = this.longStackFindEnd(prevChunkOffset, pos2);
        } else {
            l = 0L;
        }
        long masterLinkPos = l;
        this.getVolume().putLong(masterLinkOffset, DataIO.parity4Set((masterLinkPos << 48) + prevChunkOffset));
        if (false) {
            this.getVolume().clear(offset, offset + currentSize);
        }
        this.releaseData(currentSize, offset, true);
        if (true && ret2 >> 48 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (true && ret2 != 0L) {
            DataIO.parity1Get(ret2);
        }
        return ret2;
    }

    protected final long longStackFindEnd(long pageOffset, long pos) {
        long pos2 = pos;
        while (pos2 > (long)8 && this.getVolume().getUnsignedByte(pageOffset + pos2 - (long)1) == 0) {
            long l = pos2;
            pos2 = l + -1L;
        }
        return pos2;
    }

    protected final void longStackForEach(long masterLinkOffset, @NotNull Function1<? super Long, Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        long linkVal = DataIO.parity4Get(this.getVolume().getLong(masterLinkOffset));
        long endSize = StoreDirectJava.indexValToSize(linkVal);
        long offset = StoreDirectJava.indexValToOffset(linkVal);
        endSize = this.longStackFindEnd(offset, endSize);
        while (offset != 0L) {
            long stackVal;
            long currHead = DataIO.parity4Get(this.getVolume().getLong(offset));
            for (long pos = 8L; pos < endSize; pos += stackVal >>> 60) {
                stackVal = this.getVolume().getPackedLong(offset + pos);
                if ((stackVal &= 0xFFFFFFFFFFFFFFFL) >>> 48 != 0L) {
                    throw (Throwable)((Object)new AssertionError());
                }
                DataIO.parity1Get(stackVal);
                body.invoke((Object)stackVal);
            }
            offset = StoreDirectJava.indexValToOffset(currHead);
            if (offset == 0L) continue;
            endSize = StoreDirectJava.indexValToSize(DataIO.parity4Get(this.getVolume().getLong(offset)));
            endSize = this.longStackFindEnd(offset, endSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long l;
        ReadWriteLock lock$iv;
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        Lock lock = this.getStructuralLock();
        void v0 = lock$iv;
        if (v0 != null) {
            v0.lock();
        }
        try {
            l = this.allocateRecid();
        }
        finally {
            void v1 = lock$iv;
            if (v1 != null) {
                v1.unlock();
            }
        }
        long recid2 = l;
        Utils this_$iv = Utils.INSTANCE;
        lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            long oldVal;
            if (true && (oldVal = this.getVolume().getLong(this.recidToOffset(recid2))) != 0L && StoreDirectJava.indexValToSize(oldVal) != 65534L) {
                throw (Throwable)new DBException.DataCorruption("old recid is not empty");
            }
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 1, 1));
            long l2 = recid2;
            return l2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            DataInput2 di;
            long indexVal = this.getIndexVal(recid2);
            if (this.indexValFlagLinked(indexVal)) {
                byte[] di2 = this.linkedRecordGet(indexVal);
                R r = this.deserialize(serializer, new DataInput2.ByteArray(di2), di2.length);
                return r;
            }
            long size2 = StoreDirectJava.indexValToSize(indexVal);
            if (size2 == 65534L) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            if (size2 == 65535L) {
                R r = null;
                return r;
            }
            long offset = StoreDirectJava.indexValToOffset(indexVal);
            if (size2 < (long)6) {
                if (true && size2 > (long)5) {
                    throw (Throwable)new DBException.DataCorruption("wrong size record header");
                }
                R r = serializer.deserializeFromLong(offset >>> 8, (int)size2);
                return r;
            }
            DataInput2 dataInput2 = di = this.getVolume().getDataInput(offset, (int)size2);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataInput2, (String)"di");
            R r = this.deserialize(serializer, dataInput2, size2);
            return r;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long getBinaryLong(long recid2, @NotNull StoreBinaryGetLong f) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            DataInput2 dataInput2;
            long indexVal = this.getIndexVal(recid2);
            if (this.indexValFlagLinked(indexVal)) {
                byte[] di = this.linkedRecordGet(indexVal);
                long l = f.get(new DataInput2.ByteArray(di), di.length);
                return l;
            }
            long size2 = StoreDirectJava.indexValToSize(indexVal);
            if (size2 == 65534L) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            if (size2 == 65535L) {
                long l = LongCompanionObject.MIN_VALUE;
                return l;
            }
            long offset = StoreDirectJava.indexValToOffset(indexVal);
            int sizeInt = (int)size2;
            if (size2 >= (long)6) {
                dataInput2 = this.getVolume().getDataInput(offset, sizeInt);
            } else {
                byte[] buf = new byte[sizeInt];
                DataIO.putLong(buf, 0, offset >>> 8, sizeInt);
                dataInput2 = new DataInput2.ByteArray(buf);
            }
            DataInput2 di = dataInput2;
            long l = f.get(di, sizeInt);
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        DataOutput2 di = this.serialize(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.getCompactionLock();
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            long offset;
            long recid2;
            ReadWriteLock lock$iv2;
            block33: {
                block32: {
                    long l;
                    Utils utils2 = Utils.INSTANCE;
                    Lock lock = this.getStructuralLock();
                    void v0 = lock$iv2;
                    if (v0 != null) {
                        v0.lock();
                    }
                    try {
                        l = this.allocateRecid();
                    }
                    finally {
                        void v1 = lock$iv2;
                        if (v1 != null) {
                            v1.unlock();
                        }
                    }
                    recid2 = l;
                    Utils this_$iv = Utils.INSTANCE;
                    lock$iv2 = this.getLocks()[this.recidToSegment(recid2)];
                    if (lock$iv2 != null) {
                        lock$iv2.writeLock().lock();
                    }
                    try {
                        if (di != null) break block32;
                        this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
                        long l2 = recid2;
                        if (lock$iv2 != null) {
                            lock$iv2.writeLock().unlock();
                        }
                        long l3 = l2;
                        return l3;
                    }
                    catch (Throwable throwable) {
                        if (lock$iv2 != null) {
                            lock$iv2.writeLock().unlock();
                        }
                        throw throwable;
                    }
                }
                if ((long)di.pos <= 65520L) break block33;
                Intrinsics.checkExpressionValueIsNotNull((Object)di.buf, (String)"di.buf");
                long indexVal = this.linkedRecordPut(di.buf, di.pos);
                this.setIndexVal(recid2, indexVal);
                long l = recid2;
                if (lock$iv2 != null) {
                    lock$iv2.writeLock().unlock();
                }
                long l4 = l;
                return l4;
            }
            long size2 = di.pos;
            if (di.pos == 0) {
                offset = 0L;
            } else if (di.pos < 6) {
                offset = DataIO.getLong(di.buf, 0) >>> (7 - di.pos) * 8;
            } else {
                long l;
                void lock$iv3;
                Utils utils3 = Utils.INSTANCE;
                Lock lock = this.getStructuralLock();
                void v2 = lock$iv3;
                if (v2 != null) {
                    v2.lock();
                }
                try {
                    l = this.allocateData(DataIO.roundUp(di.pos, 16), false);
                }
                finally {
                    void v3 = lock$iv3;
                    if (v3 != null) {
                        v3.unlock();
                    }
                }
                offset = l;
                this.getVolume().putData(offset, di.buf, 0, di.pos);
            }
            this.setIndexVal(recid2, this.indexValCompose(size2, offset, 0, 0, 1));
            long l = recid2;
            if (lock$iv2 != null) {
                lock$iv2.writeLock().unlock();
            }
            long l5 = l;
            return l5;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        DataOutput2 di = this.serialize(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.updateProtected(recid2, di);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateProtected(long recid2, DataOutput2 di) {
        long l;
        long newUpSize;
        if (true) {
            Utils.INSTANCE.assertWriteLock(this.getLocks()[this.recidToSegment(recid2)]);
        }
        long oldIndexVal = this.getIndexVal(recid2);
        boolean oldLinked = this.indexValFlagLinked(oldIndexVal);
        long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
        if (oldSize == 65534L) {
            throw (Throwable)new DBException.GetVoid(recid2);
        }
        updateProtected.1 roundSixDown$ = updateProtected.1.INSTANCE;
        long l2 = newUpSize = di == null ? -16L : DataIO.roundUp(roundSixDown$.invoke(di.pos), 16L);
        if (oldLinked || newUpSize != DataIO.roundUp(roundSixDown$.invoke(oldSize), 16L) && oldSize != 65535L && oldSize > 5L) {
            void lock$iv;
            Utils utils = Utils.INSTANCE;
            Lock lock = this.getStructuralLock();
            void v1 = lock$iv;
            if (v1 != null) {
                v1.lock();
            }
            try {
                if (oldLinked) {
                    this.linkedRecordDelete(oldIndexVal);
                } else {
                    long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                    long sizeUp = DataIO.roundUp(oldSize, 16L);
                    if (false) {
                        this.getVolume().clear(oldOffset, oldOffset + sizeUp);
                    }
                    this.releaseData(sizeUp, oldOffset, false);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                void v2 = lock$iv;
                if (v2 != null) {
                    v2.unlock();
                }
            }
        }
        if (di == null) {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
            return;
        }
        if ((long)di.pos > 65520L) {
            Intrinsics.checkExpressionValueIsNotNull((Object)di.buf, (String)"di.buf");
            long newIndexVal = this.linkedRecordPut(di.buf, di.pos);
            this.setIndexVal(recid2, newIndexVal);
            return;
        }
        int size2 = di.pos;
        if (size2 != 0 && size2 < 6) {
            l = DataIO.getLong(di.buf, 0) >>> (7 - size2) * 8;
        } else if (!oldLinked && newUpSize == DataIO.roundUp(oldSize, 16L) && oldSize >= (long)6) {
            l = StoreDirectJava.indexValToOffset(oldIndexVal);
        } else if (size2 == 0) {
            l = 0L;
        } else {
            void lock$iv;
            Utils utils = Utils.INSTANCE;
            Lock sizeUp = this.getStructuralLock();
            void v4 = lock$iv;
            if (v4 != null) {
                v4.lock();
            }
            try {
                long l3 = this.allocateData(DataIO.roundUp(size2, 16), false);
                l = l3;
            }
            finally {
                void v5 = lock$iv;
                if (v5 != null) {
                    v5.unlock();
                }
            }
        }
        long offset = l;
        if (size2 > 5) {
            this.getVolume().putData(offset, di.buf, 0, size2);
        }
        this.setIndexVal(recid2, this.indexValCompose(size2, offset, 0, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            R old = this.get(recid2, serializer);
            if (old == null && expectedOldRecord != null) {
                boolean bl = false;
                return bl;
            }
            if (old != null && expectedOldRecord == null) {
                boolean bl = false;
                return bl;
            }
            if (old != expectedOldRecord) {
                R r = old;
                if (r == null) {
                    Intrinsics.throwNpe();
                }
                R r2 = expectedOldRecord;
                if (r2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!serializer.equals(r, r2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            DataOutput2 di = this.serialize(newRecord, serializer);
            this.updateProtected(recid2, di);
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.getLocks()[this.recidToSegment(recid2)];
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            long oldIndexVal = this.getIndexVal(recid2);
            long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
            if (oldSize == 65534L) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            if (oldSize != 65535L) {
                void lock$iv2;
                Utils utils2 = Utils.INSTANCE;
                Lock lock = this.getStructuralLock();
                void v0 = lock$iv2;
                if (v0 != null) {
                    v0.lock();
                }
                try {
                    if (this.indexValFlagLinked(oldIndexVal)) {
                        this.linkedRecordDelete(oldIndexVal);
                    } else if (oldSize > (long)5) {
                        long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                        long sizeUp = DataIO.roundUp(oldSize, 16L);
                        if (false) {
                            this.getVolume().clear(oldOffset, oldOffset + sizeUp);
                        }
                        this.releaseData(sizeUp, oldOffset, false);
                    }
                    this.releaseRecid(recid2);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void v1 = lock$iv2;
                    if (v1 != null) {
                        v1.unlock();
                    }
                }
            }
            this.setIndexVal(recid2, this.indexValCompose(65534L, 0L, 0, 0, 1));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void compact() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getCompactionLock();
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            Utils.INSTANCE.lockWriteAll(this.getLocks());
            try {
                void lock$iv2;
                Utils utils2 = Utils.INSTANCE;
                Lock lock = this.getStructuralLock();
                void v0 = lock$iv2;
                if (v0 != null) {
                    v0.lock();
                }
                try {
                    StoreDirect store2 = org.mapdb.StoreDirect$Companion.make$default(Companion, null, null, 0L, false, false, 0, 0L, 0L, false, false, false, false, false, 8143, null);
                    IntRange intRange = RangesKt.until((int)0, (int)this.getIndexPages().size());
                    int n = intRange.getFirst();
                    int n2 = intRange.getLast();
                    if (n <= n2) {
                        while (true) {
                            void i;
                            store2.allocateNewIndexPage();
                            if (i == n2) break;
                            ++i;
                        }
                    }
                    if (true && store2.getIndexPages().size() != this.getIndexPages().size()) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    long l = 1;
                    long maxRecid = this.getMaxRecid();
                    long l2 = maxRecid;
                    if (l <= l2) {
                        while (true) {
                            void recid2;
                            byte[] data = null;
                            boolean exist = true;
                            try {
                                Serializer<byte[]> serializer = Serializer.BYTE_ARRAY_NOSIZE;
                                Intrinsics.checkExpressionValueIsNotNull(serializer, (String)"Serializer.BYTE_ARRAY_NOSIZE");
                                data = this.get((long)recid2, serializer);
                                exist = true;
                            }
                            catch (Exception e) {
                                exist = false;
                            }
                            if (!exist) {
                                store2.releaseRecid((long)recid2);
                                store2.setIndexVal((long)recid2, store2.indexValCompose(65534L, 0L, 0, 0, 1));
                            } else {
                                store2.putCompact((long)recid2, data);
                            }
                            if (recid2 == l2) break;
                            ++recid2;
                        }
                    }
                    store2.setMaxRecid(maxRecid);
                    long fileTail = store2.getFileTail$mapdb();
                    this.getVolume().truncate(fileTail);
                    LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((int)0, (long)fileTail)), (long)0x100000L);
                    l2 = longProgression.getFirst();
                    long l3 = longProgression.getLast();
                    long l4 = longProgression.getStep();
                    long l5 = l2;
                    long l6 = l3;
                    if (l4 > 0L ? l5 <= l6 : l5 >= l6) {
                        while (true) {
                            void page;
                            store2.getVolume().copyTo((long)page, this.getVolume(), (long)page, 0x100000L);
                            if (page == l3) break;
                            page += l4;
                        }
                    }
                    this.getIndexPages().clear();
                    this.getIndexPages().addAll((LongIterable)store2.getIndexPages());
                    this.freeSize.set(store2.freeSize.get());
                    store2.close();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void v6 = lock$iv2;
                    if (v6 != null) {
                        v6.unlock();
                    }
                }
            }
            finally {
                Utils.INSTANCE.unlockWriteAll(this.getLocks());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    private final void putCompact(long recid2, byte[] data) {
        long l;
        if (true && this.isThreadSafe()) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (data == null) {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
            return;
        }
        if ((long)data.length > 65520L) {
            long indexVal = this.linkedRecordPut(data, data.length);
            this.setIndexVal(recid2, indexVal);
            return;
        }
        if (data.length == 0) {
            l = 0L;
        } else if (data.length < 6) {
            byte[] data2 = Arrays.copyOf(data, 8);
            l = DataIO.getLong(data2, 0) >>> (7 - data.length) * 8;
        } else {
            long offset = this.allocateData(DataIO.roundUp(data.length, 16), false);
            this.getVolume().putData(offset, data, 0, data.length);
            l = offset;
        }
        long offset = l;
        this.setIndexVal(recid2, this.indexValCompose(data.length, offset, 0, 0, 1));
    }

    @Override
    public void commit() {
        this.assertNotClosed();
        if (this.isReadOnly()) {
            return;
        }
        this.getVolume().putInt(20L, this.calculateHeaderChecksum());
        if (this.getChecksum()) {
            this.getVolume().putLong(8L, this.calculateChecksum());
        }
        this.getVolume().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            if (!this.getClosed().compareAndSet(false, true)) {
                return;
            }
            if (!this.isReadOnly()) {
                this.getVolume().putInt(20L, this.calculateHeaderChecksum());
                if (this.getChecksum()) {
                    this.getVolume().putLong(8L, this.calculateChecksum());
                }
            }
            this.getVolume().close();
            if (this.getFileDeleteAfterClose() && this.getFile() != null) {
                new File(this.getFile()).delete();
            }
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        LongArrayList ret2;
        block8: {
            ret2 = new LongArrayList();
            Utils.INSTANCE.lockReadAll(this.getLocks());
            try {
                long maxRecid = this.getMaxRecid();
                long l = 1;
                long l2 = maxRecid;
                if (l > l2) break block8;
                while (true) {
                    void recid2;
                    long offset = this.recidToOffset((long)recid2);
                    try {
                        long indexVal = DataIO.parity1Get(this.getVolume().getLong(offset));
                        if (!this.indexValFlagUnused(indexVal)) {
                            ret2.add((long)recid2);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (recid2 != l2) {
                        ++recid2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                Utils.INSTANCE.unlockReadAll(this.getLocks());
            }
        }
        return ArrayIteratorsKt.iterator((long[])ret2.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void verify() {
        ReadWriteLock it;
        Object element$iv;
        Object[] $receiver$iv;
        block15: {
            $receiver$iv = this.getLocks();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                element$iv = $receiver$iv[i];
                it = (ReadWriteLock)element$iv;
                Object object = it;
                if (object == null || (object = object.readLock()) == null) continue;
                object.lock();
            }
            Lock lock = this.getStructuralLock();
            if (lock != null) {
                lock.lock();
            }
            try {
                long size2;
                BitSet bit = new BitSet();
                long max2 = this.getFileTail$mapdb();
                Function3<Long, Long, Boolean, Unit> set$ = new Function3<Long, Long, Boolean, Unit>(this, max2, bit){
                    final /* synthetic */ StoreDirect this$0;
                    final /* synthetic */ long $max;
                    final /* synthetic */ BitSet $bit;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(long start, long end, boolean expectZeros) {
                        int n;
                        if (start > this.$max) {
                            throw (Throwable)((Object)new AssertionError((Object)"start too high"));
                        }
                        if (end > this.$max) {
                            throw (Throwable)((Object)new AssertionError((Object)"end too high"));
                        }
                        if (false && expectZeros) {
                            this.this$0.getVolume().assertZeroes(start, end);
                        }
                        int start0 = (int)start;
                        int end0 = (int)end;
                        IntRange intRange = RangesKt.until((int)start0, (int)end0);
                        int n2 = intRange.getFirst();
                        if (n2 <= (n = intRange.getLast())) {
                            while (true) {
                                void index;
                                if (this.$bit.get((int)index)) {
                                    throw (Throwable)((Object)new AssertionError((Object)("already set " + (int)index + " - " + (long)index % 0x100000L)));
                                }
                                if (index == n) break;
                                ++index;
                            }
                        }
                        this.$bit.set(start0, end0);
                    }
                    {
                        this.this$0 = storeDirect;
                        this.$max = l;
                        this.$bit = bitSet;
                        super(3);
                    }
                };
                set$.invoke(0L, 32864L, false);
                if (this.getDataTail() % 0x100000L != 0L) {
                    set$.invoke(this.getDataTail(), DataIO.roundUp(this.getDataTail(), 0x100000L), true);
                }
                Function2<Long, Long, Unit> iterateOverIndexValues$ = new Function2<Long, Long, Unit>(this, set$){
                    final /* synthetic */ StoreDirect this$0;
                    final /* synthetic */ verify.2 $set;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(long indexPage, long end) {
                        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)(indexPage + (long)16), (long)end)), (long)8L);
                        long l = longProgression.getFirst();
                        long l2 = longProgression.getLast();
                        long l3 = longProgression.getStep();
                        long l4 = l;
                        long l5 = l2;
                        if (l3 > 0L ? l4 <= l5 : l4 >= l5) {
                            while (true) {
                                void indexOffset;
                                this.$set.invoke((long)indexOffset, (long)(indexOffset + (long)8), false);
                                long indexVal = DataIO.parity1Get(this.this$0.getVolume().getLong((long)indexOffset));
                                if ((indexVal & 8L) != 0L || StoreDirectJava.indexValToSize(indexVal) >= (long)6) {
                                    long size2;
                                    long offset;
                                    while ((indexVal & 8L) != 0L) {
                                        offset = StoreDirectJava.indexValToOffset(indexVal);
                                        size2 = DataIO.roundUp(StoreDirectJava.indexValToSize(indexVal), 16L);
                                        this.$set.invoke(offset, offset + size2, false);
                                        indexVal = DataIO.parity3Get(this.this$0.getVolume().getLong(offset));
                                    }
                                    offset = StoreDirectJava.indexValToOffset(indexVal);
                                    size2 = DataIO.roundUp(StoreDirectJava.indexValToSize(indexVal), 16L);
                                    if (size2 <= 65520L) {
                                        this.$set.invoke(offset, offset + size2, false);
                                    }
                                }
                                if (indexOffset == l2) break;
                                indexOffset += l3;
                            }
                        }
                    }
                    {
                        this.this$0 = storeDirect;
                        this.$set = var2_2;
                        super(2);
                    }
                };
                long zeroIndexPageEnd = Math.min(0x100000L, this.recidToOffset(this.getMaxRecid()) + (long)8);
                set$.invoke(32864L, 32880L, false);
                iterateOverIndexValues$.invoke(32864L, zeroIndexPageEnd);
                if (zeroIndexPageEnd < 0x100000L) {
                    set$.invoke(zeroIndexPageEnd, 0x100000L, true);
                }
                this.getIndexPages().forEach(new LongProcedure(this, set$, iterateOverIndexValues$){
                    final /* synthetic */ StoreDirect this$0;
                    final /* synthetic */ verify.2 $set;
                    final /* synthetic */ verify.3 $iterateOverIndexValues;

                    public final void value(long indexPage) {
                        this.$set.invoke(indexPage, indexPage + (long)16, false);
                        long end = Math.min(indexPage + 0x100000L, this.this$0.recidToOffset(this.this$0.getMaxRecid()) + (long)8);
                        this.$iterateOverIndexValues.invoke(indexPage, end);
                        if (end < indexPage + 0x100000L) {
                            this.$set.invoke(end, indexPage + 0x100000L, true);
                        }
                    }
                    {
                        this.this$0 = storeDirect;
                        this.$set = var2_2;
                        this.$iterateOverIndexValues = var3_3;
                    }
                });
                Function2<Long, Function1<? super Long, ? extends Unit>, Unit> longStackForEach$ = new Function2<Long, Function1<? super Long, ? extends Unit>, Unit>(this, set$){
                    final /* synthetic */ StoreDirect this$0;
                    final /* synthetic */ verify.2 $set;

                    public final void invoke(long masterLinkOffset, @NotNull Function1<? super Long, Unit> body) {
                        Intrinsics.checkParameterIsNotNull(body, (String)"body");
                        long linkVal = DataIO.parity4Get(this.this$0.getVolume().getLong(masterLinkOffset));
                        long offset = StoreDirectJava.indexValToOffset(linkVal);
                        long endSize = StoreDirectJava.indexValToSize(linkVal);
                        while (offset != 0L) {
                            long stackVal;
                            long currHead = DataIO.parity4Get(this.this$0.getVolume().getLong(offset));
                            long currSize = StoreDirectJava.indexValToSize(currHead);
                            this.$set.invoke(offset, offset + currSize, false);
                            this.this$0.getVolume().assertZeroes(offset + endSize, offset + currSize);
                            for (long pos = 8L; pos < endSize; pos += stackVal >>> 60) {
                                stackVal = this.this$0.getVolume().getPackedLong(offset + pos);
                                if ((stackVal &= 0xFFFFFFFFFFFFFFFL) >>> 48 != 0L) {
                                    throw (Throwable)((Object)new AssertionError());
                                }
                                DataIO.parity1Get(stackVal);
                                body.invoke((Object)stackVal);
                            }
                            offset = StoreDirectJava.indexValToOffset(currHead);
                            if (offset == 0L) continue;
                            endSize = StoreDirectJava.indexValToSize(DataIO.parity4Get(this.this$0.getVolume().getLong(offset)));
                            endSize = this.this$0.longStackFindEnd(offset, endSize);
                        }
                    }
                    {
                        this.this$0 = storeDirect;
                        this.$set = var2_2;
                        super(2);
                    }
                };
                longStackForEach$.invoke(64L, (Function1<? super Long, Unit>)((Function1)verify.6.INSTANCE));
                LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)new LongRange((long)16, 65520L)), (long)16L);
                long l = longProgression.getFirst();
                long l2 = longProgression.getLast();
                long l3 = longProgression.getStep();
                long l4 = l;
                long l5 = l2;
                if (l3 > 0L ? l4 <= l5 : l4 >= l5) {
                    while (true) {
                        long masterLinkOffset = this.longStackMasterLinkOffset(size2);
                        longStackForEach$.invoke(masterLinkOffset, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(set$, size2){
                            final /* synthetic */ verify.2 $set;
                            final /* synthetic */ long $size;

                            public final void invoke(long freeOffset) {
                                long freeOffset2 = DataIO.parity1Get(freeOffset) << 3;
                                this.$set.invoke(freeOffset2, freeOffset2 + this.$size, true);
                            }
                            {
                                this.$set = var1_1;
                                this.$size = l;
                                super(1);
                            }
                        }));
                        if (size2 == l2) break;
                        size2 += l3;
                    }
                }
                LongRange longRange = RangesKt.until((int)0, (long)max2);
                size2 = longRange.getFirst();
                if (size2 > (l2 = longRange.getLast())) break block15;
                while (true) {
                    void index;
                    if (!bit.get((int)index)) {
                        int len = 0;
                        while (!bit.get((int)index + len)) {
                            ++len;
                        }
                        throw (Throwable)((Object)new AssertionError((Object)("not set at " + (long)index + ", for length " + len + " - " + (long)(index % 0x100000L) + " - " + this.getDataTail() + " - " + this.getFileTail$mapdb())));
                    }
                    if (index == l2) break;
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Lock lock2 = this.getStructuralLock();
                if (lock2 != null) {
                    lock2.unlock();
                }
                Object[] $receiver$iv2 = ArraysKt.reversedArray((Object[])this.getLocks());
                for (int i = 0; i < $receiver$iv2.length; ++i) {
                    Object element$iv2 = $receiver$iv2[i];
                    ReadWriteLock it2 = (ReadWriteLock)element$iv2;
                    Object object = it2;
                    if (object == null || (object = object.readLock()) == null) continue;
                    object.unlock();
                }
                throw throwable;
            }
        }
        Lock lock = this.getStructuralLock();
        if (lock != null) {
            lock.unlock();
        }
        $receiver$iv = ArraysKt.reversedArray((Object[])this.getLocks());
        for (int max2 = 0; max2 < $receiver$iv.length; ++max2) {
            element$iv = $receiver$iv[max2];
            it = (ReadWriteLock)element$iv;
            Object object = it;
            if (object == null || (object = object.readLock()) == null) continue;
            object.unlock();
        }
    }

    @Override
    protected void freeSizeIncrement(long increment) {
        long v;
        if (true && increment % (long)16 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        while ((v = this.freeSize.get()) != -1L && !this.freeSize.compareAndSet(v, v + increment)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long getFreeSize() {
        void ret2;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = this.freeSize.get();
        if (ret2.element != -1L) {
            return ret2.element;
        }
        Utils utils = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            ret2.element = this.freeSize.get();
            if (ret2.element != -1L) {
                long l = ret2.element;
                return l;
            }
            ret2.element = this.calculateFreeSize();
            this.freeSize.set(ret2.element);
            long l = ret2.element;
            return l;
        }
        finally {
            block7: {
                Lock lock2 = lock$iv;
                if (lock2 == null) break block7;
                lock2.unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final long calculateFreeSize() {
        void ret1;
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)new LongRange((long)16, 65520L)), (long)16L);
        long l = longProgression.getFirst();
        long l2 = longProgression.getLast();
        long l3 = longProgression.getStep();
        long l4 = l;
        long l5 = l2;
        if (l3 > 0L ? l4 <= l5 : l4 >= l5) {
            while (true) {
                void size2;
                long masterLinkOffset = this.longStackMasterLinkOffset((long)size2);
                this.longStackForEach(masterLinkOffset, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Ref.LongRef)ret1, (long)size2){
                    final /* synthetic */ Ref.LongRef $ret1;
                    final /* synthetic */ long $size;

                    public final void invoke(long v) {
                        long v2 = DataIO.parity1Get(v) << 3;
                        if (true && v2 == 0L) {
                            throw (Throwable)((Object)new AssertionError());
                        }
                        this.$ret1.element += this.$size;
                    }
                    {
                        this.$ret1 = longRef;
                        this.$size = l;
                        super(1);
                    }
                }));
                if (size2 == l2) break;
                l = size2 + l3;
            }
        }
        return ret1.element;
    }

    public final long getTotalSize() {
        return this.getFileTail$mapdb();
    }

    @Override
    public boolean fileLoad() {
        return this.getVolume().fileLoad();
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        if (this.getFile() == null) {
            Iterable iterable = Arrays.asList(new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"Arrays.asList<String>()");
            return iterable;
        }
        Iterable iterable = Arrays.asList(this.getFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"Arrays.asList(file)");
        return iterable;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public StoreDirect(@Nullable String file, @NotNull VolumeFactory volumeFactory, boolean isReadOnly, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDeleteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
        void lock$iv;
        Intrinsics.checkParameterIsNotNull((Object)volumeFactory, (String)"volumeFactory");
        super(file, volumeFactory, isThreadSafe, concShift, fileDeleteAfterClose, checksum, checksumHeader, checksumHeaderBypass);
        this.isReadOnly = isReadOnly;
        this.freeSize = new AtomicLong(-1L);
        Object object = ((Function0)new Function0<Volume>(this, volumeFactory, file, fileLockWait, allocateIncrement, allocateStartSize){
            final /* synthetic */ StoreDirect this$0;
            final /* synthetic */ VolumeFactory $volumeFactory;
            final /* synthetic */ String $file;
            final /* synthetic */ long $fileLockWait;
            final /* synthetic */ long $allocateIncrement;
            final /* synthetic */ long $allocateStartSize;

            public final Volume invoke() {
                Volume volume2 = this.$volumeFactory.makeVolume(this.$file, this.this$0.isReadOnly(), this.$fileLockWait, Math.max(20, DataIO.shift((int)this.$allocateIncrement)), DataIO.roundUp(this.$allocateStartSize, 0x100000L), false);
                Intrinsics.checkExpressionValueIsNotNull((Object)volume2, (String)"volumeFactory.makeVolume\u2026          false\n        )");
                return volume2;
            }
            {
                this.this$0 = storeDirect;
                this.$volumeFactory = volumeFactory;
                this.$file = string;
                this.$fileLockWait = l;
                this.$allocateIncrement = l2;
                this.$allocateStartSize = l3;
                super(0);
            }
        }).invoke();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"{\n        volumeFactory.\u2026  false\n        )\n    }()");
        this.volume = (Volume)object;
        this.headVol = this.getVolume();
        Utils utils = Utils.INSTANCE;
        Lock lock = this.getStructuralLock();
        void v1 = lock$iv;
        if (v1 != null) {
            v1.lock();
        }
        try {
            if (!this.getVolumeExistsAtStart()) {
                this.getVolume().ensureAvailable(0x100000L);
                this.getVolume().putLong(0L, this.fileHeaderCompose());
                this.getVolume().putLong(8L, 1L);
                this.setDataTail(0L);
                this.setMaxRecid(0L);
                this.setFileTail$mapdb(0x100000L);
                this.getVolume().putInt(16L, this.storeHeaderCompose());
                LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)64L, (long)32864L)), (long)8L);
                long l = longProgression.getFirst();
                long l2 = longProgression.getLast();
                long l3 = longProgression.getStep();
                long l4 = l;
                long l5 = l2;
                if (l3 > 0L ? l4 <= l5 : l4 >= l5) {
                    while (true) {
                        void offset;
                        this.getVolume().putLong((long)offset, DataIO.parity4Set(0L));
                        if (offset == l2) break;
                        offset += l3;
                    }
                }
                this.getVolume().putLong(32864L, DataIO.parity16Set(0L));
                this.commit();
            } else {
                if (this.getVolume().length() <= (long)0) {
                    throw (Throwable)new DBException.DataCorruption("File is empty");
                }
                this.fileHeaderCheck();
                MutableLongList mutableLongList = this.getIndexPages();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableLongList, (String)"indexPages");
                this.loadIndexPages(mutableLongList);
            }
            if (file != null && fileDeleteAfterOpen) {
                new File(file).delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            void v6 = lock$iv;
            if (v6 != null) {
                v6.unlock();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u008a\u0001\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lorg/mapdb/StoreDirect$Companion;", "", "()V", "make", "Lorg/mapdb/StoreDirect;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "fileLockWait", "", "isReadOnly", "", "isThreadSafe", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDeleteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "mapdb"})
    public static final class Companion {
        @NotNull
        public final StoreDirect make(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isReadOnly, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDeleteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
            Intrinsics.checkParameterIsNotNull((Object)volumeFactory, (String)"volumeFactory");
            boolean bl = checksumHeaderBypass;
            boolean bl2 = checksumHeader;
            boolean bl3 = checksum;
            boolean bl4 = fileDeleteAfterOpen;
            boolean bl5 = fileDeleteAfterClose;
            long l = allocateStartSize;
            long l2 = allocateIncrement;
            int n = concShift;
            boolean bl6 = isThreadSafe;
            boolean bl7 = isReadOnly;
            long l3 = fileLockWait;
            return new StoreDirect(file, volumeFactory, bl7, l3, bl6, n, l2, l, bl5, bl4, bl3, bl2, bl);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ StoreDirect make$default(Companion companion, String string, VolumeFactory volumeFactory, long l, boolean bl, boolean bl2, int n, long l2, long l3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: make");
            }
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                VolumeFactory volumeFactory2;
                if (string == null) {
                    VolumeFactory volumeFactory3 = CC.DEFAULT_MEMORY_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)volumeFactory3, (String)"CC.DEFAULT_MEMORY_VOLUME_FACTORY");
                } else {
                    VolumeFactory volumeFactory4 = CC.DEFAULT_FILE_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)volumeFactory4, (String)"CC.DEFAULT_FILE_VOLUME_FACTORY");
                }
                volumeFactory = volumeFactory2;
            }
            if ((n2 & 4) != 0) {
                l = 0L;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x20) != 0) {
                n = 3;
            }
            if ((n2 & 0x40) != 0) {
                l2 = 0x100000L;
            }
            if ((n2 & 0x80) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x100) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x200) != 0) {
                bl4 = false;
            }
            if ((n2 & 0x400) != 0) {
                bl5 = false;
            }
            if ((n2 & 0x800) != 0) {
                bl6 = true;
            }
            if ((n2 & 0x1000) != 0) {
                bl7 = false;
            }
            return companion.make(string, volumeFactory, l, bl, bl2, n, l2, l3, bl3, bl4, bl5, bl6, bl7);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

