/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.server.netty.cio.NettyRequestQueue;
import io.ktor.server.netty.http1.NettyHttp1Handler;
import io.ktor.server.netty.http2.NettyHttp2Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.nio.channels.ClosedChannelException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@EngineAPI
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"Bc\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "connector", "Lio/ktor/server/engine/EngineConnectorConfig;", "requestQueueLimit", "", "runningLimit", "responseWriteTimeout", "requestReadTimeout", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lio/ktor/server/engine/EngineConnectorConfig;IIIILkotlin/jvm/functions/Function0;)V", "sslContext", "Lio/netty/handler/ssl/SslContext;", "configurePipeline", "", "pipeline", "Lio/netty/channel/ChannelPipeline;", "protocol", "", "initChannel", "ch", "Companion", "NegotiatedPipelineInitializer", "ktor-server-netty"})
public final class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnginePipeline enginePipeline;
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EventExecutorGroup callEventGroup;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    @NotNull
    private final EngineConnectorConfig connector;
    private final int requestQueueLimit;
    private final int runningLimit;
    private final int responseWriteTimeout;
    private final int requestReadTimeout;
    @NotNull
    private final Function0<HttpServerCodec> httpServerCodec;
    @Nullable
    private SslContext sslContext;
    @NotNull
    private static final Lazy<SslProvider> alpnProvider$delegate = LazyKt.lazy((Function0)Companion.alpnProvider.2.INSTANCE);

    /*
     * WARNING - void declaration
     */
    public NettyChannelInitializer(@NotNull EnginePipeline enginePipeline, @NotNull ApplicationEngineEnvironment environment, @NotNull EventExecutorGroup callEventGroup2, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext, @NotNull EngineConnectorConfig connector, int requestQueueLimit, int runningLimit, int responseWriteTimeout, int requestReadTimeout, @NotNull Function0<HttpServerCodec> httpServerCodec2) {
        Intrinsics.checkNotNullParameter((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)callEventGroup2, (String)"callEventGroup");
        Intrinsics.checkNotNullParameter((Object)engineContext, (String)"engineContext");
        Intrinsics.checkNotNullParameter((Object)userContext, (String)"userContext");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(httpServerCodec2, (String)"httpServerCodec");
        this.enginePipeline = enginePipeline;
        this.environment = environment;
        this.callEventGroup = callEventGroup2;
        this.engineContext = engineContext;
        this.userContext = userContext;
        this.connector = connector;
        this.requestQueueLimit = requestQueueLimit;
        this.runningLimit = runningLimit;
        this.responseWriteTimeout = responseWriteTimeout;
        this.requestReadTimeout = requestReadTimeout;
        this.httpServerCodec = httpServerCodec2;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            SslContextBuilder sslContextBuilder;
            Certificate[] certificateArray = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getCertificateChain(((EngineSSLConnectorConfig)this.connector).getKeyAlias());
            Intrinsics.checkNotNullExpressionValue((Object)certificateArray, (String)"connector.keyStore.getCe\u2026Chain(connector.keyAlias)");
            List chain1 = ArraysKt.toList((Object[])certificateArray);
            Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)chain1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
            if (x509CertificateArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            X509Certificate[] certs = x509CertificateArray;
            char[] password = (char[])((EngineSSLConnectorConfig)this.connector).getPrivateKeyPassword().invoke();
            Key key = ((EngineSSLConnectorConfig)this.connector).getKeyStore().getKey(((EngineSSLConnectorConfig)this.connector).getKeyAlias(), password);
            if (key == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.PrivateKey");
            }
            PrivateKey pk = (PrivateKey)key;
            ArraysKt.fill$default((char[])password, (char)'\u0000', (int)0, (int)0, (int)6, null);
            SslContextBuilder sslContextBuilder2 = sslContextBuilder = SslContextBuilder.forServer((PrivateKey)pk, (X509Certificate[])Arrays.copyOf(certs, certs.length));
            NettyChannelInitializer nettyChannelInitializer = this;
            boolean bl = false;
            if (Companion.getAlpnProvider$ktor_server_netty() != null) {
                void $this$_init__u24lambda_u2d0;
                $this$_init__u24lambda_u2d0.sslProvider(Companion.getAlpnProvider$ktor_server_netty());
                $this$_init__u24lambda_u2d0.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                String[] stringArray = new String[]{"h2", "http/1.1"};
                $this$_init__u24lambda_u2d0.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, stringArray));
            }
            nettyChannelInitializer.sslContext = sslContextBuilder.build();
        }
    }

    protected void initChannel(@NotNull SocketChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        ChannelPipeline $this$initChannel_u24lambda_u2d1 = ch.pipeline();
        boolean bl = false;
        if (this.connector instanceof EngineSSLConnectorConfig) {
            SslContext sslContext = this.sslContext;
            Intrinsics.checkNotNull((Object)sslContext);
            $this$initChannel_u24lambda_u2d1.addLast("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc()));
            if (Companion.getAlpnProvider$ktor_server_netty() != null) {
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{(ChannelHandler)new NegotiatedPipelineInitializer()};
                $this$initChannel_u24lambda_u2d1.addLast(channelHandlerArray);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)$this$initChannel_u24lambda_u2d1, (String)"this");
                this.configurePipeline($this$initChannel_u24lambda_u2d1, "http/1.1");
            }
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)$this$initChannel_u24lambda_u2d1, (String)"this");
            this.configurePipeline($this$initChannel_u24lambda_u2d1, "http/1.1");
        }
    }

    private final void configurePipeline(ChannelPipeline pipeline, String protocol) {
        String string = protocol;
        if (Intrinsics.areEqual((Object)string, (Object)"h2")) {
            NettyHttp2Handler handler = new NettyHttp2Handler(this.enginePipeline, this.environment.getApplication(), this.callEventGroup, this.userContext);
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{(ChannelHandler)Http2MultiplexCodecBuilder.forServer((ChannelHandler)((ChannelHandler)handler)).build()};
            pipeline.addLast(channelHandlerArray);
            pipeline.channel().closeFuture().addListener(arg_0 -> NettyChannelInitializer.configurePipeline$lambda-2(handler, arg_0));
        } else if (Intrinsics.areEqual((Object)string, (Object)"http/1.1")) {
            NettyRequestQueue requestQueue = new NettyRequestQueue(this.requestQueueLimit, this.runningLimit);
            NettyHttp1Handler handler = new NettyHttp1Handler(this.enginePipeline, this.environment, this.callEventGroup, this.engineContext, this.userContext, requestQueue);
            ChannelPipeline $this$configurePipeline_u24lambda_u2d3 = pipeline;
            boolean bl = false;
            if (this.requestReadTimeout > 0) {
                $this$configurePipeline_u24lambda_u2d3.addLast("readTimeout", (ChannelHandler)new ReadTimeoutHandler(this.requestReadTimeout));
            }
            $this$configurePipeline_u24lambda_u2d3.addLast("codec", (ChannelHandler)this.httpServerCodec.invoke());
            $this$configurePipeline_u24lambda_u2d3.addLast("continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            $this$configurePipeline_u24lambda_u2d3.addLast("timeout", (ChannelHandler)new WriteTimeoutHandler(this.responseWriteTimeout));
            $this$configurePipeline_u24lambda_u2d3.addLast("http1", (ChannelHandler)handler);
            pipeline.context("codec").fireChannelActive();
        } else {
            this.environment.getLog().error(Intrinsics.stringPlus((String)"Unsupported protocol ", (Object)protocol));
            pipeline.close();
        }
    }

    private static final void configurePipeline$lambda-2(NettyHttp2Handler $handler, Future it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$handler), (String)"$handler");
        CoroutineScopeKt.cancel$default((CoroutineScope)$handler, null, (int)1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$NegotiatedPipelineInitializer;", "Lio/netty/handler/ssl/ApplicationProtocolNegotiationHandler;", "(Lio/ktor/server/netty/NettyChannelInitializer;)V", "configurePipeline", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "protocol", "", "handshakeFailure", "cause", "", "ktor-server-netty"})
    private final class NegotiatedPipelineInitializer
    extends ApplicationProtocolNegotiationHandler {
        public NegotiatedPipelineInitializer() {
            Intrinsics.checkNotNullParameter((Object)((Object)NettyChannelInitializer.this), (String)"this$0");
            super("http/1.1");
        }

        protected void configurePipeline(@NotNull ChannelHandlerContext ctx, @NotNull String protocol) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            ChannelPipeline channelPipeline = ctx.pipeline();
            Intrinsics.checkNotNullExpressionValue((Object)channelPipeline, (String)"ctx.pipeline()");
            NettyChannelInitializer.this.configurePipeline(channelPipeline, protocol);
        }

        protected void handshakeFailure(@NotNull ChannelHandlerContext ctx, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (cause instanceof ClosedChannelException) {
                ctx.close();
            } else {
                super.handshakeFailure(ctx, cause);
            }
        }
    }

    @EngineAPI
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/ktor/server/netty/NettyChannelInitializer$Companion;", "", "()V", "alpnProvider", "Lio/netty/handler/ssl/SslProvider;", "getAlpnProvider$ktor_server_netty", "()Lio/netty/handler/ssl/SslProvider;", "alpnProvider$delegate", "Lkotlin/Lazy;", "findAlpnProvider", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SslProvider getAlpnProvider$ktor_server_netty() {
            Lazy lazy = alpnProvider$delegate;
            return (SslProvider)lazy.getValue();
        }

        private final SslProvider findAlpnProvider() {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return SslProvider.JDK;
            }
            catch (Throwable throwable) {
                try {
                    if (OpenSsl.isAlpnSupported()) {
                        return SslProvider.OPENSSL;
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ SslProvider access$findAlpnProvider(Companion $this) {
            return $this.findAlpnProvider();
        }
    }
}

