/*
 * Decompiled with CFR 0.152.
 */
package jcuda.runtime;

import java.util.Arrays;
import jcuda.runtime.cudaComputeMode;

public class cudaDeviceProp {
    public byte[] name = new byte[256];
    public long totalGlobalMem;
    public long sharedMemPerBlock;
    public int regsPerBlock;
    public int warpSize;
    public long memPitch;
    public int maxThreadsPerBlock;
    public int[] maxThreadsDim = new int[3];
    public int[] maxGridSize = new int[3];
    public int clockRate;
    public long totalConstMem;
    public int major;
    public int minor;
    public long textureAlignment;
    public long texturePitchAlignment;
    public int deviceOverlap;
    public int multiProcessorCount;
    public int kernelExecTimeoutEnabled;
    public int integrated;
    public int canMapHostMemory;
    public int computeMode;
    public int maxTexture1D;
    public int maxTexture1DMipmap;
    public int maxTexture1DLinear;
    public int[] maxTexture2D = new int[2];
    public int[] maxTexture2DMipmap = new int[2];
    public int[] maxTexture2DLinear = new int[3];
    public int[] maxTexture2DGather = new int[2];
    public int[] maxTexture3D = new int[3];
    public int[] maxTexture3DAlt = new int[3];
    public int maxTextureCubemap;
    public int[] maxTexture1DLayered = new int[2];
    public int[] maxTexture2DLayered = new int[3];
    public int[] maxTextureCubemapLayered = new int[2];
    public int maxSurface1D;
    public int[] maxSurface2D = new int[2];
    public int[] maxSurface3D = new int[3];
    public int[] maxSurface1DLayered = new int[2];
    public int[] maxSurface2DLayered = new int[3];
    public int maxSurfaceCubemap;
    public int[] maxSurfaceCubemapLayered = new int[2];
    public long surfaceAlignment;
    public int concurrentKernels;
    public int ECCEnabled;
    public int pciBusID;
    public int pciDeviceID;
    public int pciDomainID;
    public int tccDriver;
    public int asyncEngineCount;
    public int unifiedAddressing;
    public int memoryClockRate;
    public int memoryBusWidth;
    public int l2CacheSize;
    public int maxThreadsPerMultiProcessor;
    public int streamPrioritiesSupported;
    public int globalL1CacheSupported;
    public int localL1CacheSupported;
    public long sharedMemPerMultiprocessor;
    public int regsPerMultiprocessor;
    public int managedMemory;
    public int isMultiGpuBoard;
    public int multiGpuBoardGroupID;
    public int hostNativeAtomicSupported;
    public int singleToDoublePrecisionPerfRatio;
    public int pageableMemoryAccess;
    public int concurrentManagedAccess;

    public String getName() {
        return cudaDeviceProp.createString(this.name);
    }

    public void setName(String nameString) {
        byte[] bytes = nameString.getBytes();
        int n = Math.min(this.name.length, bytes.length);
        System.arraycopy(bytes, 0, this.name, 0, n);
    }

    public String toString() {
        return "cudaDeviceProp[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "Device properties:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        return "name=" + cudaDeviceProp.createString(this.name) + f + "totalGlobalMem=" + this.totalGlobalMem + f + "sharedMemPerBlock=" + this.sharedMemPerBlock + f + "regsPerBlock=" + this.regsPerBlock + f + "warpSize=" + this.warpSize + f + "memPitch=" + this.memPitch + f + "maxThreadsPerBlock=" + this.maxThreadsPerBlock + f + "maxThreadsDim=" + Arrays.toString(this.maxThreadsDim) + f + "maxGridSize=" + Arrays.toString(this.maxGridSize) + f + "clockRate=" + this.clockRate + f + "totalConstMem=" + this.totalConstMem + f + "major=" + this.major + f + "minor=" + this.minor + f + "textureAlignment=" + this.textureAlignment + f + "texturePitchAlignment=" + this.texturePitchAlignment + f + "deviceOverlap=" + this.deviceOverlap + f + "multiProcessorCount=" + this.multiProcessorCount + f + "kernelExecTimeoutEnabled=" + this.kernelExecTimeoutEnabled + f + "integrated=" + this.integrated + f + "canMapHostMemory=" + this.canMapHostMemory + f + "computeMode=" + cudaComputeMode.stringFor(this.computeMode) + f + "maxTexture1D=" + this.maxTexture1D + f + "maxTexture1DMipmap=" + this.maxTexture1DMipmap + f + "maxTexture1DLinear=" + this.maxTexture1DLinear + f + "maxTexture2D=" + Arrays.toString(this.maxTexture2D) + f + "maxTexture2DMipmap=" + Arrays.toString(this.maxTexture2DMipmap) + f + "maxTexture2DLinear=" + Arrays.toString(this.maxTexture2DLinear) + f + "maxTexture2DGather=" + Arrays.toString(this.maxTexture2DGather) + f + "maxTexture3D=" + Arrays.toString(this.maxTexture3D) + f + "maxTexture3DAlt=" + Arrays.toString(this.maxTexture3DAlt) + f + "maxTextureCubemap=" + this.maxTextureCubemap + f + "maxTexture1DLayered=" + Arrays.toString(this.maxTexture1DLayered) + f + "maxTexture2DLayered=" + Arrays.toString(this.maxTexture2DLayered) + f + "maxTextureCubemapLayered=" + Arrays.toString(this.maxTextureCubemapLayered) + f + "maxSurface1D=" + this.maxSurface1D + f + "maxSurface2D=" + Arrays.toString(this.maxSurface2D) + f + "maxSurface3D=" + Arrays.toString(this.maxSurface3D) + f + "maxSurface1DLayered=" + Arrays.toString(this.maxSurface1DLayered) + f + "maxSurface2DLayered=" + Arrays.toString(this.maxSurface2DLayered) + f + "maxSurfaceCubemap=" + this.maxSurfaceCubemap + f + "maxSurfaceCubemapLayered=" + Arrays.toString(this.maxSurfaceCubemapLayered) + f + "surfaceAlignment=" + this.surfaceAlignment + f + "concurrentKernels=" + this.concurrentKernels + f + "ECCEnabled=" + this.ECCEnabled + f + "pciBusID=" + this.pciBusID + f + "pciDeviceID=" + this.pciDeviceID + f + "pciDomainID=" + this.pciDomainID + f + "tccDriver=" + this.tccDriver + f + "asyncEngineCount=" + this.asyncEngineCount + f + "unifiedAddressing=" + this.unifiedAddressing + f + "memoryClockRate=" + this.memoryClockRate + f + "memoryBusWidth=" + this.memoryBusWidth + f + "l2CacheSize=" + this.l2CacheSize + f + "maxThreadsPerMultiProcessor=" + this.maxThreadsPerMultiProcessor + f + "streamPrioritiesSupported=" + this.streamPrioritiesSupported + f + "globalL1CacheSupported=" + this.globalL1CacheSupported + f + "localL1CacheSupported=" + this.localL1CacheSupported + f + "sharedMemPerMultiprocessor=" + this.sharedMemPerMultiprocessor + f + "regsPerMultiprocessor=" + this.regsPerMultiprocessor + f + "managedMemory=" + this.managedMemory + f + "isMultiGpuBoard=" + this.isMultiGpuBoard + f + "multiGpuBoardGroupID=" + this.multiGpuBoardGroupID + f + "hostNativeAtomicSupported=" + this.hostNativeAtomicSupported + f + "singleToDoublePrecisionPerfRatio=" + this.singleToDoublePrecisionPerfRatio + f + "pageableMemoryAccess=" + this.pageableMemoryAccess + f + "concurrentManagedAccess=" + this.concurrentManagedAccess + f;
    }

    private static String createString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            if (!Character.isLetterOrDigit(b) && !Character.isWhitespace(b)) continue;
            sb.append((char)b);
        }
        return sb.toString();
    }
}

