package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	Hdist.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  JMZ		 Jianyang (Michael) Zeng	       Duke University			zengjy@cs.duke.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////


/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */


import java.io. *;
import java.util. *;


// TODO: Auto-generated Javadoc

/**  
 *   This class provides data structures related to back-computed NOE distance restraints. 
*     Written by  Jianyang (Michael) Zeng (2005-2009).
*/
public class Hdist 
{
	
	/** The first h atom. */
	private Cartesian firstHAtom; //Cartesian of the first proton (from rotamer)
	
	/** The first res no. */
	private int firstResNo;//residue No of the rotamer
	
	/** The first atom name. */
	private String firstAtomName;
	
	/** The first res name. */
	private String firstResName;
	
	/** The second h atom. */
	private Cartesian secondHAtom; //Cartesian of the second proton (from backbone, 
									//including HA, HN, HB
	/** The second res no. */
									private int secondResNo;//residue No of the backbone proton (HA/HN/HB)
	
	/** The second atom name. */
	private String secondAtomName;
	
	/** The second res name. */
	private String secondResName;
	
	/** The distance. */
	private double distance; //distance between two protons
	
	/**
	 * Instantiates a new hdist.
	 */
	public Hdist(){}

    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     */
    public Hdist(Cartesian firstH)
    {
    	firstHAtom = firstH;	
    }
    
    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     * @param firstNo the first no
     */
    public Hdist(Cartesian firstH, int firstNo)
    {
    	firstHAtom = firstH;	
    	firstResNo=firstNo;
    }
    
    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     * @param firstNo the first no
     * @param secondH the second h
     * @param secondNo the second no
     */
    public Hdist(Cartesian firstH, int firstNo,Cartesian secondH, int secondNo )
    {
    	firstHAtom = firstH;	
    	firstResNo=firstNo;
    	secondHAtom=secondH;
    	secondResNo=secondNo;   	
    }
    
    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     * @param firstNo the first no
     * @param atom1 the atom1
     * @param secondH the second h
     * @param secondNo the second no
     * @param atom2 the atom2
     * @param dis the dis
     */
    public Hdist(Cartesian firstH, int firstNo,String atom1, Cartesian secondH, int secondNo,String atom2,double dis)
    {
    	firstHAtom = firstH;	
    	firstResNo=firstNo;
    	secondHAtom=secondH;
    	secondResNo=secondNo;   	
    	firstAtomName=atom1;
    	secondAtomName=atom2;
    	distance=dis;
    }
    
    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     * @param firstNo the first no
     * @param res1 the res1
     * @param atom1 the atom1
     * @param secondH the second h
     * @param secondNo the second no
     * @param res2 the res2
     * @param atom2 the atom2
     * @param dis the dis
     */
    public Hdist(Cartesian firstH, int firstNo, String res1, String atom1, Cartesian secondH, int secondNo,String res2, String atom2,double dis)
    {
    	firstHAtom = firstH;	
    	firstResNo=firstNo;
    	firstResName=res1;
    	secondHAtom=secondH;
    	secondResNo=secondNo;   	
    	firstAtomName=atom1;
    	secondAtomName=atom2;
    	secondResName=res2;
    	distance=dis;
    }
    
    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     * @param firstNo the first no
     * @param secondH the second h
     * @param secondNo the second no
     * @param dis the dis
     */
    public Hdist(Cartesian firstH, int firstNo,Cartesian secondH, int secondNo, double dis )
    {
    	firstHAtom = firstH;	
    	firstResNo=firstNo;
    	secondHAtom=secondH;
    	secondResNo=secondNo;   
    	distance=dis;
    }
    
    /**
     * Instantiates a new hdist.
     * 
     * @param firstH the first h
     * @param secondH the second h
     * @param dis the dis
     */
    public Hdist(Cartesian firstH, Cartesian secondH,  double dis )
    {
    	firstHAtom = firstH;	    	
    	secondHAtom=secondH;    	
    	distance=dis;
    }
    
    /**
     * Gets the first cart.
     * 
     * @return the first cart
     */
    public Cartesian getFirstCart()
    {
    	return firstHAtom;
    }

    /**
     * Gets the first res no.
     * 
     * @return the first res no
     */
    public int getFirstResNo()
    {
    	return firstResNo;
    }
    
    /**
     * Gets the second cart.
     * 
     * @return the second cart
     */
    public Cartesian getSecondCart()
    {
    	return secondHAtom;
    }
    
    /**
     * Gets the second res no.
     * 
     * @return the second res no
     */
    public int getSecondResNo()
    {
    	return secondResNo;
    }
    
    /**
     * Gets the first atom name.
     * 
     * @return the first atom name
     */
    public String getFirstAtomName()
    {
    	return firstAtomName;
    }
    
    /**
     * Gets the second atom name.
     * 
     * @return the second atom name
     */
    public String getSecondAtomName()
    {
    	return secondAtomName;
    }

    /**
     * Gets the distance.
     * 
     * @return the distance
     */
    public double getDistance()
    {
    	return distance;
    }
    
    /**
     * Gets the first res name.
     * 
     * @return the first res name
     */
    public String getFirstResName()
    {
    	return firstResName;
    }
    
    /**
     * Gets the second res name.
     * 
     * @return the second res name
     */
    public String getSecondResName()
    {
    	return secondResName;
    }
}
