package rdcPanda;

/*
 * 
 */

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;


import java.io. *;
import java.util. *;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.lang. *;

//import Pdb.PdbComparator;

//import Nasca.Node;


import Jampack.JampackException;



//the class for implementing the GOAL algorithm:
public class Goal 
{
	
	//extended class of Pdb, for storing the ensemble of pdbs in the tree structure
	public class TreePdb 
	{
		public int id=-1;
		public Pdb pdb=new Pdb();//for storing pdb
		public Vector parenPdb=new Vector();//parent pdb (i.e., previous residue)
		public Vector vecChildPdb=new Vector();//for storing children (i.e., next residue)
		public double nhRdcDif=-99999.9;
		public double chRdcDif=-99999.9;
		public double sumRdcDif=-99999.9;//sum of rdc dif from root to current node
		
		public double ramaScore=0.0;
		public double endDist=9999.9;
		public double noeScore=0.0;
		
		public TreePdb(TreePdb old)
		{
			Pdb pp=old.pdb;
			pdb=new Pdb(pp.getResidueNo(),pp.getResidue(),pp.getAtomVec() );
			parenPdb=new Vector();
			parenPdb.addAll(old.parenPdb);
			vecChildPdb=new Vector();
			vecChildPdb.addAll(old.vecChildPdb);
			nhRdcDif=-99999.9;chRdcDif=-99999.9;
			ramaScore=0.0;endDist=9999.9;id=-1;
		};
		
		public TreePdb()
		{
			pdb=new Pdb();
			parenPdb=new Vector();
			vecChildPdb=new Vector();
			nhRdcDif=-99999.9;chRdcDif=-99999.9;
			ramaScore=0.0;endDist=9999.9;id=-1;
		};
		public TreePdb(int No,  String res, Vector aa)
		{
			pdb=new Pdb(No,res,aa);
			parenPdb=new Vector();
			vecChildPdb=new Vector();
			nhRdcDif=-99999.9;chRdcDif=-99999.9;
			ramaScore=0.0;endDist=9999.9;id=-1;
		}
		public TreePdb(Pdb pp)
		{
			pdb=pp;
			parenPdb=new Vector();
			vecChildPdb=new Vector();
			nhRdcDif=-99999.9;chRdcDif=-99999.9;
			ramaScore=0.0;endDist=9999.9;id=-1;
		}
		public TreePdb(int No,  String res, Vector aa,Vector pare,TreePdb child)
		{
			pdb=new Pdb(No,res,aa);
			parenPdb.addAll(pare);
			vecChildPdb.add(child);
			nhRdcDif=-99999.9;chRdcDif=-99999.9;
			ramaScore=0.0;endDist=9999.9;id=-1;
		}
		public TreePdb(Pdb pp,Vector pare,TreePdb child)
		{
			pdb=pp;
			parenPdb.addAll(pare);
			vecChildPdb.add(child);
			nhRdcDif=-99999.9;chRdcDif=-99999.9;
			ramaScore=0.0;endDist=9999.9;id=-1;
		}
		
		public void SetParenPdb(TreePdb pare)
		{
			parenPdb.add(pare);
		}
		public void SetPdb(Pdb pp)
		{
			pdb=pp;			
		}
		public void SetID(int ident)
		{
			id=ident;			
		}
		public void AddChildPdb(TreePdb child)
		{
			vecChildPdb.add(child);
		}
		public void SetNhRdcDif(double rdc)
		{
			nhRdcDif=rdc;
		}
		public void SetChRdcDif(double rdc)
		{
			chRdcDif=rdc;
		}
		public void SetSumRdcDif(double rdc)
		{
			sumRdcDif=rdc;
		}
		public void SetRamaScore(double sc)
		{
			ramaScore=sc;
		}
		public void SetEndDist(double dist)
		{
			endDist=dist;
		}
		public double GetNhRdcDif()
		{
			return nhRdcDif;
		}
		public double GetChRdcDif()
		{
			return chRdcDif;
		}
		public double GetSumRdcDif()
		{
			return sumRdcDif;
		}
		public double GetRamaScore()
		{
			return ramaScore;
		}
		public double GetEndDist()
		{
			return endDist;
		}
		public int GetID()
		{
			return id;
		}
		
	
	}//end of definition of TreePdb.
	
	//global variables for computing the loops:
	public Vector<Assign> vecSeq=new Vector<Assign>();//for storing sequence information
	public Vector<Pdb> vecPdbSSE=new Vector<Pdb>(); //for storing the SSE PDB
	//public Vector<Pdb> vecPdbSSEOrig=new Vector<Pdb>(); //for storing the original SSE PDB
	
	public String rotSrc="";//for storing the path of rotamer library
	public Vector<Assign> vecAsg=new Vector<Assign>(); //for storing the resonance assingment list
	public Vector<Noesy> vecNOESY=new Vector<Noesy>();//for storing the NOESY peak list
	
	public double caliConstant=0.0; //constant for NOE distance calibration
	public Vector<Noe> vecAmbNOEs=new Vector<Noe>(); //all ambiguous NOE assignments based on only chemical shift
	public double Syy=0.0;//alignment tensor, in our calculation format
	public double Szz=0.0;//alignment tensor, in our calculation format
	
	//whether the backbone is computed backfwardly or forwardly. 
	//1 if using the forward computation, 0 otherwise. 
	public boolean isForward=false;//	
	public boolean isAllGridSearch=false;//whether use the grid search for all residues
	
	public double gapThreshold=0.0;//The gap threshold between end residues for outputting the ensemble of solutions.
	public double rdcThreshold=0.0;//The rdc deviation threshold 
	
	public Vector<Dipolar> vecNhRDC=new Vector<Dipolar>();//for storing nh RDC data;
	public Vector<Dipolar> vecChRDC=new Vector<Dipolar>();//for storing ch RDC data;
	
	//for storing Ramachandran database information
	public Vector vecRamaAla=new Vector();
	public Vector vecRamaGeneral=new Vector();
	public Vector vecRamaPrePro=new Vector();
	public Vector vecRamaPro=new Vector();
	public Vector vecRamaGly=new Vector();
	
	//max number of leaf nodes at each leavel of the conformation tree.
	public int maxLeafNodes=0;
	public Goal(){ };
	
	//A comparator for sorting the tree PDB object based on rama score:
	//note: the rama score is the -log of the probablity, so the 
	//ranking is from the small values to the large values
    public static class TreePdbRamaComparator implements Comparator
    {
    	public int compare(Object o1, Object o2)
    	{
		    TreePdb n1 = (TreePdb)o1;
		    TreePdb n2 = (TreePdb)o2;
		    double d1 = n1.GetRamaScore();
		    double d2 = n2.GetRamaScore();
		    if (d1 < d2)
			return -1;
		    else if (d1 > d2)
			return 1;
		    else return 0;
    	}
    } 
	//A comparator for sorting the tree PDB object based on noe score:	
    public static class TreePdbNOEComparator implements Comparator
    {
    	public int compare(Object o1, Object o2)
    	{
		    TreePdb n1 = (TreePdb)o1;
		    TreePdb n2 = (TreePdb)o2;
		    double d1 = n1.noeScore;
		    double d2 = n2.noeScore;
		    if (d1>  d2)
			return -1;
		    else if (d1 < d2)
			return 1;
		    else return 0;
    	}
    } 
	//A comparator for sorting the tree PDB object based on ID:	
    public static class TreePdbIDComparator implements Comparator
    {
    	public int compare(Object o1, Object o2)
    	{
		    TreePdb n1 = (TreePdb)o1;
		    TreePdb n2 = (TreePdb)o2;
		    int d1 = n1.GetID();
		    int d2 = n2.GetID();
		    if (d1 < d2)
			return -1;
		    else if (d1 > d2)
			return 1;
		    else return 0;
    	}
    } 
    
    //A comparator for sorting the tree PDB object based on sum RDC rmsd (sum of ch and nh rdcs):	
    public static class TreePdbSumRDCComparator implements Comparator
    {
    	public int compare(Object o1, Object o2)
    	{
		    TreePdb n1 = (TreePdb)o1;
		    TreePdb n2 = (TreePdb)o2;
		    double d1 = n1.GetSumRdcDif();
		    double d2 = n2.GetSumRdcDif();
		    if (d1 < d2)
			return -1;
		    else if (d1 > d2)
			return 1;
		    else return 0;
    	}
    } 
    //A comparator for sorting the tree PDB object based on overall score:	
    public static class TreePdbAllComparator implements Comparator
    {
    	public int compare(Object o1, Object o2)
    	{
		    TreePdb n1 = (TreePdb)o1;
		    TreePdb n2 = (TreePdb)o2;
		    double d1 = n1.GetChRdcDif()+n1.GetNhRdcDif()+n1.GetRamaScore();
		    double d2 = n2.GetChRdcDif()+n2.GetNhRdcDif()+n2.GetRamaScore();
		    if (d1 < d2)
			return -1;
		    else if (d1 > d2)
			return 1;
		    else return 0;
    	}
    } 
    //A comparator for sorting the tree PDB object based on current RDC rmsd (sum of ch and nh rdcs):	
    public static class TreePdbRDCComparator implements Comparator
    {
    	public int compare(Object o1, Object o2)
    	{
		    TreePdb n1 = (TreePdb)o1;
		    TreePdb n2 = (TreePdb)o2;
		    double d1 = n1.GetChRdcDif()+n1.GetNhRdcDif();
		    double d2 = n2.GetChRdcDif()+n2.GetNhRdcDif();
		    if (d1 < d2)
			return -1;
		    else if (d1 > d2)
			return 1;
		    else return 0;
    	}
    } 
    
	/**
     * find the SSE anchors (ca atoms) that can possibly interact with loops
     *  
     @param topK the top number of ca atoms based on the number of ambiguous NOE assignments.
     @param resNoLoop the index of the loop residue    
     @return a vector of SSE PDB anchors.    
     */
	public Vector<Pdb> SearchSSEAnchors(int topK,int resNoLoop)
	{
		//get the maximum residue index
		Assign asgMaxNo=(Assign)this.vecSeq.elementAt(this.vecSeq.size()-1);//here pdbs are sorted based on res number.		
		int maxResNo=asgMaxNo.getResidueNo();
		int[] numNOEs=new int[maxResNo+1];
		for(int i=0;i<numNOEs.length;i++)
			numNOEs[i]=0;//initialization
		
		for(int i=0;i<this.vecAmbNOEs.size();i++)
		{
			Noe noe=(Noe)this.vecAmbNOEs.elementAt(i);
			int resNoA=noe.getResidueNoA();
			int resNoB=noe.getResidueNoB();			
			if(resNoA==resNoLoop)			
				numNOEs[resNoB]++;			
			if(resNoB==resNoLoop)
				numNOEs[resNoA]++;				
		}//for(int i=0;i<this.vecAmbNOEs.size();i++)
		
		Vector<RotaPattern> vecRotTemp=new Vector<RotaPattern>();
		for(int i=0;i<this.vecPdbSSE.size();i++)
		{
			Pdb pp=(Pdb)this.vecPdbSSE.elementAt(i);
			int resNo=pp.getResidueNo();
			vecRotTemp.add(new RotaPattern(pp,numNOEs[resNo] ) );			
		}//for(int i=0;i<this.vecPdbSSE.size();i++)
		Collections.sort(vecRotTemp, new RotaPattern.scoreComparator());
		
		Vector<Pdb> vecSSEsAnchors=new Vector<Pdb>();
		for (int i=0;i<Math.min(topK,vecRotTemp.size());i++)
		{
			RotaPattern rotPatn=(RotaPattern)vecRotTemp.elementAt(i);
			vecSSEsAnchors.add(rotPatn.getPdb());
		}
		return vecSSEsAnchors; 
	}

	/**
     * find the top set of SSE anchors (ca atoms) that can possibly interact with loops
     *  
     @param topK the top number of ca atoms based on the number of ambiguous NOE assignments.
     @param resNoLoop the index of the loop residue    
     @return a vector of SSE PDB anchors.    
     */
	public Vector<Pdb> SearchSSEAnchorsTop(int topK,int resNoLoop)
	{
		//get the maximum residue index
		Assign asgMaxNo=(Assign)this.vecSeq.elementAt(this.vecSeq.size()-1);//here pdbs are sorted based on res number.		
		int maxResNo=asgMaxNo.getResidueNo();
		int[] numNOEs=new int[maxResNo+1];
		for(int i=0;i<numNOEs.length;i++)
			numNOEs[i]=0;//initialization
		
		for(int i=0;i<this.vecAmbNOEs.size();i++)
		{
			Noe noe=(Noe)this.vecAmbNOEs.elementAt(i);
			int resNoA=noe.getResidueNoA();
			int resNoB=noe.getResidueNoB();			
			if(resNoA==resNoLoop)			
				numNOEs[resNoB]++;			
			if(resNoB==resNoLoop)
				numNOEs[resNoA]++;				
		}//for(int i=0;i<this.vecAmbNOEs.size();i++)
		
		Vector<RotaPattern> vecRotTemp=new Vector<RotaPattern>();
		for(int j=0;j<numNOEs.length;j++)
		{
			boolean isInSSE=false;
			for(int i=0;i<this.vecPdbSSE.size();i++)
			{
				Pdb pp=(Pdb)this.vecPdbSSE.elementAt(i);
				int resNo=pp.getResidueNo();
				if(resNo==j)
				{
					isInSSE=true;
					vecRotTemp.add(new RotaPattern(pp,numNOEs[resNo] ) );	
					break;
				}
			}//for(int i=0;i<this.vecPdbSSE.size();i++)
			Pdb ppTemp=new Pdb();
			if(!isInSSE)
				vecRotTemp.add(new RotaPattern(ppTemp,numNOEs[j] ) );
			
		}//for(int j=0;j<numNOEs.length;j++)		
		Collections.sort(vecRotTemp, new RotaPattern.scoreComparator());
		
		Vector<Pdb> vecSSEsAnchors=new Vector<Pdb>();
		for (int i=0;i<Math.min(topK,vecRotTemp.size());i++)
		{
			RotaPattern rotPatn=(RotaPattern)vecRotTemp.elementAt(i);
			Pdb pp=rotPatn.getPdb();
			if( this.vecPdbSSE.contains(pp))			
				vecSSEsAnchors.add(rotPatn.getPdb());
		}
		return vecSSEsAnchors; 
	}
	/**
     * search T(3)*S(3) space to find the optimal solution that best fits the NOESY data
     * Use euler angle rather than grid points.
     *   
     @param tranX0,tranXn, coordinate boundary for translation   
     @param rotX0, rotXn coordinate boundary for rotation (unit: degree)
     @param rotPdb original rotamer pdb
     @param tranResol grid resolution of translation
     @param rotResol grid resolution of rotation
     @param isCheckClash whether check the steric clash,not used so far
     @param     
     @return the best score, and the optimal translation and rotation,including translation and rotation.    
     */
	public double TranRotGridSearchNew(double[] caSSE, double[] tranX0,double[] tranXn,double[] tranResol,
			double[] translation,int noStart, int noEnd,int noCur,Vector<RotaPattern> vecCandPos)
	{
		Pdb pp=new Pdb();		
		double ranThetaS=0.0,ranPhiS=0.0,lengthRS=0.0;
		int maxNoes=-9999;
		double [] centerO={0.0, 0.0, 0.0};
		
				
		for (int m = 0; m < (Math.abs(tranXn[0]-tranX0[0])/tranResol[0]); m++)//usually from 0 to 180 degree
		{			
			double ranTheta = (tranX0[0]+ m * tranResol[0] ) * Math.PI / 180.0;			
			
			for (int j=0; j< (Math.abs(tranXn[1]-tranX0[1]) / tranResol[1]); j++)//usually from 0 to 360 degree
			{
				
				double ranPhi =(tranX0[1]+j * tranResol[1])* Math.PI / 180.0;				
								
				for (int k =0 ; k<(Math.abs(tranXn[2]-tranX0[2]) / tranResol[2]) ; k++)
				{					
					double lengthR  = tranX0[2]+ k*tranResol[2];
					
					double[] caNewTemp = { lengthR * Math.sin(ranTheta) * Math.cos(ranPhi),
		  	 			      lengthR * Math.sin(ranTheta) * Math.sin(ranPhi),
		  	 			      lengthR * Math.cos(ranTheta)};
					
					double[] trans_vec = new double[3];
					trans_vec=pp.internuclearVec(centerO,caSSE);
					
					double[] caNew=new double[3];
					caNew[0]=caNewTemp[0]+trans_vec[0];
					caNew[1]=caNewTemp[1]+trans_vec[1];
					caNew[2]=caNewTemp[2]+trans_vec[2];
					
					//check the steric clash between ca atom and SSEs(including side-chains)
 					boolean isClash=CheckClashBtwRotCaNSSEs(caNew);
					if(isClash)
						continue;
					
					//check the kinematic constraint
					boolean isKinConstraint=CheckKinConstraint(caNew,noStart, noEnd, noCur);
					if(!isKinConstraint)
						continue;
					
					//check the distance restraints (i.e., NOE pattern satisfaction)
					int numNoes=ComputeNoeSatisfaction(caNew,noCur);
		
					if(maxNoes<numNoes)
					{
						maxNoes=numNoes;
						ranThetaS=ranTheta;
						ranPhiS=ranPhi;
						lengthRS=lengthR;
					}
					vecCandPos.add(new RotaPattern(caNew, numNoes));
				}//for(int k=0; k<((tranXn[2]-tranXn[2])/tranResol);k++)
				
			}//for(int j=0; j<((tranXn[1]-tranXn[1])/tranResol);j++)
		}//for(int i=0;i<((tranXn[0]-tranXn[0])/tranResol);i++)
		translation[0]=ranThetaS*180.0/Math.PI;
		translation[1]=ranPhiS*180.0/Math.PI;
		translation[2]=lengthRS;
		
		return maxNoes;
	}
			
	/**
     * search T(3)*S(3) space to find the optimal solution that best fits the NOESY data
     *   
     @param tranX0,tranXn, coordinate boundary for translation   
     @param rotX0, rotXn coordinate boundary for rotation (unit: degree)
     @param rotPdb original rotamer pdb
     @param tranResol grid resolution of translation
     @param rotResol grid resolution of rotation
     @param isCheckClash whether check the steric clash,not used so far
     @param     
     @return the best score, and the optimal translation and rotation,including translation and rotation.    
     */
	public double TranRotGridSearch(double[] tranX0,double[] tranXn,double[] rotX0,double[] rotXn,
			Vector<Pdb> vecRotPdb,double tranResol,double rotResol,boolean isCheckClash, 
			double[] translation,double[] rotation)
	{
		Pdb pp=new Pdb();
		double scoreS=-99999.9;
		double[] XSave=new double[3];
		XSave[0]=0.0;XSave[1]=0.0;XSave[2]=0.0;
		double alphaS=0.0,betaS=0.0,gammaS=0.0;
		
		//find the ca of rotamer for translation
		Pdb pdbRot=vecRotPdb.elementAt(0);
		Vector vecAtomRot=pdbRot.getAtomVec();
		double [] ca_rot = new double[3];
		
		for (int j=0; j<vecAtomRot.size(); j++)
    	{ 
			Cartesian cc = (Cartesian)vecAtomRot.elementAt(j);
    	    String atom = cc.getAtom();
    	    if (atom.equalsIgnoreCase("CA"))
    	    	ca_rot = cc.getXYZ();	//for translation	    
    	} 
		
		for(int i=0;i<( Math.abs(tranXn[0]-tranX0[0])/tranResol);i++)
		{
			double x=tranX0[0]+i*tranResol;
			for(int j=0; j<(Math.abs(tranXn[1]-tranX0[1])/tranResol);j++)
			{
				double y=tranX0[1]+j*tranResol;
				for(int k=0; k<(Math.abs(tranXn[2]-tranX0[2])/tranResol);k++)
				{
					double z=tranX0[2]+k*tranResol;
					
					//searching the rotation:
					double alpha = 0.0, beta = 0.0, gamma = 0.0;
					double [][] mat = new double[3][3];
					Matrix A = new Matrix(3,3);
					
					for (int Ri = 0; Ri < (Math.abs(rotXn[0]-rotX0[0]) / rotResol); Ri++)
					{						
					    alpha = (rotX0[0]+Ri * rotResol) * Math.PI / 180.0;
					    for (int Rj=0; Rj< (Math.abs(rotXn[1]-rotX0[1]) / rotResol); Rj++)
					    {
							beta = (rotX0[1]+ Rj * rotResol )* Math.PI / 180.0;
							for (int Rk=0; Rk< (Math.abs(rotXn[2]-rotX0[2])/ rotResol ); Rk++)
							{
							    gamma = (rotX0[2]+Rk * rotResol) * Math.PI / 180.0;
							    //Generate the Euler matrix
							    mat[0][0] = Math.cos(alpha)*Math.cos(beta)*Math.cos(gamma) - Math.sin(alpha)*Math.sin(gamma);
							    mat[0][1] = Math.sin(alpha)*Math.cos(beta)*Math.cos(gamma) + Math.cos(alpha)*Math.sin(gamma);
							    mat[0][2] = -Math.sin(beta)*Math.cos(gamma);
							    mat[1][0] = -Math.cos(alpha)*Math.cos(beta)*Math.sin(gamma) - Math.sin(alpha)*Math.cos(gamma);
							    mat[1][1] = -Math.sin(alpha)*Math.cos(beta)*Math.sin(gamma) + Math.cos(alpha)*Math.cos(gamma);
							    mat[1][2] = Math.sin(gamma)*Math.sin(beta);
							    mat[2][0] = Math.sin(beta)*Math.cos(alpha);
							    mat[2][1] = Math.sin(alpha)*Math.sin(beta);
							    mat[2][2] = Math.cos(beta);						    
							    A = new Matrix(mat);
							    Vector vecRotNew=pp.newPdb(vecRotPdb, A);
							    
							    //the translation vector after putting into the same frame
							    double[] caRotNew=new double[3];
							    caRotNew[0]=x;caRotNew[1]=y;caRotNew[2]=z;
							    double [] trans_vec = new double[3];
						    	trans_vec= pp.internuclearVec(ca_rot,caRotNew);	//wrong....
						    	Vector<Pdb> vecRotTranNew=pp.newPdbByTranslation(vecRotNew,trans_vec);
						    	
							    double errH=0.03; 
							    double errHeavy=0.2;
							    double distBound=6.0;
							    double score=CompNoePatternScoreBetwSSEAndLoop(errH,errHeavy,this.vecPdbSSE,vecRotTranNew,distBound,this.vecAsg,this.vecNOESY);
						    
							    if(score < -100.0)
							    	continue;
							    if(score>scoreS)
							    {
							    	scoreS=score;
							    	XSave[0]=x;	XSave[1]=y; XSave[2]=z;
							    	alphaS=alpha;betaS=beta;gammaS=gamma;
							    }//if(score>scoreS)
							    
							}//for (k=0; k< (180 / rotResol ); k++)
					    }//	for (j=0; j< (180 / rotResol); j++)
					}//  for (int Ri = 0; Ri < (180 / rotResol); Ri++)					
					
				}//for(int k=0; k<((tranXn[2]-tranXn[2])/tranResol);k++)
				
			}//for(int j=0; j<((tranXn[1]-tranXn[1])/tranResol);j++)
		}//for(int i=0;i<((tranXn[0]-tranXn[0])/tranResol);i++)
		translation[0]=XSave[0];translation[1]=XSave[1];translation[2]=XSave[2];
		rotation[0]=alphaS*180.0/Math.PI;
		rotation[1]=betaS*180.0/Math.PI;
		rotation[2]=gammaS*180.0/Math.PI;	
		return scoreS;
	}
	   /**compute NOE pattern between SSE and loops. 
     * 
     * @param errH, errHeavy: error windows.
     * @param vecPdbLoop loop Pdb
     * @param vecPdbSSE SSE Pdb
     * @param distBound upper bound limit for back-computed NOEs
     * @param asgVec resonance assigment list
     * @param vecNOESY NOESY cross peak list
     * @return
     */
    public double CompNoePatternScoreBetwSSEAndLoop(double errH, double errHeavy,
    		Vector<Pdb> vecSSEPdb,Vector<Pdb> vecPdbLoop, double distBound,Vector asgVec,Vector vecNOESY)
    {
    	//1. compute the set of NOE distances 
    	double [] coordLoop = {0.0, 0.0, 0.0};
    	double [] coordSSE = {0.0, 0.0, 0.0};
    	Peak pk=new Peak();
    	Vector vecHdist =new Vector();
    	int clashThreshold=6;//todo:test which value is reasonable...
    	
    	int numClash=0;
    	for(int i=0;i<vecPdbLoop.size();i++)
    	{
    		Pdb pdbLoop=(Pdb)vecPdbLoop.elementAt(i);
    		String resLoop=pdbLoop.getResidue();
    		Vector vecAtomLoop=pdbLoop.getAtomVec();
    		int resNoLoop=pdbLoop.getResidueNo();
    		for(int j=0;j<vecAtomLoop.size();j++)
    		{
    			Cartesian ccLoop=(Cartesian)vecAtomLoop.elementAt(j);
    			coordLoop=ccLoop.getXYZ();
    			String atomLoop=ccLoop.getAtom();
    			if(! atomLoop.substring(0,1).equalsIgnoreCase("H"))
    				continue;
    			String heavyAtom=pk.GetHeavyAtomFromProton(resLoop,atomLoop);
    			if( ! (heavyAtom.substring(0,1).equalsIgnoreCase("C") || heavyAtom.substring(0,1).equalsIgnoreCase("N") ) )
    				continue;
    			
    			for(int k=0;k<vecSSEPdb.size();k++)
    			{
    				Pdb pdbSSE=(Pdb)vecSSEPdb.elementAt(k);
    				String resSSE=pdbSSE.getResidue();
    				Vector vecAtomSSE=pdbSSE.getAtomVec();
    				int resNoSSE=pdbSSE.getResidueNo();
    				for(int h=0;h<vecAtomSSE.size();h++)
    				{
    					Cartesian ccSSE=(Cartesian)vecAtomSSE.elementAt(h);
    					coordSSE=ccSSE.getXYZ();
    					String atomSSE=ccSSE.getAtom();
    					if(! atomSSE.substring(0, 1).equalsIgnoreCase("H"))
    						continue;
    					String heavyAtomSSE=pk.GetHeavyAtomFromProton(resSSE,atomSSE);
    					if( ! (heavyAtomSSE.substring(0,1).equalsIgnoreCase("C") || heavyAtomSSE.substring(0,1).equalsIgnoreCase("N") ) )
    	    				continue;
    					
    					double distance= Math.sqrt((coordLoop[0] - coordSSE[0]) * (coordLoop[0] - coordSSE[0]) 
	    						+ (coordLoop[1] - coordSSE[1]) * (coordLoop[1] - coordSSE[1]) 
	    						+ (coordLoop[2] - coordSSE[2]) * (coordLoop[2] - coordSSE[2]));
    					if(distance<1.8)
    						numClash++;
    					if(numClash>clashThreshold)
    						return -99999.9;
    					
    					if (distance < distBound)
	    				{
	    					vecHdist.add(new Hdist(ccLoop,resNoLoop,resLoop,atomLoop, ccSSE,resNoSSE,resSSE,atomSSE,distance));	    					
	    					vecHdist.add(new Hdist(ccSSE,resNoSSE,resSSE,atomSSE,ccLoop,resNoLoop,resLoop,atomLoop,distance));	
	    				}
    					
    				}//for(int h=0;h<vecAtomSSE.size();h++)
    				
    			}//for(int k=0;k<vecPdbSSE.size();k++)
    			
    			
    		}//for(int j=0;j<vecAtomLoop.size();j++)
    		
    	}//for(int i=0;i<vecPdbLoop.size();i++)
    	
    	//2.the set of back-computed NOEs:
    	Vector vecBackNoe=new Vector();
    	RotaPattern rotPattern=new RotaPattern();
    	BackNoe bn=new BackNoe();
    	for (int i=0;i<vecHdist.size();i++)
    	{
    		Hdist hdist=(Hdist)vecHdist.elementAt(i);   		
    		BackNoe backNoe=rotPattern.BackCompNOEPeak(asgVec,hdist);    		
    		vecBackNoe.add(backNoe);
    		
    	}//for (i=0;i<vecHDist.size();i++)
    	
    	Vector vecBackNoeNoRepeat=bn.DeleteRepeat(vecBackNoe);
    	
    	//3.compute the matching score:
    	Assign asg=new Assign();
    	int [] numPeaks=new int[1];
    	double dbScore=-999.9;
    	if(vecBackNoeNoRepeat.size()>0)
    		dbScore=asg.NoePatternMatchScoreWCali(errH,errHeavy, errHeavy,vecBackNoeNoRepeat,vecNOESY, numPeaks,false,this.caliConstant);
		
    	return dbScore;
    	
    }//end of function "CompNoePatternsBetweenSseAndLoop"
    	
    /**
     * simple steric clash checking, only using 1.8 as lower bound.
      @param 
 	 @param 
 	 @param 
 	 @param 
      @return true if there is serious clash, otherwise return false.    
      */
     public boolean CheckStericClashBtwTwoFragments(Vector vecPdbA,Vector vecPdbB)
     {
    	 double threshold=0.8;
    	 double bound=1.8;
    	 for(int i=0;i<vecPdbA.size();i++)
    	 {
    		 Pdb pdbA=(Pdb)vecPdbA.elementAt(i);
    		 int resNoA=pdbA.getResidueNo();
    		 Vector vecAtomA=pdbA.getAtomVec();
    		 for(int j=0;j<vecAtomA.size();j++)
    		 {
    			 Cartesian ccA = (Cartesian)vecAtomA.elementAt(j);
    			 String atomA=ccA.getAtom().substring(0,1);
    			 boolean isPossibleHbond=false;
    			 boolean isBonded=false;
    			 
    			 double [] coordA  = new double[3];
    			 coordA=ccA.getXYZ();
    			 
    			 for(int k=0;k<vecPdbB.size();k++)
    			 {
    				 Pdb pdbB=(Pdb)vecPdbB.elementAt(k);
    				 Vector vecAtomB=pdbB.getAtomVec();
    				 int resNoB=pdbB.getResidueNo();
    				 
    				 for(int t=0;t<vecAtomB.size();t++)
    	    		 {
    					 Cartesian ccB = (Cartesian)vecAtomB.elementAt(t);
    					 String atomB=ccB.getAtom().substring(0,1);
    					 if(atomA.equalsIgnoreCase("H") && atomB.equalsIgnoreCase("O"))
    						 isPossibleHbond=true;
    					 if(atomB.equalsIgnoreCase("H") && atomA.equalsIgnoreCase("O"))
    						 isPossibleHbond=true;
    					 if( ((resNoA+1)==resNoB) && (atomA.equalsIgnoreCase("C")|| atomA.equalsIgnoreCase("CO")) && atomB.equalsIgnoreCase("N"))
    						 isBonded=true;
    					 if( ((resNoB+1)==resNoA) && (atomB.equalsIgnoreCase("C")|| atomB.equalsIgnoreCase("CO")) && atomA.equalsIgnoreCase("N"))
    						 isBonded=true;   					 
    					 
    					 double [] coordB  = new double[3];
    	    			 coordB=ccB.getXYZ();
    	    			 double distance= Math.sqrt((coordB[0] - coordA[0]) * (coordB[0] - coordA[0]) 
    	 						+ (coordB[1] - coordA[1]) * (coordB[1] - coordA[1]) 
    	 						+ (coordB[2] - coordA[2]) * (coordB[2] - coordA[2]));
    	    			 if( (distance < bound* threshold) && !(isPossibleHbond) && (!isBonded))
    	    				 return true;
    	    		 }// for(int t=0;t<vecAtomB.size();t++)
    			 }//for(int k=0;k<vecPdbB.size();k++) 
    			 
    		 }//for(int j=0;j<vecAtomA.size();j++)
    	 }//for(int i=0;i<vecPdbA.size();i++)
    	 return false;
     }

     /**
      * check the kinematic restraint
     @param caPos current ca atom coordinates
  	 @param noStart,noEnd staring and end residue numbers of the loop (fixed endpoints)
  	 @param noCur current residue number
  	 @param 
     @return true if kin restraint is satisfied, otherwise return false.    
       */
      public boolean CheckKinConstraint(double[] caPos,int noStart, int noEnd, int noCur)
      {
    	  boolean isStartSatisfied=false;
    	  boolean isEndSatisfied=false;
    	  double bondLength=3.8; //length of pseudo-bond,3.8A
    	  double resolutionError=0.0;//should be 0
    	  
    	  //1. check the starting endpoint
    	  int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator() );
	  	  if (ind<0)
	  	  {
	  		  System.out.println("the first endpoint residue number not found...exist.");
	  		  System.exit(0);		 
	  	  }
    	  Pdb pdbStart=(Pdb)this.vecPdbSSE.elementAt(ind);
    	  Vector vecAtomStart=pdbStart.getAtomVec();
    	  double[] caStart=new double[3];
    	  for(int i=0;i<vecAtomStart.size();i++)
    	  {   		  
    		  Cartesian cc = (Cartesian)vecAtomStart.elementAt(i);
      	      String atom = cc.getAtom();	      	   
      	      if (atom.equalsIgnoreCase("CA"))
      	    	  caStart=cc.getXYZ();      	   		    
    	  }//for(int i=0;i<vecAtomStart.size();i++)
    	  double distance= Math.sqrt((caStart[0] - caPos[0]) * (caStart[0] - caPos[0]) 
					+ (caStart[1] - caPos[1]) * (caStart[1] - caPos[1]) 
						+ (caStart[2] - caPos[2]) * (caStart[2] - caPos[2]));
    	  if(distance< (Math.abs(noCur-noStart)*bondLength+resolutionError) )
    		  isStartSatisfied=true;
    	  
    	  //2. check the last endpoint
    	  ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator() );
    	  if (ind<0)
	  	  {
	  		  System.out.println("the last endpoint residue number not found...exist.");
	  		  System.exit(0);		 
	  	  }
    	  Pdb pdbEnd=(Pdb)this.vecPdbSSE.elementAt(ind);
    	  Vector vecAtomEnd=pdbEnd.getAtomVec();
    	  double[] caEnd=new double[3];
    	  for(int i=0;i<vecAtomEnd.size();i++)
    	  {
    		  Cartesian cc = (Cartesian)vecAtomEnd.elementAt(i);
    		  String atom = cc.getAtom();	      	   
      	      if (atom.equalsIgnoreCase("CA"))
      	    	  caEnd=cc.getXYZ();   
    	  }//for(int i=0;i<vecAtomEnd.size();i++)
    	  distance= Math.sqrt((caEnd[0] - caPos[0]) * (caEnd[0] - caPos[0]) 
					+ (caEnd[1] - caPos[1]) * (caEnd[1] - caPos[1]) 
						+ (caEnd[2] - caPos[2]) * (caEnd[2] - caPos[2]));
    	  if(distance< (Math.abs(noEnd-noCur)*bondLength+resolutionError) )
    		  isEndSatisfied=true;
    	  
    	  if(isStartSatisfied && isEndSatisfied)
    		  return true;
    	  else
    		  return false;
      }
 
      /**
       * simple steric clash checking, used for checking steric clash between ca atom in rotamers 
       * and SSEs
      @param caPos expected ca atom position of the rotamer
   	  @param noCur current residue number
   	  @param 
   	  @param 
      @return NOE satisfaction score.   
      */    
      public double CaDistCorrection(String res,String atom)
      {
    	  Pdb pp=new Pdb();
    	  String rotamFile=rotSrc+ res.toLowerCase()+ ".pdb"; 
		  Vector pdbRotam=new Vector();
		  pdbRotam=pp.readRotamerPdb(rotamFile);//which includes all rotamers	
		  //String subAtom=atom;
		  
		  if(atom.length()>=2)
		  {
			  if(atom.substring(atom.length()-1, atom.length()).equalsIgnoreCase("#"))
				  atom=atom.substring(0,atom.length()-1);
			  if(atom.substring(atom.length()-2,atom.length()).equalsIgnoreCase("##")  )
				  atom=atom.substring(0,atom.length()-2);
		  }
		  if(atom.equalsIgnoreCase("H"))
			  atom="HN";
		  
		  //get the common ca coordinates
		  double[] ca=new double[3];
		  for(int i=0;i<pdbRotam.size();i++)
		  {
			  Pdb pdbRot=(Pdb)pdbRotam.elementAt(i);
			  Vector atomVec = pdbRot.getAtomVec();
			  for(int j=0;j<atomVec.size();j++)
			  {
				  Cartesian cc = (Cartesian) atomVec.elementAt(j);
				  String atomName=cc.getAtom();
				  if(atomName.equalsIgnoreCase("CA"))
					  ca=cc.getXYZ();
			  }//for(int j=0;j<atomVec.size();j++)
		  }// for(int i=0;i<pdbRotam.size();i++)
		  
		  double distCor=-9999.9;
		  double[] sc=new double[3];
		  for(int i=0;i<pdbRotam.size();i++)
		  {
			  Pdb pdbRot=(Pdb)pdbRotam.elementAt(i);
			  Vector atomVec = pdbRot.getAtomVec();
			  for(int j=0;j<atomVec.size();j++)
			  {
				  Cartesian cc = (Cartesian) atomVec.elementAt(j);
				  String atomName=cc.getAtom();
				  if(atomName.equalsIgnoreCase("H"))
					  atomName="HN";
				  sc=cc.getXYZ();
				  if(atomName.length()>=atom.length())
				  {
					  if(atomName.substring(0,atom.length()).equalsIgnoreCase(atom) )
					  {
						  double  distance= Math.sqrt((sc[0] - ca[0]) * (sc[0] - ca[0]) 
	    	 						+ (sc[1] - ca[1]) * (sc[1] - ca[1]) 
	    	 						+ (sc[2] - ca[2]) * (sc[2] - ca[2]));
						  if(distance >distCor)
							  distCor=distance;
					  }
				  }
			  }//for(int j=0;j<atomVec.size();j++)
		  }// for(int i=0;i<pdbRotam.size();i++)
		  
		  if(distCor<-10.0)
			  System.out.println("Debugging...here we have a bug...");
		  return distCor;
      }
      
      /**
       * simple steric clash checking, used for checking steric clash between ca atom in rotamers 
       * and SSEs
     @param caPos expected ca atom position of the rotamer
   	 @param noCur current residue number
   	 @param 
   	 @param 
     @return NOE satisfaction score.   
        */    
      public int ComputeNoeSatisfaction(double[] caPos,int noCur)
      {
    	  int counter=0;
    	  for(int i=0;i<this.vecAmbNOEs.size();i++)
       	  {
			   Noe noe=(Noe)this.vecAmbNOEs.elementAt(i);
			   int firstResNo=noe.getResidueNoA();
			   int secondResNo=noe.getResidueNoB();
			   String firstResName=noe.getResidueA();
			   String secondResName=noe.getResidueB();
			   String firstAtomName=noe.getAtomA();///
			   String secondAtomName=noe.getAtomB();
			   boolean isSatisfied=false;
			   
			   if(firstResName.length()>=2)
			   {
				  if(firstResName.substring(firstResName.length()-1, firstResName.length()).equalsIgnoreCase("#"))
					  firstResName=firstResName.substring(0,firstResName.length()-1);
				  if(firstResName.substring(firstResName.length()-2,firstResName.length()).equalsIgnoreCase("##")  )
			 		  firstResName=firstResName.substring(0,firstResName.length()-2);
			   }
			   if(secondAtomName.length()>=2)
			   {
		    	  if(secondAtomName.substring(secondAtomName.length()-2,secondAtomName.length()).equalsIgnoreCase("##")  )
		    		secondAtomName=secondAtomName.substring(0,secondAtomName.length()-2);
		    	  else if (secondAtomName.substring(secondAtomName.length()-1,secondAtomName.length()).equalsIgnoreCase("#") )
		    		secondAtomName=secondAtomName.substring(0,secondAtomName.length()-1);
			    }
			   if(firstResName.equalsIgnoreCase("H"))
				   firstResName="HN";
			   if(secondAtomName.equalsIgnoreCase("H"))
				   secondAtomName="HN";
			   
			   double dist_from_inten=noe.getUpper();
			   double noeUpperPrune=0.0;
			   
			   if(firstResNo==noCur)
			   {
				   double distCor=CaDistCorrection(firstResName,firstAtomName);
				   
				   int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(secondResNo), new Pdb.PdbComparator() );
				   if (ind<0)
					   continue;
				   Pdb pdbSSE=(Pdb)this.vecPdbSSE.elementAt(ind);
				   Vector vecAtomSSE=pdbSSE.getAtomVec();
				   for(int j=0;j<vecAtomSSE.size();j++)
				   {
					   Cartesian cc = (Cartesian) vecAtomSSE.elementAt(j);
					   String atomName=cc.getAtom();
					   if(atomName.equalsIgnoreCase("H"))
						   atomName="HN";
					   double [] coord=new double[3];					 
					   coord=cc.getXYZ();
					   if(atomName.length()>=secondAtomName.length())
					   {
						   if(atomName.substring(0,secondAtomName.length()).equalsIgnoreCase(secondAtomName) )
						   {
							   double  distance= Math.sqrt((coord[0] - caPos[0]) * (coord[0] - caPos[0]) 
			    	 						+ (coord[1] - caPos[1]) * (coord[1] - caPos[1]) 
			    	 						+ (coord[2] - caPos[2]) * (coord[2] - caPos[2]));
							   if(distance < (dist_from_inten+ distCor))
								   isSatisfied=true;
						   }
					   }
				   }//for(int j=0;j<vecAtomSSE.size();j++)			   
				   
			   }//if(firstResNo==noCur)
			   
			   if(secondResNo==noCur)
			   {
				   double distCor=CaDistCorrection(secondResName,secondAtomName);
				   int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(firstResNo), new Pdb.PdbComparator() );
				   if (ind<0)
					   continue;
				   Pdb pdbSSE=(Pdb)this.vecPdbSSE.elementAt(ind);
				   Vector vecAtomSSE=pdbSSE.getAtomVec();
				   for(int j=0;j<vecAtomSSE.size();j++)
				   {
					   Cartesian cc = (Cartesian) vecAtomSSE.elementAt(j);
					   String atomName=cc.getAtom();
					   double [] coord=new double[3];					 
					   coord=cc.getXYZ();
					   if(atomName.length()>=firstAtomName.length())
					   {
						   if(atomName.substring(0,firstAtomName.length()).equalsIgnoreCase(firstAtomName) )
						   {
							   double  distance= Math.sqrt((coord[0] - caPos[0]) * (coord[0] - caPos[0]) 
			    	 						+ (coord[1] - caPos[1]) * (coord[1] - caPos[1]) 
			    	 						+ (coord[2] - caPos[2]) * (coord[2] - caPos[2]));
							   if(distance < (dist_from_inten+ distCor))
								   isSatisfied=true;
						   }
					   }
				   }//for(int j=0;j<vecAtomSSE.size();j++)			   
			   }//if(secondResNo==noCur) 
			   
			   if(isSatisfied)
				   counter++;
       	  }//for(int i=0;i<this.vecAmbNOEs.size();i++)
    	  return counter;
      }
      
    /**
    * check whether the distance satisfies the NOE restraint from ca to anchors in SSEs
    @param curPdb current residue
   	@param vecSSEAnchors list of anchored residues in SSEs
   	@param distUpCa distance upper bound for checking the NOE distance between Ca atoms
   	@param 
    @return true if the distance between ca atoms is < distUpCa, otherwise return false.    
    */
    public boolean CheckNOEBtwCaNSSEs(Pdb curPdb,Vector vecSSEAnchors,double distUpCa)
    {
    	double [] coordCA_cur = new double[3]; 	
    	boolean isSatisfied=false;
    	Vector atomVecCur=curPdb.getAtomVec();
		for (int t=0;t<atomVecCur.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecCur.elementAt(t);
    	    String atom = cc.getAtom();    	    
    	    if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_cur=cc.getXYZ();   	 
		}//for (int k=0;k<atomVecStart.size();k++)		
	   
		for(int k=0;k<vecSSEAnchors.size();k++)
		{			
			Pdb ppSSE=(Pdb)vecSSEAnchors.elementAt(k);				
			Vector vecAtomSSE=ppSSE.getAtomVec();
			double [] caSSE = new double[3];					
			for(int t=0;t<vecAtomSSE.size();t++)
			{
				Cartesian cc = (Cartesian)vecAtomSSE.elementAt(t);
				String atom = cc.getAtom();
				if (atom.equalsIgnoreCase("CA"))
					caSSE=cc.getXYZ();
			}//for(int t=0;t<vecAtomSSE.size();t++)
			
			double distance= Math.sqrt((caSSE[0] - coordCA_cur[0]) * (caSSE[0] - coordCA_cur[0]) 
					+ (caSSE[1] - coordCA_cur[1]) * (caSSE[1] - coordCA_cur[1]) 
					+ (caSSE[2] - coordCA_cur[2]) * (caSSE[2] - coordCA_cur[2]));
			
			if(distance < distUpCa)
			{
				isSatisfied=true;
				return isSatisfied;
			}			
		}//for(int k=0;k<vecSSEAnchors.size();k++)
		return isSatisfied;
    }
     /**
      * simple steric clash checking, used for checking steric clash between ca atom in rotamers 
      * and SSEs
     @param 
  	 @param 
  	 @param 
  	 @param 
       @return true if there is serious clash, otherwise return false.    
       */
      public boolean CheckClashBtwRotCaNSSEs(double[] caPos)
      {
     	 double threshold=0.95;
     	 double bound=2.03;//vdwC2H = 2.03;
     	 Vector vecPdbB=new Vector();
     	 vecPdbB.addAll(this.vecPdbSSE);
     			 
		 for(int k=0;k<vecPdbB.size();k++)
		 {
			 Pdb pdbB=(Pdb)vecPdbB.elementAt(k);
			 Vector vecAtomB=pdbB.getAtomVec();
			 int resNoB=pdbB.getResidueNo();
     				 
			 for(int t=0;t<vecAtomB.size();t++)
    		 {
				 Cartesian ccB = (Cartesian)vecAtomB.elementAt(t);   					   					 					 
				 
				 /// ////////////////////////
				 //only check backbone atoms:
				 String atom=ccB.getAtom();
				 if(!(atom.equalsIgnoreCase("N") ||atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H")||atom.equalsIgnoreCase("CA")
						 ||atom.equalsIgnoreCase("HA")|| atom.equalsIgnoreCase("C")|| atom.equalsIgnoreCase("O")||atom.equalsIgnoreCase("CB") ))
					 continue;
				///////////////////////////
				 
				 double [] coordB  = new double[3];
    			 coordB=ccB.getXYZ();
    			 double distance= Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) 
 						+ (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) 
 						+ (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
    			 if( distance < (bound* threshold) )
    				 return true;
    		 }// for(int t=0;t<vecAtomB.size();t++)
		 }//for(int k=0;k<vecPdbB.size();k++)    
     	 return false;
      }     
      /**
       * simple steric clash checking, used for checking steric clash between ca atom in rotamers 
       * and SSEs. 
      @param 
   	 @param 
   	 @param 
   	 @param 
        @return true if there is serious clash, otherwise return false.    
        */
       public boolean CheckClashBtwRotCaNSSEsNew(double[] caPos,int numClashThreshold)
       {
      	 double threshold=0.90;
      	 double bound=2.03;//vdwC2H = 2.03;
      	 Vector vecPdbB=new Vector();
      	 vecPdbB.addAll(this.vecPdbSSE);
      			 
      	 int counter=0;
 		 for(int k=0;k<vecPdbB.size();k++)
 		 {
 			 Pdb pdbB=(Pdb)vecPdbB.elementAt(k);
 			 Vector vecAtomB=pdbB.getAtomVec();
 			 int resNoB=pdbB.getResidueNo();
      				 
 			 for(int t=0;t<vecAtomB.size();t++)
     		 {
 				 Cartesian ccB = (Cartesian)vecAtomB.elementAt(t);   					   					 					 
 				 				 
 				 double [] coordB  = new double[3];
     			 coordB=ccB.getXYZ();
     			 String atom=ccB.getAtom();
     			 
     			 if(atom.substring(0, 1).equalsIgnoreCase("C")|| atom.substring(0, 1).equalsIgnoreCase("N"))
     				bound=2.45;
     			 else if (atom.substring(0, 1).equalsIgnoreCase("H"))
     				bound=2.03;
     					
     			 double distance= Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) 
  						+ (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) 
  						+ (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
     			 if( distance < (bound* threshold) )     			 
     				 counter++;
     			 if(counter>=numClashThreshold)
     				 return true;
     		 }// for(int t=0;t<vecAtomB.size();t++)
 		 }//for(int k=0;k<vecPdbB.size();k++)    
      	 return false;
       }     
       /**
        * simple steric clash checking, used for checking steric clash between ca atom in rotamers 
        * and SSEs. 
       @param 
    	 @param 
    	 @param 
    	 @param 
         @return true if there is serious clash, otherwise return false.    
         */
        public boolean CheckClashBtwRotCaNSSEsNew(Vector vecPdbB, double[] caPos,int numClashThreshold)
        {
       	 double threshold=0.90;
       	 double bound=2.03;//vdwC2H = 2.03;
       	 //Vector vecPdbB=new Vector();
       	 //vecPdbB.addAll(this.vecPdbSSE);
       			 
       	 int counter=0;
  		 for(int k=0;k<vecPdbB.size();k++)
  		 {
  			 Pdb pdbB=(Pdb)vecPdbB.elementAt(k);
  			 Vector vecAtomB=pdbB.getAtomVec();
  			 int resNoB=pdbB.getResidueNo();
       				 
  			 for(int t=0;t<vecAtomB.size();t++)
      		 {
  				 Cartesian ccB = (Cartesian)vecAtomB.elementAt(t);   					   					 					 
  				 				 
  				 double [] coordB  = new double[3];
      			 coordB=ccB.getXYZ();
      			 String atom=ccB.getAtom();
      			 
      			 if(atom.substring(0, 1).equalsIgnoreCase("C")|| atom.substring(0, 1).equalsIgnoreCase("N"))
      				bound=2.45;
      			 else if (atom.substring(0, 1).equalsIgnoreCase("H"))
      				bound=2.03;
      					
      			 double distance= Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) 
   						+ (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) 
   						+ (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
      			 if( distance < (bound* threshold) )     			 
      				 counter++;
      			 if(counter>=numClashThreshold)
      				 return true;
      		 }// for(int t=0;t<vecAtomB.size();t++)
  		 }//for(int k=0;k<vecPdbB.size();k++)    
       	 return false;
        }     
       /**
        * simple steric clash checking, used for checking steric clash between ca atom in rotamers 
        * and SSEs. 
       @param 
    	 @param 
    	 @param 
    	 @param 
         @return true if there is serious clash, otherwise return false.    
         */
        public boolean CheckClashBtwCaNPdb(Vector vecPdb, int curNo, double[] caPos,int numClashThreshold)
        {
       	 double threshold=1.15;
       	 double bound=2.03;//vdwC2H = 2.03;
       	 Vector vecPdbB=new Vector();
       	 vecPdbB.addAll(vecPdb);
       			 
       	 int counter=0;
  		 for(int k=0;k<vecPdbB.size();k++)
  		 {
  			 Pdb pdbB=(Pdb)vecPdbB.elementAt(k);
  			 int resNoTemp=pdbB.getResidueNo();
  			 if(Math.abs(curNo-resNoTemp)<=1 )
  				 continue;
  			 
  			 Vector vecAtomB=pdbB.getAtomVec();
  			 int resNoB=pdbB.getResidueNo();
       				 
  			 for(int t=0;t<vecAtomB.size();t++)
      		 {
  				 Cartesian ccB = (Cartesian)vecAtomB.elementAt(t);   					   					 					 
  				 				 
  				 double [] coordB  = new double[3];
      			 coordB=ccB.getXYZ();
      			 double distance= Math.sqrt((coordB[0] - caPos[0]) * (coordB[0] - caPos[0]) 
   						+ (coordB[1] - caPos[1]) * (coordB[1] - caPos[1]) 
   						+ (coordB[2] - caPos[2]) * (coordB[2] - caPos[2]));
      			 if( distance < (bound* threshold) )     			 
      				 counter++;
      			 if(counter>=numClashThreshold)
      				 return true;
      		 }// for(int t=0;t<vecAtomB.size();t++)
  		 }//for(int k=0;k<vecPdbB.size();k++)    
       	 return false;
        }    
    /**
    * get the candidate positions for each ca atom using kinematic constraints and rotamer replacement
     * find current ca atom candidate positions 
     @param vecPrePdb the whole structure computed in previous round
	 @param curResNo current residue number 
	 @param noStart the first residue number in the loop fragment
	 @param noEnd  the end residue number in the loop fragment
     @return a vector storing ca candidate positions for current residue.    
     */
    public void KinNeighborSearch(Pdb PrePdb,int curResNo,int noStart,int noEnd )//todo...
    {
    	double resolDih=45.0;//resolution for searching dihedral angles
    	int nTotalRes=Math.abs(noEnd-noStart)+1; //total number of residues in the loop fragment
    	double[] phiS = new double[nTotalRes]; //starting from fixed end point in SSEs
		double[] psiS = new double[nTotalRes]; 
		
    	Pdb pp=new Pdb();
    	ModelRdc mdc=new ModelRdc();
    	
    	//coordinates of N, nh, ca of previous residue:
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 	
		int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator() );
		if (ind<0)
		{
			System.out.println("the first endpoint residue number not found...exist.");
			System.exit(0);		 
		}
		//Pdb pdbCur = (Pdb)vecPrePdb.elementAt(ind);	
		Vector atomVecCur = PrePdb.getAtomVec();
		for (int k=0;k<atomVecCur.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecCur.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)	
		
		//extract the loop fragment:
    /*	Vector vecPdbLoopFrag=new Vector();//for storing loop fragment
    	Vector vecPdbSSEFrag=new Vector();//for storing SSE
    	for(int i=0;i<vecPrePdb.size();i++)
    	{
    		Pdb pdb=(Pdb)vecPrePdb.elementAt(i);
    		if( ( pdb.getResidueNo()>=noStart ) && (pdb.getResidueNo() <=noEnd)   )
    			vecPdbLoopFrag.add(pdb);
    		else
    			vecPdbSSEFrag.add(pdb);
    	}//for(int i=0;i<vecPrePdb.size();i++)
    	*/
		
    	//get the phi,psi angles of previous residue
		Vector vecPrePdb=new Vector();
		vecPrePdb.add(PrePdb);
    	Vector vecPhiPsi=new Vector();
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPrePdb);
    	for(int i=0;i<vecPhiPsiTemp.size();i++)
    	{
    		PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(i);
    		phiS[i]=phipsi.getPhi();
    		psiS[i]=phipsi.getPsi(); 
    		if(phipsi.getResidueNo()==curResNo)
    			continue;
    		vecPhiPsi.add(phipsi);    		
    	}//for(int i=0;i<vecPhiPsiTemp.size();i++)	
    	
    	//grid search
		for (int k=0;k<360/resolDih;k++)
		{
			double phiValue=k*resolDih* Math.PI / 180.0;
			System.out.println("k="+k+" phiValue="+phiValue);
	    	for (int j=0;j<360/resolDih;j++)
			{	    		
	    		double psiValue=j*resolDih* Math.PI / 180.0;
    			System.out.println("j="+j+" psiPreValue="+psiValue);
    			
    			phiS[curResNo-noStart]=phiValue;
    			psiS[curResNo-noStart]=psiValue;
    			
    			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
    			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, noStart, false);//first    			
    			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);     			
    			
    			//extract current residue
    			ind = Collections.binarySearch(pdbFragTemp, new Pdb(curResNo), new Pdb.PdbComparator() );
    			Pdb curPdb=(Pdb)pdbFragTemp.elementAt(ind);
    			Vector vecCurPdb=new Vector();
    			vecCurPdb.add(curPdb);
    			
    			//check the steric clash with SSEs
    			boolean isClash=CheckStericClashBtwTwoFragments(vecCurPdb,this.vecPdbSSE);
    			if(isClash)
    				continue;
    			
			}//for (int j=0;j<360/resolDih;j++)
		}//for (int k=0;k<360/resolDih;k++)
		
			
     }
    
    
    /**
     * get the candidate positions for each ca atom using kinematic constraints and rotamer replacement
     *  
     @param noStart starting residue number of the loop
     @param noEnd last residue number of the loop     
     @return a vector storing all candidate positions.
    
     */
	public void RotamerReplacementKin(int noStart,int noEnd )
	{
		double resolDih=30.0;//resolution for searching dihedral angles
		for(int i=noStart+1;i<noEnd;i++)
		{
			int curResNo=i;
			
			for (int k=0;k<360/resolDih;k++)
			{
				double phiValue=k*resolDih* Math.PI / 180.0;
				System.out.println("k="+k+" phiValue="+phiValue);
		    	for (int j=0;j<360/resolDih;j++)
				{	    		
		    		double psiValue=j*resolDih* Math.PI / 180.0;
	    			System.out.println("j="+j+" psiPreValue="+psiValue);
	    			
	    			
	    			
				}//for (int j=0;j<360/resolDih;j++)
			}//for (int k=0;k<360/resolDih;k++)
		
		}//for(int i=noStart+1;i<noEnd;i++)
	}
	/**use the gradient search to close the gap, while statisfying the NOE restraints
	 * 
     @param vecCurHalfPdb the set of all possible half planes for current residue
     @param curNo current residue number   
     @param chRdc,nhNextRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @return vecAllPdbs: for all residues
     Note: this function need to be double checked...
    */
	public Vector LoopLocalGapClosure(Vector vecLoopOldPdb, int noStart,int noEnd )
	{
		Random generator = new Random(22);
		int curResNo=noStart;
		double resolution=5.0;//resolution in the grid search
		int topSSEK=6;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 

		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();

		Vector vecLoopTemp=new Vector();
		vecLoopTemp.addAll(vecLoopOldPdb);		
		
		
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart-1), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: starting residue not found...exist...");
			System.exit(0);		
		}		
		Pdb prePdbTemp=(Pdb)this.vecPdbSSE.elementAt(index);
		
		
		//////////////////////////////
		//for computing rdc rmsd
		double Sxx=-this.Syy-this.Szz;	
		double[] sRmsdCH= new double[1];
		int[] sizeCH=new int[1];
		double[] sRmsdNH=new double[1];
		int[] sizeNH=new int[1];
		double[] NhRdcCal  = new double[1];
		double[] ChRdcCal  = new double[1];
		double [][] mat = new double[3][3];
		Matrix A = new Matrix(3,3);
		for(int x=0;x<3;x++)
		{
			for(int y=0;y<3;y++)
			{
				if(x==y)
					mat[x][y]=1;
				else
					mat[x][y]=0;
			}
		}
		A = new Matrix(mat);
		double rdcRmsdBound=3.0;
		
		//////////////////////////////
		
		//extract the starting peptide plane:
		//coordinates of N, nh, ca of previous residue:
		double [] coordN_start  = new double[3];
		double [] coordNH_start = new double[3];
		double [] coordCA_start = new double[3]; 
		int indStart = Collections.binarySearch(vecLoopTemp, new Pdb(curResNo), new Pdb.PdbComparator());
		if (indStart <0)
		{
			System.out.println("error: starting residue not found...exist...");
			System.exit(0);		
		}			
		Pdb pdbStart = (Pdb)vecLoopTemp.elementAt(indStart);
		Vector atomVecStart = pdbStart.getAtomVec();
		for (int k=0;k<atomVecStart.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_start = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_start=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_start = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)
		
		//compute the current distance gap:
		int indEnd0= Collections.binarySearch(vecLoopTemp, new Pdb(noEnd), new Pdb.PdbComparator());
		if (indEnd0 <0)
		{
			System.out.println("error: end residue not found...exist...");
			System.exit(0);		
		}			
		Pdb pdbEnd0 = (Pdb)vecLoopTemp.elementAt(indEnd0);
		double [] distTemp=new double[1];
		CheckLastResidue(pdbEnd0,noEnd,100.0,distTemp);
		double minDist=distTemp[0];
		
		////////////////////////////////
		//do more than one interation
		///////
		int nIterations=5;
		//double minDist=99999.9;
		
		for(int iItera=0;iItera<nIterations;iItera++)
		{
			curResNo = generator.nextInt(noEnd-noStart) + noStart;
			//curResNo=noStart;
			int counter=0;
			//while(curResNo<noEnd)
			while(counter<(noEnd-noStart))
			{
				curResNo=curResNo+counter;
				if(curResNo>=noEnd)
					curResNo=curResNo-(noEnd-noStart);
				
				vecLoopTemp.add(prePdbTemp);
				Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
				Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecLoopTemp);//note:for end half residues, phi/psi angles are 0
				int nTotalRes=Math.abs(noEnd-noStart); //total number of residues in the loop fragment
		    	double[] phiS = new double[nTotalRes]; 
				double[] psiS = new double[nTotalRes]; 		
				for(int i=0;i<nTotalRes;i++)//start from start
		    	{
		    	    PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(i+1);
		    		phiS[i]=phipsi.getPhi();
		    		psiS[i]=phipsi.getPsi();     		
		    	}//for(int i=0;i<vecPhiPsiTemp.size();i++)								
				//double phiStart=phiS[0];//phi angle of starting residue, which is fixed.
				
				//double minDist=99999.9;
				//use grid search over phi/psi angles for current residue
				double phiSave=phiS[curResNo-noStart];
				double psiSave=psiS[curResNo-noStart];
				if(curResNo==noStart)
				{
					double phiValue=phiS[0];//phi angle of starting residue, which is fixed.
					for (int j=0;j<360/resolution;j++)
	    			{
	    	    		double psiValue=j*resolution* Math.PI / 180.0;        			
	        			psiS[curResNo-noStart]=psiValue;
	        			
	        			//build up the temp structure fragment        			
	        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
	        			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN_start, coordNH_start,coordCA_start, noStart, false); 			
	        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
	        			
	        			//check whether the new fragment satisfies all NOE Ca restraints:
	        			/*boolean isAllNOEsSatisfied=true;
	        			for(int resno=curResNo+1;resno<noEnd;resno++)
	        			{
	        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
	        				if (indTemp <0)
	        				{
	        					System.out.println("error: current residue not found...exist...");
	        					System.exit(0);		
	        				}			
	        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
	        				Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,resno);//get the SSE anchors for current residue				
	        				
	        				boolean isNOESatisfied=CheckNOEBtwCaNSSEs(pdbTemp, vecPdbAchors,distBtwCa);
	        				if(!isNOESatisfied)
	        				{
	        					isAllNOEsSatisfied=false;
	        					break;
	        				}
	        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
	        			if(!isAllNOEsSatisfied)
	        				continue;
	        			*/
	        			//////////////////////////////////
	        			//check the steric clash:
	        			boolean isAllClashFree=true;
	        			for(int resno=curResNo;resno<noEnd-1;resno++)
	        			{
	        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
	        				if (indTemp <0)
	        				{
	        					System.out.println("error: current residue not found...exist...");
	        					System.exit(0);		
	        				}			
	        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
	        				Vector atomVecNext = pdbTemp.getAtomVec();
	        				double [] coordCA_next = new double[3]; 	
	        				for (int t=0;t<atomVecNext.size();t++)
	        				{
	        					Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
	        		    	    String atom = cc.getAtom();	   	 	        		    	   
	        		    	    if (atom.equalsIgnoreCase("CA"))
	        		    	    	coordCA_next=cc.getXYZ();	        		    	       
	        				}//for (int k=0;k<atomVecStart.size();k++)
	        				
	        				boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_next,1);       				
	        				if(isClash)
	        				{
	        					isAllClashFree=false;
	        					break;
	        				}
	        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
	        			if(!isAllClashFree)
	        				continue;   		
	        			
	        			//////////////////////////////////////////
	        			//check the RDC fit:
	        			/*boolean isAllRDCsSatisfied=true;
	        			for(int resno=curResNo+1;resno<noEnd;resno++)
	        			{
	        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
	        				if (indTemp <0)
	        				{
	        					System.out.println("error: current residue not found...exist...");
	        					System.exit(0);		
	        				}			
	        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
	        				Pdb pdbNextTemp = (Pdb)pdbFragTemp.elementAt(indTemp+1);
	        				Vector vecPdbTemp=new Vector();
	        				Vector vecNextPdbTemp=new Vector();
	        				vecPdbTemp.add(pdbTemp);
	        				vecNextPdbTemp.add(pdbNextTemp);
	        				double chRdc=-99999.9;
	        				double nhNextRdc=-99999.9;
	        				int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(resno), new Dipolar.rdcComparator());
	        				if(indCH>-1)
	        					chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
	        				
	        				int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(resno+1), new Dipolar.rdcComparator());
	        				if(indNH>-1)
	        					nhNextRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
	        				
	        				if(nhNextRdc>-100.0)
	            			{
	    	        			double nhRms = pdc.BackCalNHOne(vecNextPdbTemp, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
	    	        			if((nhRms>rdcRmsdBound))
	    	        			{
	    	        				isAllRDCsSatisfied=false;
	    	        				break;
	    	        			}
	    	        			
	            			}
	            			if(chRdc>-100.0)
	            			{
	    	        			double chRms = pdc.BackCalOne(vecPdbTemp, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
	    	        			if(chRms>rdcRmsdBound)	
	    	        			{
	    	        				isAllRDCsSatisfied=false;
	    	        				break;
	    	        			}
	            			}       				

	        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
	        			if(!isAllRDCsSatisfied)
	        				continue;   
	        				*/		

	        			
	        			//////////////////////////////////////////////
	        			//check the gap between end residues:
	        			double[] dist=new double[1];
	        			dist[0]=99999.9;
	        			double error=100.0;
	
	        			int indEnd= Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
	    				if (indEnd <0)
	    				{
	    					System.out.println("error: end residue not found...exist...");
	    					System.exit(0);		
	    				}			
	    				Pdb pdbEnd = (Pdb)pdbFragTemp.elementAt(indEnd);
	    				boolean isClose=CheckLastResidue(pdbEnd,noEnd,error,dist);
	    				double distance=dist[0];
	
	    				if(distance<minDist)
	    				{
	    					minDist=distance;
	    					phiSave=phiValue;
	    					psiSave=psiValue;
	    				}
	    			}//for (int j=0;j<360/resolution;j++)
	
				}//if(curResNo==noStart)
				else //if(curResNo==noStart)
				{
				
					for (int k=0;k<360/resolution;k++)
		    		{
		    			double phiValue=k*resolution* Math.PI / 180.0;
		    			
		    	    	for (int j=0;j<360/resolution;j++)
		    			{
		    	    		double psiValue=j*resolution* Math.PI / 180.0;
		        		
		        			phiS[curResNo-noStart]=phiValue;
		        			psiS[curResNo-noStart]=psiValue;
		        			
		        			//build up the temp structure fragment        			
		        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
		        			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN_start, coordNH_start,coordCA_start, noStart, false);//first    			
		        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
		        			
		        			//check whether the new fragment satisfies all NOE Ca restraints:
		        			/*boolean isAllNOEsSatisfied=true;
		        			for(int resno=curResNo+1;resno<noEnd;resno++)
		        			{
		        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
		        				if (indTemp <0)
		        				{
		        					System.out.println("error: current residue not found...exist...");
		        					System.exit(0);		
		        				}			
		        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
		        				Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,resno);//get the SSE anchors for current residue				
		        				
		        				boolean isNOESatisfied=CheckNOEBtwCaNSSEs(pdbTemp, vecPdbAchors,distBtwCa);
		        				if(!isNOESatisfied)
		        				{
		        					isAllNOEsSatisfied=false;
		        					break;
		        				}
		        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
		        			if(!isAllNOEsSatisfied)
		        				continue;
		        			*/
		        			//////////////////////////////////
		        			//check the steric clash:
		        			boolean isAllClashFree=true;
		        			for(int resno=curResNo;resno<noEnd-1;resno++)//Todo: check the end residue
		        			{
		        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
		        				if (indTemp <0)
		        				{
		        					System.out.println("error: current residue not found...exist...");
		        					System.exit(0);		
		        				}			
		        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
		        				Vector atomVecNext = pdbTemp.getAtomVec();
		        				double [] coordCA_next = new double[3]; 	
		        				for (int t=0;t<atomVecNext.size();t++)
		        				{
		        					Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
		        		    	    String atom = cc.getAtom();	   	 	        		    	   
		        		    	    if (atom.equalsIgnoreCase("CA"))
		        		    	    	coordCA_next=cc.getXYZ();	        		    	       
		        				}//for (int k=0;k<atomVecStart.size();k++)
		        				
		        				boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_next,1);   				
		        				if(isClash)
		        				{
		        					isAllClashFree=false;
		        					break;
		        				}
		        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
		        			if(!isAllClashFree)
		        				continue;   			
		        			
		        			//////////////////////////////////////////
		        			//check the RDC fit:
		        		/*	boolean isAllRDCsSatisfied=true;
		        			for(int resno=curResNo+1;resno<noEnd;resno++)
		        			{
		        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
		        				if (indTemp <0)
		        				{
		        					System.out.println("error: current residue not found...exist...");
		        					System.exit(0);		
		        				}			
		        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
		        				Pdb pdbNextTemp = (Pdb)pdbFragTemp.elementAt(indTemp+1);
		        				Vector vecPdbTemp=new Vector();
		        				Vector vecNextPdbTemp=new Vector();
		        				vecPdbTemp.add(pdbTemp);
		        				vecNextPdbTemp.add(pdbNextTemp);
		        				double chRdc=-99999.9;
		        				double nhNextRdc=-99999.9;
		        				int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(resno), new Dipolar.rdcComparator());
		        				if(indCH>-1)
		        					chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
		        				
		        				int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(resno+1), new Dipolar.rdcComparator());
		        				if(indNH>-1)
		        					nhNextRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
		        				
		        				if(nhNextRdc>-100.0)
		            			{
		    	        			double nhRms = pdc.BackCalNHOne(vecNextPdbTemp, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
		    	        			if((nhRms>rdcRmsdBound))
		    	        			{
		    	        				isAllRDCsSatisfied=false;
		    	        				break;
		    	        			}
		    	        			
		            			}
		            			if(chRdc>-100.0)
		            			{
		    	        			double chRms = pdc.BackCalOne(vecPdbTemp, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
		    	        			if(chRms>rdcRmsdBound)	
		    	        			{
		    	        				isAllRDCsSatisfied=false;
		    	        				break;
		    	        			}
		            			}       				

		        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
		        			if(!isAllRDCsSatisfied)
		        				continue;   		
		        			*/
		        			
		        			//////////////////////////////////////////
		        			//check the gap between end residues:
		        			double[] dist=new double[1];
		        			dist[0]=99999.9;
		        			double error=100.0;
		
		        			int indEnd= Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
		    				if (indEnd <0)
		    				{
		    					System.out.println("error: end residue not found...exist...");
		    					System.exit(0);		
		    				}			
		    				Pdb pdbEnd = (Pdb)pdbFragTemp.elementAt(indEnd);
		    				boolean isClose=CheckLastResidue(pdbEnd,noEnd,error,dist);
		    				double distance=dist[0];
		
		    				if(distance<minDist)
		    				{
		    					minDist=distance;
		    					phiSave=phiValue;
		    					psiSave=psiValue;
		    				}
		    			}//for (int j=0;j<360/resolution;j++)
		    		}//for (int k=0;k<360/resolution;k++)
				}//else //if(curResNo==noStart)
					
				//Todo: what if not changed?
				//update the new fragment with the smallest gap:
				phiS[curResNo-noStart]=phiSave;
				psiS[curResNo-noStart]=psiSave;
				
				Vector pdbFragTempSave0= mdc.modelBuild(phiS, psiS, coordN_start, coordNH_start,coordCA_start, noStart, false);//first    			
				Vector pdbFragTempSave= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTempSave0); 
				vecLoopTemp=new Vector();			
				vecLoopTemp.addAll(pdbFragTempSave);
				
				//curResNo++;
				counter++;
			}//while(curResNo<noEnd)
		}//for(int iItera=0;iItera<nIterations;iItera++)
		
		int indStart0 = Collections.binarySearch(vecLoopTemp, new Pdb(noStart-1), new Pdb.PdbComparator());		
		if(indStart0>-1)
			vecLoopTemp.remove(indStart0);
		//Pdb pdbStart0 = (Pdb)vecLoopOldPdb.elementAt(indStart0);
		//vecLoopTemp.add(pdbStart0);
		Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
		System.out.println("REMARK The final gap is: "+minDist );
		return vecLoopTemp;
	}
	/**use the gradient search to close the gap, for backward computation
	 * 
     @param vecCurHalfPdb the set of all possible half planes for current residue
     @param curNo current residue number   
     @param chRdc,nhNextRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @return vecAllPdbs: for all residues
    */
	public Vector LoopLocalGapClosureBackward(Vector vecLoopOldPdb, int noStart,int noEnd )
	{			
		double resolution=10.0;//resolution in the grid search

		//////////////////////////////
		//for computing rdc rmsd
		double Sxx=-this.Syy-this.Szz;	
		double[] sRmsdCH= new double[1];
		int[] sizeCH=new int[1];
		double[] sRmsdNH=new double[1];
		int[] sizeNH=new int[1];
		double[] NhRdcCal  = new double[1];
		double[] ChRdcCal  = new double[1];
		double [][] mat = new double[3][3];
		Matrix A = new Matrix(3,3);
		for(int x=0;x<3;x++)
		{
			for(int y=0;y<3;y++)
			{
				if(x==y)
					mat[x][y]=1;
				else
					mat[x][y]=0;
			}
		}
		A = new Matrix(mat);
		double rdcRmsdBound=2.0;		
		//////////////////////////////
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		PhiPsi ff=new PhiPsi();
		
		//compute the current distance gap:
		int indEnd0= Collections.binarySearch(vecLoopOldPdb, new Pdb(noStart), new Pdb.PdbComparator());
		if (indEnd0 <0)
		{
			System.out.println("error: end residue not found...exist...");
			System.exit(0);		
		}			
		Pdb pdbEnd0 = (Pdb)vecLoopOldPdb.elementAt(indEnd0);
		double [] distTemp=new double[1];
		CheckFirstResidue(pdbEnd0,noStart,1000.0,distTemp);
		double minDist=distTemp[0];
		
		//get the n, hn,ca atom coordinates at residue noEnd+1:
		//coordinates of N, nh, ca of previous residue:
		double [] coordN_fix  = new double[3];
		double [] coordNH_fix = new double[3];
		double [] coordCA_fix = new double[3]; 
		int indFix = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd+1), new Pdb.PdbComparator());
		if (indFix <0)
		{
			System.out.println("error: starting residue not found...exist...");
			System.exit(0);		
		}			
		Pdb pdbFix = (Pdb)this.vecPdbSSE.elementAt(indFix);//at residue endNo+1
		Vector atomVecFix = pdbFix.getAtomVec();
		for (int k=0;k<atomVecFix.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecFix.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_fix = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_fix=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_fix = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)
		
		Vector vecLoopTemp=new Vector();
		vecLoopTemp.addAll(vecLoopOldPdb);
		vecLoopTemp.add(pdbFix);
		Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
		

		////////////////////////////////
		//do more than one interation
		///////
		int nIterations=1;		
		
		for(int iItera=0;iItera<nIterations;iItera++)
		{
		//starting from the last residue:
		int curResNo=noEnd;
		while(curResNo>=noStart+2)		
		{
			Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecLoopTemp);//note:for end half and the first residues, phi/psi angles are 0
			
			double curPhiSave=0.0;
			double prePhiSave=0.0;
			double prePsiSave=0.0;
			boolean isChanged=false;
			
    		for (int t=0;t<360/resolution;t++)
    		{       	    
    			double phiCur=t*resolution* Math.PI / 180.0;
    			int indCur = Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo), new PhiPsi.PPComparator());
        	    PhiPsi ffCur = (PhiPsi)vecPhiPsiTemp.elementAt(indCur);
        	    ffCur.setPhi(phiCur);
        	    
        	    //check the Rama region:        	  
        		Loops lp=new Loops();
        		String curResName=lp.GetResNameFromSequence(this.vecSeq,curResNo);
            	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curResNo+1);
            	boolean isPrePro=false;
            	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
            		isPrePro=true;
            	//check the Rama region:
    			double rama_score=0.0;
    			if(curResName.equalsIgnoreCase("ALA"))
 			    	rama_score=lp.CompRamachandranScore(ffCur.getPhi(),ffCur.getPsi(),vecRamaAla);
 			    else if(curResName.equalsIgnoreCase("GLY"))
 			    	rama_score=lp.CompRamachandranScore(ffCur.getPhi(),ffCur.getPsi(),vecRamaGly);
 			    else if(curResName.equalsIgnoreCase("PRO"))
 			    	rama_score=lp.CompRamachandranScore(ffCur.getPhi(),ffCur.getPsi(),vecRamaPro);
 			    else if(isPrePro)
 			    	rama_score=lp.CompRamachandranScore(ffCur.getPhi(),ffCur.getPsi(),this.vecRamaPrePro);
 			    else
 			    {
 			    	rama_score=lp.CompRamachandranScore(ffCur.getPhi(),ffCur.getPsi(),vecRamaGeneral);     			    	
 			    }
    			
    			if(rama_score<=0.02)
    				continue;						    		
	    		rama_score=-Math.log(rama_score);//Todo: add the update operation...	
	    		
	    		//variate the phi,psi angles of previous residue
    			for (int k=0;k<360/resolution;k++)
    			{
    				double phiPre=k*resolution* Math.PI / 180.0;
    				
    				for (int j=0;j<360/resolution;j++)
        			{
        				double psiPre=j*resolution* Math.PI / 180.0;
        				int inPre= Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo-1), new PhiPsi.PPComparator());
                	    PhiPsi ffPre = (PhiPsi)vecPhiPsiTemp.elementAt(inPre);
                	    ffPre.setPhi(phiPre);
                	    ffPre.setPsi(psiPre);
                	    
                	    //check the Rama region:                 		
                		curResName=lp.GetResNameFromSequence(this.vecSeq,curResNo-1);
                    	nextResName=lp.GetResNameFromSequence(this.vecSeq,curResNo);
                    	isPrePro=false;
                    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
                    		isPrePro=true;
                    	//check the Rama region:
            			rama_score=0.0;
            			if(curResName.equalsIgnoreCase("ALA"))
         			    	rama_score=lp.CompRamachandranScore(ffPre.getPhi(),ffPre.getPsi(),vecRamaAla);
         			    else if(curResName.equalsIgnoreCase("GLY"))
         			    	rama_score=lp.CompRamachandranScore(ffPre.getPhi(),ffPre.getPsi(),vecRamaGly);
         			    else if(curResName.equalsIgnoreCase("PRO"))
         			    	rama_score=lp.CompRamachandranScore(ffPre.getPhi(),ffPre.getPsi(),vecRamaPro);
         			    else if(isPrePro)
         			    	rama_score=lp.CompRamachandranScore(ffPre.getPhi(),ffPre.getPsi(),this.vecRamaPrePro);
         			    else
         			    {
         			    	rama_score=lp.CompRamachandranScore(ffPre.getPhi(),ffPre.getPsi(),vecRamaGeneral);     			    	
         			    }
            			
            			if(rama_score<=0.02)//use the allowed regions
            				continue;						    		
        	    		rama_score=-Math.log(rama_score);//Todo: add the update operation...
                	    
                		//build up the temp structure fragment        			
	        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
	        			pdbFragTemp0= mdc.modelBuildLoopBackward(vecPhiPsiTemp,coordN_fix,coordNH_fix,coordCA_fix,noStart+1,noEnd);			
	        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 	        			

	        			//////////////////////////////////
	        			//check the steric clash:
	        			boolean isAllClashFree=true;
	        			for(int resno=curResNo;resno>noStart+1;resno--)
	        			{
	        				
	        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno-1), new Pdb.PdbComparator());
	        				if (indTemp <0)
	        				{
	        					System.out.println("error: current residue not found...exist...");
	        					System.exit(0);		
	        				}			
	        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);
	        				Vector atomVecPre = pdbTemp.getAtomVec();
	        				double [] coordCA_pre = new double[3]; 	
	        				for (int h=0;h<atomVecPre.size();h++)
	        				{
	        					Cartesian cc = (Cartesian)atomVecPre.elementAt(h);
	        		    	    String atom = cc.getAtom();	   	 	        		    	   
	        		    	    if (atom.equalsIgnoreCase("CA"))
	        		    	    	coordCA_pre=cc.getXYZ();	        		    	       
	        				}//for (int k=0;k<atomVecStart.size();k++)
	        				
	        				boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_pre,1);       				
	        				if(isClash)
	        				{
	        					isAllClashFree=false;
	        					break;
	        				}
	        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
	        			if(!isAllClashFree)
	        				continue;   		
	        			
	        			/////////////////////////////////
	        			//check the rdc fit:
	        			boolean isAllRDCsSatisfied=true;
	        			for(int resno=curResNo;resno>noStart;resno--)
	        			{
	        				int indTemp= Collections.binarySearch(pdbFragTemp, new Pdb(resno), new Pdb.PdbComparator());
	        				if (indTemp <0)
	        				{
	        					System.out.println("error: current residue not found...exist...");
	        					System.exit(0);		
	        				}			
	        				Pdb pdbTemp = (Pdb)pdbFragTemp.elementAt(indTemp);	        				
	        				Vector vecPdbTemp=new Vector();	        				
	        				vecPdbTemp.add(pdbTemp);
	        				
	        				double chRdc=-99999.9;
	        				double nhRdc=-99999.9;
	        				int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(resno), new Dipolar.rdcComparator());
	        				if(indCH>-1)
	        					chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
	        				
	        				int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(resno), new Dipolar.rdcComparator());
	        				if(indNH>-1)
	        					nhRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
	        				
	        				if(nhRdc>-1000.0)
	            			{
	    	        			double nhRms = pdc.BackCalNHOne(vecPdbTemp, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
	    	        			if((nhRms>rdcRmsdBound))
	    	        			{
	    	        				isAllRDCsSatisfied=false;
	    	        				break;
	    	        			}
	    	        			
	            			}
	            			if(chRdc>-1000.0)
	            			{
	    	        			double chRms = pdc.BackCalOne(vecPdbTemp, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
	    	        			if(chRms>rdcRmsdBound)	
	    	        			{
	    	        				isAllRDCsSatisfied=false;
	    	        				break;
	    	        			}
	            			}       				

	        			}//for(int resno=curResNo+1;resno<noEnd;resno++)
	        			if(!isAllRDCsSatisfied)
	        				continue;   		

	        			
	        			//check the gap between another fixed residue:
	        			double[] dist=new double[1];
	        			dist[0]=99999.9;
	        			double error=100.0;
	
	        			int indStart= Collections.binarySearch(pdbFragTemp, new Pdb(noStart), new Pdb.PdbComparator());
	    				if (indStart <0)
	    				{
	    					System.out.println("error: end residue not found...exist...");
	    					System.exit(0);		
	    				}			
	    				Pdb pdbStart = (Pdb)pdbFragTemp.elementAt(indStart);
	    				
	    				CheckFirstResidue(pdbStart,noStart,1000.0,dist);	    				
	    				double distance=dist[0];
	
	    				if(distance<minDist)
	    				{
	    					minDist=distance;
	    					curPhiSave=phiCur;
	    					prePhiSave=phiPre;
	    					prePsiSave=psiPre;
	    					isChanged=true;
	    				}
	        			
        				
        			}//for (int j=0;j<360/resolution;j++)
    			}//for (int k=0;k<360/resolution;k++)
    			
    		}//for (int t=0;t<360/resolution;t++)
    		
    		if(isChanged)
    		{
	    		//update the new fragment with the smallest gap:
	    		int indCur = Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo), new PhiPsi.PPComparator());
	    	    PhiPsi ffCur = (PhiPsi)vecPhiPsiTemp.elementAt(indCur);
	    	    ffCur.setPhi(curPhiSave);
	    	    
	    	    int inPre= Collections.binarySearch(vecPhiPsiTemp, new PhiPsi(curResNo-1), new PhiPsi.PPComparator());
	    	    PhiPsi ffPre = (PhiPsi)vecPhiPsiTemp.elementAt(inPre);
	    	    ffPre.setPhi(prePhiSave);
	    	    ffPre.setPsi(prePsiSave);    	    
	    	    
	    	    Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
				pdbFragTemp0= mdc.modelBuildLoopBackward(vecPhiPsiTemp,coordN_fix,coordNH_fix,coordCA_fix,noStart+1,noEnd);			
				Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 	   			
				
				vecLoopTemp=new Vector();			
				vecLoopTemp.addAll(pdbFragTemp);
				vecLoopTemp.add(pdbFix);
				Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
    		}
			
			curResNo--;
		}//while(curResNo>=noStart+2)			
		}//end of iterations
		
		int indTemp0 = Collections.binarySearch(vecLoopTemp, new Pdb(noEnd+1), new Pdb.PdbComparator());		
		if(indTemp0>-1)
			vecLoopTemp.remove(indTemp0);
		
		int indTemp1 = Collections.binarySearch(vecLoopTemp, new Pdb(noStart), new Pdb.PdbComparator());		
		if(indTemp1>-1)
			vecLoopTemp.remove(indTemp1);
		
		int ind1 = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
		if(ind1>-1)
		{
			Pdb pdb1=(Pdb)this.vecPdbSSE.elementAt(ind1);
			vecLoopTemp.add(pdb1);
		}		
		
		Collections.sort(vecLoopTemp, new Pdb.PdbComparator());
		System.out.println("REMARK The final gap is: "+minDist );
		return vecLoopTemp;
	}

	/**compute possible phi/psi angles for current residue when the RDCs are missing. 
     * search the loop phi/psi angles over using grid search
     @param vecCurHalfPdb the set of all possible half planes for current residue
     @param curNo current residue number   
     @param chRdc,nhNextRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @return vecAllPdbs: for all residues
    */
	public boolean LoopCurResPhiPsiGridSearch(Vector vecCurHalfPdb, int curNo,int startResNo, int endResNo,double chRdc, double nhNextRdc,
			final Vector vecCurFullPdb, final Vector vecNextHalfPdb,boolean isLast)
	{
		double resolCluster=0.4;//cluster gap for cluster ca, n, hn atoms
		int topNum=500;//number of top planes that can be selected based on rama or rdc rmsd, default:500
		double rdcRmsdBound=this.rdcThreshold;//3.0;//4.0//rdc rmsd threshold for pruning bad solutions		
		double resolution=5.0;//resolution in the grid search (degree), 15
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,curNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
		Vector vecFinalPdb=new Vector();
		TreePdb FinalPdbS=new TreePdb();
		double minDist=999999.9;
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		
		
		int topSSEK=5;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 
		
	   //Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,curNo+1);//get the SSE anchors for current residue				
	
    	double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}
		//vecNextHalfPdb=new Vector();
		//vecCurFullPdb=new Vector();
		Vector vecCurPdbTemp=new Vector();
		Vector vecNextPdbTemp=new Vector();
				
		for(int i=0;i<vecCurHalfPdb.size();i++)
		{
			//coordinates of N, nh, ca of previous residue:
			double [] coordN  = new double[3];
			double [] coordNH = new double[3];
			double [] coordCA = new double[3]; 
			
			TreePdb pdbCurHalf=(TreePdb)vecCurHalfPdb.elementAt(i);		
			TreePdb curParent=(TreePdb)pdbCurHalf.parenPdb.elementAt(0);
			Vector vecPreChild=curParent.vecChildPdb;
			vecPreChild.remove(pdbCurHalf);//need to double check about this.
			//double preRdcRmsd=curParent.GetRdcRmsd();
			double preRamaScore=curParent.GetRamaScore();
			double pre_sum_rdc=curParent.GetSumRdcDif();
			
			Vector atomVecStart = pdbCurHalf.pdb.getAtomVec();
			for (int k=0;k<atomVecStart.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)
			
						
			//use grid search over phi/psi angles for current residue
			for (int k=0;k<360/resolution;k++)
    		{
    			double phiValue=k*resolution* Math.PI / 180.0;
    			
    	    	for (int j=0;j<360/resolution;j++)
    			{
    	    		double psiValue=j*resolution* Math.PI / 180.0;
        		
        			phiS[0]=phiValue;
        			psiS[0]=psiValue;        			
        		
        			///////////////////////////////////////
        			//check the Rama region:
        			double rama_score=0.0;
        			if(curResName.equalsIgnoreCase("ALA"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaAla);
     			    else if(curResName.equalsIgnoreCase("GLY"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGly);
     			    else if(curResName.equalsIgnoreCase("PRO"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaPro);
     			    else if(isPrePro)
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,this.vecRamaPrePro);
     			    else
     			    {
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGeneral);     			    	
     			    }
        			
        			if(rama_score<=0.02)
        				continue;
        			rama_score=-Math.log(rama_score);
        			
        			////////////////////
        			//for debugging...
        			//double degree_phi2=k*resolution;
        			//double degree_psi2=j*resolution;
        			//if( (curNo==19) && (degree_phi>=295) &&(degree_phi<=306)&& (degree_psi>=330) &&  (degree_psi<=340) )
        			//		System.out.println("we stop here...");
        			//////////////////////
        			
        			/////////////////////////////////////
        			//build up the temp structure fragment        			
        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
        			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, curNo, false);//first    			
        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
        			
        			Pdb curPdb= (Pdb)pdbFragTemp.elementAt(0);	
        			Pdb nextHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
        			int resNoNext=nextHalfPdb.getResidueNo();
        			Vector atomVecNext = nextHalfPdb.getAtomVec();
        			double [] coordN_next  = new double[3];
        			double [] coordNH_next = new double[3];
        			double [] coordCA_next = new double[3]; 	
        			for (int t=0;t<atomVecNext.size();t++)
        			{
        				Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
        	    	    String atom = cc.getAtom();	    	   
        	    	    if (atom.equalsIgnoreCase("N"))
        	    	    	coordN_next = cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("CA"))
        	    	    	coordCA_next=cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
        	    	    	coordNH_next = cc.getXYZ();		    
        			}//for (int k=0;k<atomVecStart.size();k++)		
        			
        			//1. check the steric clash between ca of the next residue and the SSEs:
        			//Note: this is a mild steric clash checking. It can 
        			//be extended to the more accurate approach
        			//check the steric clash between ca atom and SSEs(including side-chains)        			
        			//if(!isLast)
        			if(resNoNext<endResNo)        			
        			{
	        			boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_next,1);
						if(isClash)
							continue;
						
						
						//isClash=CheckClashBtwCaNPdb(pdbFragTemp,  curNo, coordCA_next,1);
						//if(isClash)
						//	continue;
						 
        			}//if(resNoNext<endResNo)
        			
					////////////////////////////////////////////////////
					//check whether the kin chain restraint is satified
        			if(resNoNext<=endResNo)
        			{
	        			double errorKin=0.6;
	        			//if(isLast )//&& Math.abs(startNo-endResNo)>8)
	        			if(resNoNext==endResNo)
	        				errorKin=this.gapThreshold;//3.0;//2.0 for long loops (> 8 residues)//////-1.0...
	        			else
	        				errorKin=1.0;//0.6
						boolean isKinChain=CheckKinChainRestraint(nextHalfPdb,endResNo,errorKin);
						if(!isKinChain)
						{
							//System.out.println("here we have one kin chain violation...");
							continue;
						}
        			}//if(resNoNext<=endResNo)
					
					/////////////////////////////////////////////////////////////////////
					//2. check whether ca of the next residue statisfies the NOE restraints.
					/*if(!isLast)
					{
						boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);					
						if(!isNOESatisfied)
							continue;
					}*/
        			       			
        			//3. check the RDC deviation. the dihedral angles are pruned if rdc rmsd is larger 
        			//than some threshold.
        			//at least one RDC (either CH in current residue or NH in next residue is missing),
        			//otherwise the RDC-EXACT search function will be called.
        			double Sxx=-this.Syy-this.Szz;
        			Vector vecCurPdb=new Vector();
        			Vector vecNextPdb=new Vector();
        			vecCurPdb.add(curPdb);
        			vecNextPdb.add(nextHalfPdb);
        			
        			double[] sRmsdCH= new double[1];
        			int[] sizeCH=new int[1];
        			double[] sRmsdNH=new double[1];
        			int[] sizeNH=new int[1];
        			double[] NhRdcCal  = new double[vecCurPdb.size()];
        			double[] ChRdcCal  = new double[vecCurPdb.size()];
        			double [][] mat = new double[3][3];
        			Matrix A = new Matrix(3,3);
        			for(int x=0;x<3;x++)
        			{
        				for(int y=0;y<3;y++)
        				{
        					if(x==y)
        						mat[x][y]=1;
        					else
        						mat[x][y]=0;
        				}
        			}
        			A = new Matrix(mat);
        			
        			double cur_sum_rdc=0.0;
        			double nhRms=-99999.9;
        			double chRms=-99999.9;
        				//double check the follosing functions...
        			if(nhNextRdc>-100.0)
        			{
	        			nhRms = pdc.BackCalNHOne(vecNextPdb, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
	        			if((nhRms>rdcRmsdBound))
	        				continue;
	        			cur_sum_rdc=cur_sum_rdc+nhRms;
        			}
        			if(chRdc>-100.0)
        			{
	        			chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
	        		
	        			if(chRms>rdcRmsdBound)	
	        				continue;
	        			cur_sum_rdc=cur_sum_rdc+chRms;
        			}
        			
        			////////////////////////////////////////////////////////
        			//4.if last residue in the loop, check the end residue:
        			double[] dist=new double[1];
        			double[] distCa=new double[1];
        			dist[0]=99999.9;
        			distCa[0]=99999.9;
        			
        			if(isLast)
        			{        				
        				double error=this.gapThreshold;//3.0;//1.5;
        				int endNo=curPdb.getResidueNo();
        				boolean isClose=CheckLastResidue(curPdb,endNo,error,dist,distCa);
        				
        				if(!isClose)
        					continue;
        				
        			}
        			
        			//save the full pdb for current residue
        			TreePdb curTreePdb=new TreePdb(curPdb);
        			//curTreePdb.SetRdcRmsd(preRdcRmsd+rdcRmsd);
        			curTreePdb.SetNhRdcDif(nhRms);
        			curTreePdb.SetChRdcDif(chRms);
        			curTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			curTreePdb.SetRamaScore(preRamaScore+rama_score);
        			curTreePdb.SetEndDist(distCa[0]);
        			
        			vecPreChild.add(curTreePdb);
        			curTreePdb.parenPdb.add(curParent);        			
        			vecCurPdbTemp.add(curTreePdb);
        			
        			//save the possible pdbs for the next residue
        			TreePdb nextHalfTreePdb=new TreePdb(nextHalfPdb);        			
        			//nextHalfTreePdb.SetRdcRmsd(preRdcRmsd+rdcRmsd);//for next residue, the rdc rmsd will be updated later
        			nextHalfTreePdb.SetNhRdcDif(nhRms);
        			nextHalfTreePdb.SetChRdcDif(chRms);
        			nextHalfTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			nextHalfTreePdb.SetRamaScore(preRamaScore+rama_score);
        			nextHalfTreePdb.SetEndDist(distCa[0]);
        			
        			curTreePdb.vecChildPdb.add(nextHalfTreePdb);
        			nextHalfTreePdb.parenPdb.add(curTreePdb);        			
        			vecNextPdbTemp.add(nextHalfTreePdb);  
        			
        			if(distCa[0]<minDist)
    				{
    					minDist=distCa[0];
    					FinalPdbS=new TreePdb(curTreePdb);
    				}
        			
        			/*if(vecNextPdbTemp.size()>this.maxLeafNodes)
        			{
        				PlaneClustering(resolCluster,vecCurPdbTemp,vecNextPdbTemp);
        				//if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
        					//PlaneClusteringAndTopSelectionNOEs(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum,startResNo,true);
        				
        					//PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum);
        			}*/
    			}//for (int j=0;j<360/resolution;j++)
    		}//for (int k=0;k<360/resolution;k++)			
		}//for(int i=0;i<vecCurHalfPdb.size();i++)	 	
		
		if(curNo==37)
			System.out.println("stop here...debugging");
		
	
		//do the clustering step:		
		Vector vecIndex=new Vector();
		if(vecCurPdbTemp.size()>0)
			PlaneClustering(resolCluster,vecCurPdbTemp,vecNextPdbTemp);
		else
			return false;
		
		if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
			PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum);
		
	/*	if(  (curNo==67))
			PlaneClusteringAndTopSelectionNOEs(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum,startResNo,true);
		else
		{	
			if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
				PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum);				
		}*/
		
		Vector vecCurPdbTempSorted=new Vector();
		vecCurPdbTempSorted.addAll(vecCurPdbTemp);
		Collections.sort(vecCurPdbTempSorted, new Goal.TreePdbNOEComparator());
		
		/*if(curNo>=37)
		{
			System.out.println("--------------------------------");
			System.out.println("---Now is resiude number: "+ curNo);
			
			OutputEnsemblePdbs( vecCurPdbTempSorted,startResNo,endResNo,  8.0);//debugging
		}*/
		
		vecNextHalfPdb.addAll(vecNextPdbTemp);
		vecCurFullPdb.addAll(vecCurPdbTemp);
		
		vecCurHalfPdb=new Vector();//free space
		vecFinalPdb.add(FinalPdbS);
		//return vecFinalPdb;
		return true;
		
	}
	/**compute possible phi/psi angles with min RDC RMSD
	 * similar to LoopCurResPhiPsiGridSearch function. 
     * search the loop phi/psi angles over using grid search
     @param vecCurHalfPdb the set of all possible half planes for current residue
     @param curNo current residue number   
     @param chRdc,nhNextRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @param topNodes top number of leaf nodes 
     @return vecAllPdbs: for all residues
    
    */
	public boolean CurPhiPsiGridForwardMinRdcRmsd(Vector vecCurHalfPdb, int curNo,int startResNo, int endResNo,double chRdc, double nhNextRdc,
			final Vector vecCurFullPdb, final Vector vecNextHalfPdb,boolean isLast,int topNodes)
	{
		double resolCluster=0.4;//cluster gap for cluster ca, n, hn atoms
		int topNum=500;//number of top planes that can be selected based on rama or rdc rmsd
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,curNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
		Vector vecFinalPdb=new Vector();
		TreePdb FinalPdbS=new TreePdb();
		double minDist=999999.9;
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		
		double resolution=15.0;//resolution in the grid search
		int topSSEK=5;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 
		double rdcRmsdBound=20.0;//4.0//rdc rmsd threshold for pruning bad solutions		
	   //Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,curNo+1);//get the SSE anchors for current residue				
	
    	double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}
		//vecNextHalfPdb=new Vector();
		//vecCurFullPdb=new Vector();
		Vector vecCurPdbTemp=new Vector();
		Vector vecNextPdbTemp=new Vector();
				
		for(int i=0;i<vecCurHalfPdb.size();i++)
		{
			//coordinates of N, nh, ca of previous residue:
			double [] coordN  = new double[3];
			double [] coordNH = new double[3];
			double [] coordCA = new double[3]; 
			
			TreePdb pdbCurHalf=(TreePdb)vecCurHalfPdb.elementAt(i);		
			TreePdb curParent=(TreePdb)pdbCurHalf.parenPdb.elementAt(0);
			Vector vecPreChild=curParent.vecChildPdb;
			vecPreChild.remove(pdbCurHalf);//need to double check about this.
			//double preRdcRmsd=curParent.GetRdcRmsd();
			double preRamaScore=curParent.GetRamaScore();
			double pre_sum_rdc=curParent.GetSumRdcDif();
			
			Vector atomVecStart = pdbCurHalf.pdb.getAtomVec();
			for (int k=0;k<atomVecStart.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)
			
						
			//use grid search over phi/psi angles for current residue
			for (int k=0;k<360/resolution;k++)
    		{
    			double phiValue=k*resolution* Math.PI / 180.0;
    			
    	    	for (int j=0;j<360/resolution;j++)
    			{
    	    		double psiValue=j*resolution* Math.PI / 180.0;
        		
        			phiS[0]=phiValue;
        			psiS[0]=psiValue;        			
        		
        			///////////////////////////////////////
        			//check the Rama region:
        			double rama_score=0.0;
        			if(curResName.equalsIgnoreCase("ALA"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaAla);
     			    else if(curResName.equalsIgnoreCase("GLY"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGly);
     			    else if(curResName.equalsIgnoreCase("PRO"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaPro);
     			    else if(isPrePro)
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,this.vecRamaPrePro);
     			    else
     			    {
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGeneral);     			    	
     			    }
        			
        			if(rama_score<=0.02)
        				continue;
        			rama_score=-Math.log(rama_score);
        			
        			////////////////////
        			//for debugging...
        			//double degree_phi2=k*resolution;
        			//double degree_psi2=j*resolution;
        			//if( (curNo==19) && (degree_phi>=295) &&(degree_phi<=306)&& (degree_psi>=330) &&  (degree_psi<=340) )
        			//		System.out.println("we stop here...");
        			//////////////////////
        			
        			/////////////////////////////////////
        			//build up the temp structure fragment        			
        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
        			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, curNo, false);//first    			
        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
        			
        			Pdb curPdb= (Pdb)pdbFragTemp.elementAt(0);	
        			Pdb nextHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
        			Vector atomVecNext = nextHalfPdb.getAtomVec();
        			double [] coordN_next  = new double[3];
        			double [] coordNH_next = new double[3];
        			double [] coordCA_next = new double[3]; 	
        			for (int t=0;t<atomVecNext.size();t++)
        			{
        				Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
        	    	    String atom = cc.getAtom();	    	   
        	    	    if (atom.equalsIgnoreCase("N"))
        	    	    	coordN_next = cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("CA"))
        	    	    	coordCA_next=cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
        	    	    	coordNH_next = cc.getXYZ();		    
        			}//for (int k=0;k<atomVecStart.size();k++)		
        			
        			//1. check the steric clash between ca of the next residue and the SSEs:
        			//Note: this is a mild steric clash checking. It can 
        			//be extended to the more accurate approach
        			//check the steric clash between ca atom and SSEs(including side-chains)        			
        			if(!isLast)
        			{
	        			boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_next,1);
						if(isClash)
							continue;
        			}
        			
					////////////////////////////////////////////////////
					//check whether the kin chain restraint is satified
        			double errorKin=0.6;
        			if(isLast )//&& Math.abs(startNo-endResNo)>8)
        				errorKin=this.gapThreshold;//3.0;//2.0 for long loops (> 8 residues)
        			else
        				errorKin=1.0;//0.6
					boolean isKinChain=CheckKinChainRestraint(nextHalfPdb,endResNo,errorKin);
					if(!isKinChain)
					{
						//System.out.println("here we have one kin chain violation...");
						continue;
					}
					
					/////////////////////////////////////////////////////////////////////
					//2. check whether ca of the next residue statisfies the NOE restraints.
					/*if(!isLast)
					{
						boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);					
						if(!isNOESatisfied)
							continue;
					}*/
        			       			
        			//3. check the RDC deviation. the dihedral angles are pruned if rdc rmsd is larger 
        			//than some threshold.
        			//at least one RDC (either CH in current residue or NH in next residue is missing),
        			//otherwise the RDC-EXACT search function will be called.
        			double Sxx=-this.Syy-this.Szz;
        			Vector vecCurPdb=new Vector();
        			Vector vecNextPdb=new Vector();
        			vecCurPdb.add(curPdb);
        			vecNextPdb.add(nextHalfPdb);
        			
        			double[] sRmsdCH= new double[1];
        			int[] sizeCH=new int[1];
        			double[] sRmsdNH=new double[1];
        			int[] sizeNH=new int[1];
        			double[] NhRdcCal  = new double[vecCurPdb.size()];
        			double[] ChRdcCal  = new double[vecCurPdb.size()];
        			double [][] mat = new double[3][3];
        			Matrix A = new Matrix(3,3);
        			for(int x=0;x<3;x++)
        			{
        				for(int y=0;y<3;y++)
        				{
        					if(x==y)
        						mat[x][y]=1;
        					else
        						mat[x][y]=0;
        				}
        			}
        			A = new Matrix(mat);
        			
        			double cur_sum_rdc=0.0;
        			double nhRms=-99999.9;
        			double chRms=-99999.9;
        				//double check the follosing functions...
        			if(nhNextRdc>-100.0)
        			{
	        			nhRms = pdc.BackCalNHOne(vecNextPdb, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
	        			if((nhRms>rdcRmsdBound))
	        				continue;
	        			cur_sum_rdc=cur_sum_rdc+nhRms;
        			}
        			if(chRdc>-100.0)
        			{
	        			chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
	        		
	        			if(chRms>rdcRmsdBound)	
	        				continue;
	        			cur_sum_rdc=cur_sum_rdc+chRms;
        			}
        			
        			//4.if last residue in the loop, check the end residue:
        			double[] dist=new double[1];
        			double[] distCa=new double[1];
        			dist[0]=99999.9;
        			distCa[0]=99999.9;
        			
        			if(isLast)
        			{        				
        				double error=this.gapThreshold;//3.0;//1.5;
        				int endNo=nextHalfPdb.getResidueNo();
        				boolean isClose=CheckLastResidue(nextHalfPdb,endNo,error,dist,distCa);
        				
        				if(!isClose)
        					continue;
        				
        			}
        			
        			//save the full pdb for current residue
        			TreePdb curTreePdb=new TreePdb(curPdb);
        			//curTreePdb.SetRdcRmsd(preRdcRmsd+rdcRmsd);
        			curTreePdb.SetNhRdcDif(nhRms);
        			curTreePdb.SetChRdcDif(chRms);
        			curTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			curTreePdb.SetRamaScore(preRamaScore+rama_score);
        			curTreePdb.SetEndDist(distCa[0]);
        			
        			vecPreChild.add(curTreePdb);
        			curTreePdb.parenPdb.add(curParent);        			
        			vecCurPdbTemp.add(curTreePdb);
        			
        			//save the possible pdbs for the next residue
        			TreePdb nextHalfTreePdb=new TreePdb(nextHalfPdb);        			
        			//nextHalfTreePdb.SetRdcRmsd(preRdcRmsd+rdcRmsd);//for next residue, the rdc rmsd will be updated later
        			nextHalfTreePdb.SetNhRdcDif(nhRms);
        			nextHalfTreePdb.SetChRdcDif(chRms);
        			nextHalfTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			nextHalfTreePdb.SetRamaScore(preRamaScore+rama_score);
        			nextHalfTreePdb.SetEndDist(distCa[0]);
        			
        			curTreePdb.vecChildPdb.add(nextHalfTreePdb);
        			nextHalfTreePdb.parenPdb.add(curTreePdb);        			
        			vecNextPdbTemp.add(nextHalfTreePdb);  
        			
        			if(distCa[0]<minDist)
    				{
    					minDist=distCa[0];
    					FinalPdbS=new TreePdb(curTreePdb);
    				}
        			
        			if(vecNextPdbTemp.size()>this.maxLeafNodes)
        			{
        				PlaneClusteringBackward(resolCluster,vecCurPdbTemp,vecNextPdbTemp);
        				if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
        					PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum);
        			}
    			}//for (int j=0;j<360/resolution;j++)
    		}//for (int k=0;k<360/resolution;k++)			
		}//for(int i=0;i<vecCurHalfPdb.size();i++)	 	
		
		//select the node with min rdc rmsd:
		Vector vecCurTreePdbNew=new Vector();		
		Collections.sort(vecCurPdbTemp, new Goal.TreePdbRDCComparator());
		for(int i=0;i<Math.min(topNodes, vecCurPdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecCurPdbTemp.elementAt(i);
			vecCurTreePdbNew.add(treePdb);
		}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
		
		Vector vecNextTreePdbNew=new Vector();
		Collections.sort(vecNextPdbTemp, new Goal.TreePdbRDCComparator());
		for(int i=0;i<Math.min(topNodes, vecNextPdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecNextPdbTemp.elementAt(i);
			vecNextTreePdbNew.add(treePdb);
		}//
			
		vecNextHalfPdb.addAll(vecNextTreePdbNew);
		vecCurFullPdb.addAll(vecCurTreePdbNew);
		
		vecCurHalfPdb=new Vector();//free space
		vecFinalPdb.add(FinalPdbS);
		//return vecFinalPdb;
		if(vecCurFullPdb.size()>0)
			return true;
		else
			return false;
		
	}

	/**compute possible phi/psi angles with min RDC RMSD
	 * similar to LoopCurResPhiPsiGridSearch function. 
     * search the loop phi/psi angles over using grid search
     @param vecCurHalfPdb the set of all possible half planes for current residue
     @param curNo current residue number   
     @param chRdc,nhNextRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isFirst whether this is the first residue in the loop.
     @param topNodes top number of leaf nodes 
     @return vecAllPdbs: for all residues
    
    */
	public boolean CurPhiPsiGridBackwardMinRdcRmsd(Vector vecCurHalfPdb, int curNo,int startNo,int lastNo,double chRdc, double nhRdc,
			final Vector vecCurFullPdb, final Vector vecPreHalfPdb,boolean isFirst,int topNodes)
	{
		double resolCluster=0.4;//cluster gap for cluster ca, n, hn atoms
		int topNum=500;//number of top planes that can be selected based on rama or rdc rmsd
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,curNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
		Vector vecFinalPdb=new Vector();
		TreePdb FinalPdbS=new TreePdb();
		double minDist=999999.9;
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		
		double resolution=15.0;//resolution in the grid search
		int topSSEK=5;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 
		double rdcRmsdBound=100.0;//4.0//rdc rmsd threshold for pruning bad solutions		
	    //Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,curNo+1);//get the SSE anchors for current residue		
    	
		//vecNextHalfPdb=new Vector();
		//vecCurFullPdb=new Vector();
		Vector vecCurPdbTemp=new Vector();
		Vector vecPrePdbTemp=new Vector();
				
		for(int i=0;i<vecCurHalfPdb.size();i++)
		{
			//coordinates of N, nh, ca of next residue:
			double [] coordN  = new double[3];
			double [] coordNH = new double[3];
			double [] coordCA = new double[3]; 
			
			TreePdb pdbCurHalf=(TreePdb)vecCurHalfPdb.elementAt(i);		
			TreePdb curParent=(TreePdb)pdbCurHalf.parenPdb.elementAt(0);
			Vector vecPreChild=curParent.vecChildPdb;
			vecPreChild.remove(pdbCurHalf);//need to double check about this.
			//double preRdcRmsd=curParent.GetRdcRmsd();
			double preRamaScore=curParent.GetRamaScore();
			double pre_sum_rdc=curParent.GetSumRdcDif();
			
			TreePdb treePdbNext=(TreePdb)pdbCurHalf.parenPdb.elementAt(0);				
			Vector atomVecStart = treePdbNext.pdb.getAtomVec();
			for (int k=0;k<atomVecStart.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)			
						
			//use grid search over phi/psi angles for current residue
			for (int k=0;k<360/resolution;k++)
    		{
    			double phiValue=k*resolution* Math.PI / 180.0;
    			
    	    	for (int j=0;j<360/resolution;j++)
    			{
    	    		double psiValue=j*resolution* Math.PI / 180.0;
        			
        			///////////////////////////////////////
        			//check the Rama region:
        			double rama_score=0.0;
        			if(curResName.equalsIgnoreCase("ALA"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaAla);
     			    else if(curResName.equalsIgnoreCase("GLY"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGly);
     			    else if(curResName.equalsIgnoreCase("PRO"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaPro);
     			    else if(isPrePro)
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,this.vecRamaPrePro);
     			    else
     			    {
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGeneral);     			    	
     			    }
        			
        			if(rama_score<=0.02)
        				continue;
        			rama_score=-Math.log(rama_score);        			
        			
        			/////////////////////////////////////
        			//build up the temp structure fragment        			
        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
        			//pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, curNo, false);//first    			
        			pdbFragTemp0=mdc.coordByBackwardNew(phiValue, psiValue, coordN, coordNH,coordCA, curNo);
        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
        			
        			Pdb curPdb= (Pdb)pdbFragTemp.elementAt(1);	
        			Pdb preHalfPdb= (Pdb)pdbFragTemp.elementAt(0);	
        			Vector atomVecPre = preHalfPdb.getAtomVec();
        			double [] coordN_pre  = new double[3];
        			double [] coordNH_pre = new double[3];
        			double [] coordCA_pre = new double[3]; 	
        			for (int t=0;t<atomVecPre.size();t++)
        			{
        				Cartesian cc = (Cartesian)atomVecPre.elementAt(t);
        	    	    String atom = cc.getAtom();	    	   
        	    	    if (atom.equalsIgnoreCase("N"))
        	    	    	coordN_pre = cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("CA"))
        	    	    	coordCA_pre=cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
        	    	    	coordNH_pre = cc.getXYZ();		    
        			}//for (int k=0;k<atomVecStart.size();k++)		
		
        			
        			//1. check the steric clash between ca of the next residue and the SSEs:
        			//Note: this is a mild steric clash checking. It can 
        			//be extended to the more accurate approach
        			//check the steric clash between ca atom and SSEs(including side-chains)        			
        			if(!isFirst)
        			{
	        			boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_pre,1);
						if(isClash)
							continue;
        			}
        			
					////////////////////////////////////////////////////
					//check whether the kin chain restraint is satified
        			double errorKin=0.6;
        			if(isFirst )//&& Math.abs(lastNo-startNo)>8)
        				errorKin=this.gapThreshold;//2.0;//for long loops (> 8 residues)
        			else
        				errorKin=1.0;//0.6;
					boolean isKinChain=CheckKinChainRestraintBackward(preHalfPdb,startNo,errorKin);
					if(!isKinChain)
					{
						//System.out.println("here we have one kin chain violation...");
						continue;
					}
					
					/////////////////////////////////////////////////////////////////////
					//2. check whether ca of the next residue statisfies the NOE restraints.
					/*if(!isLast)
					{
						boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);					
						if(!isNOESatisfied)
							continue;
					}*/
        			       			
        			//3. check the RDC deviation. the dihedral angles are pruned if rdc rmsd is larger 
        			//than some threshold.
        			//at least one RDC (either CH in current residue or NH in next residue is missing),
        			//otherwise the RDC-EXACT search function will be called.
        			double Sxx=-this.Syy-this.Szz;
        			Vector vecCurPdb=new Vector();        			
        			vecCurPdb.add(curPdb);       			
        			
        			double[] sRmsdCH= new double[1];
        			int[] sizeCH=new int[1];
        			double[] sRmsdNH=new double[1];
        			int[] sizeNH=new int[1];
        			double[] NhRdcCal  = new double[vecCurPdb.size()];
        			double[] ChRdcCal  = new double[vecCurPdb.size()];
        			double [][] mat = new double[3][3];
        			Matrix A = new Matrix(3,3);
        			for(int x=0;x<3;x++)
        			{
        				for(int y=0;y<3;y++)
        				{
        					if(x==y)
        						mat[x][y]=1;
        					else
        						mat[x][y]=0;
        				}
        			}
        			A = new Matrix(mat);       			
        			
        			double cur_sum_rdc=0.0;
        			double nhRms=-99999.9;
        			double chRms=-99999.9;
        				
        			if(nhRdc>-1000.0)
        			{
	        			nhRms = pdc.BackCalNHOne(vecCurPdb, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
	        			if((nhRms>rdcRmsdBound))
	        				continue;	 
	        			cur_sum_rdc=cur_sum_rdc+nhRms;
        			}
        			if(chRdc>-1000.0)
        			{
	        			chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
	        			if(chRms>rdcRmsdBound)	
	        				continue;	 
	        			cur_sum_rdc=cur_sum_rdc+chRms;
        			}
        			
        			//4.if last residue in the loop, check the end residue:
        			double[] dist=new double[1];
        			double[] distCa=new double[1];
        			dist[0]=99999.9;
        			distCa[0]=99999.9;
        			
        			if(isFirst)
        			{        				
        				double error=this.gapThreshold;//1.5;//4.5;
        				int fixNo=preHalfPdb.getResidueNo();
        				boolean isClose=CheckFirstResidue(preHalfPdb,fixNo,error,dist,distCa);
        				
        				if(!isClose)
        					continue;
        				
        			}
        			
        			//save the full pdb for current residue
        			TreePdb curTreePdb=new TreePdb(curPdb);
        			
        			curTreePdb.SetNhRdcDif(nhRms);
        			curTreePdb.SetChRdcDif(chRms);
        			curTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			curTreePdb.SetRamaScore(preRamaScore+rama_score);
        			curTreePdb.SetEndDist(distCa[0]);
        			
        			vecPreChild.add(curTreePdb);
        			curTreePdb.parenPdb.add(curParent);        			
        			vecCurPdbTemp.add(curTreePdb);
        			
        			//save the possible pdbs for the next residue
        			TreePdb preHalfTreePdb=new TreePdb(preHalfPdb);        			
        			preHalfTreePdb.SetNhRdcDif(nhRms);
        			preHalfTreePdb.SetChRdcDif(chRms);
        			preHalfTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			preHalfTreePdb.SetRamaScore(preRamaScore+rama_score);
        			preHalfTreePdb.SetEndDist(distCa[0]);
        			
        			curTreePdb.vecChildPdb.add(preHalfTreePdb);
        			preHalfTreePdb.parenPdb.add(curTreePdb);        			
        			vecPrePdbTemp.add(preHalfTreePdb);  
        			
        			if(distCa[0]<minDist)
    				{
    					minDist=distCa[0];
    					FinalPdbS=new TreePdb(curTreePdb);
    				}
        			
        			if(vecPrePdbTemp.size()>this.maxLeafNodes)
        			{
        				PlaneClusteringBackward(resolCluster,vecCurPdbTemp,vecPrePdbTemp);
        				if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
        					PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum);
        			}
    			}//for (int j=0;j<360/resolution;j++)
    		}//for (int k=0;k<360/resolution;k++)			
		}//for(int i=0;i<vecCurHalfPdb.size();i++)	 	
		
		//select the node with min rdc rmsd:
		Vector vecCurTreePdbNew=new Vector();		
		Collections.sort(vecCurPdbTemp, new Goal.TreePdbRDCComparator());
		for(int i=0;i<Math.min(topNodes, vecCurPdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecCurPdbTemp.elementAt(i);
			vecCurTreePdbNew.add(treePdb);
		}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
		
		Vector vecPreTreePdbNew=new Vector();
		Collections.sort(vecPrePdbTemp, new Goal.TreePdbRDCComparator());
		for(int i=0;i<Math.min(topNodes, vecPrePdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecPrePdbTemp.elementAt(i);
			vecPreTreePdbNew.add(treePdb);
		}//
				
		vecPreHalfPdb.addAll(vecPreTreePdbNew);
		vecCurFullPdb.addAll(vecCurTreePdbNew);
		
		vecCurHalfPdb=new Vector();//free space
		vecFinalPdb.add(FinalPdbS);
		//return vecFinalPdb;
		if(vecCurFullPdb.size()>0)
			return true;
		else
			return false;
		
	}
	/**compute possible phi/psi angles for current residue when the RDCs are missing. 
     * search the loop phi/psi angles over using grid search
     @param vecCurHalfPdb the set of all possible half planes for current residue
     @param curNo current residue number   
     @param chRdc,nhRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @return vecAllPdbs: for all residues
    */
	public boolean LoopCurResPhiPsiGridSearchBackward(Vector vecCurHalfPdb, int curNo,int startNo,int lastNo,double chRdc, double nhRdc,
			final Vector vecCurFullPdb, final Vector vecPreHalfPdb,boolean isFirst)
	{
		double resolCluster=0.4;//cluster gap for cluster ca, n, hn atoms
		int topNum=500;//number of top planes that can be selected based on rama or rdc rmsd
		double resolution=15.0;//resolution in the grid search (degree)
		double rdcRmsdBound=this.rdcThreshold;//2.0;//4.0//rdc rmsd threshold for pruning bad solutions		
		
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,curNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
		Vector vecFinalPdb=new Vector();
		TreePdb FinalPdbS=new TreePdb();
		double minDist=999999.9;
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		
		
		int topSSEK=5;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 
		
	    //Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,curNo+1);//get the SSE anchors for current residue		
    	
		//vecNextHalfPdb=new Vector();
		//vecCurFullPdb=new Vector();
		Vector vecCurPdbTemp=new Vector();
		Vector vecPrePdbTemp=new Vector();
				
		for(int i=0;i<vecCurHalfPdb.size();i++)
		{
			//coordinates of N, nh, ca of next residue:
			double [] coordN  = new double[3];
			double [] coordNH = new double[3];
			double [] coordCA = new double[3]; 
			
			TreePdb pdbCurHalf=(TreePdb)vecCurHalfPdb.elementAt(i);		
			TreePdb curParent=(TreePdb)pdbCurHalf.parenPdb.elementAt(0);
			Vector vecPreChild=curParent.vecChildPdb;
			vecPreChild.remove(pdbCurHalf);//need to double check about this.
			//double preRdcRmsd=curParent.GetRdcRmsd();
			double preRamaScore=curParent.GetRamaScore();
			double pre_sum_rdc=curParent.GetSumRdcDif();
			
			TreePdb treePdbNext=(TreePdb)pdbCurHalf.parenPdb.elementAt(0);				
			Vector atomVecStart = treePdbNext.pdb.getAtomVec();
			for (int k=0;k<atomVecStart.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)			
						
			//use grid search over phi/psi angles for current residue
			for (int k=0;k<360/resolution;k++)
    		{
    			double phiValue=k*resolution* Math.PI / 180.0;
    			
    	    	for (int j=0;j<360/resolution;j++)
    			{
    	    		double psiValue=j*resolution* Math.PI / 180.0;
        			
        			///////////////////////////////////////
        			//check the Rama region:
        			double rama_score=0.0;
        			if(curResName.equalsIgnoreCase("ALA"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaAla);
     			    else if(curResName.equalsIgnoreCase("GLY"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGly);
     			    else if(curResName.equalsIgnoreCase("PRO"))
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaPro);
     			    else if(isPrePro)
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,this.vecRamaPrePro);
     			    else
     			    {
     			    	rama_score=lp.CompRamachandranScore(phiValue,psiValue,vecRamaGeneral);     			    	
     			    }
        			
        			if(rama_score<=0.02)
        				continue;
        			rama_score=-Math.log(rama_score);        			
        			
        			/////////////////////////////////////
        			//build up the temp structure fragment        			
        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
        			//pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, curNo, false);//first    			
        			pdbFragTemp0=mdc.coordByBackwardNew(phiValue, psiValue, coordN, coordNH,coordCA, curNo);
        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
        			
        			Pdb curPdb= (Pdb)pdbFragTemp.elementAt(1);	
        			Pdb preHalfPdb= (Pdb)pdbFragTemp.elementAt(0);
        			int resNoPre=preHalfPdb.getResidueNo();
        			Vector atomVecPre = preHalfPdb.getAtomVec();
        			double [] coordN_pre  = new double[3];
        			double [] coordNH_pre = new double[3];
        			double [] coordCA_pre = new double[3]; 	
        			for (int t=0;t<atomVecPre.size();t++)
        			{
        				Cartesian cc = (Cartesian)atomVecPre.elementAt(t);
        	    	    String atom = cc.getAtom();	    	   
        	    	    if (atom.equalsIgnoreCase("N"))
        	    	    	coordN_pre = cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("CA"))
        	    	    	coordCA_pre=cc.getXYZ();
        	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
        	    	    	coordNH_pre = cc.getXYZ();		    
        			}//for (int k=0;k<atomVecStart.size();k++)		
		
        			
        			//1. check the steric clash between ca of the next residue and the SSEs:
        			//Note: this is a mild steric clash checking. It can 
        			//be extended to the more accurate approach
        			//check the steric clash between ca atom and SSEs(including side-chains)        			
        			//if(!isFirst)
        			if(resNoPre>startNo)
        			{
	        			boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_pre,1);
						if(isClash)
							continue;
        			}
        			
					////////////////////////////////////////////////////
					//check whether the kin chain restraint is satified
        			if(resNoPre>=startNo)
        			{
	        			double errorKin=0.6;
	        			//if(isFirst )//&& Math.abs(lastNo-startNo)>8)
	        			if(resNoPre==startNo)
	        				errorKin=this.gapThreshold;//2.0;//for long loops (> 8 residues)
	        			else
	        				errorKin=1.0;//0.6;
						boolean isKinChain=CheckKinChainRestraintBackward(preHalfPdb,startNo,errorKin);
						if(!isKinChain)
						{
							//System.out.println("here we have one kin chain violation...");
							continue;
						}
        			}
					
					/////////////////////////////////////////////////////////////////////
					//2. check whether ca of the next residue statisfies the NOE restraints.
					/*if(!isLast)
					{
						boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);					
						if(!isNOESatisfied)
							continue;
					}*/
        			       			
        			//3. check the RDC deviation. the dihedral angles are pruned if rdc rmsd is larger 
        			//than some threshold.
        			//at least one RDC (either CH in current residue or NH in next residue is missing),
        			//otherwise the RDC-EXACT search function will be called.
        			double Sxx=-this.Syy-this.Szz;
        			Vector vecCurPdb=new Vector();        			
        			vecCurPdb.add(curPdb);       			
        			
        			double[] sRmsdCH= new double[1];
        			int[] sizeCH=new int[1];
        			double[] sRmsdNH=new double[1];
        			int[] sizeNH=new int[1];
        			double[] NhRdcCal  = new double[vecCurPdb.size()];
        			double[] ChRdcCal  = new double[vecCurPdb.size()];
        			double [][] mat = new double[3][3];
        			Matrix A = new Matrix(3,3);
        			for(int x=0;x<3;x++)
        			{
        				for(int y=0;y<3;y++)
        				{
        					if(x==y)
        						mat[x][y]=1;
        					else
        						mat[x][y]=0;
        				}
        			}
        			A = new Matrix(mat);       			
        			
        			double cur_sum_rdc=0.0;
        			double nhRms=-99999.9;
        			double chRms=-99999.9;
        				
        			if(nhRdc>-1000.0)
        			{
	        			nhRms = pdc.BackCalNHOne(vecCurPdb, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
	        			if((nhRms>rdcRmsdBound))
	        				continue;	 
	        			cur_sum_rdc=cur_sum_rdc+nhRms;
        			}
        			if(chRdc>-1000.0)
        			{
	        			chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
	        			if(chRms>rdcRmsdBound)	
	        				continue;	 
	        			cur_sum_rdc=cur_sum_rdc+chRms;
        			}
        			
        			//4.if last residue in the loop, check the end residue:
        			double[] dist=new double[1];
        			double[] distCa=new double[1];
        			dist[0]=99999.9;
        			distCa[0]=99999.9;
        			
        			if(isFirst)
        			{        				
        				double error=this.gapThreshold;//+1.0;
        				int fixNo=curPdb.getResidueNo();
        				boolean isClose=CheckFirstResidue(curPdb,fixNo,error,dist,distCa);
        				
        				if(!isClose)
        					continue;
        				
        			}
        			
        			//save the full pdb for current residue
        			TreePdb curTreePdb=new TreePdb(curPdb);
        			
        			curTreePdb.SetNhRdcDif(nhRms);
        			curTreePdb.SetChRdcDif(chRms);
        			curTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			curTreePdb.SetRamaScore(preRamaScore+rama_score);
        			curTreePdb.SetEndDist(distCa[0]);
        			
        			vecPreChild.add(curTreePdb);
        			curTreePdb.parenPdb.add(curParent);        			
        			vecCurPdbTemp.add(curTreePdb);
        			
        			//save the possible pdbs for the next residue
        			TreePdb preHalfTreePdb=new TreePdb(preHalfPdb);        			
        			preHalfTreePdb.SetNhRdcDif(nhRms);
        			preHalfTreePdb.SetChRdcDif(chRms);
        			preHalfTreePdb.SetSumRdcDif(pre_sum_rdc+cur_sum_rdc);
        			
        			preHalfTreePdb.SetRamaScore(preRamaScore+rama_score);
        			preHalfTreePdb.SetEndDist(distCa[0]);
        			
        			curTreePdb.vecChildPdb.add(preHalfTreePdb);
        			preHalfTreePdb.parenPdb.add(curTreePdb);        			
        			vecPrePdbTemp.add(preHalfTreePdb);  
        			
        			if(distCa[0]<minDist)
    				{
    					minDist=distCa[0];
    					FinalPdbS=new TreePdb(curTreePdb);
    				}
        			
        			/*if(vecPrePdbTemp.size()>this.maxLeafNodes)
        			{
        				PlaneClusteringBackward(resolCluster,vecCurPdbTemp,vecPrePdbTemp);
        				//if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
        					//PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum);
        			}*/
    			}//for (int j=0;j<360/resolution;j++)
    		}//for (int k=0;k<360/resolution;k++)			
		}//for(int i=0;i<vecCurHalfPdb.size();i++)	 	
		
		//do the clustering step:		
		Vector vecIndex=new Vector();
		if(vecCurPdbTemp.size()>0)
			PlaneClusteringBackward(resolCluster,vecCurPdbTemp,vecPrePdbTemp);
		else
			return false;		
				

		//if(  (curNo==50)  )
		//	PlaneClusteringAndTopSelectionNOEs(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum,lastNo,false);
		//else
		//{
			if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
				PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum);
		//}
				
				
		/*if(curNo==62)
		{
			System.out.println("--------------------------------");
			System.out.println("---Now is resiude number: "+ curNo);
			
			//OutputEnsemblePdbs( vecCurPdbTemp,startNo,lastNo,  8.0);//debugging
			OutputEnsemblePdbsBackward( vecCurPdbTemp,startNo,lastNo,  8.0);
			
		}*/

		
		vecPreHalfPdb.addAll(vecPrePdbTemp);
		vecCurFullPdb.addAll(vecCurPdbTemp);
		
		vecCurHalfPdb=new Vector();//free space
		vecFinalPdb.add(FinalPdbS);
		//return vecFinalPdb;
		return true;
		
	}

	/** use the grid search to find the set of variated peptide planes of the first residue
     @param resNoFix the residue number of fixed residue of the loop.  
     @param isSampleInitPlane whether sampling the init peptite plane positions        
     @return the set of all possible atom positions for the first half planes
    */
	public Vector SampleFirstHalfPlanes(int resNoFix,boolean isSampleInitPlane)
	{
		Vector vecAtomSet=new Vector();//storing the set of all possible atom positions
		double distThreshold=10.6;//distance threshold for checking the positions of ca and hn atoms
		double resolution=30.0;//degree resolution used in the grid search
		PdbRdc pdc=new PdbRdc();
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(resNoFix), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: fixed residue not found...exist...");
			System.exit(0);		
		}		
		Pdb pdbFixed = (Pdb)this.vecPdbSSE.elementAt(index);		
			
		//coordinates of N, nh, ca of current residue:
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 
		double [] coordNHNew = new double[3];
		double [] coordCANew = new double[3]; 
		
		double [] nToNHVec = new double[3];
		double [] nToCAVec = new double[3];
		double [] nToNHVecNew = new double[3];
		double [] nToCAVecNew = new double[3];
		Vector atomVecFix =pdbFixed.getAtomVec();
		
		vecAtomSet.add(atomVecFix);				
		
		if(!isSampleInitPlane)
			return vecAtomSet;
		
		Vector vecAtomTemp=new Vector();//store none ca, hn atoms
		for (int k=0;k<atomVecFix.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecFix.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if ( !(atom.equalsIgnoreCase("CA")||atom.equalsIgnoreCase("HN")|| atom.equalsIgnoreCase("H")) )
    	    	vecAtomTemp.add(cc);
		}//for (int k=0;k<atomVecFix.size();k++)
	
		//get the coordinates of orginal n, ca and hn atoms:		
		for (int k=0;k<atomVecFix.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecFix.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)	
		nToNHVec = pdc.internuclearVec(coordN, coordNH);
		nToCAVec = pdc.internuclearVec(coordN, coordCA);
		
		//apply the grid search to find the set of possible half peptide planes:
		//angle range in the grid search ( 0 =< alpha <360, 0 =< beta <180, 0 =< gamma <360) 
		
		double [][] mat = new double[3][3];//rotation matrix
		for (int i = 0; i < (360 / resolution); i++)
		{		
		    double alpha = i * resolution * Math.PI / 180.0;
		    for (int j=0; j< (180 / resolution); j++)
		    {
		    	double beta = j * resolution * Math.PI / 180.0;
				for (int k=0; k< (360 / resolution ); k++)
				{
					double gamma = k * resolution * Math.PI / 180.0;
				    //Generate the Euler matrix
				    mat[0][0] = Math.cos(alpha)*Math.cos(beta)*Math.cos(gamma) - Math.sin(alpha)*Math.sin(gamma);
				    mat[0][1] = Math.sin(alpha)*Math.cos(beta)*Math.cos(gamma) + Math.cos(alpha)*Math.sin(gamma);
				    mat[0][2] = -Math.sin(beta)*Math.cos(gamma);
				    mat[1][0] = -Math.cos(alpha)*Math.cos(beta)*Math.sin(gamma) - Math.sin(alpha)*Math.cos(gamma);
				    mat[1][1] = -Math.sin(alpha)*Math.cos(beta)*Math.sin(gamma) + Math.cos(alpha)*Math.cos(gamma);
				    mat[1][2] = Math.sin(gamma)*Math.sin(beta);
				    mat[2][0] = Math.sin(beta)*Math.cos(alpha);
				    mat[2][1] = Math.sin(alpha)*Math.sin(beta);
				    mat[2][2] = Math.cos(beta);				    
				    
				    Matrix mm = new Matrix(mat);
				    nToNHVecNew = mm.times(nToNHVec);
				    nToCAVecNew = mm.times(nToCAVec);
				    
				    Vector vecAtomNew=new Vector();
				    coordNHNew=pdc.newVecByTranslation(coordN, nToNHVecNew);
				    coordCANew=pdc.newVecByTranslation(coordN,nToCAVecNew);			    
				  
				    
				   double distHN=Math.sqrt((coordNHNew[0]-coordNH[0])*(coordNHNew[0]-coordNH[0]) +(coordNHNew[1]-coordNH[1])*(coordNHNew[1]-coordNH[1])+
				    		(coordNHNew[2]-coordNH[2])*(coordNHNew[2]-coordNH[2]));
				    double distCA=Math.sqrt((coordCANew[0]-coordCA[0])*(coordCANew[0]-coordCA[0]) +(coordCANew[1]-coordCA[1])*(coordCANew[1]-coordCA[1])+
				    		(coordCANew[2]-coordCA[2])*(coordCANew[2]-coordCA[2]));
				    if( (distHN>distThreshold) || (distCA > distThreshold) )
				    	continue;		    
				    
				    vecAtomNew.addAll(vecAtomTemp);
				    vecAtomNew.add(new Cartesian("HN", coordNHNew));
				    vecAtomNew.add(new Cartesian("CA", coordCANew));
				    
				    vecAtomSet.add(vecAtomNew);							     
				}// for (int k=0; k< (180 / resolution ); k++)
		    }//for (int j=0; j< (180 / resolution); j++)
		}//for (int i = 0; i < (180 / resolution); i++)
		    
		return vecAtomSet;		
	}
	/**compute possible psi angles for the first half residue. 
     * use the grid search approach    
     @param curNo current residue number   
     @param chRdc,nhNextRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @return ture if there exists more than one solution
    */
	public boolean LoopFirstHalfResPsiGridSearch(int startNo,int endResNo, double nhNextRdc,
			final Vector vecCurFullPdb, final Vector vecNextHalfPdb)
	{
		double rdcRmsdBound=this.rdcThreshold;//3.0;//rdc rmsd threshold for pruning bad solutions		
		double resolution=2.0;//resolution in the grid search
		double resol=0.2;//cluster gap for cluster ca, n, hn atoms
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,startNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,startNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();

		int topSSEK=6;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 	
		
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(startNo), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: starting residue not found...exist...");
			System.exit(0);		
		}		
		Pdb pdbStartOrig = (Pdb)this.vecPdbSSE.elementAt(index);

		Pdb prePdbTemp=(Pdb)this.vecPdbSSE.elementAt(index-1);
		Vector vecPdbStart=new Vector();
		vecPdbStart.add(prePdbTemp);
		vecPdbStart.add(pdbStartOrig);    	
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbStart);//the psi angle of the last residue is 0
    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(1);
		double phiStart=phipsi.getPhi();	
		
		
		//coordinates of N, nh, ca of current residue:
		Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(index);		
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 
		Vector atomVecStart =pdbStart.getAtomVec();
		for (int k=0;k<atomVecStart.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		
		
	//	Vector<Pdb> vecPdbAchors=SearchSSEAnchorsTop(topSSEK,startNo+1);//get the SSE anchors for next residue				
		
		Vector vecCurPdbTemp=new Vector();///
		Vector vecNextPdbTemp=new Vector();////
		
		double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}	
			
		TreePdb RootPrePdb=new TreePdb(prePdbTemp);
		
	    //use grid search over phi/psi angles for current residue    			
    	for (int j=0;j<360/resolution;j++)
		{
    		double psiValue=j*resolution* Math.PI / 180.0;        		
			phiS[0]=phiStart;
			psiS[0]=psiValue;			
			
			//check the Rama region:
			double rama_score=0.0;
			if(curResName.equalsIgnoreCase("ALA"))
			    	rama_score=lp.CompRamachandranScore(phiStart,psiValue,vecRamaAla);
		    else if(curResName.equalsIgnoreCase("GLY"))
			    	rama_score=lp.CompRamachandranScore(phiStart,psiValue,vecRamaGly);
		    else if(curResName.equalsIgnoreCase("PRO"))
			    	rama_score=lp.CompRamachandranScore(phiStart,psiValue,vecRamaPro);
		    else if(isPrePro)
			    	rama_score=lp.CompRamachandranScore(phiStart,psiValue,this.vecRamaPrePro);
		    else
		    {
		    	rama_score=lp.CompRamachandranScore(phiStart,psiValue,vecRamaGeneral);     			    	
		    }			
			if(rama_score<=0.02)
				continue;
			rama_score=-Math.log(rama_score);
					
			//build up the temp structure fragment        			
			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, startNo, false);//first    			
			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
			
			Pdb curPdb= (Pdb)pdbFragTemp.elementAt(0);	
			Pdb nextHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
			Vector atomVecNext = nextHalfPdb.getAtomVec();
			double [] coordN_next  = new double[3];
			double [] coordNH_next = new double[3];
			double [] coordCA_next = new double[3]; 	
			for (int t=0;t<atomVecNext.size();t++)
			{
				Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN_next = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA_next=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH_next = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)		
			
			//1. check the steric clash between ca of the next residue and the SSEs:
			//Note: this is a mild steric clash checking. It can 
			//be extended to the more accurate approach
			//check the steric clash between ca atom and SSEs(including side-chains)        			
			boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_next,1);
			if(isClash)
				continue;
			
			//check whether the kin chain restraint is satified
			boolean isKinChain=CheckKinChainRestraint(nextHalfPdb,endResNo,1.0);
			if(!isKinChain)
			{
				//System.out.println("here we have one kin chain violation...");
				continue;
			}
			
			
			//boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);					
			//if(!isNOESatisfied)
			//	continue;			
			
			       			
			//3. check the RDC deviation. the dihedral angles are pruned if rdc rmsd is larger 
			//than some threshold.
			//at least one RDC (either CH in current residue or NH in next residue is missing),
			//otherwise the RDC-EXACT search function will be called.
			double Sxx=-this.Syy-this.Szz;
			Vector vecCurPdb=new Vector();
			Vector vecNextPdb=new Vector();
			vecCurPdb.add(curPdb);
			vecNextPdb.add(nextHalfPdb);
			
			double[] sRmsdCH= new double[1];
			int[] sizeCH=new int[1];
			double[] sRmsdNH=new double[1];
			int[] sizeNH=new int[1];
			double[] NhRdcCal  = new double[vecCurPdb.size()];
			double[] ChRdcCal  = new double[vecCurPdb.size()];
			double [][] mat = new double[3][3];
			Matrix A = new Matrix(3,3);
			for(int x=0;x<3;x++)
			{
				for(int y=0;y<3;y++)
				{
					if(x==y)
						mat[x][y]=1;
					else
						mat[x][y]=0;
				}
			}
			A = new Matrix(mat);
			
			double sum_rdc=0.0;
			double nhRms=-99999.9;
			//double check the following functions...
			if(nhNextRdc>-1000.0)
			{
    			nhRms = pdc.BackCalNHOne(vecNextPdb, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
    			if((nhRms>rdcRmsdBound))
    				continue;
    			sum_rdc=sum_rdc+nhRms;
			}	
			
			//save the full pdb for current residue
			TreePdb curTreePdb=new TreePdb(curPdb);
			//curTreePdb.SetRdcRmsd(rdcRmsd);
			curTreePdb.SetNhRdcDif(nhRms);
			curTreePdb.SetSumRdcDif(sum_rdc);
			
			curTreePdb.SetRamaScore(rama_score);
			RootPrePdb.vecChildPdb.add(curTreePdb);
			curTreePdb.parenPdb.add(RootPrePdb);
			      			
			vecCurPdbTemp.add(curTreePdb);
			
			//save the possible pdbs for the next residue
			TreePdb nextHalfTreePdb=new TreePdb(nextHalfPdb);        			
			//nextHalfTreePdb.SetRdcRmsd(rdcRmsd);//for next residue, the rdc rmsd will be updated later
			nextHalfTreePdb.SetNhRdcDif(nhRms);
			nextHalfTreePdb.SetSumRdcDif(sum_rdc);
			
			nextHalfTreePdb.SetRamaScore(rama_score);
			
			curTreePdb.vecChildPdb.add(nextHalfTreePdb);
			nextHalfTreePdb.parenPdb.add(curTreePdb);        			
			vecNextPdbTemp.add(nextHalfTreePdb); 					
			
		}//for (int j=0;j<360/resolution;j++)	
		
		//do the clustering step:
		
		Vector vecIndex=new Vector();
		if(vecCurPdbTemp.size()>0)
			PlaneClustering(resol,vecCurPdbTemp,vecNextPdbTemp);
		else 
			return false;
		
		vecNextHalfPdb.addAll(vecNextPdbTemp);
		vecCurFullPdb.addAll(vecCurPdbTemp);
		return true;
	}
	/**compute possible psi angles for the last half residue, which will be used to compute the
	 * second half fragment in a backward way.      *     
     @param curNo current residue number   
     @param chRdc,nhRdc: at least one is missing (with the value -99999.9)
     @return vecNextHalfPdb the set of all possible half planes for the next residue
     @param isLast whether this is the last residue in the loop.
     @return true if there exists more than one solution
    */
	public boolean LoopLastHalfResPsiGridSearch(int startNo,int endResNo, double nhRdc,double chRdc,
			final Vector vecCurFullPdb, final Vector vecPreHalfPdb)
	{
		double rdcRmsdBound=this.rdcThreshold;//2.0;//rdc rmsd threshold for pruning bad solutions	
		double resol=0.2;//cluster gap for cluster ca, n, hn atoms (A)
		double resolution=2.0;//resolution in the grid search (degree)
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		Model md=new Model();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,endResNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,endResNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();

		int topSSEK=6;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 
			
		
		
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: starting residue not found...exist...");
			System.exit(0);		
		}		
		Pdb pdbLast = (Pdb)this.vecPdbSSE.elementAt(index);

		Pdb nextPdbTemp=(Pdb)this.vecPdbSSE.elementAt(index+1);/////////
		Vector vecPdbLast=new Vector();
		vecPdbLast.add(nextPdbTemp);
		vecPdbLast.add(pdbLast);    
		Collections.sort(vecPdbLast, new Pdb.PdbComparator());		
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbLast);//the psi angle of the last residue is 0
    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(0);
		double psiLast=phipsi.getPsi();		
		
		//coordinates of N, nh, ca of next residue:
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 
		Vector atomVecStart =nextPdbTemp.getAtomVec();
		for (int k=0;k<atomVecStart.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		
		
		Vector vecCurPdbTemp=new Vector();///
		Vector vecPrePdbTemp=new Vector();////
						
		TreePdb RootPrePdb=new TreePdb(nextPdbTemp);
		
	    //use grid search over phi/psi angles for current residue    			
    	for (int j=0;j<360/resolution;j++)
		{
    		double phiValue=j*resolution* Math.PI / 180.0;  
    		
			//check the Rama region:
			double rama_score=0.0;
			if(curResName.equalsIgnoreCase("ALA"))
			    	rama_score=lp.CompRamachandranScore(phiValue,psiLast,vecRamaAla);
		    else if(curResName.equalsIgnoreCase("GLY"))
			    	rama_score=lp.CompRamachandranScore(phiValue,psiLast,vecRamaGly);
		    else if(curResName.equalsIgnoreCase("PRO"))
			    	rama_score=lp.CompRamachandranScore(phiValue,psiLast,vecRamaPro);
		    else if(isPrePro)
			    	rama_score=lp.CompRamachandranScore(phiValue,psiLast,this.vecRamaPrePro);
		    else
		    {
		    	rama_score=lp.CompRamachandranScore(phiValue,psiLast,vecRamaGeneral);     			    	
		    }			
			if(rama_score<=0.02)
				continue;
			rama_score=-Math.log(rama_score);				
			
			//build up the temp structure fragment        			
			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
			//pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, endResNo, false);//first    
			pdbFragTemp0=mdc.coordByBackwardNew(phiValue, psiLast, coordN, coordNH,coordCA, endResNo);
			
			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
			
			//rotate and translate the new pdb to the sse end residue:
			//Vector pdbFragTemp=md.BackonbeRotationAtResidue(pdbFragTemp1, this.vecPdbSSE,endResNo);
					
			Pdb curPdb= (Pdb)pdbFragTemp.elementAt(1);	
			Pdb preHalfPdb= (Pdb)pdbFragTemp.elementAt(0);	
			Vector atomVecPre = preHalfPdb.getAtomVec();
			double [] coordN_pre  = new double[3];
			double [] coordNH_pre = new double[3];
			double [] coordCA_pre = new double[3]; 	
			for (int t=0;t<atomVecPre.size();t++)
			{
				Cartesian cc = (Cartesian)atomVecPre.elementAt(t);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN_pre = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA_pre=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH_pre = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)		
			
			//1. check the steric clash between ca of the next residue and the SSEs:
			//Note: this is a mild steric clash checking. It can 
			//be extended to the more accurate approach
			//check the steric clash between ca atom and SSEs(including side-chains)        			
			boolean isClash=CheckClashBtwRotCaNSSEsNew(coordCA_pre,1);
			if(isClash)
				continue;
			
			//check whether the kin chain restraint is satified
			
			boolean isKinChain=CheckKinChainRestraintBackward(preHalfPdb,startNo,0.2);
			if(!isKinChain)
			{
				//System.out.println("here we have one kin chain violation...");
				continue;
			}			
			
			//boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);					
			//if(!isNOESatisfied)
			//	continue;
						       			
			//3. check the RDC deviation. the dihedral angles are pruned if rdc rmsd is larger 
			//than some threshold.
			//at least one RDC (either CH in current residue or NH in next residue is missing),
			//otherwise the RDC-EXACT search function will be called.
			double Sxx=-this.Syy-this.Szz;
			Vector vecCurPdb=new Vector();		
			vecCurPdb.add(curPdb);		
			
			double[] sRmsdCH= new double[1];
			int[] sizeCH=new int[1];
			double[] sRmsdNH=new double[1];
			int[] sizeNH=new int[1];
			double[] NhRdcCal  = new double[vecCurPdb.size()];
			double[] ChRdcCal  = new double[vecCurPdb.size()];
			double [][] mat = new double[3][3];
			Matrix A = new Matrix(3,3);
			for(int x=0;x<3;x++)
			{
				for(int y=0;y<3;y++)
				{
					if(x==y)
						mat[x][y]=1;
					else
						mat[x][y]=0;
				}
			}
			A = new Matrix(mat);
			
			double sum_rdc=0.0;
			double nhRms=-99999.9;
			double chRms=-99999.9;
			//double check the follosing functions...
			if(nhRdc>-100.0)
			{
    			nhRms = pdc.BackCalNHOne(vecCurPdb, this.vecNhRDC, "N", "H",A, Sxx,this.Syy, this.Szz, Const.nhRatio, NhRdcCal,sRmsdNH, sizeNH);
    			if((nhRms>rdcRmsdBound))
    				continue;
    			sum_rdc=sum_rdc+nhRms;
    			
			}	
			if(chRdc>-100.0)
			{
    			chRms = pdc.BackCalOne(vecCurPdb, this.vecChRDC, "CA", "HA", A, Sxx,this.Syy,this.Szz, Const.cahaRatio, ChRdcCal,sRmsdCH, sizeCH );
    			if(chRms>rdcRmsdBound)	
    				continue;    	
    			sum_rdc=sum_rdc+chRms;
			}
			//save the full pdb for current residue
			TreePdb curTreePdb=new TreePdb(curPdb);
			//curTreePdb.SetRdcRmsd(rdcRmsd);
			curTreePdb.SetNhRdcDif(nhRms);
			curTreePdb.SetChRdcDif(chRms);
			curTreePdb.SetSumRdcDif(sum_rdc);
			
			curTreePdb.SetRamaScore(rama_score);
			RootPrePdb.vecChildPdb.add(curTreePdb);
			curTreePdb.parenPdb.add(RootPrePdb);
			      			
			vecCurPdbTemp.add(curTreePdb);
			
			//save the possible pdbs for the next residue
			TreePdb preHalfTreePdb=new TreePdb(preHalfPdb);        			
			//nextHalfTreePdb.SetRdcRmsd(rdcRmsd);//for next residue, the rdc rmsd will be updated later
			preHalfTreePdb.SetNhRdcDif(nhRms);
			preHalfTreePdb.SetChRdcDif(chRms);
			preHalfTreePdb.SetSumRdcDif(sum_rdc);
			
			preHalfTreePdb.SetRamaScore(rama_score);
			
			curTreePdb.vecChildPdb.add(preHalfTreePdb);
			preHalfTreePdb.parenPdb.add(curTreePdb);        			
			vecPrePdbTemp.add(preHalfTreePdb); 					
			
		}//for (int j=0;j<360/resolution;j++)	
		
		//do the clustering step:
	
		Vector vecIndex=new Vector();
		if(vecCurPdbTemp.size()>0)
			PlaneClusteringBackward(resol,vecCurPdbTemp,vecPrePdbTemp);
		else 
			return false;
		
		vecPreHalfPdb.addAll(vecPrePdbTemp);
		vecCurFullPdb.addAll(vecCurPdbTemp);
		return true;
	}
	
	/**
     * check whether the end residue closes the gap
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckLastResidueOld(Pdb nextHalfPdb,int endResNo,double error, double[] dist)
    {
    	dist[0]=0.0;
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = nextHalfPdb.getAtomVec();
		double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    	
    	
    	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] nEnd = new double[3];
 		double [] hnEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("N"))
 				nEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
 	    		hnEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_n= Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) 
				+ (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) 
				+ (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_hn= Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) 
				+ (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) 
				+ (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
		if(distance_n<error && distance_ca<error && distance_hn<error)
			isClose=true;
		dist[0]=(distance_n+distance_ca+distance_hn)/3;
		
		return isClose; 		
     }
    
    /**
     * check whether the end residue closes the gap
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckLastResidue(Pdb nextHalfPdb,int endResNo,double error, double[] dist)
    {
    	dist[0]=0.0;
    	
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = nextHalfPdb.getAtomVec();		
		double [] coordCO_next  = new double[3];
		double [] coordC_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O"))
    	    	coordCO_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
    	    	coordC_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    
		
	  	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] coEnd = new double[3];
 		double [] cEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("CO")|| atom.equalsIgnoreCase("O"))
 				coEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
 	    		cEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 	
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_co= Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) 
				+ (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) 
				+ (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_c= Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) 
				+ (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) 
				+ (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
		if(distance_co<error && distance_ca<error && distance_c<error)
			isClose=true;
		dist[0]=(distance_co+distance_ca+distance_c)/3;
		
		return isClose; 		
     }
    /**
     * check whether the end residue closes the gap
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckLastResidue(Pdb nextHalfPdb,int endResNo,double error, double[] dist,double[] distCa)
    {
    	dist[0]=0.0;
    	
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = nextHalfPdb.getAtomVec();		
		double [] coordCO_next  = new double[3];
		double [] coordC_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O"))
    	    	coordCO_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
    	    	coordC_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    
		
	  	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] coEnd = new double[3];
 		double [] cEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("CO")|| atom.equalsIgnoreCase("O"))
 				coEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
 	    		cEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 	
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_co= Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) 
				+ (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) 
				+ (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_c= Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) 
				+ (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) 
				+ (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
		if(distance_co<error && distance_ca<error && distance_c<error)
			isClose=true;
		dist[0]=(distance_co+distance_ca+distance_c)/3;
		distCa[0]=distance_ca;
		
		return isClose; 		
     }
    
   
    /**
     * check whether the end residue closes the gap
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckLastResidueOld(Pdb nextHalfPdb,int endResNo,double error, double[] dist,double[] distCa)
    {
    	dist[0]=0.0;
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = nextHalfPdb.getAtomVec();
		double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    	
    	
    	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] nEnd = new double[3];
 		double [] hnEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("N"))
 				nEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
 	    		hnEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_n= Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) 
				+ (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) 
				+ (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_hn= Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) 
				+ (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) 
				+ (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
		if(distance_n<error && distance_ca<error && distance_hn<error)
			isClose=true;
		dist[0]=(distance_n+distance_ca+distance_hn)/3;
		distCa[0]=distance_ca;
		
		return isClose; 		
     }
	/**
     * check whether the end residue closes the gap. For backward bb calculation.
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckFirstResidue(Pdb preHalfPdb,int fixNo,double error, double[] dist,double [] caDist)
    {
    	dist[0]=0.0;
       
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = preHalfPdb.getAtomVec();
    	double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    		    	
    	
		//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] nEnd = new double[3];
 		double [] hnEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("N"))
 				nEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
 	    		hnEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_n= Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) 
				+ (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) 
				+ (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_hn= Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) 
				+ (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) 
				+ (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
		if(distance_n<error && distance_ca<error && distance_hn<error)
			isClose=true;
		dist[0]=(distance_n+distance_ca+distance_hn)/3; 		
		caDist[0]=distance_ca;
		return isClose; 		
     }
	/**
     * check whether the end residue closes the gap. For backward bb calculation.
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckFirstResidue(Pdb preHalfPdb,int fixNo,double error, double[] dist)
    {
    	dist[0]=0.0;
       
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = preHalfPdb.getAtomVec();
    	double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    		    	
    	
		//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] nEnd = new double[3];
 		double [] hnEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("N"))
 				nEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
 	    		hnEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_n= Math.sqrt((coordN_next[0] - nEnd[0]) * (coordN_next[0] - nEnd[0]) 
				+ (coordN_next[1] - nEnd[1]) * (coordN_next[1] - nEnd[1]) 
				+ (coordN_next[2] - nEnd[2]) * (coordN_next[2] - nEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_hn= Math.sqrt((coordNH_next[0] - hnEnd[0]) * (coordNH_next[0] - hnEnd[0]) 
				+ (coordNH_next[1] - hnEnd[1]) * (coordNH_next[1] - hnEnd[1]) 
				+ (coordNH_next[2] - hnEnd[2]) * (coordNH_next[2] - hnEnd[2]));
		if(distance_n<error && distance_ca<error && distance_hn<error)
			isClose=true;
		dist[0]=(distance_n+distance_ca+distance_hn)/3; 		
		
		return isClose; 		
     }
	
	/**
     * check whether the end residue closes the gap. For backward bb calculation.
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckFirstResidueOld(Pdb preHalfPdb,int fixNo,double error, double[] dist,double [] caDist)
    {
    	dist[0]=0.0;
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = preHalfPdb.getAtomVec();
		double [] coordCO_next  = new double[3];
		double [] coordC_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O"))
    	    	coordCO_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
    	    	coordC_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    	
    	
    	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] coEnd = new double[3];
 		double [] cEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("CO")|| atom.equalsIgnoreCase("O"))
 				coEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
 	    		cEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_co= Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) 
				+ (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) 
				+ (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_c= Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) 
				+ (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) 
				+ (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
		if(distance_co<error && distance_ca<error && distance_c<error)
			isClose=true;
		dist[0]=(distance_co+distance_ca+distance_c)/3;
		caDist[0]=distance_ca;
		return isClose; 		
     }
	/**
     * check whether the end residue closes the gap. For backward bb calculation.
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold for checking whether the gap is closed
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckFirstResidueOld(Pdb preHalfPdb,int fixNo,double error, double[] dist)
    {
    	dist[0]=0.0;
    	//1. get the ca, n, nh of the end residue in the loop
    	Vector atomVecNext = preHalfPdb.getAtomVec();
		double [] coordCO_next  = new double[3];
		double [] coordC_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("O"))
    	    	coordCO_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
    	    	coordC_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		    	
    	
    	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3];
 		double [] coEnd = new double[3];
 		double [] cEnd = new double[3];
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(fixNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ();
 			if (atom.equalsIgnoreCase("CO")|| atom.equalsIgnoreCase("O"))
 				coEnd = cc.getXYZ();		    	  
 	    	else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
 	    		cEnd = cc.getXYZ();					 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isClose=false;
		double distance_co= Math.sqrt((coordCO_next[0] - coEnd[0]) * (coordCO_next[0] - coEnd[0]) 
				+ (coordCO_next[1] - coEnd[1]) * (coordCO_next[1] - coEnd[1]) 
				+ (coordCO_next[2] - coEnd[2]) * (coordCO_next[2] - coEnd[2]));
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		double distance_c= Math.sqrt((coordC_next[0] - cEnd[0]) * (coordC_next[0] - cEnd[0]) 
				+ (coordC_next[1] - cEnd[1]) * (coordC_next[1] - cEnd[1]) 
				+ (coordC_next[2] - cEnd[2]) * (coordC_next[2] - cEnd[2]));
		if(distance_co<error && distance_ca<error && distance_c<error)
			isClose=true;
		dist[0]=(distance_co+distance_ca+distance_c)/3;
		
		return isClose; 		
     }
	/**
     * check whether kinematic chain restraint is satisfied
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold 
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckKinChainRestraint(Pdb nextHalfPdb, int endResNo,double error)
    {    	
    	//1. get the ca, n, nh of the end residue in the loop
    	int curNo=nextHalfPdb.getResidueNo();
    	Vector atomVecNext = nextHalfPdb.getAtomVec();
		
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();      	   
    	    if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();    	       
		}//for (int k=0;k<atomVecStart.size();k++)		    	
    	
    	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3]; 		
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(endResNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ(); 								 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isSatisfied=false;
		
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		
		if( (distance_ca< ( 3.8*Math.abs(endResNo-curNo) + error ) ) )
			isSatisfied=true;
		
		
		return isSatisfied; 		
     }
	/**
     * check whether kinematic chain restraint is satisfied
     @param 
 	 @param nextHalfPdb end residue computed from loop
 	 @param error threshold 
 	 @param endResNo end residue no in SSE.
      @return true if it closes the gap, otherwise return false.    
    */
    public boolean CheckKinChainRestraintBackward(Pdb nextHalfPdb, int startResNo,double error)
    {    	
    	//1. get the ca, n, nh of the end residue in the loop
    	int curNo=nextHalfPdb.getResidueNo();
    	Vector atomVecNext = nextHalfPdb.getAtomVec();
		
		double [] coordCA_next = new double[3]; 	
		for (int t=0;t<atomVecNext.size();t++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(t);
    	    String atom = cc.getAtom();      	   
    	    if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();    	       
		}//for (int k=0;k<atomVecStart.size();k++)		    	
    	
    	//2. get the ca, n, nh of the end residue in SSE
    	double [] caEnd = new double[3]; 		
    	int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(startResNo), new Pdb.PdbComparator());
 		if (index <0)
 		{
 			System.out.println("error: loop ends not found...exist...");
 		 	System.exit(0);		
 		}
 		
 		Pdb pdbEnd = (Pdb)this.vecPdbSSE.elementAt(index); 		
 		Vector vecAtomEnd=pdbEnd.getAtomVec();
 		for (int j=0; j<vecAtomEnd.size(); j++)
     	{ 
 			Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
 			String atom = cc.getAtom();
 			if (atom.equalsIgnoreCase("CA"))
 				caEnd=cc.getXYZ(); 								 
     	 }//for (int j=0; j<vecAtomStart.size(); j++)
 		
 		//3. check whether the distances between end points are less than the treshold
 		boolean isSatisfied=false;
		
		double distance_ca= Math.sqrt((coordCA_next[0] - caEnd[0]) * (coordCA_next[0] - caEnd[0]) 
				+ (coordCA_next[1] - caEnd[1]) * (coordCA_next[1] - caEnd[1]) 
				+ (coordCA_next[2] - caEnd[2]) * (coordCA_next[2] - caEnd[2]));				
		
		if( (distance_ca< ( 3.8*Math.abs(startResNo-curNo) + error ) ) )
			isSatisfied=true;
		
		
		return isSatisfied; 		
     }
	/**
     * compute the structure fragment that best fits the 
     * NOE restraints.
     *  
     @param vecFinalTreePdb storing all possible pdbs for the final residue
     @param noStart, noEnd, end residue numbers
     @param distUpCa distance upper bound between ca atoms
     @return 
    
     */
	public Vector OutputEnsemblePdbs(Vector vecFinalTreePdb,int noStart,int noEnd, double distUpCa)
	{	
		double ave_nhRMSD=0.0;
		double ave_chRMSD=0.0;		
		
		Pdb pp=new Pdb();
		int maxCount=-99999;
		Vector vecPdbSave=new Vector();
		
		double max_nhRMSD=-99999.9;
		double min_nhRMSD=99999.9;
		double max_chRMSD=-99999.9;
		double min_chRMSD=99999.9;		
		
		for(int i=0;i<vecFinalTreePdb.size();i++)
		{
			int nhRdcCount=0;
			int chRdcCount=0;
			double sum_nhRdc=0.0;
			double sum_chRdc=0.0;
			Vector vecLoopFrag=new Vector();
			
			//get the structure fragment:
			TreePdb treePdb=(TreePdb)vecFinalTreePdb.elementAt(i);
			double rama_score=treePdb.GetRamaScore();
			//double rdcRmsd=treePdb.GetRdcRmsd();
			double nhRdcDif=treePdb.GetNhRdcDif();
			double chRdcDif=treePdb.GetChRdcDif();
			if(nhRdcDif>-100.0)
			{
				sum_nhRdc=sum_nhRdc+nhRdcDif*nhRdcDif;
				nhRdcCount++;
			}
			if(chRdcDif>-100.0)
			{
				sum_chRdc=sum_chRdc+chRdcDif*chRdcDif;
				chRdcCount++;
			}
			
			double endDist=treePdb.GetEndDist();
			
			int resNo=treePdb.pdb.getResidueNo();
			TreePdb treePdbEnd=(TreePdb)treePdb.vecChildPdb.elementAt(0);
			//vecLoopFrag.add(treePdbEnd.pdb);
			while(resNo>=noStart)
			//while(resNo<=noEnd)
			{
				vecLoopFrag.add(treePdb.pdb);
				if(resNo==noStart) 
					break;
				
				treePdb=(TreePdb)treePdb.parenPdb.elementAt(0);
				resNo=treePdb.pdb.getResidueNo();
				
				nhRdcDif=treePdb.GetNhRdcDif();
				chRdcDif=treePdb.GetChRdcDif();
				if(nhRdcDif>-1000.0)
				{
					sum_nhRdc=sum_nhRdc+nhRdcDif*nhRdcDif;
					nhRdcCount++;
				}
				if(chRdcDif>-1000.0)
				{
					sum_chRdc=sum_chRdc+chRdcDif*chRdcDif;
					chRdcCount++;
				}
			}//while(resNo>=noStart)
			Collections.sort(vecLoopFrag, new Pdb.PdbComparator());
			
			//check NOE statisfaction score:
			int counter=0;
			for(int j=0;j<this.vecAmbNOEs.size();j++)
			{
				boolean isSatisfied=false;
				Noe noe=(Noe)this.vecAmbNOEs.elementAt(j);
				int resNoA=noe.getResidueNoA();
				int resNoB=noe.getResidueNoB();
				
				for(int k=0;k<vecLoopFrag.size();k++)
				{
					Pdb pdbLoop=(Pdb)vecLoopFrag.elementAt(k);
					int resNoLoop=pdbLoop.getResidueNo();
					if( !( (resNoLoop==resNoA) || (resNoLoop==resNoB) ))
						continue;
					
					Vector vecAtomLoop=pdbLoop.getAtomVec();
					double [] caLoop = new double[3];
					for(int kk=0;kk<vecAtomLoop.size();kk++)
					{
						Cartesian cc = (Cartesian)vecAtomLoop.elementAt(kk);
						String atom = cc.getAtom();
						if (atom.equalsIgnoreCase("CA"))
							caLoop=cc.getXYZ();
					}//for(int t=0;t<vecAtomSSE.size();t++)

					for(int t=0;t<this.vecPdbSSE.size();t++)
					{
						Pdb pdbSSE=(Pdb)this.vecPdbSSE.elementAt(t);
						int resNoSSE=pdbSSE.getResidueNo();
						if( !( (resNoSSE==resNoA) || (resNoSSE==resNoB) ))
							continue;
						
						Vector vecAtomSSE=pdbSSE.getAtomVec();
						double [] caSSE = new double[3];
						for(int tt=0;tt<vecAtomSSE.size();tt++)
						{
							Cartesian cc = (Cartesian)vecAtomSSE.elementAt(tt);
							String atom = cc.getAtom();
							if (atom.equalsIgnoreCase("CA"))
								caSSE=cc.getXYZ();
						}//for(int t=0;t<vecAtomSSE.size();t++)

						if(  !( ((resNoSSE==resNoA)&&(resNoLoop==resNoB)) || ((resNoSSE==resNoB)&&(resNoLoop==resNoA)) ) )
							continue;
							
							
						double distance= Math.sqrt((caSSE[0] - caLoop[0]) * (caSSE[0] - caLoop[0]) 
								+ (caSSE[1] - caLoop[1]) * (caSSE[1] - caLoop[1]) 
								+ (caSSE[2] - caLoop[2]) * (caSSE[2] - caLoop[2]));
						
						if(distance < distUpCa)
						{
							isSatisfied=true;
							break;
						}							
						
					}//for(int t=0;t<this.vecPdbSSE.size();t++)
					if(isSatisfied==true)
						break;
					
				}//for(int k=0;k<vecLoopFrag.size();k++)
				if(isSatisfied)
					counter++;				
				
			}//for(int i=0;i<this.vecAmbNOEs.size();i++)


			//delete the repeated structures:
			boolean isRepeated=false;
			for(int t=0;t<vecPdbSave.size();t++)
			{
				Vector vecPdbTemp=(Vector)vecPdbSave.elementAt(t);
				if(vecPdbTemp.equals(vecLoopFrag))
				{
					isRepeated=true;
					break;
				}
			}
			if(isRepeated)
				continue;
			
			System.out.println("REMARK number of statisfied NOEs for the "+(i+1)+" th solution: "+ counter);
			System.out.println("REMARK distance between end residues: "+ endDist);
			System.out.println("REMARK rama score: "+ rama_score);
			System.out.println("REMARK NH RDC RMSD: "+ Math.sqrt(sum_nhRdc/nhRdcCount ));
			System.out.println("REMARK CH RDC RMSD: "+ Math.sqrt(sum_chRdc/chRdcCount ));
			
			System.out.println("REMARK :  =========================  ");
			System.out.println("TER");
			
			//Vector vecLoopNew=LoopLocalGapClosure(vecLoopFrag, noStart,noEnd);////////////	
			
			pp.print(vecLoopFrag);////////
			
			if(vecLoopFrag.size()>0)
				vecPdbSave.add(vecLoopFrag);
			
			
			/*if(counter>maxCount)	
			{
				maxCount=counter;
				vecPdbSave=new Vector();
				vecPdbSave.addAll(vecLoopFrag);
			}*/
			
			ave_nhRMSD=ave_nhRMSD+Math.sqrt(sum_nhRdc/nhRdcCount );
			ave_chRMSD=ave_chRMSD+Math.sqrt(sum_chRdc/chRdcCount );
			if(max_nhRMSD< Math.sqrt(sum_nhRdc/nhRdcCount ))
				max_nhRMSD=Math.sqrt(sum_nhRdc/nhRdcCount);
			if(min_nhRMSD>Math.sqrt(sum_nhRdc/nhRdcCount ))
				min_nhRMSD=Math.sqrt(sum_nhRdc/nhRdcCount);
			
			if(max_chRMSD< Math.sqrt(sum_chRdc/chRdcCount ))
				max_chRMSD=Math.sqrt(sum_chRdc/chRdcCount);
			if(min_chRMSD>Math.sqrt(sum_chRdc/chRdcCount ))
				min_chRMSD=Math.sqrt(sum_chRdc/chRdcCount);
		}//for(int i=0;i<vecFinalTreePdb.size();i++)
		ave_nhRMSD=ave_nhRMSD/vecFinalTreePdb.size();
		ave_chRMSD=ave_chRMSD/vecFinalTreePdb.size();
			
		System.out.println("REMARK NH RDCs: average RMSD= "+ave_nhRMSD +" ; Dev ="+ Math.max(Math.abs(ave_nhRMSD-max_nhRMSD ), Math.abs(ave_nhRMSD-min_nhRMSD )) );
		
		System.out.println("REMARK CH RDCs: average RMSD= "+ave_chRMSD +" ; Dev ="+ Math.max(Math.abs(ave_chRMSD-max_chRMSD ), Math.abs(ave_chRMSD-min_chRMSD )) );
		
		return vecPdbSave;		
	}
	
	/**
     * compute the structure fragment that best fits the 
     * NOE restraints.
     *  
     @param vecFinalTreePdb storing all possible pdbs for the final residue
     @param noStart, noEnd, end residue numbers
     @param distUpCa distance upper bound between ca atoms
     @return 
    
     */
	public Vector OutputEnsemblePdbsBackward(Vector vecFinalTreePdb,int noStart,int noEnd, double distUpCa)
	{
		double ave_nhRMSD=0.0;
		double ave_chRMSD=0.0;		
		double max_nhRMSD=-99999.9;
		double min_nhRMSD=99999.9;
		double max_chRMSD=-99999.9;
		double min_chRMSD=99999.9;
		
		Pdb pp=new Pdb();
		int maxCount=-99999;
		Vector vecPdbSave=new Vector();
		for(int i=0;i<vecFinalTreePdb.size();i++)
		{
			int nhRdcCount=0;
			int chRdcCount=0;
			double sum_nhRdc=0.0;
			double sum_chRdc=0.0;
			Vector vecLoopFrag=new Vector();
			
			//get the structure fragment:
			TreePdb treePdb=(TreePdb)vecFinalTreePdb.elementAt(i);
			double rama_score=treePdb.GetRamaScore();
			//double rdcRmsd=treePdb.GetRdcRmsd();
			double nhRdcDif=treePdb.GetNhRdcDif();
			double chRdcDif=treePdb.GetChRdcDif();
			if(nhRdcDif>-100.0)
			{
				sum_nhRdc=sum_nhRdc+nhRdcDif*nhRdcDif;
				nhRdcCount++;
			}
			if(chRdcDif>-100.0)
			{
				sum_chRdc=sum_chRdc+chRdcDif*chRdcDif;
				chRdcCount++;
			}
			
			double endDist=treePdb.GetEndDist();
			
			int resNo=treePdb.pdb.getResidueNo();
			TreePdb treePdbEnd=(TreePdb)treePdb.vecChildPdb.elementAt(0);
			//vecLoopFrag.add(treePdbEnd.pdb);
			
			while(resNo<=noEnd)
			{
				vecLoopFrag.add(treePdb.pdb);
				if(resNo==noEnd) 
					break;
				
				treePdb=(TreePdb)treePdb.parenPdb.elementAt(0);
				resNo=treePdb.pdb.getResidueNo();
				
				nhRdcDif=treePdb.GetNhRdcDif();
				chRdcDif=treePdb.GetChRdcDif();
				if(nhRdcDif>-100.0)
				{
					sum_nhRdc=sum_nhRdc+nhRdcDif*nhRdcDif;
					nhRdcCount++;
				}
				if(chRdcDif>-100.0)
				{
					sum_chRdc=sum_chRdc+chRdcDif*chRdcDif;
					chRdcCount++;
				}
			}//while(resNo>=noStart)
			Collections.sort(vecLoopFrag, new Pdb.PdbComparator());
			
			//check NOE statisfaction score:
			int counter=0;
			for(int j=0;j<this.vecAmbNOEs.size();j++)
			{
				boolean isSatisfied=false;
				Noe noe=(Noe)this.vecAmbNOEs.elementAt(j);
				int resNoA=noe.getResidueNoA();
				int resNoB=noe.getResidueNoB();
				
				for(int k=0;k<vecLoopFrag.size();k++)
				{
					Pdb pdbLoop=(Pdb)vecLoopFrag.elementAt(k);
					int resNoLoop=pdbLoop.getResidueNo();
					if( !( (resNoLoop==resNoA) || (resNoLoop==resNoB) ))
						continue;
					
					Vector vecAtomLoop=pdbLoop.getAtomVec();
					double [] caLoop = new double[3];
					for(int kk=0;kk<vecAtomLoop.size();kk++)
					{
						Cartesian cc = (Cartesian)vecAtomLoop.elementAt(kk);
						String atom = cc.getAtom();
						if (atom.equalsIgnoreCase("CA"))
							caLoop=cc.getXYZ();
					}//for(int t=0;t<vecAtomSSE.size();t++)

					for(int t=0;t<this.vecPdbSSE.size();t++)
					{
						Pdb pdbSSE=(Pdb)this.vecPdbSSE.elementAt(t);
						int resNoSSE=pdbSSE.getResidueNo();
						if( !( (resNoSSE==resNoA) || (resNoSSE==resNoB) ))
							continue;
						
						Vector vecAtomSSE=pdbSSE.getAtomVec();
						double [] caSSE = new double[3];
						for(int tt=0;tt<vecAtomSSE.size();tt++)
						{
							Cartesian cc = (Cartesian)vecAtomSSE.elementAt(tt);
							String atom = cc.getAtom();
							if (atom.equalsIgnoreCase("CA"))
								caSSE=cc.getXYZ();
						}//for(int t=0;t<vecAtomSSE.size();t++)

						if(  !( ((resNoSSE==resNoA)&&(resNoLoop==resNoB)) || ((resNoSSE==resNoB)&&(resNoLoop==resNoA)) ) )
							continue;
							
							
						double distance= Math.sqrt((caSSE[0] - caLoop[0]) * (caSSE[0] - caLoop[0]) 
								+ (caSSE[1] - caLoop[1]) * (caSSE[1] - caLoop[1]) 
								+ (caSSE[2] - caLoop[2]) * (caSSE[2] - caLoop[2]));
						
						if(distance < distUpCa)
						{
							isSatisfied=true;
							break;
						}							
						
					}//for(int t=0;t<this.vecPdbSSE.size();t++)
					if(isSatisfied==true)
						break;
					
				}//for(int k=0;k<vecLoopFrag.size();k++)
				if(isSatisfied)
					counter++;				
				
			}//for(int i=0;i<this.vecAmbNOEs.size();i++)

			//delete the repeated structures:
			boolean isRepeated=false;
			for(int t=0;t<vecPdbSave.size();t++)
			{
				Vector vecPdbTemp=(Vector)vecPdbSave.elementAt(t);
				if(vecPdbTemp.equals(vecLoopFrag))
				{
					isRepeated=true;
					break;
				}
			}
			if(isRepeated)
				continue;
			
			System.out.println("REMARK number of statisfied NOEs for the "+(i+1)+" th solution: "+ counter);
			System.out.println("REMARK distance between end residues: "+ endDist);
			System.out.println("REMARK rama score: "+ rama_score);
			System.out.println("REMARK NH RDC RMSD: "+ Math.sqrt(sum_nhRdc/nhRdcCount ));
			System.out.println("REMARK CH RDC RMSD: "+ Math.sqrt(sum_chRdc/chRdcCount ));
			
			
			
			System.out.println("REMARK :  =========================  ");
			
			System.out.println("TER");
			
			
			pp.print(vecLoopFrag);////////
			System.out.println("TER");
			
			
			/*System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK :  =========================  ");
			Vector vecLoopNew=LoopLocalGapClosureBackward(vecLoopFrag, noStart,noEnd);////////////				
			
			System.out.println("REMARK :  New fragment after gradient search: ");
			
			pp.print(vecLoopNew);////////
			vecPdbSave.add(vecLoopNew);*/
			
			/*if(counter>maxCount)	
			{
				maxCount=counter;
				vecPdbSave=new Vector();
				vecPdbSave.addAll(vecLoopFrag);
			}*/
			
			if(vecLoopFrag.size()>0)
				vecPdbSave.add(vecLoopFrag);
			
			ave_nhRMSD=ave_nhRMSD+Math.sqrt(sum_nhRdc/nhRdcCount );
			ave_chRMSD=ave_chRMSD+Math.sqrt(sum_chRdc/chRdcCount );
			if(max_nhRMSD< Math.sqrt(sum_nhRdc/nhRdcCount ))
				max_nhRMSD=Math.sqrt(sum_nhRdc/nhRdcCount);
			if(min_nhRMSD>Math.sqrt(sum_nhRdc/nhRdcCount ))
				min_nhRMSD=Math.sqrt(sum_nhRdc/nhRdcCount);
			
			if(max_chRMSD< Math.sqrt(sum_chRdc/chRdcCount ))
				max_chRMSD=Math.sqrt(sum_chRdc/chRdcCount);
			if(min_chRMSD>Math.sqrt(sum_chRdc/chRdcCount ))
				min_chRMSD=Math.sqrt(sum_chRdc/chRdcCount);
		}//for(int i=0;i<vecFinalTreePdb.size();i++)
		
		ave_nhRMSD=ave_nhRMSD/vecFinalTreePdb.size();
		ave_chRMSD=ave_chRMSD/vecFinalTreePdb.size();
			
		System.out.println("REMARK NH RDCs: average RMSD= "+ave_nhRMSD +" ; Dev ="+ Math.max(Math.abs(ave_nhRMSD-max_nhRMSD ), Math.abs(ave_nhRMSD-min_nhRMSD )) );
		
		System.out.println("REMARK CH RDCs: average RMSD= "+ave_chRMSD +" ; Dev ="+ Math.max(Math.abs(ave_chRMSD-max_chRMSD ), Math.abs(ave_chRMSD-min_chRMSD )) );
		
		return vecPdbSave;		
	}

	
	/**
     * compute the loop structures
     *  
     @param noStart starting residue, in SSE
     @param noEnd last residue, in SSE
     @return a vector storing all candidate positions.
    
     */
	public Vector LoopAllComputation(int noStart,int noEnd )
	{	
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		Vector vecPdbLoop=new Vector();
		
		//get the coordinates of endpoints:
		String resStart="", resEnd="";
		Vector vecAtomStart=new Vector();
		Vector vecAtomEnd=new Vector();
		double [] caStart = new double[3];
		double [] nStart = new double[3];
		double [] hnStart = new double[3];
		double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: loop ends not found...exist...");
			System.exit(0);		
		}
		
		Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(index);
		resStart=pdbStart.getResidue();
		vecAtomStart=pdbStart.getAtomVec();
		for (int j=0; j<vecAtomStart.size(); j++)
    	{ 
			Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
			String atom = cc.getAtom();
			if (atom.equalsIgnoreCase("CA"))
				caStart=cc.getXYZ();
			if (atom.equalsIgnoreCase("N"))
    	    	nStart = cc.getXYZ();		    	  
	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	hnStart = cc.getXYZ();					 
    	}//for (int j=0; j<vecAtomStart.size(); j++)
		Pdb prePdbTemp=(Pdb)this.vecPdbSSE.elementAt(index-1);
		Vector vecPdbStart=new Vector();
		vecPdbStart.add(prePdbTemp);
		vecPdbStart.add(pdbStart);    	
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbStart);//the psi angle of the last residue is 0
    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(1);
		phiS[0]=phipsi.getPhi();
		psiS[0]=phipsi.getPsi();		
		Vector pdbFragTemp0= mdc.modelBuild(phiS, psiS, nStart, hnStart,caStart, noStart, false);//
		Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
		
		//get the next half residue:
		Pdb curHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
		/*Vector atomVecNext = curHalfPdb.getAtomVec();
		double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int f=0;f<atomVecNext.size();f++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(f);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		*/
		
		Vector vecAllPdbs=new Vector();
		
		Vector vecCurHalfPdb=new Vector();
		TreePdb startTreePdb=new TreePdb(pdbStart);
		TreePdb curHalfTreePdb=new TreePdb(curHalfPdb);
		startTreePdb.vecChildPdb.add(curHalfTreePdb);
		curHalfTreePdb.parenPdb.add(startTreePdb);
		
		Vector vecFinalPdb=new Vector();
		vecCurHalfPdb.add(curHalfTreePdb);
		int curResNo=noStart;///
		Vector vecNextHalfPdb=new Vector();
		Vector vecCurFullPdb=new Vector();
		boolean isLast=false;
		boolean isSolution=false;//whether finding a solution
		while(curResNo<=noEnd)
		{
			//if(curResNo==64)
 				//System.out.println("stop here...");
			if(curResNo==noEnd)
				isLast=true;
			
			/////
			vecNextHalfPdb=new Vector();
			vecCurFullPdb=new Vector();
			
			//check the RDC data are missing:
			boolean isMissing=false;
			double chRdc=-99999.9;
			double nhNextRdc=-99999.9;
			int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
			if(indCH>-1)
				chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
			
			int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo+1), new Dipolar.rdcComparator());
			if(indNH>-1)
				nhNextRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
			
			if(curResNo==noStart)
			{
				isSolution=LoopFirstHalfResPsiGridSearch(curResNo,noEnd,nhNextRdc,vecCurFullPdb,vecNextHalfPdb);
			}
			else
			{
				if(this.isAllGridSearch)
					isSolution=LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhNextRdc, vecCurFullPdb,vecNextHalfPdb,isLast);
				else
				{
					if( (indCH<0) || (indNH<0) )//one rdc is missing						
						isSolution=LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhNextRdc, vecCurFullPdb,vecNextHalfPdb,isLast);
					else
					{
						isSolution=LoopCurResPhiPsiExactSearch(vecCurHalfPdb,curResNo,noStart,noEnd,chRdc,nhNextRdc,vecCurFullPdb,vecNextHalfPdb,isLast);
						if(!isSolution)
							isSolution=LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhNextRdc, vecCurFullPdb,vecNextHalfPdb,isLast);						
					}
				}
					//	if(!isSolution)
				//	isSolution=CurPhiPsiGridForwardMinRdcRmsd(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhNextRdc, vecCurFullPdb,vecNextHalfPdb,isLast,20);
				
			}
			vecAllPdbs.add(vecCurFullPdb);
			
			vecCurHalfPdb=new Vector();
			vecCurHalfPdb.addAll(vecNextHalfPdb);
			vecNextHalfPdb=new Vector();
			
			if(!isSolution)
			{
				System.out.println("Solution not found for forward computation...");
				return vecPdbLoop;
			}
			
			System.out.println("debugging...residue num: "+ curResNo);//
			System.out.println("debugging...num of soutions: "+ vecCurFullPdb.size());//
			
			///debugging...
			/*if((curResNo==51) && vecCurFullPdb.size()<6)
			{
				System.out.println("debuggging...");
				isSolution=false;
				break;
			}*/
			
			
			curResNo++;
		}//while(curResNo<noEnd)
		
		Vector vecLoopsNew2=new Vector();
		if(isSolution)
		{
			Vector vecFinalTreePdb=(Vector)vecAllPdbs.elementAt(vecAllPdbs.size()-1);
			System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK : Here are the ensemble of structures computed in a forward way. ");
			System.out.println("REMARK :  =========================  ");
			
			vecLoopsNew2=OutputEnsemblePdbs( vecFinalTreePdb,noStart,noEnd,  8.0);
			
			//print out the final ensemble of structures
			System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK : Here are the fixed SSEs: ");
			System.out.println("REMARK :  =========================  ");
			System.out.println("TER");
			//pp.print(this.vecPdbSSE);
			System.out.println("END");

			//use gradient search to close the gap:
			//Vector vecLoopNew=LoopLocalGapClosure(vecLoops, noStart,noEnd);		
			
		}
		else
			System.out.println("No solution is found...");
		
		//System.out.println("REMARK :  =========================  ");
		//System.out.println("TER");
		//pp.print(this.vecPdbSSE);
		
		//System.out.println("REMARK :  =========================  ");
		//pp.print(vecLoopsNew2);
		
		
		/*index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
		if (index > -1)
		{
			Pdb pdb = (Pdb)this.vecPdbSSE.elementAt(index);
			resEnd=pdb.getResidue();
			vecAtomEnd=pdb.getAtomVec();
			for (int j=0; j<vecAtomEnd.size(); j++)
	    	{ 
				Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
				String atom = cc.getAtom();
				if (atom.equalsIgnoreCase("CA"))
					caEnd=cc.getXYZ();
	    	}//for (int j=0; j<vecAtomStart.size(); j++)
		}//if (index > -1)
		*/		
		return vecLoopsNew2;
	}
	/**
     * compute the loop structures from both direction
     *  
     @param noStart starting residue, in SSE
     @param noEnd last residue, in SSE
     @return a vector storing all candidate positions.
    
     */
	public Vector LoopAllComputationBiDirection(int noStart,int noEnd )
	{	
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		Vector vecPdbLoop=new Vector();
		
		//get the coordinates of endpoints:
		String resStart="", resEnd="";
		Vector vecAtomStart=new Vector();
		Vector vecAtomEnd=new Vector();
		double [] caStart = new double[3];
		double [] nStart = new double[3];
		double [] hnStart = new double[3];
		double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: loop ends not found...exist...");
			System.exit(0);		
		}
		
		Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(index);
		resStart=pdbStart.getResidue();
		vecAtomStart=pdbStart.getAtomVec();
		for (int j=0; j<vecAtomStart.size(); j++)
    	{ 
			Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
			String atom = cc.getAtom();
			if (atom.equalsIgnoreCase("CA"))
				caStart=cc.getXYZ();
			if (atom.equalsIgnoreCase("N"))
    	    	nStart = cc.getXYZ();		    	  
	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	hnStart = cc.getXYZ();					 
    	}//for (int j=0; j<vecAtomStart.size(); j++)
		Pdb prePdbTemp=(Pdb)this.vecPdbSSE.elementAt(index-1);
		Vector vecPdbStart=new Vector();
		vecPdbStart.add(prePdbTemp);
		vecPdbStart.add(pdbStart);    	
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbStart);//the psi angle of the last residue is 0
    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(1);
		phiS[0]=phipsi.getPhi();
		psiS[0]=phipsi.getPsi();		
		Vector pdbFragTemp0= mdc.modelBuild(phiS, psiS, nStart, hnStart,caStart, noStart, false);//
		Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
		
		//get the next half residue:
		Pdb curHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
		/*Vector atomVecNext = curHalfPdb.getAtomVec();
		double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int f=0;f<atomVecNext.size();f++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(f);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		*/
		
		Vector vecAllPdbs=new Vector();
		
		Vector vecCurHalfPdb=new Vector();
		TreePdb startTreePdb=new TreePdb(pdbStart);
		TreePdb curHalfTreePdb=new TreePdb(curHalfPdb);
		startTreePdb.vecChildPdb.add(curHalfTreePdb);
		curHalfTreePdb.parenPdb.add(startTreePdb);
		
		Vector vecFinalPdb=new Vector();
		vecCurHalfPdb.add(curHalfTreePdb);
		int curResNo=noStart;///
		Vector vecNextHalfPdb=new Vector();
		Vector vecCurFullPdb=new Vector();
		boolean isLast=false;
		
		//compute the first half fragment in a forward way:
		boolean isSolution=false;//whether finding a solution
		while(curResNo<noEnd)
		{		
			
			if(curResNo==(noEnd-1))
				isLast=true;
			
			
			vecNextHalfPdb=new Vector();
			vecCurFullPdb=new Vector();
			
			//check the RDC data are missing:
			boolean isMissing=false;
			double chRdc=-99999.9;
			double nhNextRdc=-99999.9;
			int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
			if(indCH>-1)
				chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
			
			int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo+1), new Dipolar.rdcComparator());
			if(indNH>-1)
				nhNextRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
			
			if(curResNo==noStart)
			{
				isSolution=LoopFirstHalfResPsiGridSearch(curResNo,noEnd,nhNextRdc,vecCurFullPdb,vecNextHalfPdb);
			}
			else
			{
				if( (indCH<0) || (indNH<0) )//one rdc is missing
					isSolution=LoopCurResPhiPsiGridSearch(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhNextRdc, vecCurFullPdb,vecNextHalfPdb,isLast);
				else
					isSolution=LoopCurResPhiPsiExactSearch(vecCurHalfPdb,curResNo,noStart,noEnd,chRdc,nhNextRdc,vecCurFullPdb,vecNextHalfPdb,isLast);
			}
			vecAllPdbs.add(vecCurFullPdb);
			
			vecCurHalfPdb=new Vector();
			vecCurHalfPdb.addAll(vecNextHalfPdb);
			vecNextHalfPdb=new Vector();
			if(!isSolution)
			{
				System.out.println("No solution found for forward computation for residue: "+ curResNo);
				break;
			}
			System.out.println("debugging...residue num: "+ curResNo);//
			System.out.println("debugging...num of soutions: "+ vecCurFullPdb.size());//
			
			
			curResNo++;			
			
		}//while(curResNo<noEnd)		
		
		Vector vecLoopsNew=new Vector();
		if(isSolution)
		{
			Vector vecFinalTreePdb=(Vector)vecAllPdbs.elementAt(vecAllPdbs.size()-1);
			
			System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK : Here are ensemble of structures computed in a forward way. ");
			System.out.println("REMARK :  =========================  ");
			vecLoopsNew=OutputEnsemblePdbs( vecFinalTreePdb,noStart,noEnd,  8.0);
		}
		
		
		//compute the second half fragement in a backward way:
		isSolution=false;//whether finding a solution
		boolean isFirst=false;
		curResNo=noEnd;
		Vector vecAllPdbsBackward=new Vector();
		//while(curResNo>=noMiddle)
		while(curResNo>noStart)
		{						
		
			if(curResNo==(noStart+1))
				isFirst=true;
			vecNextHalfPdb=new Vector();
			vecCurFullPdb=new Vector();
			
			//check the RDC data are missing:
			boolean isMissing=false;
			double chRdc=-99999.9;
			double nhRdc=-99999.9;
			int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
			if(indCH>-1)
				chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
			
			int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
			if(indNH>-1)
				nhRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
			
			if(curResNo==noEnd)
			{
				isSolution=LoopLastHalfResPsiGridSearch(noStart,noEnd,nhRdc,chRdc,vecCurFullPdb,vecNextHalfPdb);
			}
			else
			{
				if( (indCH<0) || (indNH<0) )//one rdc is missing
					isSolution=LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhRdc, vecCurFullPdb,vecNextHalfPdb,isFirst);
				else
					isSolution=LoopCurResPhiPsiExactSearchBackward(vecCurHalfPdb,curResNo,noStart,noEnd,chRdc,nhRdc,vecCurFullPdb,vecNextHalfPdb,isFirst);
			}
			vecAllPdbsBackward.add(vecCurFullPdb);
			
			vecCurHalfPdb=new Vector();
			vecCurHalfPdb.addAll(vecNextHalfPdb);
			vecNextHalfPdb=new Vector();
			if(!isSolution)
			{
				System.out.println("No solution found for backward computation for residue: "+ curResNo);
				break;
			}
		
			System.out.println("debugging...residue num: "+ curResNo);//
			System.out.println("debugging...num of soutions: "+ vecCurFullPdb.size());//
			curResNo--;
		}//while(curResNo<noEnd)	
		Vector vecLoopsNew2=new Vector();
		if(isSolution)
		{
			Vector vecFinalTreePdbBackward=(Vector)vecAllPdbsBackward.elementAt(vecAllPdbsBackward.size()-1);
			
			System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK : Here are ensemble of structures computed in a Backward way. ");
			System.out.println("REMARK :  =========================  ");
			
			vecLoopsNew2=OutputEnsemblePdbsBackward( vecFinalTreePdbBackward,noStart,noEnd,  8.0);
		}
		//use gradient search to close the gap:
		//Vector vecLoopNew=LoopLocalGapClosure(vecLoops, noStart,noEnd);
		
		//System.out.println("REMARK :  =========================  ");
		//System.out.println("TER");
		//pp.print(this.vecPdbSSE);
		
		//System.out.println("REMARK :  =========================  ");
		//pp.print(vecLoopsNew2);
		
		System.out.println("REMARK :  =========================  ");
		System.out.println("REMARK : Here are ensemble of combined structures. ");
		System.out.println("REMARK :  =========================  ");
		
		int noMiddle=(noEnd+noStart)/2;//middle residue number
		Vector vecFinalEnsemble=new Vector();
		if(vecLoopsNew.size()>0 && vecLoopsNew2.size()>0)
		{
			if(vecLoopsNew.size()>vecLoopsNew2.size())
			{
				vecFinalEnsemble=MergeTwoFragmentIntoOne(vecLoopsNew2,vecLoopsNew,0.2, noStart, noEnd,noMiddle, false);
				
			}
			else
			{
				vecFinalEnsemble=MergeTwoFragmentIntoOne(vecLoopsNew,vecLoopsNew2,0.2, noStart, noEnd,noMiddle, true);
			}
		}
		else
		{
			if(vecLoopsNew.size()>0)
				vecFinalEnsemble.addAll(vecLoopsNew);
			else
				vecFinalEnsemble.addAll(vecLoopsNew2);
		}
		
		//print out the final ensemble of structures
		pp.print(this.vecPdbSSE);
		System.out.println("TER");
		for(int i=0;i<vecFinalEnsemble.size();i++)
		{
			Vector vecPdb=(Vector)vecFinalEnsemble.elementAt(i);
			pp.print(vecPdb);
			System.out.println("TER");
		}
		System.out.println("END");
		
		return vecPdbLoop;
	}
	/**
     * compute the loop structures from backward direction
     *  
     @param noStart starting residue, in SSE
     @param noEnd last residue, in SSE
     @return a vector storing all candidate positions.
    
     */
	public Vector LoopAllComputationBackward(int noStart,int noEnd )
	{	
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
		//Vector vecPdbLoop=new Vector();
		
		//get the coordinates of endpoints:
		String resStart="", resEnd="";
		Vector vecAtomStart=new Vector();
		Vector vecAtomEnd=new Vector();
		double [] caStart = new double[3];
		double [] nStart = new double[3];
		double [] hnStart = new double[3];
		double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}
		int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
		if (index <0)
		{
			System.out.println("error: loop ends not found...exist...");
			System.exit(0);		
		}
		
		Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(index);
		resStart=pdbStart.getResidue();
		vecAtomStart=pdbStart.getAtomVec();
		for (int j=0; j<vecAtomStart.size(); j++)
    	{ 
			Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
			String atom = cc.getAtom();
			if (atom.equalsIgnoreCase("CA"))
				caStart=cc.getXYZ();
			if (atom.equalsIgnoreCase("N"))
    	    	nStart = cc.getXYZ();		    	  
	    	else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	hnStart = cc.getXYZ();					 
    	}//for (int j=0; j<vecAtomStart.size(); j++)
		Pdb prePdbTemp=(Pdb)this.vecPdbSSE.elementAt(index-1);
		Vector vecPdbStart=new Vector();
		vecPdbStart.add(prePdbTemp);
		vecPdbStart.add(pdbStart);    	
    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbStart);//the psi angle of the last residue is 0
    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(1);
		phiS[0]=phipsi.getPhi();
		psiS[0]=phipsi.getPsi();		
		Vector pdbFragTemp0= mdc.modelBuild(phiS, psiS, nStart, hnStart,caStart, noStart, false);//
		Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
		
		//get the next half residue:
		Pdb curHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
		/*Vector atomVecNext = curHalfPdb.getAtomVec();
		double [] coordN_next  = new double[3];
		double [] coordNH_next = new double[3];
		double [] coordCA_next = new double[3]; 	
		for (int f=0;f<atomVecNext.size();f++)
		{
			Cartesian cc = (Cartesian)atomVecNext.elementAt(f);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN_next = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA_next=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH_next = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)		*/
		
		Vector vecAllPdbs=new Vector();
		
		Vector vecCurHalfPdb=new Vector();
		TreePdb startTreePdb=new TreePdb(pdbStart);
		TreePdb curHalfTreePdb=new TreePdb(curHalfPdb);
		startTreePdb.vecChildPdb.add(curHalfTreePdb);
		curHalfTreePdb.parenPdb.add(startTreePdb);
		
		Vector vecFinalPdb=new Vector();
		vecCurHalfPdb.add(curHalfTreePdb);
		int curResNo=noStart;///
		Vector vecNextHalfPdb=new Vector();
		Vector vecCurFullPdb=new Vector();
			
		//compute the second half fragement in a backward way:
		boolean isSolution=false;//whether finding a solution
		boolean isFirst=false;
		curResNo=noEnd;
		Vector vecAllPdbsBackward=new Vector();
		//while(curResNo>=noMiddle)
		while(curResNo>=noStart)
		{					
			
			if(curResNo==noStart)
				isFirst=true;
			vecNextHalfPdb=new Vector();
			vecCurFullPdb=new Vector();
			
			//check the RDC data are missing:
			boolean isMissing=false;
			double chRdc=-99999.9;
			double nhRdc=-99999.9;
			int indCH = Collections.binarySearch(this.vecChRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
			if(indCH>-1)
				chRdc=((Dipolar)this.vecChRDC.elementAt(indCH)).getRdc();
			
			int indNH = Collections.binarySearch(this.vecNhRDC, new Dipolar(curResNo), new Dipolar.rdcComparator());
			if(indNH>-1)
				nhRdc=((Dipolar)this.vecNhRDC.elementAt(indNH)).getRdc();
			
			if(curResNo==noEnd)
			{
				isSolution=LoopLastHalfResPsiGridSearch(noStart,noEnd,nhRdc,chRdc,vecCurFullPdb,vecNextHalfPdb);
			}
			else
			{
				if(this.isAllGridSearch)
					isSolution=LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhRdc, vecCurFullPdb,vecNextHalfPdb,isFirst);
				else
				{
					if( (indCH<0) || (indNH<0) )//one rdc is missing
						isSolution=LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhRdc, vecCurFullPdb,vecNextHalfPdb,isFirst);
					else
					{
						isSolution=LoopCurResPhiPsiExactSearchBackward(vecCurHalfPdb,curResNo,noStart,noEnd,chRdc,nhRdc,vecCurFullPdb,vecNextHalfPdb,isFirst);
						if(!isSolution)
							isSolution=LoopCurResPhiPsiGridSearchBackward(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhRdc, vecCurFullPdb,vecNextHalfPdb,isFirst);
					}
				}
				//if(!isSolution)
					//isSolution=CurPhiPsiGridBackwardMinRdcRmsd(vecCurHalfPdb, curResNo,noStart,noEnd,chRdc, nhRdc, vecCurFullPdb,vecNextHalfPdb,isFirst,20);
					
			}
			vecAllPdbsBackward.add(vecCurFullPdb);
			
			vecCurHalfPdb=new Vector();
			vecCurHalfPdb.addAll(vecNextHalfPdb);
			vecNextHalfPdb=new Vector();
			if(!isSolution)
			{
				System.out.println("No solution found for backward computation for residue: "+ curResNo);
				break;
			}
		
			System.out.println("debugging...residue num: "+ curResNo);//
			System.out.println("debugging...num of soutions: "+ vecCurFullPdb.size());//
			curResNo--;
		}//while(curResNo<noEnd)	
		Vector vecLoopsNew2=new Vector();
		if(isSolution)
		{
			Vector vecFinalTreePdbBackward=(Vector)vecAllPdbsBackward.elementAt(vecAllPdbsBackward.size()-1);
			
			System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK : Here are the ensemble of structures computed in a Backward way. ");
			System.out.println("REMARK :  =========================  ");
			
			vecLoopsNew2=OutputEnsemblePdbsBackward( vecFinalTreePdbBackward,noStart,noEnd,  8.0);
			
			//print out the final ensemble of structures
			System.out.println("REMARK :  =========================  ");
			System.out.println("REMARK : Here are the fixed SSEs: ");
			System.out.println("REMARK :  =========================  ");
			System.out.println("TER");
			//pp.print(this.vecPdbSSE);
			System.out.println("END");
		}
		else
			System.out.println("No solution is found...");
		
		
			//use gradient search to close the gap:
			//Vector vecLoopNew=LoopLocalGapClosureBackward(vecLoopsNew2, noStart,noEnd);
		
		
		//System.out.println("REMARK :  =========================  ");
		//System.out.println("TER");
		//pp.print(this.vecPdbSSE);
		
		//System.out.println("REMARK :  =========================  ");
		//pp.print(vecLoopsNew2);
		
		
		return vecLoopsNew2;//vecPdbLoop;
	}
	
	
	
	/**Merge two framgements computed using backward and forward ways into one fragment
     * 
     @param vecPdbEnsemb1 ensemble of the the first fragment
     @param vecPdbEnsemb2 ensemble of the the second fragment
     @param error error shreshold for connecting two ca atoms
     @param isFirstHalf whether the first half of the first fragment is aligned.
     @return vecAllPdbs ensemble of final PDBs
     @return 
    */
	public Vector MergeTwoFragmentIntoOne(Vector vecPdbEnsemb1, Vector vecPdbEnsemb2,double error, int noStart, int noEnd,int noMiddle,boolean isFirstHalf)
	{		
		Vector vecFinalEnsemble=new Vector();
		
		for (int i=0;i<vecPdbEnsemb1.size();i++)
		{
			Vector vecPdbNew=new Vector();
			boolean isFindMatched=false;
			double minDist=999999.9;
			Vector vecSecFragment=new Vector();
			Vector vecAtomMiddle2=new Vector();
			
			Vector vecPdb1=(Vector)vecPdbEnsemb1.elementAt(i);
			int index1 = Collections.binarySearch(vecPdb1, new Pdb(noMiddle), new Pdb.PdbComparator());
			if (index1 <0)
			{
				System.out.println("error: middle residue not found...exist...");
				System.exit(0);		
			}		
			Pdb pdb1=(Pdb)vecPdb1.elementAt(index1);
			Vector atomVec1 =pdb1.getAtomVec();
			double [] coordCA1 = new double[3]; 
			for (int k=0;k<atomVec1.size();k++)
			{
				Cartesian cc = (Cartesian)atomVec1.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    
	    	    if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA1=cc.getXYZ();	    	    
			}//for (int k=0;k<atomVecStart.size();k++)		

			for(int j=0;j<vecPdbEnsemb2.size();j++)
			{
				Vector vecPdb2=(Vector)vecPdbEnsemb2.elementAt(j);
				int index2 = Collections.binarySearch(vecPdb2, new Pdb(noMiddle), new Pdb.PdbComparator());
				if (index2 <0)
				{
					System.out.println("error: middle residue not found...exist...");
					System.exit(0);		
				}		
				Pdb pdb2=(Pdb)vecPdb2.elementAt(index2);
				
				Vector atomVec2 =pdb2.getAtomVec();
				double [] coordCA2 = new double[3]; 
				for (int k=0;k<atomVec2.size();k++)
				{
					Cartesian cc = (Cartesian)atomVec2.elementAt(k);
		    	    String atom = cc.getAtom();	    	   
		    	    
		    	    if (atom.equalsIgnoreCase("CA"))
		    	    	coordCA2=cc.getXYZ();	    	    
				}//for (int k=0;k<atomVecStart.size();k++)		
				double distance_ca= Math.sqrt((coordCA2[0] - coordCA1[0]) * (coordCA2[0] - coordCA1[0]) 
						+ (coordCA2[1] - coordCA1[1]) * (coordCA2[1] - coordCA1[1]) 
						+ (coordCA2[2] - coordCA1[2]) * (coordCA2[2] - coordCA1[2]));
				if(distance_ca<minDist)
				{
					minDist=distance_ca;
					vecSecFragment=new Vector();
					vecSecFragment.addAll(vecPdb2);
					vecAtomMiddle2=new Vector();
					vecAtomMiddle2.addAll(atomVec2);
					isFindMatched=true;
				}
			}//for(int j=0;j<vecPdbEnsemb2.size();j++)
			
			if(!isFindMatched)
				continue;
			Vector vecAtomMiddleNew=new Vector();
			if(isFirstHalf)
			{
				for(int t=0;t<atomVec1.size();t++)			
				{
					Cartesian ccTemp=(Cartesian)atomVec1.elementAt(t);
	    			String strAtomTemp=ccTemp.getAtom();
	    			if(strAtomTemp.equalsIgnoreCase("HN")|| strAtomTemp.equalsIgnoreCase("H")||
	    					strAtomTemp.equalsIgnoreCase("N")||strAtomTemp.equalsIgnoreCase("CA")||
	    					strAtomTemp.equalsIgnoreCase("HA")||strAtomTemp.equalsIgnoreCase("CB")||
	    					strAtomTemp.equalsIgnoreCase("HB"))
	    				vecAtomMiddleNew.add(ccTemp);
				}//for(int t=0;t<atomVec1.size();t++)
				for(int t=0;t<vecAtomMiddle2.size();t++)
				{
					Cartesian ccTemp=(Cartesian)vecAtomMiddle2.elementAt(t);
	    			String strAtomTemp=ccTemp.getAtom();
	    			if(strAtomTemp.equalsIgnoreCase("C")|| strAtomTemp.equalsIgnoreCase("C'")||
	    					strAtomTemp.equalsIgnoreCase("O")||strAtomTemp.equalsIgnoreCase("CO"))    					
	    				vecAtomMiddleNew.add(ccTemp);
				}//for(int t=0;t<vecAtomMiddle2.size();t++)
			}
			else
			{
				for(int t=0;t<vecAtomMiddle2.size();t++)			
				{
					Cartesian ccTemp=(Cartesian)vecAtomMiddle2.elementAt(t);
	    			String strAtomTemp=ccTemp.getAtom();
	    			if(strAtomTemp.equalsIgnoreCase("HN")|| strAtomTemp.equalsIgnoreCase("H")||
	    					strAtomTemp.equalsIgnoreCase("N")||strAtomTemp.equalsIgnoreCase("CA")||
	    					strAtomTemp.equalsIgnoreCase("HA")||strAtomTemp.equalsIgnoreCase("CB")||
	    					strAtomTemp.equalsIgnoreCase("HB"))
	    				vecAtomMiddleNew.add(ccTemp);
				}//for(int t=0;t<atomVec1.size();t++)
				for(int t=0;t<atomVec1.size();t++)
				{
					Cartesian ccTemp=(Cartesian)atomVec1.elementAt(t);
	    			String strAtomTemp=ccTemp.getAtom();
	    			if(strAtomTemp.equalsIgnoreCase("C")|| strAtomTemp.equalsIgnoreCase("C'")||
	    					strAtomTemp.equalsIgnoreCase("O")||strAtomTemp.equalsIgnoreCase("CO"))    					
	    				vecAtomMiddleNew.add(ccTemp);
				}//for(int t=0;t<vecAtomMiddle2.size();t++)
			}
			pdb1.setAtomVec(vecAtomMiddleNew);
			
			if(isFirstHalf)
			{						
				for(int t=noStart;t<=noMiddle;t++)
				{
					int indexT = Collections.binarySearch(vecPdb1, new Pdb(t), new Pdb.PdbComparator());
					Pdb pdbTemp=(Pdb)vecPdb1.elementAt(indexT);
					vecPdbNew.add(pdbTemp);
				}//for(int t=noStart;t<=noMiddle;t++)
				for(int t=noMiddle+1;t<=noEnd;t++)
				{
					int indexT = Collections.binarySearch(vecSecFragment, new Pdb(t), new Pdb.PdbComparator());
					Pdb pdbTemp=(Pdb)vecSecFragment.elementAt(indexT);
					vecPdbNew.add(pdbTemp);
				}//for(int t=noStart;t<=noMiddle;t++)
				
			}//if(isFirstHalf)
			else
			{
				for(int t=noMiddle;t<=noEnd;t++)
				{
					int indexT = Collections.binarySearch(vecPdb1, new Pdb(t), new Pdb.PdbComparator());
					Pdb pdbTemp=(Pdb)vecPdb1.elementAt(indexT);
					vecPdbNew.add(pdbTemp);
				}//for(int t=noStart;t<=noMiddle;t++)
				
				for(int t=noStart;t<noMiddle;t++)
				{
					int indexT = Collections.binarySearch(vecSecFragment, new Pdb(t), new Pdb.PdbComparator());
					Pdb pdbTemp=(Pdb)vecSecFragment.elementAt(indexT);
					vecPdbNew.add(pdbTemp);
				}//for(int t=noStart;t<=noMiddle;t++)
			}			
			
			Collections.sort(vecPdbNew, new Pdb.PdbComparator());
			vecFinalEnsemble.add(vecPdbNew);
		}//for (int i=0;i<vecPdbEnsemb1.size();i++)
		
		return vecFinalEnsemble;
	}
	
	
	public void PdbGenerateFromTree(Vector vecAllPdbTree)
	{
		for(int i=0;i<vecAllPdbTree.size();i++)
		{
			Vector vecCurPdbs=(Vector)vecAllPdbTree.elementAt(i);
			
			for(int j=0;j<vecCurPdbs.size();j++)
			{
				
			}
			
		}//for(int i=0;i<vecAllPdbTree.size();i++)
		
	}

	/**compute possible phi/psi angles for current residue using RDC-EXACT algorithm. 
     * 
     @param vecPrePdb vector to store all possible current planes, given previous residue
     @param int curNo current residue number   
     @param chRdc ch rdc of current residue
     @param nhNextRDC nh rdc of the next residue
     @return vecAllPdbs ensemble of all PDBs
     @return 
    */
	public boolean LoopCurResPhiPsiExactSearch(Vector vecCurHalfPdb,int curNo,int startResNo, int endResNo,double chRdc, double nhNextRdc,
			final Vector vecCurFullPdb, final Vector vecNextHalfPdb,boolean isLast)
	{
		double resolCluster=0.4;//cluster gap for cluster ca, n, hn atoms
		int topNum=1000;//number of top planes that can be selected based on rama or rdc rmsd
		double rdcGrid=0.4;//grid for rdc sampleing, Hz
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,curNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;
    	
    	
		Vector vecFinalPdb=new Vector();
		TreePdb FinalPdbS=new TreePdb();
		double minDist=999999.9;
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
				
		int topSSEK=5;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 
		//double rdcRmsdBound=4.0;//rdc rmsd threshold for pruning bad solutions		
		//Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,curNo+1);//get the SSE anchors for next residue				
		
    	double[] phiS = new double[1]; 
		double[] psiS = new double[1];
		for(int i=0;i<1;i++)
		{
			phiS[i]=0.0;
			psiS[i]=0.0;
		}
						
		Vector  vecCurPdbTemp=new Vector();//for storing the set of possible pdbs for current residue
		Vector  vecNextPdbTemp=new Vector();//for storing the set of possible pdbs for next residue
		int rdcSampCycles=50;//number of rdc sampling cycles; choose small number because only one residue is considered
		
		for(int i=0;i<vecCurHalfPdb.size();i++)
		{
			//coordinates of N, nh, ca of current residue:
			double [] coordN  = new double[3];
			double [] coordNH = new double[3];
			double [] coordCA = new double[3]; 
			
			TreePdb pdbTreeCur=(TreePdb)vecCurHalfPdb.elementAt(i);			
			Vector atomVecStart = pdbTreeCur.pdb.getAtomVec();
			
			TreePdb curParent=(TreePdb)pdbTreeCur.parenPdb.elementAt(0);
			Vector vecPreChild=curParent.vecChildPdb;
			vecPreChild.remove(pdbTreeCur);//need to double check about this.
			
			//double preRdcRmsd=pdbTreeCur.GetRdcRmsd();
			double preRamaScore=curParent.GetRamaScore();
			double pre_sum_rdc=curParent.GetSumRdcDif();
			
			for (int k=0;k<atomVecStart.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)

			double[] nToNHVec = mdc.internuclearVec(coordN, coordNH);
	        double[] nToCAVec = mdc.internuclearVec(coordN, coordCA);
	        ppGlobal ppg = new ppGlobal();
	        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
	      
	        //uniformly sample the RDC values
	        Vector phiVec = new Vector();
	        Vector psiVec = new Vector();
			for (int k=0;k<this.rdcThreshold/rdcGrid;k++)
			{
				double ch_rdc=((chRdc-(this.rdcThreshold/2))+k*rdcGrid)/Const.cahaRatio;
				for(int t=0;t<this.rdcThreshold/rdcGrid;t++)
				{
					double nhNext_rdc=( (nhNextRdc-(this.rdcThreshold/2))+t*rdcGrid )/Const.nhRatio;
					PhiPsi ff=new PhiPsi();
					boolean isHelix=false;
					phiVec =ff.phiCalLoop(this.Syy, this.Szz, ch_rdc, mat);
					if (!phiVec.isEmpty())
					{
						for (int h =0; h<phiVec.size(); h++)
						{
						    double phi = ((Double)phiVec.elementAt(h)).doubleValue();
						    phiS[0]=phi;
						    psiVec = ff.psiCalLoop(this.Syy, this.Szz, nhNext_rdc, phi,  mat);
						    if (!psiVec.isEmpty())
						    {
						    	for (int g =0; g<psiVec.size(); g++)
						    	{
						    		double psi = ((Double)psiVec.elementAt(g)).doubleValue();
						    		psiS[0]=psi;
						    		
						    		//check the Rama region:
				        			double rama_score=0.0;
				        			if(curResName.equalsIgnoreCase("ALA"))
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaAla);
				     			    else if(curResName.equalsIgnoreCase("GLY"))
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaGly);
				     			    else if(curResName.equalsIgnoreCase("PRO"))
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaPro);
				     			    else if(isPrePro)
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,this.vecRamaPrePro);
				     			    else
				     			    {
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaGeneral);     			    	
				     			    }
				        			
				        			if(rama_score<=0.02)
				        				continue;						    		
						    		rama_score=-Math.log(rama_score);
						    		
						    		//build up the temp structure fragment        			
				        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();    
				        			pdbFragTemp0= mdc.modelBuild(phiS, psiS, coordN, coordNH,coordCA, curNo, false);//first
				        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
				        			Pdb curPdb=(Pdb)pdbFragTemp.elementAt(0);	
				        			Pdb nextHalfPdb= (Pdb)pdbFragTemp.elementAt(1);	
				        			int resNoNext=nextHalfPdb.getResidueNo();
				        			Vector atomVecNext = nextHalfPdb.getAtomVec();
				        			double [] coordN_next  = new double[3];
				        			double [] coordNH_next = new double[3];
				        			double [] coordCA_next = new double[3]; 	
				        			for (int f=0;f<atomVecNext.size();f++)
				        			{
				        				Cartesian cc = (Cartesian)atomVecNext.elementAt(f);
				        	    	    String atom = cc.getAtom();	    	   
				        	    	    if (atom.equalsIgnoreCase("N"))
				        	    	    	coordN_next = cc.getXYZ();
				        	    	    else if (atom.equalsIgnoreCase("CA"))
				        	    	    	coordCA_next=cc.getXYZ();
				        	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
				        	    	    	coordNH_next = cc.getXYZ();		    
				        			}//for (int k=0;k<atomVecStart.size();k++)		
				        			
				          			//1. check the steric clash between ca and the SSEs:
				        			//Note: this is a mild steric clash checking. It can 
				        			//be extended to the more accurate approach.
				        			//now only check the steric clash between ca atom and SSEs(including side-chains)        			
				        			//if(!isLast)
				        			if(resNoNext<endResNo)
				        			{
					        			boolean isClash=CheckClashBtwRotCaNSSEs(coordCA_next);
										if(isClash)
											continue;
				        			}
				        			
				        			////////////////////////////////////////////////////
									//check whether the kin chain restraint is satified
				        			if(resNoNext<=endResNo)
				        			{
					        			double errorKin=0.0;
					        			//if(isLast )//&& Math.abs(startNo-endResNo)>8)
					        			if(resNoNext==endResNo)
					        				errorKin=this.gapThreshold;//3.0;//2.0 for long loops (> 8 residues)
					        			else
					        				errorKin=1.0;//1.0;//0.6
										boolean isKinChain=CheckKinChainRestraint(nextHalfPdb,endResNo,errorKin);
										if(!isKinChain)
										{
											//System.out.println("here we have one kin chain violation...");
											continue;
										}
				        			}

									
									//2. check whether ca statisfies the NOE restraints.
									/*if(!isLast)
									{
										boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);
					        			if(!isNOESatisfied)
					        				continue;
									}*/
									
				        			//double rdcRms=Math.abs(chRdc-ch_rdc)/Const.cahaRatio+Math.abs(nhNext_rdc-nhNextRdc)/Const.nhRatio;
				        			
				        			//3.if last residue in the loop, check the end residue:
				        			double[] dist=new double[1];
				        			double[] distCa=new double[1];
				        			dist[0]=99999.9;
				        			distCa[0]=99999.9;
				        			if(isLast)
				        			{
				        				double error=this.gapThreshold;//+1.0
				        				int endNo=curPdb.getResidueNo();
				        				
				        				boolean isClose=CheckLastResidue(curPdb,endNo,error,dist,distCa);
				        				if(!isClose)
				        					continue;
				        			}
				        			
				        			
				        			///////////////////////////////////////
				        			//save the full pdb for current residue
				        			TreePdb curTreePdb=new TreePdb(curPdb);
				        			//curTreePdb.SetRdcRmsd(preRdcRmsd+rdcRms);
				        			curTreePdb.SetNhRdcDif(Math.abs(nhNext_rdc-nhNextRdc)/Const.nhRatio);
				        			curTreePdb.SetChRdcDif(Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			curTreePdb.SetSumRdcDif(pre_sum_rdc+Math.abs(nhNext_rdc-nhNextRdc)/Const.nhRatio+Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			
				        			curTreePdb.SetEndDist(distCa[0]);

				        			curTreePdb.SetRamaScore(preRamaScore+rama_score);
				        			
				        			vecPreChild.add(curTreePdb);
				        			curTreePdb.parenPdb.add(curParent);        			
				        			vecCurPdbTemp.add(curTreePdb);
				        			
				        			//save the possible pdbs for the next residue
				        			TreePdb nextHalfTreePdb=new TreePdb(nextHalfPdb);        			
				        			//nextHalfTreePdb.SetRdcRmsd(preRdcRmsd+rdcRms);//for next residue, the rdc rmsd will be updated later
				        			nextHalfTreePdb.SetNhRdcDif(Math.abs(nhNext_rdc-nhNextRdc)/Const.nhRatio);
				        			nextHalfTreePdb.SetChRdcDif(Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			nextHalfTreePdb.SetSumRdcDif(pre_sum_rdc+Math.abs(nhNext_rdc-nhNextRdc)/Const.nhRatio+Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			
				        			nextHalfTreePdb.SetEndDist(distCa[0]);
				        			nextHalfTreePdb.SetRamaScore(preRamaScore+rama_score);
				        			
				        			curTreePdb.vecChildPdb.add(nextHalfTreePdb);
				        			nextHalfTreePdb.parenPdb.add(curTreePdb);        			
				        			vecNextPdbTemp.add(nextHalfTreePdb);
				        			
				        			if(distCa[0]<minDist)
				    				{
				    					minDist=distCa[0];
				    					FinalPdbS=new TreePdb(curTreePdb);
				    				}
				        			
				        			/*if(vecNextPdbTemp.size()>this.maxLeafNodes)
				        			{
				        				PlaneClustering(resolCluster,vecCurPdbTemp,vecNextPdbTemp);
				        				if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
				        					PlaneClusteringAndTopSelectionNOEs(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum,startResNo,true);
				        			
				        				//if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
				        					//PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum);
				        			}*/

				        			if(vecNextPdbTemp.size()>this.maxLeafNodes)
				        				return false;
						    	}//for (int g =0; g<psiVec.size(); g++)
						    }//if (!psiVec.isEmpty())
						    
						}//for (int h =0; h<phiVec.size(); h++)
						
					}//if (!phiVec.isEmpty())
					
				}//for(int t=0;t<6/rdcGrid;t++)
				
			}//for (int k=0;k<6/rdcGrid;k++)
			
			//get the phi,psi angles of the previous residue: 
			/*Vector vecPdbStart=new Vector();
			vecPdbStart.add(pdbPre);
	    	//Vector vecPhiPsi=new Vector();
	    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbStart);
	    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(0);
			phiS[0]=phipsi.getPhi();
			psiS[0]=phipsi.getPsi(); 	
			*/			
		}//for(int i=0;i<vecCurHalfPdb.size();i++)
		
		//do the clustering step:	
		Vector vecIndex=new Vector();
		if(vecCurPdbTemp.size()>0)
			PlaneClustering(resolCluster,vecCurPdbTemp,vecNextPdbTemp);
		else 
			return false;

		
		if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
			PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecNextPdbTemp,topNum);
				
		vecNextHalfPdb.addAll(vecNextPdbTemp);
		vecCurFullPdb.addAll(vecCurPdbTemp);
		
		vecCurHalfPdb=new Vector();//free space			
		vecFinalPdb.add(FinalPdbS);
		return true;
	}
	/**compute possible phi/psi angles for current residue using RDC-EXACT algorithm. 
     * Use a backward approach.
     @param vecPrePdb vector to store all possible current planes, given previous residue
     @param int curNo current residue number   
     @param chRdc ch rdc of current residue
     @param nhNextRDC nh rdc of the next residue
     @return vecAllPdbs ensemble of all PDBs
     @return 
    */
	public boolean LoopCurResPhiPsiExactSearchBackward(Vector vecCurHalfPdb,int curNo,int startNo,int endResNo,double chRdc, double nhRdc,
			final Vector vecCurFullPdb, final Vector vecPreHalfPdb,boolean isFirst)
	{
		double resolCluster=0.4;//cluster gap for cluster ca, n, hn atoms
		int topNum=1000;//number of top planes that can be selected based on rama or rdc rmsd
		double rdcGrid=0.4;//grid for rdc sampleing, Hz 
		
		//compute the Ramachandaran score:
		Loops lp=new Loops();
		String curResName=lp.GetResNameFromSequence(this.vecSeq,curNo);
    	String nextResName=lp.GetResNameFromSequence(this.vecSeq,curNo+1);
    	boolean isPrePro=false;
    	if(nextResName.equalsIgnoreCase("PRO") && (!curResName.equalsIgnoreCase("PRO")) && (!curResName.equalsIgnoreCase("GLY")) )
    		isPrePro=true;  	
    	
		Vector vecFinalPdb=new Vector();
		TreePdb FinalPdbS=new TreePdb();
		double minDist=999999.9;
		
		Pdb pp=new Pdb();
		ModelRdc mdc=new ModelRdc();
		PdbRdc pdc=new PdbRdc();
				
		int topSSEK=5;//number of SSE anchors
		double distBtwCa=8.0;//distance between loop ca atoms and the SSE ca anchors 			
		//Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,curNo+1);//get the SSE anchors for next residue				
		   
						
		Vector  vecCurPdbTemp=new Vector();//for storing the set of possible pdbs for current residue
		Vector  vecPrePdbTemp=new Vector();//for storing the set of possible pdbs for preceeding residue
		//int rdcSampCycles=50;//number of rdc sampling cycles; choose small number because only one residue is considered
		
		for(int i=0;i<vecCurHalfPdb.size();i++)
		{
			//coordinates of N, nh, ca of current residue:
			double [] coordN  = new double[3];
			double [] coordNH = new double[3];
			double [] coordCA = new double[3]; 
			
			TreePdb pdbTreeCur=(TreePdb)vecCurHalfPdb.elementAt(i);			
			//Vector atomVecStart = pdbTreeCur.pdb.getAtomVec();
			
			TreePdb curParent=(TreePdb)pdbTreeCur.parenPdb.elementAt(0);
			Vector atomVecPar = curParent.pdb.getAtomVec();
			Vector vecParChild=curParent.vecChildPdb;
			vecParChild.remove(pdbTreeCur);//need to double check about this.
			
			//double preRdcRmsd=pdbTreeCur.GetRdcRmsd();
			double preRamaScore=curParent.GetRamaScore();
			double pre_sum_rdc=curParent.GetSumRdcDif();
			
			for (int k=0;k<atomVecPar.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecPar.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)

			PhiPsi ff=new PhiPsi();
			double[] nToNHVec = mdc.internuclearVec(coordN, coordNH);
	        double[] nToCAVec = mdc.internuclearVec(coordN, coordCA);
	        ppGlobal ppg = new ppGlobal();
	        Matrix mat = ff.RgCal(nToNHVec, nToCAVec);
	      
	        //uniformly sample the RDC values
	        Vector phiVec = new Vector();
	        Vector psiVec = new Vector();
			for (int k=0;k<this.rdcThreshold/rdcGrid;k++)
			{
				double ch_rdc=((chRdc-(this.rdcThreshold/2))+k*rdcGrid)/Const.cahaRatio;
				for(int t=0;t<this.rdcThreshold/rdcGrid;t++)
				{
					double nh_rdc=( (nhRdc-(this.rdcThreshold/2))+t*rdcGrid )/Const.nhRatio;		
					
					psiVec = ff.psiCalBackward(this.Syy, this.Szz, ch_rdc, mat);					
					if (!psiVec.isEmpty())
					{				
						for (int h =0; h<psiVec.size(); h++)
						{
						    double psi = ((Double)psiVec.elementAt(h)).doubleValue();					    
						  
						    phiVec =ff.phiCalBackward(Syy, Szz, nh_rdc, psi, mat);
						    if (!phiVec.isEmpty())
						    {
						    	for (int g =0; g<phiVec.size(); g++)
						    	{
						    		double phi = ((Double)phiVec.elementAt(g)).doubleValue();					    	
						    		
						    		//check the Rama region:
				        			double rama_score=0.0;
				        			if(curResName.equalsIgnoreCase("ALA"))
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaAla);
				     			    else if(curResName.equalsIgnoreCase("GLY"))
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaGly);
				     			    else if(curResName.equalsIgnoreCase("PRO"))
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaPro);
				     			    else if(isPrePro)
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,this.vecRamaPrePro);
				     			    else
				     			    {
				     			    	rama_score=lp.CompRamachandranScore(phi,psi,vecRamaGeneral);     			    	
				     			    }
				        			
				        			if(rama_score<=0.02)
				        				continue;						    		
						    		rama_score=-Math.log(rama_score);
						    		
						    		//build up the temp structure fragment        			
				        			Vector<Pdb> pdbFragTemp0 = new Vector<Pdb>();   
				        			pdbFragTemp0=mdc.coordByBackwardNew(phi, psi, coordN, coordNH,coordCA, curNo);
				        			Vector pdbFragTemp= pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0); 
				        							        			
				        			Pdb curPdb=(Pdb)pdbFragTemp.elementAt(1);	
				        			Pdb preHalfPdb= (Pdb)pdbFragTemp.elementAt(0);	
				        			int resNoPre=preHalfPdb.getResidueNo();
				        			Vector atomVecPre  = preHalfPdb.getAtomVec();
				        			double [] coordN_pre  = new double[3];
				        			double [] coordNH_pre = new double[3];
				        			double [] coordCA_pre = new double[3]; 	
				        			for (int f=0;f<atomVecPre .size();f++)
				        			{
				        				Cartesian cc = (Cartesian)atomVecPre .elementAt(f);
				        	    	    String atom = cc.getAtom();	    	   
				        	    	    if (atom.equalsIgnoreCase("N"))
				        	    	    	coordN_pre = cc.getXYZ();
				        	    	    else if (atom.equalsIgnoreCase("CA"))
				        	    	    	coordCA_pre=cc.getXYZ();
				        	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
				        	    	    	coordNH_pre = cc.getXYZ();		    
				        			}//for (int k=0;k<atomVecStart.size();k++)		
				        			
				          			//1. check the steric clash between ca and the SSEs:
				        			//Note: this is a mild steric clash checking. It can 
				        			//be extended to the more accurate approach.
				        			//now only check the steric clash between ca atom and SSEs(including side-chains)        			
				        			//if(!isFirst)
				        			if(resNoPre>startNo)
				        			{
					        			boolean isClash=CheckClashBtwRotCaNSSEs(coordCA_pre);
										if(isClash)
											continue;
				        			}
				        			
				        			////////////////////////////////////////////////////
									//check whether the kin chain restraint is satified
				        			if(resNoPre>=startNo)
				        			{
					        			double errorKin=0.6;
					        			//if(isFirst )//&& Math.abs(startNo-endResNo)>8)
					        			if(resNoPre==startNo)
					        				errorKin=this.gapThreshold;//3.0;//2.0 for long loops (> 8 residues)
					        			else
					        				errorKin=1.0;//0.6
	
										boolean isKinChain=CheckKinChainRestraintBackward(preHalfPdb,startNo,errorKin);
										if(!isKinChain)
										{
											//System.out.println("here we have one kin chain violation...");
											continue;
										}
				        			}

									
									//2. check whether ca statisfies the NOE restraints.
									/*if(!isLast)
									{
										boolean isNOESatisfied=CheckNOEBtwCaNSSEs(nextHalfPdb, vecPdbAchors,distBtwCa);
					        			if(!isNOESatisfied)
					        				continue;
									}*/
									
				        			//double rdcRms=Math.abs(chRdc-ch_rdc)/Const.cahaRatio+Math.abs(nhNext_rdc-nhNextRdc)/Const.nhRatio;
				        			
				        			//3.if last residue in the loop, check the end residue:
				        			double[] dist=new double[1];
				        			double[] distCa=new double[1];
				        			//double[] dist=new double[1];
				        			dist[0]=99999.9;
				        			distCa[0]=99999.9;
				        			if(isFirst)
				        			{
				        				double error=this.gapThreshold;//3.0;//1.5;
				        				int fixNo=curPdb.getResidueNo();
				        				
				        				boolean isClose=CheckFirstResidue(curPdb,fixNo,error,dist,distCa);
				        				if(!isClose)
				        					continue;
				        			}				        			
				        			
				        			///////////////////////////////////////
				        			//save the full pdb for current residue
				        			TreePdb curTreePdb=new TreePdb(curPdb);
				        			
				        			curTreePdb.SetNhRdcDif(Math.abs(nh_rdc-nhRdc)/Const.nhRatio);
				        			curTreePdb.SetChRdcDif(Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			curTreePdb.SetSumRdcDif(pre_sum_rdc+Math.abs(nh_rdc-nhRdc)/Const.nhRatio+ Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			
				        			curTreePdb.SetEndDist(distCa[0]);
				        			curTreePdb.SetRamaScore(preRamaScore+rama_score);
				        			
				        			vecParChild.add(curTreePdb);
				        			curTreePdb.parenPdb.add(curParent);        			
				        			vecCurPdbTemp.add(curTreePdb);
				        			
				        			//save the possible pdbs for the next residue
				        			TreePdb preHalfTreePdb=new TreePdb(preHalfPdb);        			
				        			//nextHalfTreePdb.SetRdcRmsd(preRdcRmsd+rdcRms);//for next residue, the rdc rmsd will be updated later
				        			preHalfTreePdb.SetNhRdcDif(Math.abs(nh_rdc-nhRdc)/Const.nhRatio);
				        			preHalfTreePdb.SetChRdcDif(Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			preHalfTreePdb.SetSumRdcDif(pre_sum_rdc+Math.abs(nh_rdc-nhRdc)/Const.nhRatio+ Math.abs(chRdc-ch_rdc)/Const.cahaRatio);
				        			
				        			preHalfTreePdb.SetEndDist(distCa[0]);
				        			preHalfTreePdb.SetRamaScore(preRamaScore+rama_score);
				        			
				        			curTreePdb.vecChildPdb.add(preHalfTreePdb);
				        			preHalfTreePdb.parenPdb.add(curTreePdb);        			
				        			vecPrePdbTemp.add(preHalfTreePdb);			        			
				        			
				        			if(distCa[0]<minDist)
				    				{
				    					minDist=distCa[0];
				    					FinalPdbS=new TreePdb(curTreePdb);
				    				}
				        			
				        			/*if(vecPrePdbTemp.size()>this.maxLeafNodes)
				        			{
				        				PlaneClusteringBackward(resolCluster,vecCurPdbTemp,vecPrePdbTemp);
				        				//if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
				        				//	PlaneClusteringAndTopSelectionNOEs(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum,startResNo,true);
				        			
				        				//if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
				        					//PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum);
				        			}*/
				        			if(vecPrePdbTemp.size()>this.maxLeafNodes)
				        				return false;
				        			
						    	}//for (int g =0; g<phiVec.size(); g++)
						    }//if (!phiVec.isEmpty())
						    
						}//for (int h =0; h<psiVec.size(); h++)
						
					}//if (!psiVec.isEmpty())
					
				}//for(int t=0;t<6/rdcGrid;t++)
				
			}//for (int k=0;k<6/rdcGrid;k++)
			
			//get the phi,psi angles of the previous residue: 
			/*Vector vecPdbStart=new Vector();
			vecPdbStart.add(pdbPre);
	    	//Vector vecPhiPsi=new Vector();
	    	Vector vecPhiPsiTemp=pp.PhiPsiTotalPdb(vecPdbStart);
	    	PhiPsi phipsi=(PhiPsi)vecPhiPsiTemp.elementAt(0);
			phiS[0]=phipsi.getPhi();
			psiS[0]=phipsi.getPsi(); 	
			*/			
		}//for(int i=0;i<vecCurHalfPdb.size();i++)
		
		//do the clustering step:
		
		Vector vecIndex=new Vector();
		if(vecCurPdbTemp.size()>0)
			PlaneClusteringBackward(resolCluster,vecCurPdbTemp,vecPrePdbTemp);
		else 
			return false;		
		
		if(vecCurPdbTemp.size()>topNum)//which means the fragment lenghth is usually >5
			PlaneClusteringAndTopSelection(resolCluster,vecCurPdbTemp,vecPrePdbTemp,topNum);

		
		vecPreHalfPdb.addAll(vecPrePdbTemp);
		vecCurFullPdb.addAll(vecCurPdbTemp);
		
		vecCurHalfPdb=new Vector();//free space			
		vecFinalPdb.add(FinalPdbS);
		//return vecFinalPdb;
		return true;
	}

	/**
     * clustering the first peptide plane, including ca, n, hn atoms.
     *  
     @param 
     @param      
     @return   
     */
	public void PlaneClustering(double resol,Vector<TreePdb> vecCurTreePdb,Vector<TreePdb> vecNextTreePdb)
	{	
		Vector vecIsChecked=new Vector();
		for(int i=0;i<vecNextTreePdb.size();i++)	
		{
			vecIsChecked.add(new Integer(0));	
			vecIsChecked.set(i, 0);
		}
		vecIsChecked.set(0, 0);
		while(true)
		{
			boolean isAllChecked=true;
			for(int i=0;i<vecIsChecked.size();i++)
			{
				int nTemp=(Integer)vecIsChecked.elementAt(i);
				if(nTemp==0)
				{
					isAllChecked=false;	
					break;
				}
			}
			if(isAllChecked==true)
				break;
			int [] isDele=new int[vecNextTreePdb.size()];
			for(int i=0;i<isDele.length;i++)
				isDele[i]=0;
			
			int counter=0;
			while(counter<vecIsChecked.size())
			{
				int nTemp=(Integer)vecIsChecked.elementAt(counter);
				if(nTemp==1)
					counter++;
				else
					break;
			}
			TreePdb pdb0=(TreePdb)vecNextTreePdb.elementAt(counter);
			
			Vector vecAtom0=pdb0.pdb.getAtomVec();
			//coordinates of N, nh, ca of current residue:
			double [] coordN0  = new double[3];
			double [] coordNH0 = new double[3];
			double [] coordCA0 = new double[3]; 
			for (int k=0;k<vecAtom0.size();k++)
			{
				Cartesian cc = (Cartesian)vecAtom0.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("N"))
	    	    	coordN0 = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA0=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
	    	    	coordNH0 = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)
			isDele[counter]=1;///////
			vecIsChecked.set(counter, 1);
			
			//double rdcRmsd0=pdb0.GetRdcRmsd();
			double ramaScore0=pdb0.GetRamaScore();
			
			TreePdb pdbS=pdb0;//for saving the pdb with min rdc rmsd
			//double rdcRmsdS=rdcRmsd0;//for saving the min rdc rmsd
			double ramaScoreS=ramaScore0;
			
			int indS=counter;
			
			for(int i=counter;i<vecNextTreePdb.size();i++)		
			{
				int nTemp=(Integer)vecIsChecked.elementAt(i);
				if(nTemp==1)
					continue;
				
				TreePdb pdb1=(TreePdb)vecNextTreePdb.elementAt(i);
				Vector vecAtom1=pdb1.pdb.getAtomVec();
				//coordinates of N, nh, ca of current residue:
				double [] coordN1  = new double[3];
				double [] coordNH1 = new double[3];
				double [] coordCA1 = new double[3]; 
				for (int k=0;k<vecAtom1.size();k++)
				{
					Cartesian cc = (Cartesian)vecAtom1.elementAt(k);
		    	    String atom = cc.getAtom();	    	   
		    	    if (atom.equalsIgnoreCase("N"))
		    	    	coordN1 = cc.getXYZ();
		    	    else if (atom.equalsIgnoreCase("CA"))
		    	    	coordCA1=cc.getXYZ();
		    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
		    	    	coordNH1 = cc.getXYZ();		    
				}//for (int k=0;k<atomVecStart.size();k++)
			//	double rdcRmsd1=pdb1.GetRdcRmsd();
				double ramaScore1=pdb1.GetRamaScore();
				
				boolean isInCluster=false;
				double distance_n= Math.sqrt((coordN1[0] - coordN0[0]) * (coordN1[0] - coordN0[0]) 
						+ (coordN1[1] - coordN0[1]) * (coordN1[1] - coordN0[1]) 
						+ (coordN1[2] - coordN0[2]) * (coordN1[2] - coordN0[2]));
				double distance_ca= Math.sqrt((coordCA1[0] - coordCA0[0]) * (coordCA1[0] - coordCA0[0]) 
						+ (coordCA1[1] - coordCA0[1]) * (coordCA1[1] - coordCA0[1]) 
						+ (coordCA1[2] - coordCA0[2]) * (coordCA1[2] - coordCA0[2]));				
				double distance_hn= Math.sqrt((coordNH1[0] - coordNH0[0]) * (coordNH1[0] - coordNH0[0]) 
						+ (coordNH1[1] - coordNH0[1]) * (coordNH1[1] - coordNH0[1]) 
						+ (coordNH1[2] - coordNH0[2]) * (coordNH1[2] - coordNH0[2]));
				if(distance_n<resol && distance_ca<resol && distance_hn<resol)
					isInCluster=true;
				
				if(isInCluster)
				{
					isDele[i]=1;
					vecIsChecked.set(i, 1);
					/*if(rdcRmsd1<rdcRmsdS)
					{
						pdbS=pdb1;
						rdcRmsdS=rdcRmsd1;
						indS=i;
					}*/
					
					if(ramaScore1<ramaScoreS)
					{
						pdbS=pdb1;
						ramaScoreS=ramaScore1;
						indS=i;
					}
					
				}//if(isInCluster)				
			}//for(int i=1;i<vecTreePdb.size();i++)
			
			isDele[indS]=0;
			Vector vecIsDeleNext=new Vector();
			Vector vecIsDeleCur=new Vector();
			for(int i=0;i<isDele.length;i++)
			{
				if(isDele[i]==1)
				{
					vecIsDeleNext.add(new Integer(1));
					vecIsDeleCur.add(new Integer(1));
				}
				else
				{
					vecIsDeleNext.add(new Integer(0));
					vecIsDeleCur.add(new Integer(0));
				}
			}				
			
			for(int i=0;i<vecNextTreePdb.size();i++)		
			{
				int  isDelete=(Integer)vecIsDeleNext.elementAt(i);
				if(isDelete==0)
					continue;
				TreePdb pdbNextT=(TreePdb)vecNextTreePdb.elementAt(i);
				TreePdb pdbTparen=(TreePdb)pdbNextT.parenPdb.elementAt(0);
				Vector vecChild=pdbTparen.vecChildPdb;
				for(int j=0;j<vecChild.size();j++)
				{
					TreePdb pdbTemp=(TreePdb)vecChild.elementAt(j);
					if(pdbTemp.equals(pdbNextT))//double check this
					{
						vecChild.remove(j);
						break;
					}
				}//for(int j=0;j<vecChild.size();j++)
				vecNextTreePdb.remove(i);	
				vecIsDeleNext.remove(i);
				vecIsChecked.remove(i);
				i--;//
			}//for(int i=0;i<vecTreePdb.size();i++)	
			for(int i=0;i<vecCurTreePdb.size();i++)
			{
				int  isDelete=(Integer)vecIsDeleCur.elementAt(i);
				if(isDelete==0)
					continue;
				TreePdb pdbCurT=(TreePdb)vecCurTreePdb.elementAt(i);
				TreePdb pdbTparen=(TreePdb)pdbCurT.parenPdb.elementAt(0);
				Vector vecChild=pdbTparen.vecChildPdb;
				for(int j=0;j<vecChild.size();j++)
				{
					TreePdb pdbTemp=(TreePdb)vecChild.elementAt(j);
					if(pdbTemp.equals(pdbCurT))//double check this
					{
						vecChild.remove(j);
						break;
					}
				}//for(int j=0;j<vecChild.size();j++)
				vecCurTreePdb.remove(i);	
				vecIsDeleCur.remove(i);
				i--;//
				
			}//for(int i=0;i<vecCurTreePdb.size();i++)		
			
		}//while(vecTreePdb.size()>0)		
	}
	/**
     * clustering the first peptide plane, including ca, n, hn atoms.
     *  For backward backbone computation.
     @param 
     @param      
     @return   
     */
	public void PlaneClusteringBackward(double resol,Vector<TreePdb> vecCurTreePdb,Vector<TreePdb> vecPreTreePdb)
	{	
		Vector vecIsChecked=new Vector();
		for(int i=0;i<vecPreTreePdb.size();i++)	
		{
			vecIsChecked.add(new Integer(0));	
			vecIsChecked.set(i, 0);
		}
		vecIsChecked.set(0, 0);
		while(true)
		{
			boolean isAllChecked=true;
			for(int i=0;i<vecIsChecked.size();i++)
			{
				int nTemp=(Integer)vecIsChecked.elementAt(i);
				if(nTemp==0)
				{
					isAllChecked=false;	
					break;
				}
			}
			if(isAllChecked==true)
				break;
			int [] isDele=new int[vecPreTreePdb.size()];
			for(int i=0;i<isDele.length;i++)
				isDele[i]=0;
			
			int counter=0;
			while(counter<vecIsChecked.size())
			{
				int nTemp=(Integer)vecIsChecked.elementAt(counter);
				if(nTemp==1)
					counter++;
				else
					break;
			}
			TreePdb pdb0=(TreePdb)vecPreTreePdb.elementAt(counter);
			
			Vector vecAtom0=pdb0.pdb.getAtomVec();
			//coordinates of N, nh, ca of current residue:
			double [] coordCO2  = new double[3];
			double [] coordC2 = new double[3];
			double [] coordCA2 = new double[3]; 
			for (int k=0;k<vecAtom0.size();k++)
			{
				Cartesian cc = (Cartesian)vecAtom0.elementAt(k);
	    	    String atom = cc.getAtom();	    	   
	    	    if (atom.equalsIgnoreCase("CO")|| atom.equalsIgnoreCase("O"))
	    	    	coordCO2 = cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("CA"))
	    	    	coordCA2=cc.getXYZ();
	    	    else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
	    	    	coordC2 = cc.getXYZ();		    
			}//for (int k=0;k<atomVecStart.size();k++)
			isDele[counter]=1;///////
			vecIsChecked.set(counter, 1);
			
			//double rdcRmsd0=pdb0.GetRdcRmsd();
			double ramaScore0=pdb0.GetRamaScore();
			
			TreePdb pdbS=pdb0;//for saving the pdb with min rdc rmsd
			//double rdcRmsdS=rdcRmsd0;//for saving the min rdc rmsd
			double ramaScoreS=ramaScore0;
			
			int indS=counter;
			
			for(int i=counter;i<vecPreTreePdb.size();i++)		
			{
				int nTemp=(Integer)vecIsChecked.elementAt(i);
				if(nTemp==1)
					continue;
				
				TreePdb pdb1=(TreePdb)vecPreTreePdb.elementAt(i);
				Vector vecAtom1=pdb1.pdb.getAtomVec();
				//coordinates of N, nh, ca of current residue:
				double [] coordCO1  = new double[3];
				double [] coordC1 = new double[3];
				double [] coordCA1 = new double[3]; 
				for (int k=0;k<vecAtom1.size();k++)
				{
					Cartesian cc = (Cartesian)vecAtom1.elementAt(k);
		    	    String atom = cc.getAtom();	    	   
		    	    if (atom.equalsIgnoreCase("CO")|| atom.equalsIgnoreCase("O"))
		    	    	coordCO1 = cc.getXYZ();
		    	    else if (atom.equalsIgnoreCase("CA"))
		    	    	coordCA1=cc.getXYZ();
		    	    else if (atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("C'"))
		    	    	coordC1 = cc.getXYZ();		    
				}//for (int k=0;k<atomVecStart.size();k++)
			//	double rdcRmsd1=pdb1.GetRdcRmsd();
				double ramaScore1=pdb1.GetRamaScore();
				
				boolean isInCluster=false;
				double distance_co= Math.sqrt((coordCO1[0] - coordCO2[0]) * (coordCO1[0] - coordCO2[0]) 
						+ (coordCO1[1] - coordCO2[1]) * (coordCO1[1] - coordCO2[1]) 
						+ (coordCO1[2] - coordCO2[2]) * (coordCO1[2] - coordCO2[2]));
				double distance_ca= Math.sqrt((coordCA1[0] - coordCA2[0]) * (coordCA1[0] - coordCA2[0]) 
						+ (coordCA1[1] - coordCA2[1]) * (coordCA1[1] - coordCA2[1]) 
						+ (coordCA1[2] - coordCA2[2]) * (coordCA1[2] - coordCA2[2]));				
				double distance_c= Math.sqrt((coordC2[0] - coordC1[0]) * (coordC2[0] - coordC1[0]) 
						+ (coordC2[1] - coordC1[1]) * (coordC2[1] - coordC1[1]) 
						+ (coordC2[2] - coordC1[2]) * (coordC2[2] - coordC1[2]));
				if(distance_co<resol && distance_ca<resol && distance_c<resol)
					isInCluster=true;
				
				if(isInCluster)
				{
					isDele[i]=1;
					vecIsChecked.set(i, 1);
					/*if(rdcRmsd1<rdcRmsdS)
					{
						pdbS=pdb1;
						rdcRmsdS=rdcRmsd1;
						indS=i;
					}*/
					
					if(ramaScore1<ramaScoreS)
					{
						pdbS=pdb1;
						ramaScoreS=ramaScore1;
						indS=i;
					}
					
				}//if(isInCluster)				
			}//for(int i=1;i<vecTreePdb.size();i++)
			
			isDele[indS]=0;
			Vector vecIsDeleNext=new Vector();
			Vector vecIsDeleCur=new Vector();
			for(int i=0;i<isDele.length;i++)
			{
				if(isDele[i]==1)
				{
					vecIsDeleNext.add(new Integer(1));
					vecIsDeleCur.add(new Integer(1));
				}
				else
				{
					vecIsDeleNext.add(new Integer(0));
					vecIsDeleCur.add(new Integer(0));
				}
			}				
			
			for(int i=0;i<vecPreTreePdb.size();i++)		
			{
				int  isDelete=(Integer)vecIsDeleNext.elementAt(i);
				if(isDelete==0)
					continue;
				TreePdb pdbNextT=(TreePdb)vecPreTreePdb.elementAt(i);
				TreePdb pdbTparen=(TreePdb)pdbNextT.parenPdb.elementAt(0);
				Vector vecChild=pdbTparen.vecChildPdb;
				for(int j=0;j<vecChild.size();j++)
				{
					TreePdb pdbTemp=(TreePdb)vecChild.elementAt(j);
					if(pdbTemp.equals(pdbNextT))//double check this
					{
						vecChild.remove(j);
						break;
					}
				}//for(int j=0;j<vecChild.size();j++)
				vecPreTreePdb.remove(i);	
				vecIsDeleNext.remove(i);
				vecIsChecked.remove(i);
				i--;//
			}//for(int i=0;i<vecTreePdb.size();i++)	
			for(int i=0;i<vecCurTreePdb.size();i++)
			{
				int  isDelete=(Integer)vecIsDeleCur.elementAt(i);
				if(isDelete==0)
					continue;
				TreePdb pdbCurT=(TreePdb)vecCurTreePdb.elementAt(i);
				TreePdb pdbTparen=(TreePdb)pdbCurT.parenPdb.elementAt(0);
				Vector vecChild=pdbTparen.vecChildPdb;
				for(int j=0;j<vecChild.size();j++)
				{
					TreePdb pdbTemp=(TreePdb)vecChild.elementAt(j);
					if(pdbTemp.equals(pdbCurT))//double check this
					{
						vecChild.remove(j);
						break;
					}
				}//for(int j=0;j<vecChild.size();j++)
				vecCurTreePdb.remove(i);	
				vecIsDeleCur.remove(i);
				i--;//
				
			}//for(int i=0;i<vecCurTreePdb.size();i++)		
			
		}//while(vecTreePdb.size()>0)		
	}
	/**
     * clustering the first peptide plane, including ca, n, hn atoms, and selecting the top planes.
       
     @param resol
     @param vecCurTreePdb,vecNextTreePdb
     @param topNum number of top selected planes.
     @return   
     */
	public void PlaneClusteringAndTopSelection(double resol, Vector<TreePdb> vecCurTreePdb, Vector<TreePdb> vecNextTreePdb,
			int topNum)
	{	
		//update the ID of each tree pdb:
		for(int i=0;i<vecCurTreePdb.size();i++)
		{
			TreePdb treeCurPdb=(TreePdb)vecCurTreePdb.elementAt(i);
			TreePdb treeNextPdb=(TreePdb)vecNextTreePdb.elementAt(i);
			treeCurPdb.SetID(i);
			treeNextPdb.SetID(i);
		}//for(int i=0;i<vecCurTreePdb.size();i++)
		
		Vector vecCurTreePdbTemp=new Vector();
		vecCurTreePdbTemp.addAll(vecCurTreePdb);		
		
		Vector vecCurRama=new Vector();
		
		//debugging...
		//Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbAllComparator());
		
		Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbRamaComparator());
		
		for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
			vecCurRama.add(treePdb);
		}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
		
		
		Vector vecCurRdc=new Vector();
		Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbRDCComparator());//this has better results
		//Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbSumRDCComparator());
		
		TreePdb treePdb0=(TreePdb)vecCurTreePdb.elementAt(0);
		if( (treePdb0.GetChRdcDif()>-1000.0) || (treePdb0.GetNhRdcDif()>-1000.0))
		{
			for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
			{
				TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
				vecCurRdc.add(treePdb);
			}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
			
		
			//finding the intersection subset:
			for(int i=0;i<vecCurRama.size();i++)
			{
				TreePdb treePdb=(TreePdb)vecCurRama.elementAt(i);
				if(!vecCurRdc.contains(treePdb))
				{
					vecCurRama.remove(i);
					i--;//
				}
				
			}//for(int i=0;i<vecCurRama.size();i++)
		}//if( (treePdb0.GetChRdcDif()>-1000.0) && (treePdb0.GetNhRdcDif()>-1000.0))
		
		
		for(int i=0; i<vecCurTreePdb.size();i++)
		{
			TreePdb treePdb=(TreePdb)vecCurTreePdb.elementAt(i);
			int idNext=treePdb.GetID();
			boolean isIn=false;
			for(int j=0;j<vecCurRama.size();j++)
			{
				TreePdb treePdbTemp=(TreePdb)vecCurRama.elementAt(j);
				if(treePdbTemp.GetID()==idNext)
				{
					isIn=true;
					break;
				}
			}//for(int j=0;j<vecCurRama.size();j++)
		
			if(!isIn)
			{
				vecCurTreePdb.remove(i);
				i--;
			}
				
		}//for(int i=0; i<vecNextTreePdb.size();i++)
		
		//Vector vecNextNew=new Vector();
		for(int i=0; i<vecNextTreePdb.size();i++)
		{
			TreePdb treePdb=(TreePdb)vecNextTreePdb.elementAt(i);
			int idNext=treePdb.GetID();
			boolean isIn=false;
			for(int j=0;j<vecCurRama.size();j++)
			{
				TreePdb treePdbTemp=(TreePdb)vecCurRama.elementAt(j);
				if(treePdbTemp.GetID()==idNext)
				{
					isIn=true;
					break;
				}
			}//for(int j=0;j<vecCurRama.size();j++)
		
			if(!isIn)
			{
				vecNextTreePdb.remove(i);
				i--;
			}
				
		}//for(int i=0; i<vecNextTreePdb.size();i++)
		
		//vecCurTreePdb=new Vector();
		//vecCurTreePdb.addAll(vecCurRama);
		//vecNextTreePdb=new Vector();
		//vecNextTreePdb.addAll(vecNextNew);		
	}
	/**
     * clustering the first peptide plane, including ca, n, hn atoms, and selecting the top planes. 
     * similar to PlaneClusteringAndTopSelection, but with additional NOE pattern score.
       
     @param resol
     @param vecCurTreePdb,vecNextTreePdb
     @param topNum number of top selected planes.
     @param noStart residue num of end
     @param isForward whether is forward or backward, 1 if forward.
     @return   
     */
	public void PlaneClusteringAndTopSelectionNOEs(double resol, Vector<TreePdb> vecCurTreePdb, Vector<TreePdb> vecNextTreePdb,
			int topNum,int noStart,boolean isForward)
	{	
		double distUpCa=8.0;
		int numNOEGap=60;//
		int maxNum=50;
		
		//update the ID of each tree pdb:
		for(int i=0;i<vecCurTreePdb.size();i++)
		{
			TreePdb treeCurPdb=(TreePdb)vecCurTreePdb.elementAt(i);
			TreePdb treeNextPdb=(TreePdb)vecNextTreePdb.elementAt(i);
			treeCurPdb.SetID(i);
			treeNextPdb.SetID(i);
		}//for(int i=0;i<vecCurTreePdb.size();i++)
		
		Vector vecCurTreePdbTemp=new Vector();
		vecCurTreePdbTemp.addAll(vecCurTreePdb);		
		
		Vector vecCurRama=new Vector();
		Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbRamaComparator());
		for(int i=0;i<Math.min(topNum*1.5, vecCurTreePdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
			vecCurRama.add(treePdb);
		}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
		
		
		//////////////////////////////////
		TreePdb treePdb0=(TreePdb)vecCurTreePdb.elementAt(0);
		if((treePdb0.GetChRdcDif()>-1000.0) && (treePdb0.GetNhRdcDif()>-1000.0) )
		{
			Vector vecCurRdc=new Vector();
			Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbRDCComparator());//this has better results
			//Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbSumRDCComparator());
			
			for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
			{
				TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
				vecCurRdc.add(treePdb);
			}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
			
				
			//finding the intersection subset:
			for(int i=0;i<vecCurRama.size();i++)
			{
				TreePdb treePdb=(TreePdb)vecCurRama.elementAt(i);
				if(!vecCurRdc.contains(treePdb))
				{
					vecCurRama.remove(i);
					i--;//
				}
				
			}//for(int i=0;i<vecCurRama.size();i++)
		}
		//////////////////////////////////
		
		
		///////////////////////////////////////////////		
		//update the NOE scores:
		for(int i=0;i<vecCurTreePdbTemp.size();i++)
		{
			Vector vecLoopFrag=new Vector();
			TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
			TreePdb treeCurPdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
			int resNo=treeCurPdb.pdb.getResidueNo();
			TreePdb treePdbEnd=(TreePdb)treeCurPdb.vecChildPdb.elementAt(0);
			vecLoopFrag.add(treePdbEnd.pdb);
			if(isForward)
			{
				while(resNo>=noStart)
				{
					vecLoopFrag.add(treeCurPdb.pdb);
					if(resNo==noStart) 
						break;
					
					treeCurPdb=(TreePdb)treeCurPdb.parenPdb.elementAt(0);
					resNo=treeCurPdb.pdb.getResidueNo();			
				}//while(resNo>=noStart)
			}
			else
			{
				while(resNo<=noStart)
				{
					vecLoopFrag.add(treeCurPdb.pdb);
					if(resNo==noStart) 
						break;
					
					treeCurPdb=(TreePdb)treeCurPdb.parenPdb.elementAt(0);
					resNo=treeCurPdb.pdb.getResidueNo();			
				}//while(resNo>=noStart)
			}
			Collections.sort(vecLoopFrag, new Pdb.PdbComparator());	
			
			
			//check NOE statisfaction score:
			int counter=0;
			for(int j=0;j<this.vecAmbNOEs.size();j++)
			{
				boolean isSatisfied=false;
				Noe noe=(Noe)this.vecAmbNOEs.elementAt(j);
				int resNoA=noe.getResidueNoA();
				int resNoB=noe.getResidueNoB();
				
				//new:
				String atomA=noe.getAtomA();
				String atomB=noe.getAtomB();
				String sub_atomA=atomA;
				String sub_atomB=atomB;
				if(atomA.length()>=2)
					sub_atomA=atomA.substring(0,2);
				if(atomB.length()>=2)
					sub_atomB=atomB.substring(0,2);
				
				for(int k=0;k<vecLoopFrag.size();k++)
				{
					Pdb pdbLoop=(Pdb)vecLoopFrag.elementAt(k);
					int resNoLoop=pdbLoop.getResidueNo();
					if( !( (resNoLoop==resNoA) || (resNoLoop==resNoB) ))
						continue;
					
					Vector vecAtomLoop=pdbLoop.getAtomVec();
					double [] caLoop = new double[3];
					for(int kk=0;kk<vecAtomLoop.size();kk++)
					{
						Cartesian cc = (Cartesian)vecAtomLoop.elementAt(kk);
						String atom = cc.getAtom();
						if (atom.equalsIgnoreCase("CA"))
							caLoop=cc.getXYZ();
					}//for(int t=0;t<vecAtomSSE.size();t++)

					for(int t=0;t<this.vecPdbSSE.size();t++)
					{
						Pdb pdbSSE=(Pdb)this.vecPdbSSE.elementAt(t);
						int resNoSSE=pdbSSE.getResidueNo();
						if( !( (resNoSSE==resNoA) || (resNoSSE==resNoB) ))
							continue;
						
						Vector vecAtomSSE=pdbSSE.getAtomVec();
						double [] caSSE = new double[3];
						for(int tt=0;tt<vecAtomSSE.size();tt++)
						{
							Cartesian cc = (Cartesian)vecAtomSSE.elementAt(tt);
							String atom = cc.getAtom();
							if (atom.equalsIgnoreCase("CA"))
								caSSE=cc.getXYZ();
						}//for(int t=0;t<vecAtomSSE.size();t++)

						if(  !( ((resNoSSE==resNoA)&&(resNoLoop==resNoB)) || ((resNoSSE==resNoB)&&(resNoLoop==resNoA)) ) )
							continue;
							
							
						///////////////new:
						/*if(((resNoSSE==resNoA)&&(resNoLoop==resNoB)))
						{
							if( !( sub_atomB.equalsIgnoreCase("H")|| sub_atomB.equalsIgnoreCase("HN")|| sub_atomB.equalsIgnoreCase("HA")|| sub_atomB.equalsIgnoreCase("HB")   ))
								continue;
						}
							
						if(((resNoSSE==resNoB)&&(resNoLoop==resNoA)))
						{
							if( !( sub_atomA.equalsIgnoreCase("H")|| sub_atomA.equalsIgnoreCase("HN")|| sub_atomA.equalsIgnoreCase("HA")|| sub_atomA.equalsIgnoreCase("HB")   ))
								continue;
						}*/
						
						
						double distance= Math.sqrt((caSSE[0] - caLoop[0]) * (caSSE[0] - caLoop[0]) 
								+ (caSSE[1] - caLoop[1]) * (caSSE[1] - caLoop[1]) 
								+ (caSSE[2] - caLoop[2]) * (caSSE[2] - caLoop[2]));
						
						if(distance < distUpCa)
						{
							isSatisfied=true;
							break;
						}							
						
					}//for(int t=0;t<this.vecPdbSSE.size();t++)
					if(isSatisfied==true)
						break;
					
				}//for(int k=0;k<vecLoopFrag.size();k++)
				if(isSatisfied)
					counter++;				
				
			}//for(int i=0;i<this.vecAmbNOEs.size();i++)

			treePdb.noeScore=counter;			

		}//for(int i=0;i<vecCurTreePdbTemp.size();i++)
		
		Vector vecCurNoe=new Vector();
		Collections.sort(vecCurTreePdbTemp, new Goal.TreePdbNOEComparator());
		TreePdb treepdb=(TreePdb)vecCurTreePdbTemp.elementAt(0);
		double  maxNoeNum=treepdb.noeScore;
		for(int i=0;i<vecCurTreePdbTemp.size();i++)
		{
			TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
			if(Math.abs(treePdb.noeScore-maxNoeNum)<numNOEGap)
			{
				vecCurNoe.add(treePdb);				
			}
			else
				break;
			if(vecCurNoe.size()>=maxNum)
				break;
			
		}//for(int i=0;i<vecCurRama.size();i++)*/
		Collections.sort(vecCurNoe, new Goal.TreePdbNOEComparator());
		//vecCurRama=new Vector();
		//vecCurRama.addAll(vecCurNoe);
		
		/*Vector vecCurNoe=new Vector();
		for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)
		{
			TreePdb treePdb=(TreePdb)vecCurTreePdbTemp.elementAt(i);
			vecCurNoe.add(treePdb);
		}//for(int i=0;i<Math.min(topNum, vecCurTreePdbTemp.size());i++)	
		*/
		//finding the intersection subset:
		for(int i=0;i<vecCurRama.size();i++)
		{
			TreePdb treePdb=(TreePdb)vecCurRama.elementAt(i);
			if(!vecCurNoe.contains(treePdb))
			{
				vecCurRama.remove(i);
				i--;//
			}
			
		}//for(int i=0;i<vecCurRama.size();i++)
		
		//vecCurRama=new Vector ();
		//vecCurRama.addAll(vecCurNoe);
		////////////////////////////////////////////////////////////
				
		////////////////////////////////////////////////////////////
		for(int i=0; i<vecCurTreePdb.size();i++)
		{
			TreePdb treePdb=(TreePdb)vecCurTreePdb.elementAt(i);
			int idNext=treePdb.GetID();
			boolean isIn=false;
			for(int j=0;j<vecCurRama.size();j++)
			{
				TreePdb treePdbTemp=(TreePdb)vecCurRama.elementAt(j);
				if(treePdbTemp.GetID()==idNext)
				{
					isIn=true;
					break;
				}
			}//for(int j=0;j<vecCurRama.size();j++)
		
			if(!isIn)
			{
				vecCurTreePdb.remove(i);
				i--;
			}
				
		}//for(int i=0; i<vecNextTreePdb.size();i++)
		
		//Vector vecNextNew=new Vector();
		for(int i=0; i<vecNextTreePdb.size();i++)
		{
			TreePdb treePdb=(TreePdb)vecNextTreePdb.elementAt(i);
			int idNext=treePdb.GetID();
			boolean isIn=false;
			for(int j=0;j<vecCurRama.size();j++)
			{
				TreePdb treePdbTemp=(TreePdb)vecCurRama.elementAt(j);
				if(treePdbTemp.GetID()==idNext)
				{
					isIn=true;
					break;
				}
			}//for(int j=0;j<vecCurRama.size();j++)
		
			if(!isIn)
			{
				vecNextTreePdb.remove(i);
				i--;
			}
				
		}//for(int i=0; i<vecNextTreePdb.size();i++)
		
		//vecCurTreePdb=new Vector();
		//vecCurTreePdb.addAll(vecCurRama);
		//vecNextTreePdb=new Vector();
		//vecNextTreePdb.addAll(vecNextNew);		
	}

	/**
     * Compute a structure, given the backbone and rotamers at all residue positions
     *  
     @param noStart starting residue number of the loop
     @param noEnd last residue number of the loop     
     @return a vector storing all candidate positions.
    
     */
	public Vector RotamerReplacement(int noStart,int noEnd )
	{		
		Pdb pp=new Pdb();
		
		//for debuggging...
		String userDirTemp = System.getProperty("user.dir");////
		String refPdbFileDebugging = userDirTemp+"/inputFiles/1UBQHNew.pdb";
    	Vector vecPdbRef= pp.readPdb(refPdbFileDebugging);
    	/////////////////////////////
    	
		
		//get the coordinates of endpoints:
		String resStart="", resEnd="";
		Vector vecAtomStart=new Vector();
		Vector vecAtomEnd=new Vector();
		double [] caStart = new double[3];
		double [] caEnd = new double[3];
		
		int index = Collections.binarySearch(vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
		if (index > -1)
		{
			Pdb pdb = (Pdb)vecPdbSSE.elementAt(index);
			resStart=pdb.getResidue();
			vecAtomStart=pdb.getAtomVec();
			for (int j=0; j<vecAtomStart.size(); j++)
	    	{ 
				Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
				String atom = cc.getAtom();
				if (atom.equalsIgnoreCase("CA"))
					caStart=cc.getXYZ();
	    	}//for (int j=0; j<vecAtomStart.size(); j++)
		}//if (index > -1)
		
		index = Collections.binarySearch(vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
		if (index > -1)
		{
			Pdb pdb = (Pdb)vecPdbSSE.elementAt(index);
			resEnd=pdb.getResidue();
			vecAtomEnd=pdb.getAtomVec();
			for (int j=0; j<vecAtomEnd.size(); j++)
	    	{ 
				Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
				String atom = cc.getAtom();
				if (atom.equalsIgnoreCase("CA"))
					caEnd=cc.getXYZ();
	    	}//for (int j=0; j<vecAtomStart.size(); j++)
		}//if (index > -1)
		
		//search the possible rotamer conformations 
		int topSSEK=5;//number of SSE anchors
		double caSearchRange=12.0;//search range between ca atoms (A)
		
		Vector<Vector> vecAllCandPos=new Vector<Vector>();//the chain of all candidate positions
		for(int i=noStart+1;i<noEnd;i++)
		{
			//get the residue type:
			String resid="";
			for(int j=0;j<vecSeq.size();j++)
			{
				Assign asg = (Assign)vecSeq.elementAt(j);
				int no = asg.getResidueNo();			    
			    if(no==i)
			    	resid = (asg.getResidueType()).trim();			    	
			}//for(int j=0;j<vecSeq.size();j++)
			
			String rotamFile=rotSrc+ resid.toLowerCase()+ ".pdb"; 
			Vector pdbRotam=new Vector();
			pdbRotam=pp.readRotamerPdb(rotamFile);//which includes all rotamers			
			
			Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,i);
			
			//use a coarse-to-fine strategy for sampling		
			double searchRadius=11.0;//radius of search range.
			
			//for(int j=0;j<pdbRotam.size();j++)
			//{
				Pdb pdb_rot=(Pdb)pdbRotam.elementAt(0);
				Vector<Pdb> vecRotPdb=new Vector<Pdb>();
				vecRotPdb.add(pdb_rot);
				double scoreMax=-99999.9;
				double [] bestTranS=new double[3];
				double [] bestRotS=new double[3];
				
				Vector vecCandPosTemp=new Vector();
				
				for(int k=0;k<vecPdbAchors.size();k++)
				{
					Vector<RotaPattern> vecCandPos=new Vector<RotaPattern>();//for storing candidate positions.
					
					Pdb ppSSE=(Pdb)vecPdbAchors.elementAt(k);					
					
					Vector vecAtomSSE=ppSSE.getAtomVec();
					double [] caSSE = new double[3];					
					for(int t=0;t<vecAtomSSE.size();t++)
					{
						Cartesian cc = (Cartesian)vecAtomSSE.elementAt(t);
						String atom = cc.getAtom();
						if (atom.equalsIgnoreCase("CA"))
							caSSE=cc.getXYZ();
					}//for(int t=0;t<vecAtomSSE.size();t++)
					
					
					double [] bestTran=new double[3];					
					double[] tranResol=new double[3];//grid resolution for translation
					double[] tranX0=new double[3];
					double[] tranXn=new double[3];
					tranX0[0]=0.0;tranXn[0]=180.0;
					tranX0[1]=0.0;tranXn[1]=360.0;	
					tranX0[2]=3.8;tranXn[2]=8.0;//upper bound is obtained for several test cases, need to be double checked	
					tranResol[0]=10;//30;
					tranResol[1]=10;//30; 
					tranResol[2]=0.5;//0.5; 	//need to double check	 	
					int noCur=i;
					double sc=TranRotGridSearchNew(caSSE,tranX0, tranXn,tranResol,bestTran, noStart,  noEnd, noCur, vecCandPos);
					
					System.out.println("here after finshing grid search..."+ i+"th residue...and " +k +"th anchor ("+ppSSE.getResidueNo()+")"); 									
					System.out.println("The tatoal number of candidate position for this anchor: "+vecCandPos.size() );
					//vecCandPos.add(bestTran);	
					vecCandPosTemp.addAll(vecCandPos);				
					
				}//for(int k=0;k<vecPdbAchors.size();k++)
										
				Collections.sort(vecCandPosTemp, new RotaPattern.scoreComparator());
				
				int chosenNum=150;
				Vector vecCandPosRefined=new Vector();
				for (int g=0;g<Math.min(chosenNum,vecCandPosTemp.size());g++)
				{
					RotaPattern rotPatn=(RotaPattern)vecCandPosTemp.elementAt(g);
					vecCandPosRefined.add(rotPatn);
				}
				
				vecCandPosRefined=new Vector();
				for (int e=0;e<vecCandPosTemp.size();e++)
				{
					RotaPattern rotPatn=(RotaPattern)vecCandPosTemp.elementAt(e);
					if(rotPatn.getScore()>0)
						vecCandPosRefined.add(rotPatn);
				}
				
				vecAllCandPos.add(vecCandPosRefined);
				
				
				//for debugging...
				/*if(vecAllCandPos.size()<1)
					continue;		
				Vector vecTemp=new Vector();
				vecTemp.add(vecCandPosRefined);
				EvaluateCandPositions(noStart, noEnd,vecTemp,vecPdbRef);
				*/
				
				//vecCandPos.add(bestTranS);				
			//}//for(int j=0;j<pdbRotam.size();j++)	
			
		}//for(int i=noStart+1;i<noEnd;i++)	
		return vecAllCandPos;		
	}//end of function RotamerReplacement()
			
	/**
     * Compute a structure, given the backbone and rotamers at all residue positions
     *  
     @param noStart starting residue number of the loop
     @param noEnd last residue number of the loop     
     @return a vector storing all candidate positions.
    
     */
	public Vector RotamerReplacementOld(int noStart,int noEnd )
	{			
		Pdb pp=new Pdb();
		//get the coordinates of endpoints:
		String resStart="", resEnd="";
		Vector vecAtomStart=new Vector();
		Vector vecAtomEnd=new Vector();
		double [] caStart = new double[3];
		double [] caEnd = new double[3];
		
		int index = Collections.binarySearch(vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
		if (index > -1)
		{
			Pdb pdb = (Pdb)vecPdbSSE.elementAt(index);
			resStart=pdb.getResidue();
			vecAtomStart=pdb.getAtomVec();
			for (int j=0; j<vecAtomStart.size(); j++)
	    	{ 
				Cartesian cc = (Cartesian)vecAtomStart.elementAt(j);
				String atom = cc.getAtom();
				if (atom.equalsIgnoreCase("CA"))
					caStart=cc.getXYZ();
	    	}//for (int j=0; j<vecAtomStart.size(); j++)
		}//if (index > -1)
		
		index = Collections.binarySearch(vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
		if (index > -1)
		{
			Pdb pdb = (Pdb)vecPdbSSE.elementAt(index);
			resEnd=pdb.getResidue();
			vecAtomEnd=pdb.getAtomVec();
			for (int j=0; j<vecAtomEnd.size(); j++)
	    	{ 
				Cartesian cc = (Cartesian)vecAtomEnd.elementAt(j);
				String atom = cc.getAtom();
				if (atom.equalsIgnoreCase("CA"))
					caEnd=cc.getXYZ();
	    	}//for (int j=0; j<vecAtomStart.size(); j++)
		}//if (index > -1)
		
		//search the possible rotamer conformations 
		int topSSEK=5;//number of SSE anchors
		double caSearchRange=12.0;//search range between ca atoms (A)
		
		Vector<Vector> vecAllCandPos=new Vector<Vector>();//the chain of all candidate positions
		for(int i=noStart+1;i<noEnd;i++)
		{
			//get the residue type:
			String resid="";
			for(int j=0;j<vecSeq.size();j++)
			{
				Assign asg = (Assign)vecSeq.elementAt(j);
				int no = asg.getResidueNo();			    
			    if(no==i)
			    	resid = (asg.getResidueType()).trim();			    	
			}//for(int j=0;j<vecSeq.size();j++)
			
			String rotamFile=rotSrc+ resid.toLowerCase()+ ".pdb"; 
			Vector pdbRotam=new Vector();
			pdbRotam=pp.readRotamerPdb(rotamFile);//which includes all rotamers			
			
			Vector<Pdb> vecPdbAchors=SearchSSEAnchors(topSSEK,i);
			
			//use a coarse-to-fine strategy for sampling		
			double searchRadius=11.0;//radius of search range.
			Vector<double[]> vecCandPos=new Vector<double[]>();//for storing candidate positions.
			
			//for(int j=0;j<pdbRotam.size();j++)
			//{
				Pdb pdb_rot=(Pdb)pdbRotam.elementAt(0);
				Vector<Pdb> vecRotPdb=new Vector<Pdb>();
				vecRotPdb.add(pdb_rot);
				double scoreMax=-99999.9;
				double [] bestTranS=new double[3];
				double [] bestRotS=new double[3];
				
				for(int k=0;k<vecPdbAchors.size();k++)
				{
					Pdb ppSSE=(Pdb)vecPdbAchors.elementAt(k);
					Vector vecAtomSSE=ppSSE.getAtomVec();
					double [] caSSE = new double[3];
					double [] caSSEOrg=new double[3];
					double [] caSSEEnd=new double[3];
					double [] rotOrg=new double[3];
					double [] rotEnd=new double[3];
					double [] bestTran=new double[3];
					double [] bestRot=new double[3];
					for(int t=0;t<vecAtomSSE.size();t++)
					{
						Cartesian cc = (Cartesian)vecAtomSSE.elementAt(t);
						String atom = cc.getAtom();
						if (atom.equalsIgnoreCase("CA"))
							caSSE=cc.getXYZ();
					}//for(int t=0;t<vecAtomSSE.size();t++)
					
					
					//First. use coarse sampling (i.e., using large grid resolution)
					double tranResol=2.0;//grid resolution for translation
					double rotResol=45.0;//grid resolution for rotation
					double tranResolCoarse=tranResol;

					caSSEOrg[0]=caSSE[0]+4.0;
					caSSEOrg[1]=caSSE[1]+4.0;
					caSSEOrg[2]=caSSE[2]+4.0;
					caSSEEnd[0]=caSSE[0]+searchRadius;
					caSSEEnd[1]=caSSE[1]+searchRadius;
					caSSEEnd[2]=caSSE[2]+searchRadius;
					rotOrg[0]=0.0;rotOrg[1]=0.0;rotOrg[2]=0.0;
					rotEnd[0]=180.0;rotEnd[1]=180.0;rotEnd[2]=180.0;
					double sc=TranRotGridSearch(caSSEOrg,caSSEEnd,rotOrg,rotEnd,vecRotPdb,tranResol,rotResol,false,bestTran,bestRot);
					
					System.out.println("here after coarse sampling..."+ i+"th...rotamer");
					
					//Second. Use fine sampling (i.e., using small grid resolution)
					tranResol=0.6;//Todo: try smaller resolution
					rotResol=10.0;
					caSSEOrg[0]=bestTran[0]-1.5;
					caSSEOrg[1]=bestTran[1]-1.5;
					caSSEOrg[2]=bestTran[2]-1.5;
					caSSEEnd[0]=bestTran[0]+1.5;
					caSSEEnd[1]=bestTran[1]+1.5;
					caSSEEnd[2]=bestTran[2]+1.5;
					rotOrg[0]=Math.max(bestRot[0]-20,0);rotOrg[1]=Math.max(bestRot[1]-20,0);rotOrg[2]=Math.max(bestRot[2]-20,0);
					rotEnd[0]=Math.min(bestRot[0]+20,180);rotEnd[1]=Math.min(bestRot[1]+20,180);rotEnd[2]=Math.min(bestRot[2]+20,180);
					sc=TranRotGridSearch(caSSEOrg,caSSEEnd,rotOrg,rotEnd,vecRotPdb,tranResol,rotResol,false,bestTran,bestRot);
										
					System.out.println("here after fine sampling..."+ i+"th...rotamer");
					
					if(sc>scoreMax)
					{
						scoreMax=sc;
						System.arraycopy(bestTran, 0, bestTranS, 0, bestTran.length);
						System.arraycopy(bestRot, 0, bestRotS, 0, bestRot.length);
					}//if(sc>scoreMax)					
					
					vecCandPos.add(bestTran);	
				}//for(int k=0;k<vecPdbAchors.size();k++)
				//vecCandPos.add(bestTranS);				
			//}//for(int j=0;j<pdbRotam.size();j++)	
			vecAllCandPos.add(vecCandPos);
		}//for(int i=noStart+1;i<noEnd;i++)	
		return vecAllCandPos;		
	}//end of function RotamerReplacement()
			

	
	/** 
     * evaluate the set of candidate positions based on the known reference structure
     * 
     @param noStart,noEnd endpoints of the loop 
     @param vecCandPosAll the chain of all candidate positions
     @param vecPdbRef reference structure pdb (under the same frame)
     @return void
     */       
    public void EvaluateCandPositions(int noStart, int noEnd,Vector vecCandPosAll,Vector vecPdbRef)
    {
	
		//evaluate the candidate positions:
		for(int i=noStart+1;i<noEnd;i++)
		{
			int indTemp= Collections.binarySearch(vecPdbRef, new Pdb(i), new Pdb.PdbComparator() );
			if (indTemp<0)
			{
				System.out.println("the starting residue not found...exist.");
				System.exit(0);		 
			}
			Pdb pdbRefCur=(Pdb)vecPdbRef.elementAt(indTemp);
			Vector atomVecRefCur = pdbRefCur.getAtomVec();
			double[] caRefCur=new double[3];
			for (int k=0;k<atomVecRefCur.size();k++)
			{
				Cartesian cc = (Cartesian)atomVecRefCur.elementAt(k);
	    	    String atom = cc.getAtom();	       	  
	    	    if (atom.equalsIgnoreCase("CA"))
	    	    	caRefCur=cc.getXYZ();
			}
			int index=i-(noStart+1);
			Vector vecCandPosCur=(Vector)vecCandPosAll.elementAt(index);
			double minDist=999999.9;
			if(vecCandPosCur.size()<1)
			{
				System.out.println("empty candidate position set...");
				continue;
			}
		
			//debugging
			System.out.println("Total number of candidate positions for "+i+ "th residue is: "+ vecCandPosCur.size());
			double[] x=new double[vecCandPosCur.size()];
			double[] y=new double[vecCandPosCur.size()];
			double[] z=new double[vecCandPosCur.size()];
			String tempXStr="x=[ ";
			String tempYStr="y=[ ";
			String tempZStr="z=[ ";
			for(int j=0;j<vecCandPosCur.size();j++)
			{
				RotaPattern rtp=(RotaPattern)vecCandPosCur.elementAt(j);
				double [] caPos=new double[3];
				caPos=rtp.getCoord();
				tempXStr=tempXStr+caPos[0]+",";
				tempYStr=tempYStr+caPos[1]+",";
				tempZStr=tempZStr+caPos[2]+",";
			}
			System.out.println("The X coordinate is:" );
			System.out.println( tempXStr );
			System.out.println("The Y coordinate is:" );
			System.out.println( tempYStr );
			System.out.println("The Z coordinate is:" );
			System.out.println( tempZStr );
			//double tempStr="x=[ ";
			/////////////////////////////
			
			for(int j=0;j<vecCandPosCur.size();j++)
			{
				RotaPattern rtp=(RotaPattern)vecCandPosCur.elementAt(j);
				double [] caPos=new double[3];
				caPos=rtp.getCoord();
				
				//double [] caPos=(double[])vecCandPosCur.elementAt(j);
				double[] caCand=new double[3];
				caCand[0]=caPos[0];caCand[1]=caPos[1];caCand[2]=caPos[2];
				/*Pdb pdbCand=(Pdb)vecCandPosCur.elementAt(j);
				Vector vecAtomCand=pdbCand.getAtomVec();
				double[] caCand=new double[3];
				for (int k=0;k<vecAtomCand.size();k++)
				{
					Cartesian cc = (Cartesian)vecAtomCand.elementAt(k);
					String atom = cc.getAtom();	       	  
	        	    if (atom.equalsIgnoreCase("CA"))
	        	    	caCand=cc.getXYZ();
				}//for (int k=0;k<vecAtomCand.size();k++)
				*/
				double distance= Math.sqrt((caRefCur[0] - caCand[0]) * (caRefCur[0] - caCand[0]) 
						+ (caRefCur[1] - caCand[1]) * (caRefCur[1] - caCand[1]) 
						+ (caRefCur[2] - caCand[2]) * (caRefCur[2] - caCand[2]));
				if(distance<minDist)
					minDist=distance;    			
			}//for(j=0;j<vecCandPosCur.size();j++)
			
			System.out.println("res no: " + i+"   distance: "+ minDist);
		}//for(i=noStart+1;i<noEnd;i++)
    }
	public Vector myPdbVectorCopy(Vector vecSrc)
	{
		Vector vecFinal=new Vector();
		//for(int i=0;i<vecSrc.size();i++)
		//{
			//Vector vecFianlOne=new Vector();
			//Vector vecSrcOne=(Vector)vecSrc.elementAt(i);
			for (int j=0;j<vecSrc.size();j++)
			{
				Pdb pdb=(Pdb)vecSrc.elementAt(j);
				Pdb pdbCopy=new Pdb(pdb);				
				vecFinal.add(pdbCopy);
			}//for (int j=0;j<vecSrcOne.size();j++)
			
		//}//for(int i=0;i<vecSrc.size();i++)
		return vecFinal;
	}
	
	//test: comparisons with other approaches (E.g.CCD) 
	public static void main (String[] args)
	{
		long startTime = System.currentTimeMillis();
    	Pdb pp=new Pdb();
    	Loops lp=new Loops();
    	PdbRdc pdc=new PdbRdc();
		Goal goal=new Goal();
		
    	//the path of rotamer library:
    	String userDir = System.getProperty("user.dir");///  
    	String strInPath=userDir+"/inputFiles-temp/";
    	String strOut=userDir+"/outFiles/";    	
    	
    	String userDirTemp = System.getProperty("user.dir");//current user directory
    	
    	//read the Ramachandran data.
    	String strRamaAla=userDirTemp+"/system/rama_data/pct/rama/rama500-ala-nosec.data";//path of Ramachandran data base
    	String strRamaGeneral=userDirTemp+"/system/rama_data/pct/rama/rama500-general-nosec.data";
    	String strRamaGly=userDirTemp+"/system/rama_data/pct/rama/rama500-gly-sym-nosec.data";
    	String strRamaPro=userDirTemp+"/system/rama_data/pct/rama/rama500-pro.data";
    	String strRamaPrePro=userDirTemp+"/system/rama_data/pct/rama/rama500-prepro.data";
    	goal.vecRamaAla=lp.ReadRamachandranFile(strRamaAla);
    	goal.vecRamaGeneral=lp.ReadRamachandranFile(strRamaGeneral);
    	goal.vecRamaGly=lp.ReadRamachandranFile(strRamaGly);
    	goal.vecRamaPro=lp.ReadRamachandranFile(strRamaPro);
    	goal.vecRamaPrePro=lp.ReadRamachandranFile(strRamaPrePro);
    	
    	//////////////////////////////////////////////////
    	//input Files and parameters:
    	String strOutPdb="test_loop.pdb";
    	int noStart=121;//end residue number of the loop
    	int noEnd=124;
    	String strPdbTest=strInPath+"1thf_h.pdb";//the x-ray pdb;
    	double AT_syy=7.74;//7.74; //the chosen alignment tensor values
    	double AT_szz= 12.66;
    	goal.isForward=false;
    	goal.isAllGridSearch=true;
    	goal.gapThreshold=1.0;
    	goal.rdcThreshold=2.0;
    	double sigmaErr=0.5;//sigma for RDC noise
    	long seed =26111; 
    	//////////////////////////////////////////////////   	
    	
    	double AT_sxx=-AT_syy-AT_szz;
    	
    	//read the test pdb    	
    	Vector vecPdbTest = pp.readPdb(strPdbTest);

    	//extract sequence information from Pdb
    	goal.vecSeq=new Vector();
    	for(int i=0;i<vecPdbTest.size();i++)
    	{
    		Pdb pdb=(Pdb)vecPdbTest.elementAt(i);
    		int res_no=pdb.getResidueNo();
    		String res=pdb.getResidue();
    		goal.vecSeq.add(new Assign(res_no,res));    		
    	}//for(int i=0;i<vecPdbTest.size();i++)
    	
    	//extract the SSE PDB:
    	Vector vecPdbTemp=new Vector();
    	for(int i=0;i<vecPdbTest.size();i++)
    	{
    		Pdb pdb=(Pdb)vecPdbTest.elementAt(i);
    		int res_no=pdb.getResidueNo();
    		if( (res_no>noStart) && (res_no<noEnd))
    			continue;
    		vecPdbTemp.add(pdb);    		  		
    	}//for(int i=0;i<vecPdbTest.size();i++)
    	Collections.sort(vecPdbTemp,new Pdb.PdbComparator() );
    	goal.vecPdbSSE=new Vector();
    	goal.vecPdbSSE.addAll(vecPdbTemp);
    	
    	/////////////////////////////////////
    	//generate the CH and NH RDCs given the structure and alignment tensor.
    	
		Random rr = new Random(seed);
		
		
    	//generate the RDC data:
    	double [][] mat = new double[3][3];
		Matrix mm = new Matrix(3,3);
		for(int x=0;x<3;x++)
		{
			for(int y=0;y<3;y++)
			{
				if(x==y)
					mat[x][y]=1;
				else
					mat[x][y]=0;
			}
		}
		mm = new Matrix(mat);		
    	
		//Generate the NH RDCs
    	String atom1="N";
    	String atom2="HN";
    	double [] amide = new double[3];
		double [] nh = new double[3];
		double [] nToNHVec = new double[3];
		double rdcRatio= Const.nhRatio;
    	for (int i = 0; i < vecPdbTest.size() ; i++)
		{
		    Pdb pdb =(Pdb) vecPdbTest.elementAt(i); 
		    String res=pdb.getResidue();
		    if(res.equalsIgnoreCase("PRO"))
		    	continue;
		    int res_no=pdb.getResidueNo();
		    Vector atomVec = pdb.getAtomVec();
		    for (int j=0; j<atomVec.size(); j++)
		    {
		    	Cartesian cc = (Cartesian)atomVec.elementAt(j);
				String atom = cc.getAtom();
				if(atom.equalsIgnoreCase("H"))
					atom="HN";
				if (atom.equals(atom1))
				    amide = cc.getXYZ();
				else if (atom.equals(atom2))
				    nh = cc.getXYZ();
		    }
		    nToNHVec = pdc.internuclearVec(amide, nh);
		    nToNHVec = mm.times(pdc.dirCos(nToNHVec));
		    double cosX = nToNHVec[0];
		    double cosY = nToNHVec[1];
		    double cosZ = nToNHVec[2];
		    double rdc_value = (cosX * cosX * AT_sxx + cosY * cosY * AT_syy + cosZ * cosZ * AT_szz) * rdcRatio; 
		    rdc_value=rdc_value+sigmaErr * rr.nextGaussian();
		    goal.vecNhRDC.add(new Dipolar(res_no, "", rdc_value, 0.0));
		}
    	
    	//Generate the CH RDCs
    	atom1="CA";
    	atom2="HA";
    	double [] ca = new double[3];
		double [] ha = new double[3];
		double [] caToHaVec = new double[3];
		rdcRatio= Const.cahaRatio;
    	for (int i = 0; i < vecPdbTest.size() ; i++)
		{
		    Pdb pdb =(Pdb) vecPdbTest.elementAt(i); 
		    int res_no=pdb.getResidueNo();
		    String res=pdb.getResidue();
		    if(res.equalsIgnoreCase("GLY"))
		    	continue;
		    Vector atomVec = pdb.getAtomVec();
		    for (int j=0; j<atomVec.size(); j++)
		    {
		    	Cartesian cc = (Cartesian)atomVec.elementAt(j);
				String atom = cc.getAtom();
				if(atom.equalsIgnoreCase("H"))
					atom="HN";
				if (atom.equals(atom1))
				    ca = cc.getXYZ();
				else if (atom.equals(atom2))
				    ha = cc.getXYZ();
		    }
		    caToHaVec = pdc.internuclearVec(ca, ha);
		    caToHaVec = mm.times(pdc.dirCos(caToHaVec));
		    double cosX = caToHaVec[0];
		    double cosY = caToHaVec[1];
		    double cosZ = caToHaVec[2];
		    double rdc_value = (cosX * cosX * AT_sxx + cosY * cosY * AT_syy + cosZ * cosZ * AT_szz) * rdcRatio; 
		    rdc_value=rdc_value+sigmaErr * rr.nextGaussian();
		    goal.vecChRDC.add(new Dipolar(res_no, "", rdc_value, 0.0));
		}//for (int i = 0; i < vecPdbTest.size() ; i++)
    	
    	
    	 ///////////////////////////////////////////////////////////////////
	    //compute the alignment tensor
	    PdbRdc pdr = new PdbRdc();
	    //compute new Saupes
		int N = goal.vecPdbSSE.size();
	 	double[] rdc1Cal = new double[N];
		double[] rdc2Cal = new double[N];
		double[] saupeSave = new double[4]; //for returning Saupe elements  
	    System.out.println("================================================================================");	
		System.out.println("The alignment tensor for both CH and NH RDC:  ");
	    mm = pdr.bestFit(goal.vecPdbSSE, goal.vecNhRDC, goal.vecChRDC, rdc1Cal, rdc2Cal, saupeSave);
	    Vector vecPdbSSENew=new Vector();
	    vecPdbSSENew=pp.newPdb(goal.vecPdbSSE, mm);
	    goal.vecPdbSSE=new Vector();
	    goal.vecPdbSSE.addAll(vecPdbSSENew);	    
	
	    double Syy = saupeSave[0];
	 	double Szz = saupeSave[1];
	 	goal.Syy=Syy;
	 	goal.Szz=Szz;
	 	double Sxx=-Syy-Szz;
	 	double rdc1Rmsd = saupeSave[2];
	 	double rdc2Rmsd = saupeSave[3];
	 	System.out.println("================================================================================");	
	 	System.out.println("The alignment tensor for my own calculation:");
	 	
	 	System.out.println("Sxx, Syy, Szz =    " +(-Syy-Szz)+"    "   +Syy+"  "+Szz);
		System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=    " +" :  "+rdc1Rmsd+"  "+rdc2Rmsd);
		System.out.println("Second   (Licong's original version) "+Syy+"  "+Szz+" :  "+rdc1Rmsd+"  "+rdc2Rmsd);
	 	//System.out.println("Another format of alingment tenosr:  "); //added by zeng
		System.out.println("================================================================================");	
		///////////////////////////////////////////////////////////////////
	    
		///////////////////////////////////////////////////////////////////
    	//compute the loop:
		goal.maxLeafNodes=10000;//max number of leaf nodes in the conformation tree
		
		Vector vecFinal=new Vector();
		
		Pdb pdbFixed=new Pdb();
		
		if(goal.isForward)
		{
			int index = Collections.binarySearch(goal.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
			if (index <0)
			{
				System.out.println("error: fixed residue not found...exist...");
				System.exit(0);		
			}		
			pdbFixed = (Pdb)goal.vecPdbSSE.elementAt(index);
		}
		else
		{
			int index = Collections.binarySearch(goal.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
			if (index <0)
			{
				System.out.println("error: fixed residue not found...exist...");
				System.exit(0);		
			}		
			pdbFixed = (Pdb)goal.vecPdbSSE.elementAt(index);
		}
		
		
		Vector vecFixAtomSet=new Vector();
		if(goal.isForward)
			vecFixAtomSet=goal.SampleFirstHalfPlanes(noStart,false);
		else
			vecFixAtomSet=goal.SampleFirstHalfPlanes(noEnd,false); //for backward, we haven't implemented it yet.
		
		System.out.println("Total number of initial positions: "+ vecFixAtomSet.size());
		
		for(int i=0;i<vecFixAtomSet.size();i++)
		{		
			System.out.println("++++++++++++++++++++++++++++++++++++++");
			System.out.println("The "+ i+ "th initial positions: ");
			System.out.println("++++++++++++++++++++++++++++++++++++++");
			
			Vector vecAtomTemp=(Vector)vecFixAtomSet.elementAt(i);
			pdbFixed.setAtomVec(vecAtomTemp);
			//System.out.println("TER");
			//pp.print(this.vecPdbSSE);
			vecFinal=new Vector();			
			if(goal.isForward)
				vecFinal=goal.LoopAllComputation(noStart,noEnd );
			else
				vecFinal=goal.LoopAllComputationBackward(noStart,noEnd );
			
			//vecFinal.add(this.vecPdbSSE);
		}
		//System.out.println("REMARK ++++++++++++++++++++++++++++++++++++++");
		//System.out.println("REMARK Here is the SSEs");
		//System.out.println("TER");
		//pp.print(this.vecPdbSSE);//the coordinates of fixed end residue are changed
	
	 	//write the new pdb file:
    	String fileName =strOut+strOutPdb;
    	try
    	{
    		PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
    		for(int t=0;t<vecFinal.size();t++)
    		{
    			Vector vecOneFragment=(Vector)vecFinal.elementAt(t);
    			pp.printToFile(vecOneFragment,fileName, out);	
    			out.println("TER");  
    		}
	    	out.println("END");  
	    	out.close();
	    	
		}catch (FileNotFoundException e)
		{
			System.out.println("File not found: " + fileName);
		}catch (IOException e)
		{
			System.out.println("IOException: the stack trace is:");
			e.printStackTrace();
		}  
		
		
		long endTime = System.currentTimeMillis() ;
		double totalTime = (double) ((endTime - startTime) / 60000.0); //in minutes
		
		System.out.println("The total time for computing loop fragments is:  "+ totalTime +" minutes");  	
    	

	}  // End of main()
	
	
	/** 
     * compute the loop using a gradient search approach (like ccd.)
     * 
     @param src location of the input file
     @param strOut location of the output file
     @param strInput  input file name
     @return void
     */       
    public void doGoalCalLoops(String src, String strOut, String strInput)throws JampackException
    {	    	 
    	boolean isDebug=true;
    	Hsqc hqc = new Hsqc();
    	Peak pk = new Peak();
    	
    	ModelRdc mdc = new ModelRdc();    	
    	Assign asg = new Assign();
    	long startTime = System.currentTimeMillis();
    	
    	//the path of rotamer library:
    	String userDir = System.getProperty("user.dir");////
    	String rotSrc= userDir+"/system/rot-lib/";
    	this.rotSrc=rotSrc;
    	
    	String userDirTemp = System.getProperty("user.dir");//current user directory
    	
    	Loops lp=new Loops();
    	
    	//read the Ramachandran data.
    	String strRamaAla=userDirTemp+"/system/rama_data/pct/rama/rama500-ala-nosec.data";//path of Ramachandran data base
    	String strRamaGeneral=userDirTemp+"/system/rama_data/pct/rama/rama500-general-nosec.data";
    	String strRamaGly=userDirTemp+"/system/rama_data/pct/rama/rama500-gly-sym-nosec.data";
    	String strRamaPro=userDirTemp+"/system/rama_data/pct/rama/rama500-pro.data";
    	String strRamaPrePro=userDirTemp+"/system/rama_data/pct/rama/rama500-prepro.data";
    	vecRamaAla=lp.ReadRamachandranFile(strRamaAla);
    	vecRamaGeneral=lp.ReadRamachandranFile(strRamaGeneral);
    	vecRamaGly=lp.ReadRamachandranFile(strRamaGly);
    	vecRamaPro=lp.ReadRamachandranFile(strRamaPro);
    	vecRamaPrePro=lp.ReadRamachandranFile(strRamaPrePro);
    	
    	/////////////////////////////////////////////
    	/// 1. Read the input files
    	//
    	/////////////////////////////////////////////
    	int i, j;    	
    	Pdb  pp = new Pdb();    	
    	Vector<Map<String, String>> paraVec = asg.ParamReader(src+strInput);
    	double haErr  = 0.0;
    	double h1Err  = 0.0;
    	double c13Err = 0.0;
    	double hnErr  = 0.0;
    	double nErr   = 0.0;
    	
    	int nIs4DNoesy=0;
    	
    	String strResNameScheme="",strIsCheckLongAA="",strBB="",stroutName="",strOutOrFormat="",strSSEBB="",
    		   strIsCheck="",strRefPdb="",strRefNameSchem="",strIsWholeStr="",strPdbNameScheme="";
    	int nIsoriginalUp=0,noStart=0,noEnd=0; 
    	double Syy=0.0,Szz=0.0,noeLimit=0.0,metCor=0.0,gap_Threshold=0.0,rdc_Threshold=0.0;
    	
    	String strReson="",strResFormat="",strSeq="", strNoesy2D="",strHnNoesy3D="",strHaNoesy3D="",str4DNoesy="",
    		strNoesyFormat="",strSSEPDBFile="",strChFile="",strNhFile="",strOutPdb="",strCaCoFile="",strCoNFile="",
    		strIsScaled="",strIsForward="",strIsAllGridSearch="",strIsSampleInitPlane="";
    	
    	for (i=0;i<paraVec.size();i++)
    	{
    		//get the error tolerance for each dimension
    		Map paraMap = paraVec.elementAt(i);
    		if(paraMap.containsKey("HAERR"))
    			 haErr  =  Double.parseDouble((String)paraMap.get("HAERR"));
    		if(paraMap.containsKey("H1ERR"))
   			 	h1Err  =  Double.parseDouble((String)paraMap.get("H1ERR"));
    		if(paraMap.containsKey("C13ERR"))
    			c13Err  =  Double.parseDouble((String)paraMap.get("C13ERR"));
    		if(paraMap.containsKey("HNERR"))
    			hnErr  =  Double.parseDouble((String)paraMap.get("HNERR"));
    		if(paraMap.containsKey("NERR"))
    			nErr  =  Double.parseDouble((String)paraMap.get("NERR"));
    		
    		if(paraMap.containsKey("SEQUENCE"))////////
    			strSeq  =  (String)paraMap.get("SEQUENCE");
    		if(paraMap.containsKey("RESFORMAT"))
    			strResFormat  =  (String)paraMap.get("RESFORMAT");
    		if(paraMap.containsKey("RESONANCE"))
    			strReson  =  (String)paraMap.get("RESONANCE");
    		strReson=strReson.toLowerCase();
    		if(paraMap.containsKey("2D-NOESY"))
    			strNoesy2D  =  (String)paraMap.get("2D-NOESY");
    		
    		if(paraMap.containsKey("3D-N15-NOESY"))
    			strHnNoesy3D  =  (String)paraMap.get("3D-N15-NOESY");
    	
    		if(paraMap.containsKey("3D-C13-NOESY"))
    			strHaNoesy3D  =  (String)paraMap.get("3D-C13-NOESY");
    		
    		if(paraMap.containsKey("PDBNAMESCHEME"))
    			strPdbNameScheme  =  (String)paraMap.get("PDBNAMESCHEME");	
    		if(paraMap.containsKey("OUTNOENAME"))
    			stroutName  =  (String)paraMap.get("OUTNOENAME");   	
    		if(paraMap.containsKey("BACKBONE"))
    			strBB  =  (String)paraMap.get("BACKBONE");
    		if(paraMap.containsKey("SSEBB"))
    			strSSEBB  =  (String)paraMap.get("SSEBB");
    		
    		if(paraMap.containsKey("NOELIMIT"))
    			noeLimit  =  Double.parseDouble((String)paraMap.get("NOELIMIT"));
    		if(paraMap.containsKey("IS4DNOESY"))
    			nIs4DNoesy  =   Integer.parseInt((String)paraMap.get("IS4DNOESY"));
    		
    		if(paraMap.containsKey("4D-NOESY"))
    			str4DNoesy  =  (String)paraMap.get("4D-NOESY");
    		
    		if(paraMap.containsKey("ISORIGINALUP"))
    			nIsoriginalUp  =   Integer.parseInt((String)paraMap.get("ISORIGINALUP"));	
    		if(paraMap.containsKey("RESNAMESCHEME"))
    			strResNameScheme  =  (String)paraMap.get("RESNAMESCHEME");	
    		if(paraMap.containsKey("NOESY-FORMAT"))
    			strNoesyFormat  =  (String)paraMap.get("NOESY-FORMAT");   	
    		if(paraMap.containsKey("ISCHECKLONGAA"))
    			strIsCheckLongAA =  (String)paraMap.get("ISCHECKLONGAA"); 	
    		if(paraMap.containsKey("ISCHECK"))
    			strIsCheck  =  (String)paraMap.get("ISCHECK");   	
    		if(paraMap.containsKey("REFPDB"))
    			strRefPdb  =  (String)paraMap.get("REFPDB");  
    		if(paraMap.containsKey("METHYL-CORRECTION"))
    			metCor  =  Double.parseDouble((String)paraMap.get("METHYL-CORRECTION"));    		
    		if(paraMap.containsKey("REFNAMESCHEME"))
    			strRefNameSchem  =  (String)paraMap.get("REFNAMESCHEME");  
    		if(paraMap.containsKey("ISWHOLESTRUCTURE"))
    			strIsWholeStr  =  (String)paraMap.get("ISWHOLESTRUCTURE");  
    		if(paraMap.containsKey("ISOUTORFORMAT"))
    			strOutOrFormat  =  (String)paraMap.get("ISOUTORFORMAT");
    		if(paraMap.containsKey("ISSCALED"))
    			strIsScaled  =  (String)paraMap.get("ISSCALED"); 
    		if(paraMap.containsKey("ISFORWARD"))
    			strIsForward  =  (String)paraMap.get("ISFORWARD");
    		
    		if(paraMap.containsKey("ISALLGRIDSEARCH"))
    			strIsAllGridSearch  =  (String)paraMap.get("ISALLGRIDSEARCH");
    		if(paraMap.containsKey("ISSAMPLEINITPLANE"))
    			strIsSampleInitPlane  =  (String)paraMap.get("ISSAMPLEINITPLANE");
    		
    		////////////////////////
    		
    		if(paraMap.containsKey("GAPTHRESHOLD"))
    			gap_Threshold  =  Double.parseDouble((String)paraMap.get("GAPTHRESHOLD"));
    		if(paraMap.containsKey("RDCTHRESHOLD"))
    			rdc_Threshold  =  Double.parseDouble((String)paraMap.get("RDCTHRESHOLD"));
    		    		
    		if(paraMap.containsKey("SSES"))
    			strSSEPDBFile  =  (String)paraMap.get("SSES");  
    		if(paraMap.containsKey("SYY"))
    			Syy  =  Double.parseDouble((String)paraMap.get("SYY"));
    		if(paraMap.containsKey("SZZ"))
    			Szz  =  Double.parseDouble((String)paraMap.get("SZZ"));    	
    		if(paraMap.containsKey("CHFILE"))
    			strChFile  =  (String)paraMap.get("CHFILE"); 
    		if(paraMap.containsKey("NHFILE"))
    			strNhFile  =  (String)paraMap.get("NHFILE"); 
    		if(paraMap.containsKey("COCAFILE"))
    			strCaCoFile  =  (String)paraMap.get("COCAFILE"); 
    		if(paraMap.containsKey("CONFILE"))
    			strCoNFile  =  (String)paraMap.get("CONFILE");   
    		
    		if(paraMap.containsKey("OUTPDBNAME"))
    			strOutPdb  =  (String)paraMap.get("OUTPDBNAME"); 
    		
    		if(paraMap.containsKey("FIRSTNO"))
    			noStart  =   Integer.parseInt((String)paraMap.get("FIRSTNO"));	
    		if(paraMap.containsKey("LASTNO"))
    			noEnd  =   Integer.parseInt((String)paraMap.get("LASTNO"));	
    	}   
    	
    	this.gapThreshold=gap_Threshold;
    	this.rdcThreshold=rdc_Threshold;
    	
    	if(strIsForward.equalsIgnoreCase("1"))
    		this.isForward=true;
    	else
    		this.isForward=false;
    	
    	if(strIsAllGridSearch.equalsIgnoreCase("1"))
    		this.isAllGridSearch=true;
    	else
    		this.isAllGridSearch=false;
    	
    	boolean isSampleInitPlane=false;
    	if(strIsSampleInitPlane.equalsIgnoreCase("1"))
    		isSampleInitPlane=true;
    	else
    		isSampleInitPlane=false;
    	
    	//read the RDC data
    	String strChRdcFile=src+strChFile;
    	String strNhRdcFile=src+strNhFile;
    	String strCaCoRdcFile=src+strCaCoFile;
    	String strCoNRdcFile=src+strCoNFile;
    	Dipolar dd  =  new Dipolar();
    	Vector<Dipolar> cacoRdc = new Vector();
		Vector<Dipolar> conRdc = new Vector();
		Vector<Dipolar> nhRdc =new Vector<Dipolar> ();		
		Vector<Dipolar> cahaRdc = new Vector<Dipolar> ();		
		
		double scale_ca_to_nh=Math.pow(Const.dCA2HA /Const.dN2H, 3) * (Const.nitrogenGyroRatio /Const.carbonGyroRatio);
		//scale_ca_to_nh=1/scale_ca_to_nh;
		
		nhRdc = dd.rdcRead(strNhRdcFile,1.0);
		
		if(strIsScaled.equalsIgnoreCase("1"))
			cahaRdc = dd.rdcRead(strChRdcFile,1.0);					
		else
			cahaRdc = dd.rdcRead(strChRdcFile,scale_ca_to_nh);		
			
		this.vecNhRDC=new Vector();
		this.vecNhRDC.addAll(nhRdc);
		this.vecChRDC=new Vector();
		this.vecChRDC.addAll(cahaRdc);
		
		//need to check the caco and con rdcs:
		boolean existCaCo = (new File(strCaCoRdcFile)).exists();
		boolean existCoN = (new File(strCoNRdcFile)).exists();		
		if(existCaCo)
			cacoRdc=dd.rdcRead(strCaCoRdcFile,0.19845);
		else
			System.out.println("Warn: The Co-Ca RDC doesn't exist.");
		if(existCoN) 			
			dd.rdcRead(strCoNRdcFile,0.12086);	    	
		else
			System.out.println("Warn: The Co-N RDC doesn't exist.");
		
		
    	//read the alignment tensor;
    	//this.Syy=Syy;
    	//this.Szz=Szz;
    	
    	//-------------------------------------
    	// (1.1) Read the protein sequence
    	// 
    	//-------------------------------------	    	
    	String seqFile = src + strSeq;
    	//this is the vector of residues (protein sequence)
    	this.vecSeq=asg.ReaderSeq(seqFile);      	    	
    	
    	//read the sse pdb
    	String ssePdbFile = userDirTemp+strSSEPDBFile;
    	Vector vecPdbSSETemp = pp.readPdb(ssePdbFile);
    	Vector vecSSETemp2= pp.residueNameUpdateNoStr(this.vecSeq, vecPdbSSETemp); 
    	   	
    	//this.vecPdbSSE= pp.residueNameUpdateNoStr(vecSeq, vecPdbSSETemp); 
    	    	
    	//-------------------------------------
    	// (1.2) Read the resonance list 
    	// 
    	// in the "resonance.prot" format
    	//-------------------------------------
        	
    	//following is for the general case
    	H1CS h1CS=new H1CS();
    	   
    	String assignFile = src+ strReson; 
    	//this is the vector that stores resonance assignments;
    	//each one includes resNo, resName, atomName, csH1(chemical shift value)
    	Vector assignVec=new Vector();
    	if(strResFormat.equalsIgnoreCase("CYANA"))
    		assignVec=h1CS.h1CSReader(assignFile,vecSeq); 
    	else if(strResFormat.equalsIgnoreCase("BMRB"))
    		assignVec=h1CS.h1CSReader_BMRB(assignFile);  
    	else 
    	{
    		System.out.println("unknown format of the resonance file...");
    		System.exit(0);
    	}
    	this.vecAsg=new Vector();
    	this.vecAsg.addAll(assignVec);
    	
    	//all sorted proton resonances
    	Vector allH1Vec = pk.allProtonSorted(assignVec);
    	Collections.sort(allH1Vec, new Peak.csComparator()); 	    	
    	
    	//-------------------------------------
    	// (1.3) Read the NOESY peak list 
    	// in the xeasy format
    	// including 2D NOESY peak list, 3D N15 NOESY and 3D C13 NOESY peak lists
    	//-------------------------------------
    	Noesy noesy = new Noesy();
    	
    	String strNoeFile = ""; 
    	Vector hnNoeVec=new Vector();//for storing 3d n15 NOESY peaks
    	Vector cnoeVec=new Vector();//for storing 3d c13 noesy peaks
    	Vector Noe4DVec=new Vector();//for storing 4d NOESY peaks
    	if (!strNoesy2D.equalsIgnoreCase("NULL"))
    	{
    		//to do: extension to 2d case...
    	}
    	if (!strHnNoesy3D.equalsIgnoreCase("NULL"))
    	{
    		strNoeFile=src+strHnNoesy3D;
    		if(strNoesyFormat.equalsIgnoreCase("XEASY"))
    			hnNoeVec = noesy.NoesyReader(strNoeFile);
    		else
    			hnNoeVec = noesy.NoesyReaderNMRView(strNoeFile);    		
    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
    	
    	if (!strHaNoesy3D.equalsIgnoreCase("NULL"))
    	{
    		strNoeFile=src+strHaNoesy3D;
    		if(strNoesyFormat.equalsIgnoreCase("XEASY"))
    			cnoeVec = noesy.NoesyReader(strNoeFile);
    		else
    			cnoeVec=noesy.NoesyReaderNMRView(strNoeFile);
    	}
    	
    	//4D NOESY data
    	if (!( str4DNoesy.equalsIgnoreCase("NULL")|| str4DNoesy.equalsIgnoreCase("")) )
    	{
    		strNoeFile=src+str4DNoesy;
    		if(strNoesyFormat.equalsIgnoreCase("XEASY"))
    			Noe4DVec = noesy.NoesyReader(strNoeFile);// to be changed....
    		else
    			Noe4DVec = noesy.NoesyReaderNMRView4D(strNoeFile);    		
    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
    	
    	Vector vecNoesy=new Vector();
    	vecNoesy.addAll(hnNoeVec);
    	vecNoesy.addAll(cnoeVec);
    	
    	Vector vecNoesy4D=new Vector();
    	vecNoesy4D.addAll(Noe4DVec);//for 4D noesy   
    	
    	///////////////////////////////
    	//distance calibration
    	String pdbSSEFile = userDirTemp+strSSEPDBFile;
    	Vector vecSSE = pp.readPdb(pdbSSEFile);
    	double[] constant=new double[1];
    	//noesy.SetCalibrationN15(vecNoesy,vecSSE,assignVec,constant);
    	noesy.SetCalibrationN15(hnNoeVec,vecSSE,assignVec,constant);
    	this.caliConstant=constant[0];    	
    	///////////////////////////////    		
    	
    	////////////////////////////////////
    	//remove the diagonal NOESY peaks:
    	Vector vecNoesyNoDia=new Vector();
    	for (i=0;i< vecNoesy.size();i++)
    	{
    		Noesy noesy2=(Noesy)vecNoesy.elementAt(i);
    		double cs_h1=noesy2.getH1();
    		double cs_h2=noesy2.getH2();
    		    		    		
    		if (Math.abs(cs_h1-cs_h2)>0.01)//range from 0.01  to 0.05
    			vecNoesyNoDia.add(noesy2);    		
    		
    	}//for (i=0;i< vecNoesy.size();i++)
    	vecNoesy=new Vector();
    	vecNoesy.addAll(vecNoesyNoDia);    	
    	
    	//for 4D
    	vecNoesyNoDia=new Vector();
    	for (i=0;i< vecNoesy4D.size();i++)
    	{
    		Noesy noesy2=(Noesy)vecNoesy4D.elementAt(i);
    		double cs_h1=noesy2.getH1();
    		double cs_h2=noesy2.getH2();
    		double cs_heavy1=noesy2.getHeavy1();
    		double cs_heavy2=noesy2.getHeavy2();   		    		
    		if (Math.abs(cs_h1-cs_h2)>0.04 && Math.abs(cs_heavy1-cs_heavy2)>0.06)//range from 0.01  to 
    			vecNoesyNoDia.add(noesy2);    		
    		
    	}//for (i=0;i< vecNoesy.size();i++)
    	vecNoesy4D=new Vector();
    	vecNoesy4D.addAll(vecNoesyNoDia);   
    	
    	Vector vecNewNoesy=new Vector();    	
    	Vector vecNewNoesy4D=new Vector();	
    	
    	vecNewNoesy.addAll(vecNoesy);
    	vecNewNoesy4D.addAll(vecNoesy4D);
    	
    	//compute the ambiguous NOE assignments based on chemical shifts
    	Vector vecAmbgAsg=asg.InitAmbiAssignment(nErr,c13Err,hnErr,haErr,h1Err,assignVec,allH1Vec,vecNoesy );
    	// change the naming scheme from bmrb-new to pdb-new:
    	Vector vecNewNoes=new Vector();
    	vecNewNoes.addAll(vecAmbgAsg);
    	if(strResNameScheme.equalsIgnoreCase("PDB-NEW"))
    	{
    		Vector vecTemp=new Vector();
    		Noe ee=new Noe();
    		vecTemp=ee.NameConvertFromPDBNewToPDBNew(vecNewNoes);
    		vecNewNoes=new Vector();
    		vecNewNoes.addAll(vecTemp);    		
    	}
    	if(strResNameScheme.equalsIgnoreCase("BMRB-NEW"))
    	{
    		Vector vecTemp=new Vector();
    		Noe ee=new Noe();
    		vecTemp=ee.NameConvertFromBMRBNewToPDBNew(vecNewNoes);
    		vecNewNoes=new Vector();
    		vecNewNoes.addAll(vecTemp);
    		
    		Vector vecAsgNew=new Vector();
    		H1CS h1cs=new H1CS();
    		vecAsgNew=h1cs.CSNameConvertFromBMRBNewToPDBNew(assignVec);
    		assignVec=new Vector();
    		assignVec.addAll(vecAsgNew);
    	}//if(strResNameScheme.equalsIgnoreCase("BMRB-NEW"))
    	vecAmbgAsg=new Vector();
    	vecAmbgAsg.addAll(vecNewNoes);
    	
    	////////////////////////////////////
    	
    	this.vecAmbNOEs=new Vector();
    	this.vecAmbNOEs.addAll(vecAmbgAsg);
    	
    	////////////////////////////////////		
		//starting and ending residue no
		//this is for test, will be changed in future:
		//int noStart=16;//50;//17;//7;
		//int noEnd=24;//65;//24;//11;
		double csErrH=0.04;
		double csErrHeavy=0.2;	  	
    	
    	this.vecNOESY=new Vector();
    	this.vecNOESY.addAll(vecNoesy);
    	
    	//add rotamers to the backbone:
	    Vector vecSSE2Rot=pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy,vecSSETemp2,assignVec,rotSrc,vecNoesy,
    			4.5, 1,this.caliConstant);
	    
	    this.vecPdbSSE=new Vector();
	    this.vecPdbSSE.addAll(vecSSE2Rot);	    		  
	    
	    ///////////////////////////////////////////////////////////////////
	    //compute the alignment tensor
	    PdbRdc pdr = new PdbRdc();
	    //compute new Saupes
		int N = this.vecPdbSSE.size();
	 	double[] rdc1Cal = new double[N];
		double[] rdc2Cal = new double[N];
		double[] saupeSave = new double[4]; //for returning Saupe elements  
	    System.out.println("================================================================================");	
		System.out.println("The alignment tensor for both CH and NH RDC:  ");
	    Matrix mm = pdr.bestFit(this.vecPdbSSE, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupeSave);
	    Vector vecPdbSSENew=new Vector();
	    vecPdbSSENew=pp.newPdb(this.vecPdbSSE, mm);
	    this.vecPdbSSE=new Vector();
	    this.vecPdbSSE.addAll(vecPdbSSENew);
	    
	    //Vector vecTempNew=myPdbVectorCopy(vecPdbSSENew);
	   // this.vecPdbSSEOrig=new Vector();
	   // this.vecPdbSSEOrig.addAll(vecTempNew);
	    
	    Syy = saupeSave[0];
	 	Szz = saupeSave[1];
	 	this.Syy=Syy;
	 	this.Szz=Szz;
	 	double Sxx=-Syy-Szz;
	 	double rdc1Rmsd = saupeSave[2];
	 	double rdc2Rmsd = saupeSave[3];
	 	System.out.println("================================================================================");	
	 	System.out.println("The alignment tensor for my own calculation:");
	 	
	 	System.out.println("Sxx, Syy, Szz =    " +(-Syy-Szz)+"    "   +Syy+"  "+Szz);
		System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=    " +" :  "+rdc1Rmsd+"  "+rdc2Rmsd);
		System.out.println("Second   (Licong's original version) "+Syy+"  "+Szz+" :  "+rdc1Rmsd+"  "+rdc2Rmsd);
	 	//System.out.println("Another format of alingment tenosr:  "); //added by zeng
		System.out.println("================================================================================");	
		///////////////////////////////////////////////////////////////////
	    
		//coordinates of N, nh, ca of the starting residue:
		double [] coordN  = new double[3];
		double [] coordNH = new double[3];
		double [] coordCA = new double[3]; 	
		int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator() );
		if (ind<0)
		{
			System.out.println("the starting residue not found...exist.");
			System.exit(0);		 
		}
		Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(ind);	
		Vector atomVecStart = pdbStart.getAtomVec();
		for (int k=0;k<atomVecStart.size();k++)
		{
			Cartesian cc = (Cartesian)atomVecStart.elementAt(k);
    	    String atom = cc.getAtom();	    	   
    	    if (atom.equalsIgnoreCase("N"))
    	    	coordN = cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("CA"))
    	    	coordCA=cc.getXYZ();
    	    else if (atom.equalsIgnoreCase("HN")||atom.equalsIgnoreCase("H"))
    	    	coordNH = cc.getXYZ();		    
		}//for (int k=0;k<atomVecStart.size();k++)
    	    	
		boolean isSkipNOE=false;
    	//compute the loop fragments:
    	//Vector vecLoopFrag=calcFragment(Syy, Szz, vecChRdc, vecNhRdc, 
    		//	coordN, coordNH, coordCA, noStart,noEnd, vecNewNoesy, assignVec,
        	//	csErrH, csErrHeavy,isSkipNOE);
    	
    	
    	//for debugging:
    	//read the sse pdb
    	/*String ssePdbFileDebugging = userDirTemp+"/inputFiles/1UBQHNewSSE.pdb";
    	Vector vecPdbdebug = pp.readPdb(ssePdbFileDebugging);
    	this.vecPdbSSE=new Vector();
    	this.vecPdbSSE.addAll(vecPdbdebug); //for debugging...
    	String refPdbFileDebugging = userDirTemp+"/inputFiles/1UBQHNew.pdb";
    	Vector vecPdbRef= pp.readPdb(refPdbFileDebugging);
    	*/
		this.maxLeafNodes=10000;//max number of leaf nodes in the conformation tree
		
		Vector vecFinal=new Vector();
		
		Pdb pdbFixed=new Pdb();
		
		if(this.isForward)
		{
			int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
			if (index <0)
			{
				System.out.println("error: fixed residue not found...exist...");
				System.exit(0);		
			}		
			pdbFixed = (Pdb)this.vecPdbSSE.elementAt(index);
		}
		else
		{
			int index = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
			if (index <0)
			{
				System.out.println("error: fixed residue not found...exist...");
				System.exit(0);		
			}		
			pdbFixed = (Pdb)this.vecPdbSSE.elementAt(index);
		}
		
		Vector vecFixAtomSet=new Vector();
		if(this.isForward)
			vecFixAtomSet=SampleFirstHalfPlanes(noStart,isSampleInitPlane);
		else
			vecFixAtomSet=SampleFirstHalfPlanes(noEnd,false); //for backward, we haven't implemented it yet.
		
		System.out.println("Total number of initial positions: "+ vecFixAtomSet.size());
		
		for(i=0;i<vecFixAtomSet.size();i++)
		{		
			System.out.println("++++++++++++++++++++++++++++++++++++++");
			System.out.println("The "+ i+ "th initial positions: ");
			System.out.println("++++++++++++++++++++++++++++++++++++++");
			
			Vector vecAtomTemp=(Vector)vecFixAtomSet.elementAt(i);
			pdbFixed.setAtomVec(vecAtomTemp);
			//System.out.println("TER");
			//pp.print(this.vecPdbSSE);
			vecFinal=new Vector();			
			if(this.isForward)
				vecFinal=LoopAllComputation(noStart,noEnd );
			else
				vecFinal=LoopAllComputationBackward(noStart,noEnd );
			
			vecFinal.add(this.vecPdbSSE);
		}
		System.out.println("REMARK ++++++++++++++++++++++++++++++++++++++");
		System.out.println("REMARK Here is the SSEs");
		System.out.println("TER");
		pp.print(this.vecPdbSSE);//the coordinates of fixed end residue are changed
		
    	//Vector vecFinal=IterativeGradientSearch( vecPdbdebug,Syy, Szz, vecChRdc,vecNhRdc, 
         //		  noStart, noEnd,  vecNoesy,  assignVec, csErrH,  csErrHeavy, isSkipNOE);
    	
    	
    	//Vector<Vector> vecCandPosAll=RotamerReplacement(noStart,noEnd);
    	
    	//evaluate the candidate positions:
    	//EvaluateCandPositions(noStart, noEnd,vecCandPosAll,vecPdbRef);  			
		
    	//write the new pdb file:
    	String fileName =strOut+strOutPdb;
    	try
    	{
    		PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
    		for(int t=0;t<vecFinal.size();t++)
    		{
    			Vector vecOneFragment=(Vector)vecFinal.elementAt(t);
    			pp.printToFile(vecOneFragment,fileName, out);	
    			out.println("TER");  
    		}
	    	out.println("END");  
	    	out.close();
	    	
		}catch (FileNotFoundException e)
		{
			System.out.println("File not found: " + fileName);
		}catch (IOException e)
		{
			System.out.println("IOException: the stack trace is:");
			e.printStackTrace();
		}  
		
		
		long endTime = System.currentTimeMillis() ;
		double totalTime = (double) ((endTime - startTime) / 60000.0); //in minutes
		if(Const.isDebug)
			System.out.println("The total time for computing loop fragments is:  "+ totalTime +" minutes");  	
    	
    }
	
	
	
}
