/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package NascaGUI;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;

import javax.swing.ImageIcon;

import Jampack.JampackException;
import Nasca.AStar;
import Nasca.GraphNode;
import Nasca.NascaNew;
import Nasca.ProtonLabel;

import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Hsqc;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;

/**
 *
 * @author zjy
 */
public class NascaGUI {

   /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
            	   
    	//initialize the system parameters:
    	String userDir = System.getProperty("user.dir");////
    	String srcNascaSystem=userDir+"/system/nasca/nasca_system.input";
    	readSystemParameters(srcNascaSystem); 	
    	
    	
        NascaFrame frame=new NascaFrame();
        
        java.net.URL imgURL = NascaGUI.class.getResource("/NascaGUI/image/logo.jpg");
        frame.setIconImage(new ImageIcon(imgURL).getImage());
        frame.setVisible(true);
    }
    
  
    
    
    public static void readSystemParameters(String srcNascaSystem){
    	Assign asg = new Assign();
    	Vector<Map<String, String>> paraVec = asg.ParamReader(srcNascaSystem);
       	
    	for (int i=0;i<paraVec.size();i++)
    	{
    		
    		Map<String, String> paraMap = paraVec.elementAt(i);
    		if(paraMap.containsKey("HAERR"))
    			Global.haErr  =  Double.parseDouble((String)paraMap.get("HAERR"));
    		if(paraMap.containsKey("H1ERR"))
    			Global.h1Err  =  Double.parseDouble((String)paraMap.get("H1ERR"));
    		if(paraMap.containsKey("C13ERR"))
    			Global.c13Err  =  Double.parseDouble((String)paraMap.get("C13ERR"));
    		if(paraMap.containsKey("HNERR"))
    			Global.hnErr  =  Double.parseDouble((String)paraMap.get("HNERR"));
    		if(paraMap.containsKey("NERR"))
    			Global.nErr  =  Double.parseDouble((String)paraMap.get("NERR"));
    		if(paraMap.containsKey("NOELIMIT"))
    			Global.noeDistLimit  =  Double.parseDouble((String)paraMap.get("NOELIMIT"));
    		
    		//get the input file name   
    		if(paraMap.containsKey("INPUT_DIRECTORY"))
    			Global.updateInputFilePath(  (String)paraMap.get("INPUT_DIRECTORY")  );
    		if(paraMap.containsKey("OUTPUT_DIRECTORY"))
    			Global.updateOutputFilePath( (String)paraMap.get("OUTPUT_DIRECTORY") );
    		if(paraMap.containsKey("INPUT_SESSION_FILE"))
    			Global.updateDefaultInputSessionName( (String)paraMap.get("INPUT_SESSION_FILE") );
    		
    	}       	   	
    }
    
    

}
