package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/

import java.util.Comparator;
import java.util.Vector;


/** This class provides data structure and functions for A* tree search.  
 *
 */
public class TreeNode {

	double gScore=0.0;//actual cost
	double hScore=0.0;//estimate cost
	double fScore=0.0;//total cost
	
	//int asgLabelID=-1;//assigned label ID.
	GraphNode resonNode=null;//original resonance node;
	ProtonLabel labelNode=null;// mapped proton label.
	TreeNode pNode=null; //parent node
	Vector<TreeNode> vecChildNode=new Vector<TreeNode>();//child node
	int level=0;//level of the A* search tree
	Vector<TreeNode> vecUnsgedNodes=new Vector<TreeNode>();//vector of remaining unassigned nodes. used for tracking stereo assignments.
	
	public TreeNode(){
		
	}
	public TreeNode(TreeNode tnode){
		gScore=tnode.gScore; hScore=tnode.hScore;fScore=tnode.fScore;
		resonNode=tnode.resonNode;labelNode=tnode.labelNode;		
	}
	public void setTotalScore(){
		fScore=gScore+hScore;
	}
	public void setActualScore(double g){
		gScore=g;
	}
	public void setEstimateScore(double h){
		hScore=h;
	}
	
	public void emptyAsgedIdTemp(Vector<GraphNode> vecResonGraph){
		for(int i=0;i<vecResonGraph.size();i++){
			GraphNode node=(GraphNode)vecResonGraph.elementAt(i);
			node.asgedIdTemp=-1;
		}
	}
	
	public void emptyAsgedIdTemp(TreeNode curTNode){
		TreeNode tempTNode=curTNode;
		while(tempTNode!=null){
			GraphNode resonNode=tempTNode.resonNode;
			resonNode.asgedIdTemp=-1;
			
			Vector<GraphNode> vecAdj=resonNode.getAdjVec();
			for(int j=0;j<vecAdj.size();j++){
				GraphNode vecAdjNode=(GraphNode)vecAdj.elementAt(j);
				vecAdjNode.asgedIdTemp=-1;
			}
			
			tempTNode=tempTNode.pNode;
		}		
	}
	
	//set the Temp assigned ID along the path to current tree node:
	public void setAsgedIdTemp(TreeNode curTNode){
		emptyAsgedIdTemp(curTNode);//initialize all temp assigned ID to be -1;
		
		TreeNode tempTNode=curTNode;
		
		while(tempTNode!=null){
			GraphNode resonNode=tempTNode.resonNode;
			resonNode.asgedIdTemp=tempTNode.labelNode.getID();
			
			tempTNode=tempTNode.pNode;
		}		
	}

	 /**
     * The Class scoreComparator.
     */
    public static class fscoreComparator implements Comparator<Object>{
    	
	    /* (non-Javadoc)
	     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	     */
	    public int compare(Object o1, Object o2){
	    	TreeNode n1 = (TreeNode)o1;
	    	TreeNode n2 = (TreeNode)o2;
    	    double d1 = n1.fScore;
    	    double d2 = n2.fScore;
    	    if (d1 >d2)
    		return -1;
    	    else if (d1 < d2)
    		return 1;
    	    else return 0;
    	}
        }
}
