package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.util.Vector;

import rdcPanda.Cartesian;
import rdcPanda.Pdb;
import rdcPanda.Peak;


/**This class is the data structure for proton label.
 * Methyl protons are regarded as one label; while methylene protons are regarded two labels.
 * 
 *
 */
public class ProtonLabel {	
	private int id=-1;
			
	//proton name (residue number, residue name, and atom name):
	private int resNo=-1;
	private String resName="";
	private String atomName="";
	
	//all coordinates in different rotamers corresponding to the same node;
	//thus the index of each set of coordinates represents the rotamer index.
	private Vector<Cartesian> vecRotCoords = new Vector<Cartesian>();
	
	/////private int rotIndex=-1;//rotamer index, starting from 0. Now it is not used in the program.
	/////private Cartesian coord=new Cartesian();
	
	public boolean isAsigned=false;//this is not used for now?
	public int asgedId=-1;//the one-to-one assignment
	public boolean isRestrained=false;
	
	//for storing the adjacent points within NOE distance threshold (e.g. 6 A);
	public Vector<ProtonLabel> vecAdj=new Vector<ProtonLabel>();
	
	//for storing the close proton lables (with distance less than 2.8A)
	public Vector<ProtonLabel> vecCloseAdj=new Vector<ProtonLabel>();
	public Vector<GraphNode> vecMappingSet=new Vector<GraphNode>();//store all nodes mapped to this proton label
	
	public int stereoID=-99;//id of the other stereo proton (like methylene protons)
	//public double maxMapScore=-999.9;//for storing the max score of mapped resonance nodes
	//public int maxMappedID=-99;//id of resonance node with the max mapping score
	
	
	public ProtonLabel(){
		//id=-1;		
	}
	//initialization for proton node
	public ProtonLabel(int idT, int resIDT, String res, String atom, Vector<Cartesian> vecAtom)
	{
		id=idT;
		resNo=resIDT;
		resName=res;
		atomName=atom;
		vecRotCoords.addAll(vecAtom);
		if(atom.equalsIgnoreCase("CA") ||atom.equalsIgnoreCase("N")|| 
				atom.equalsIgnoreCase("HN") ||atom.equalsIgnoreCase("H")||
				atom.equalsIgnoreCase("HA")||atom.equalsIgnoreCase("HA1")|| atom.equalsIgnoreCase("HA2")||atom.equalsIgnoreCase("HA3")||
				atom.equalsIgnoreCase("C")||atom.equalsIgnoreCase("CO")||atom.equalsIgnoreCase("CB"))
			isAsigned=true;
		else
			isAsigned=false;		
		vecAdj=new Vector<ProtonLabel>();
		vecCloseAdj=new Vector<ProtonLabel>();
	}
	
	public Vector<ProtonLabel> getAdjVec(){return vecAdj;}
	public boolean getIsAssigned(){return isAsigned;}
	public int getID(){
		return id;
	}
	public int getResNo(){
		return resNo;
	}
	public String getResName(){
		return resName;
	}
	public String getAtomName(){
		return atomName;
	}
	public Vector<Cartesian> getRotCoords(){
		return vecRotCoords;
	}
	public Vector<GraphNode> getMappingSet(){return vecMappingSet;}
	public void setIsRestrained(boolean isRsd){ 
		isRestrained=isRsd;
	}
	public void setID(int index){ id=index;}
	public void setIsAssigned(boolean tf){ isAsigned=tf;}
	
	public void AddCoord(Cartesian coord)
	{
		vecRotCoords.add(coord);
	}
	public void emptyCoord(){
		vecRotCoords=new Vector<Cartesian>();
	}
	public void AddAdj(ProtonLabel ndNeigh){
		int IDT=ndNeigh.getID();
		boolean isInPres=false;
		for(int i=0;i<vecAdj.size();i++)
		{
			ProtonLabel nd=(ProtonLabel)vecAdj.elementAt(i);
			int IDPre=nd.getID();
			if(IDT==IDPre)
				isInPres=true;
		}
		if(!isInPres)
			vecAdj.add(ndNeigh);
	}
	public void AddCloseAdj(ProtonLabel ndNeigh){
		int IDT=ndNeigh.getID();
		boolean isInPres=false;
		for(int i=0;i<vecCloseAdj.size();i++)
		{
			ProtonLabel nd=(ProtonLabel)vecCloseAdj.elementAt(i);
			int IDPre=nd.getID();
			if(IDT==IDPre)
				isInPres=true;
		}
		if(!isInPres)
			vecCloseAdj.add(ndNeigh);
	}

	public void setStereoID(Vector<ProtonLabel> vecLabels){
		Peak pk=new Peak();
	 	// set up stereo IDs for two protons, which should have the same heavy atom name
		for(int j=0;j<vecLabels.size();j++)	{
			ProtonLabel ndProton=(ProtonLabel)vecLabels.elementAt(j);
			String atom=ndProton.getAtomName();
			String res=ndProton.getResName();
			String heavy=pk.GetHeavyAtomFromProton(res,atom);
			int resNo=ndProton.getResNo();			
			for(int k=0;k<vecLabels.size();k++){
				if(j==k)
					continue;
				ProtonLabel ndProton2=(ProtonLabel)vecLabels.elementAt(k);
				String atom2=ndProton2.getAtomName();
				String res2=ndProton2.getResName();
				String heavy2=pk.GetHeavyAtomFromProton(res2,atom2);
				int resNo2=ndProton2.getResNo();
				if(heavy.equalsIgnoreCase(heavy2) && resNo==resNo2){
					ndProton.stereoID=k;
					ndProton2.stereoID=j;
				}
			}//for(int k=0;k<vecGraph.size();k++)			
		}//for(int j=0;j<vecGraph.size();j++)
		
		//new: add the update for ring protons
		/*for(int j=0;j<vecLabels.size();j++)	{
			ProtonLabel ndProton=(ProtonLabel)vecLabels.elementAt(j);
			String atom=ndProton.getAtomName();
			String res=ndProton.getResName();
			if( !(res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TYR")) )
				continue;
			
			String heavy=pk.GetHeavyAtomFromProton(res,atom);
			if(heavy.length()>=2)
				heavy=heavy.substring(0,2);
			int resNo=ndProton.getResNo();			
			for(int k=0;k<vecLabels.size();k++){
				if(j==k)
					continue;
				ProtonLabel ndProton2=(ProtonLabel)vecLabels.elementAt(k);
				String atom2=ndProton2.getAtomName();
				String res2=ndProton2.getResName();
				String heavy2=pk.GetHeavyAtomFromProton(res2,atom2);
				if(heavy2.length()>=2)
					heavy2=heavy2.substring(0,2);
				int resNo2=ndProton2.getResNo();
				if(heavy.equalsIgnoreCase(heavy2) && resNo==resNo2){
					ndProton.stereoID=k;
					ndProton2.stereoID=j;
				}
			}//for(int k=0;k<vecGraph.size();k++)			
		}//for(int j=0;j<vecGraph.size();j++)
		*/
	}
	/**
     * put all rotamers at each redidue, and construct the proton label set,
     * which includes all possible proton positions.
     * 
     @param pdbBBVec the PDB backbone structure
     @param rotSrc  the path of rotmaer library
     @param noeUp upper limit for noe interaction, default:6A
     @return vecNodes vector of nodes.
     */
	public Vector<ProtonLabel> ConstructProtonLabelSet(Vector<Pdb> pdbBBVec, String rotSrc, double noeUp){
		double distUpClose=2.8;//distance bound for considering close neighbors
		Pdb pp=new Pdb();
		Vector<Pdb> vecPdbAllRots=pp.AllRotamersStructure(pdbBBVec,rotSrc);
		//int curID=1;
		Vector<ProtonLabel> vecAllLabels=new Vector<ProtonLabel>();
		
		//initialization:
		for(int i=0;i<vecPdbAllRots.size();i++ ){
			Pdb pdb=(Pdb)vecPdbAllRots.elementAt(i);
			int resNo=pdb.getResidueNo();
			String resName=pdb.getResidue();
			Vector<Cartesian> vecAtom=pdb.getAtomVec();
			for(int j=0;j<vecAtom.size();j++){
				//boolean isMethyl=false;
				Cartesian cc = (Cartesian)vecAtom.elementAt(j);
				String atomName=cc.getAtom();
				String subAtomName=atomName;
				if(atomName.length()>1)
					subAtomName=atomName.substring(0, (atomName.length()-1) );
				
				if(resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("HH"))
					continue;
				if(resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("HG"))
					continue;
				if(resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("HG"))
					continue;
				if(resName.equalsIgnoreCase("LYS") && (atomName.equalsIgnoreCase("HZ1")||atomName.equalsIgnoreCase("HZ2")||atomName.equalsIgnoreCase("HZ3") )   )
					continue;//
				if(resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("HD2"))
					continue;
				if(resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("HE2"))
					continue;
				if(resName.equalsIgnoreCase("ARG") && (atomName.equalsIgnoreCase("HE")||subAtomName.equalsIgnoreCase("HH1")||subAtomName.equalsIgnoreCase("HH2")  ))
					continue;
				if(resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG1"))
					continue;
				
				//for methyl group protons, need to be consistent with resonance list
		    	if(resName.equalsIgnoreCase("ALA") )
		    		if(atomName.equalsIgnoreCase("HB1")||atomName.equalsIgnoreCase("HB2")||atomName.equalsIgnoreCase("HB3"))
		    			atomName = "HB";
		    	if(resName.equalsIgnoreCase("ILE")  )
		    		if (atomName.equalsIgnoreCase("HG21")||atomName.equalsIgnoreCase("HG22")||atomName.equalsIgnoreCase("HG23"))
		    			atomName = "HG2";
		    	if(resName.equalsIgnoreCase("ILE"))
		    		if (atomName.equalsIgnoreCase("HD11")||atomName.equalsIgnoreCase("HD12")||atomName.equalsIgnoreCase("HD13"))
		    			atomName = "HD1";
		    	if(resName.equalsIgnoreCase("LEU") )
		    		if (atomName.equalsIgnoreCase("HD11")||atomName.equalsIgnoreCase("HD12")||atomName.equalsIgnoreCase("HD13"))
		    			atomName = "HD1";
		    	if(resName.equalsIgnoreCase("LEU"))
		    		if(atomName.equalsIgnoreCase("HD21")||atomName.equalsIgnoreCase("HD22")||atomName.equalsIgnoreCase("HD23"))
		    			atomName = "HD2";
		    	if(resName.equalsIgnoreCase("VAL"))
		    		if(atomName.equalsIgnoreCase("HG11")||atomName.equalsIgnoreCase("HG12")||atomName.equalsIgnoreCase("HG13"))
		    			atomName = "HG1";
		    	if(resName.equalsIgnoreCase("VAL") )
		    		if( atomName.equalsIgnoreCase("HG21")||atomName.equalsIgnoreCase("HG22")||atomName.equalsIgnoreCase("HG23"))
		    			atomName = "HG2";
		    	if(resName.equalsIgnoreCase("THR") )
		    		if (atomName.equalsIgnoreCase("HG21")||atomName.equalsIgnoreCase("HG22")||atomName.equalsIgnoreCase("HG23"))
		    			atomName = "HG2";	    	
		    	if(resName.equalsIgnoreCase("MET") )
		    		if (atomName.equalsIgnoreCase("HE1")||atomName.equalsIgnoreCase("HE2")||atomName.equalsIgnoreCase("HE3"))
		    			atomName = "HE";	    				
				
				if(atomName.substring(0,1).equalsIgnoreCase("H"))
					AddProtonLabel(resNo,resName,atomName, cc,vecAllLabels);
			}//for(int j=0;j<vecAtom.size();j++)			
		}//for(int i=0;i<vecPdbAllRots.size();i++ )
		
		//set up connection.
		//build up an edge between two labels, if the distance between any pair of their 
		//rotamer proton coordinates is less than the NOE distance threshold.
		double [] coordA = {0.0, 0.0, 0.0};
		double [] coordB = {0.0, 0.0, 0.0};
		for(int i=0;i<vecAllLabels.size();i++){
			ProtonLabel labelA=(ProtonLabel)vecAllLabels.elementAt(i);
			Vector<Cartesian> vecAtomA=labelA.getRotCoords();
			for(int i1=0;i1<vecAtomA.size();i1++)
			{
				Cartesian ccA = (Cartesian)vecAtomA.elementAt(i1);
				coordA=ccA.getXYZ();
				for (int j=0;j<vecAllLabels.size();j++)
				{
					ProtonLabel labelB=(ProtonLabel)vecAllLabels.elementAt(j);
					if(i==j)
						continue;
					Vector<Cartesian> vecAtomB=labelB.getRotCoords();
					
					boolean isAllIn=true;
					boolean isAllInClose=true;
					for(int j1=0;j1<vecAtomB.size();j1++)
					{
						Cartesian ccB=(Cartesian)vecAtomB.elementAt(j1);
						coordB=ccB.getXYZ();
						double disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
								+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
								+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
					
						if(disTemp>noeUp)
							isAllIn=false;
						if(disTemp>distUpClose)
							isAllInClose=false;
					}//for(int j1=0;j1<vecAtomB.size();j1++)
					
					if(isAllIn)
					{
						labelA.AddAdj(labelB);
						labelB.AddAdj(labelA);
					}
					if(isAllInClose)
					{
						labelA.AddCloseAdj(labelB);
						labelB.AddCloseAdj(labelA);
					}
					
				}//for (int j=0;j<vecAllNodes.size();j++)
			}//for(i1=0;i1<vecAtom.size();i1++)
			
		}//for(int i=0;i<vecAllNodes.size();i++)
		
		return vecAllLabels;
	}
	/**
     * update the close neighbor information based on pdb structure.
     @param vecAllLabels all proton labels
     @param pdbBBVec the PDB backbone structure
     @param rotSrc  the path of rotmaer library
     @param distUpClose upper limit for close neighbors, default:2.8A
     @return vecNodes vector of nodes.
     */
	public void updateProtonLabelCloseNeighs(Vector<ProtonLabel> vecAllLabels,Vector<Pdb> pdbBBVec, 
			String rotSrc,  double distUpClose){
		
		emptyCoordsInProtonLabel(vecAllLabels);
		Pdb pp=new Pdb();
		Vector<Pdb> vecPdbAllRots=pp.AllRotamersStructure(pdbBBVec,rotSrc);
		
		//initialization:
		for(int i=0;i<vecPdbAllRots.size();i++ ){
			Pdb pdb=(Pdb)vecPdbAllRots.elementAt(i);
			int resNo=pdb.getResidueNo();
			String resName=pdb.getResidue();
			Vector<Cartesian> vecAtom=pdb.getAtomVec();
			if(vecAtom.size()==0)
				continue;
			for(int j=0;j<vecAtom.size();j++){
				//boolean isMethyl=false;
				Cartesian cc = (Cartesian)vecAtom.elementAt(j);
				String atomName=cc.getAtom();
				String subAtomName=atomName;
				if(atomName.length()>1)
					subAtomName=atomName.substring(0, (atomName.length()-1) );
				
				if(resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("HH"))
					continue;
				if(resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("HG"))
					continue;
				if(resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("HG"))
					continue;
				if(resName.equalsIgnoreCase("LYS") && (atomName.equalsIgnoreCase("HZ1")||atomName.equalsIgnoreCase("HZ2")||atomName.equalsIgnoreCase("HZ3") )   )
					continue;//
				if(resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("HD2"))
					continue;
				if(resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("HE2"))
					continue;
				if(resName.equalsIgnoreCase("ARG") && (atomName.equalsIgnoreCase("HE")||subAtomName.equalsIgnoreCase("HH1")||subAtomName.equalsIgnoreCase("HH2")  ))
					continue;
				if(resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG1"))
					continue;
				
				//for methyl group protons, need to be consistent with resonance list
		    	if(resName.equalsIgnoreCase("ALA") )
		    		if(atomName.equalsIgnoreCase("HB1")||atomName.equalsIgnoreCase("HB2")||atomName.equalsIgnoreCase("HB3"))
		    			atomName = "HB";
		    	if(resName.equalsIgnoreCase("ILE")  )
		    		if (atomName.equalsIgnoreCase("HG21")||atomName.equalsIgnoreCase("HG22")||atomName.equalsIgnoreCase("HG23"))
		    			atomName = "HG2";
		    	if(resName.equalsIgnoreCase("ILE"))
		    		if (atomName.equalsIgnoreCase("HD11")||atomName.equalsIgnoreCase("HD12")||atomName.equalsIgnoreCase("HD13"))
		    			atomName = "HD1";
		    	if(resName.equalsIgnoreCase("LEU") )
		    		if (atomName.equalsIgnoreCase("HD11")||atomName.equalsIgnoreCase("HD12")||atomName.equalsIgnoreCase("HD13"))
		    			atomName = "HD1";
		    	if(resName.equalsIgnoreCase("LEU"))
		    		if(atomName.equalsIgnoreCase("HD21")||atomName.equalsIgnoreCase("HD22")||atomName.equalsIgnoreCase("HD23"))
		    			atomName = "HD2";
		    	if(resName.equalsIgnoreCase("VAL"))
		    		if(atomName.equalsIgnoreCase("HG11")||atomName.equalsIgnoreCase("HG12")||atomName.equalsIgnoreCase("HG13"))
		    			atomName = "HG1";
		    	if(resName.equalsIgnoreCase("VAL") )
		    		if( atomName.equalsIgnoreCase("HG21")||atomName.equalsIgnoreCase("HG22")||atomName.equalsIgnoreCase("HG23"))
		    			atomName = "HG2";
		    	if(resName.equalsIgnoreCase("THR") )
		    		if (atomName.equalsIgnoreCase("HG21")||atomName.equalsIgnoreCase("HG22")||atomName.equalsIgnoreCase("HG23"))
		    			atomName = "HG2";	    	
		    	if(resName.equalsIgnoreCase("MET") )
		    		if (atomName.equalsIgnoreCase("HE1")||atomName.equalsIgnoreCase("HE2")||atomName.equalsIgnoreCase("HE3"))
		    			atomName = "HE";	    				
				
				if(atomName.substring(0,1).equalsIgnoreCase("H"))
					AddProtonLabel(resNo,resName,atomName, cc,vecAllLabels);
			}//for(int j=0;j<vecAtom.size();j++)			
		}//for(int i=0;i<vecPdbAllRots.size();i++ )
		
		//set up connection.	
		//double distUpClose=2.8;//distance bound for considering close neighbors	
		double noeUp=6.0;
		double [] coordA = {0.0, 0.0, 0.0};
		double [] coordB = {0.0, 0.0, 0.0};
		for(int i=0;i<vecAllLabels.size();i++){
			ProtonLabel labelA=(ProtonLabel)vecAllLabels.elementAt(i);
			Vector<Cartesian> vecAtomA=labelA.getRotCoords();
			for(int i1=0;i1<vecAtomA.size();i1++)
			{
				Cartesian ccA = (Cartesian)vecAtomA.elementAt(i1);
				coordA=ccA.getXYZ();
				for (int j=0;j<vecAllLabels.size();j++)
				{
					ProtonLabel labelB=(ProtonLabel)vecAllLabels.elementAt(j);
					if(i==j)
						continue;
					Vector<Cartesian> vecAtomB=labelB.getRotCoords();
					
					boolean isAllIn=true;
					boolean isAllInClose=true;
					if(vecAtomB.size()==0)
						continue;
					
					for(int j1=0;j1<vecAtomB.size();j1++)
					{
						Cartesian ccB=(Cartesian)vecAtomB.elementAt(j1);
						coordB=ccB.getXYZ();
						double disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
								+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
								+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
						if(disTemp>noeUp)
							isAllIn=false;
						if(disTemp>distUpClose)
							isAllInClose=false;
					}//for(int j1=0;j1<vecAtomB.size();j1++)
					
					if(isAllIn)
					{
						labelA.AddAdj(labelB);
						labelB.AddAdj(labelA);
					}
					if(isAllInClose)
					{
						labelA.AddCloseAdj(labelB);
						labelB.AddCloseAdj(labelA);
					}
					
				}//for (int j=0;j<vecAllNodes.size();j++)
			}//for(i1=0;i1<vecAtom.size();i1++)
			
		}//for(int i=0;i<vecAllNodes.size();i++)		
		
	}
	public void addMappingNode(GraphNode node){ 
		vecMappingSet.add(node);
	}
	
	public void EmptyMappingSet(){ 
		vecMappingSet=new Vector<GraphNode>();
	}
	/**
     * add a proton label into the set. Note: the rotamer index is not updated yet. It can be updated easily by
     * checking the proton labels with the same proton name.
     @param resID 
     @param resName  
     @param atomName 
     @param coord coordiante of the proton
     @param vecProtonLabel proton label set 
     @return void
     */
	public void AddProtonLabel(int resID,String resName, String atomName, Cartesian coord,Vector<ProtonLabel> vecProtonLabel )
	{
		boolean isInPres=false;
		for(int i=0;i<vecProtonLabel.size();i++)
		{
			ProtonLabel label=(ProtonLabel)vecProtonLabel.elementAt(i);
			int preResID=label.getResNo();
			String preAtomName=label.getAtomName();
			if( (resID==preResID) && (preAtomName.equalsIgnoreCase(atomName) ) )
			{
				label.AddCoord(coord);
				isInPres=true;
			}			
		}//for(int i=0;i<vecOldGraph.size();i++)
		if(!isInPres)
		{
			Vector<Cartesian> atomVecT=new Vector<Cartesian>();
			atomVecT.add(coord);			
			ProtonLabel label =new ProtonLabel(vecProtonLabel.size(),resID,resName,atomName,atomVecT);
			vecProtonLabel.add(label);
		}
		//return vecOldGraph;
	}
	
	  /**
     * empty all coordinates in proton label set
     @param vecProtonLabel proton label set 
     @return void
     */
	public void emptyCoordsInProtonLabel(Vector<ProtonLabel> vecProtonLabel){		
		for(int i=0;i<vecProtonLabel.size();i++){
			ProtonLabel label=(ProtonLabel)vecProtonLabel.elementAt(i);
			label.emptyCoord();
			//label.vecCloseAdj=new Vector<ProtonLabel>();
		}//for(int i=0;i<vecProtonLabel.size();i++)		
	}
	
	
	   
}
